/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import java.io.IOException;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.DefaultSerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.util.ClassMap;

public class ToolingSerializer {
    private final DefaultSerializationService myDefaultSerializationService = new DefaultSerializationService();
    private final ClassMap<SerializationService<?>> mySerializationServices = new ClassMap();

    public ToolingSerializer() {
        for (SerializationService serializerService : ServiceLoader.load(SerializationService.class, SerializationService.class.getClassLoader())) {
            this.register(serializerService);
        }
    }

    public final void register(@NotNull SerializationService<?> serializerService) {
        if (serializerService == null) {
            ToolingSerializer.$$$reportNull$$$0(0);
        }
        this.mySerializationServices.put(serializerService.getModelClass(), serializerService);
    }

    public byte[] write(@NotNull Object object, @NotNull Class modelClazz) throws IOException {
        if (object == null) {
            ToolingSerializer.$$$reportNull$$$0(1);
        }
        if (modelClazz == null) {
            ToolingSerializer.$$$reportNull$$$0(2);
        }
        return this.getService(modelClazz).write(object, modelClazz);
    }

    @Nullable
    public <T> T read(@NotNull byte[] object, @NotNull Class<T> modelClazz) throws IOException {
        if (object == null) {
            ToolingSerializer.$$$reportNull$$$0(3);
        }
        if (modelClazz == null) {
            ToolingSerializer.$$$reportNull$$$0(4);
        }
        return this.getService(modelClazz).read(object, modelClazz);
    }

    @NotNull
    private <T> SerializationService<T> getService(@NotNull Class<T> modelClazz) {
        DefaultSerializationService service;
        if (modelClazz == null) {
            ToolingSerializer.$$$reportNull$$$0(5);
        }
        DefaultSerializationService defaultSerializationService = (service = this.mySerializationServices.get(modelClazz)) == null ? this.myDefaultSerializationService : service;
        if (defaultSerializationService == null) {
            ToolingSerializer.$$$reportNull$$$0(6);
        }
        return defaultSerializationService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializerService";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClazz";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/serialization/ToolingSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/serialization/ToolingSerializer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

