/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.Bits;
import com.intellij.util.io.OpenChannelsCache;
import com.intellij.util.io.Page;
import com.intellij.util.io.PagePool;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class RandomAccessDataFile
implements Forceable,
Closeable {
    protected static final Logger LOG = Logger.getInstance(RandomAccessDataFile.class);
    private static final OpenChannelsCache ourCache = new OpenChannelsCache(150, EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
    private static final AtomicInteger ourFilesCount = new AtomicInteger();
    private final int myCount;
    private final Path myFile;
    private final PagePool myPool;
    private static final ThreadLocal<byte[]> ourTypedIOBuffer = ThreadLocal.withInitial(() -> new byte[8]);
    private final FileWriter log;
    private volatile long mySize;
    private volatile boolean myIsDirty;
    private volatile boolean myIsDisposed;
    private static final boolean DEBUG = false;
    public static int totalReads;
    public static long totalReadBytes;
    public static int totalWrites;
    public static long totalWriteBytes;

    public RandomAccessDataFile(@NotNull File file, @NotNull PagePool pool) throws IOException {
        if (file == null) {
            RandomAccessDataFile.$$$reportNull$$$0(0);
        }
        if (pool == null) {
            RandomAccessDataFile.$$$reportNull$$$0(1);
        }
        this.myCount = ourFilesCount.incrementAndGet();
        this.myPool = pool;
        this.myFile = file.toPath();
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath() + " does not exist");
        }
        this.mySize = file.length();
        this.log = null;
    }

    public void put(long addr, byte[] bytes, int off, int len) {
        this.assertNotDisposed();
        this.myIsDirty = true;
        this.mySize = Math.max(this.mySize, addr + (long)len);
        while (len > 0) {
            Page page = this.myPool.alloc(this, addr);
            int written = page.put(addr, bytes, off, len);
            len -= written;
            addr += (long)written;
            off += written;
        }
    }

    public void get(long addr, byte[] bytes, int off, int len) {
        this.assertNotDisposed();
        while (len > 0) {
            Page page = this.myPool.alloc(this, addr);
            int read = page.get(addr, bytes, off, len);
            len -= read;
            addr += (long)read;
            off += read;
        }
    }

    private <T> T useFileChannel(@NotNull OpenChannelsCache.ChannelProcessor<T> channelConsumer) throws IOException {
        if (channelConsumer == null) {
            RandomAccessDataFile.$$$reportNull$$$0(2);
        }
        return ourCache.useChannel(this.myFile, channelConsumer);
    }

    public void putInt(long addr, int value) {
        Bits.putInt(ourTypedIOBuffer.get(), 0, value);
        this.put(addr, ourTypedIOBuffer.get(), 0, 4);
    }

    public int getInt(long addr) {
        this.get(addr, ourTypedIOBuffer.get(), 0, 4);
        return Bits.getInt(ourTypedIOBuffer.get(), 0);
    }

    public void putLong(long addr, long value) {
        Bits.putLong(ourTypedIOBuffer.get(), 0, value);
        this.put(addr, ourTypedIOBuffer.get(), 0, 8);
    }

    public long getLong(long addr) {
        this.get(addr, ourTypedIOBuffer.get(), 0, 8);
        return Bits.getLong(ourTypedIOBuffer.get(), 0);
    }

    public long length() {
        this.assertNotDisposed();
        return this.mySize;
    }

    public long physicalLength() {
        this.assertNotDisposed();
        try {
            return this.useFileChannel(file -> file.size());
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void dispose() {
        if (this.myIsDisposed) {
            return;
        }
        this.myPool.flushPages(this);
        ourCache.closeChannel(this.myFile);
        this.myIsDisposed = true;
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void force() {
        this.assertNotDisposed();
        if (this.isDirty()) {
            this.myPool.flushPages(this);
            this.myIsDirty = false;
        }
    }

    public void sync() {
        this.force();
        try {
            this.useFileChannel(ch -> {
                ch.force(true);
                return null;
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushSomePages(int maxPagesToFlush) {
        this.assertNotDisposed();
        if (this.isDirty()) {
            this.myIsDirty = !this.myPool.flushPages(this, maxPagesToFlush);
        }
    }

    @Override
    public boolean isDirty() {
        this.assertNotDisposed();
        return this.myIsDirty;
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    private void assertNotDisposed() {
        if (this.myIsDisposed) {
            LOG.error("storage file is disposed: " + this.myFile);
        }
    }

    void loadPage(Page page) {
        this.assertNotDisposed();
        try {
            this.useFileChannel(file -> {
                ByteBuffer buf = page.getBuf();
                ++totalReads;
                totalReadBytes += (long)Page.PAGE_SIZE;
                return file.read(ByteBuffer.wrap(buf.array(), 0, Page.PAGE_SIZE), page.getOffset());
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void flushPage(Page page, int start, int end) {
        this.assertNotDisposed();
        try {
            this.flush(page.getBuf(), page.getOffset() + (long)start, start, end - start);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void flush(ByteBuffer buf, long fileOffset, int bufOffset, int length) throws IOException {
        if (fileOffset + (long)length > this.mySize) {
            length = (int)(this.mySize - fileOffset);
        }
        int finalLength = length;
        this.useFileChannel(file -> {
            ++totalWrites;
            totalWriteBytes += (long)finalLength;
            return file.write(ByteBuffer.wrap(buf.array(), bufOffset, finalLength), fileOffset);
        });
    }

    public int hashCode() {
        return this.myCount;
    }

    public String toString() {
        return "RandomAccessFile[" + this.myFile + ", dirty=" + this.myIsDirty + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pool";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channelConsumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/RandomAccessDataFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "useFileChannel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

