/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.MessageEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.DefaultExternalDependencyId;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencySyncIssue;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.DefaultExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.Project;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionWorkspace;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public final class GradleProjectResolverUtil {
    private static final Logger LOG = Logger.getInstance(GradleProjectResolverUtil.class);
    @NonNls
    public static final String BUILD_SRC_NAME = "buildSrc";
    @NonNls
    private static final String SOURCE_JAR_SUFFIX = "-sources.jar";
    @NonNls
    private static final String JAVADOC_JAR_SUFFIX = "-javadoc.jar";
    private static final Key<Set<LibraryData>> LIBRARIES_CACHE = Key.create((String)"GradleProjectResolverUtil.LIBRARIES_CACHE");
    private static final Key<Map<String, Map<LibraryPathType, List<String>>>> PATHS_CACHE = Key.create((String)"GradleProjectResolverUtil.PATHS_CACHE");

    @NotNull
    public static DataNode<ModuleData> createMainModule(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        String mainModuleFileDirectoryPath;
        String moduleName;
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(0);
        }
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(1);
        }
        if (projectDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(2);
        }
        String string = moduleName = resolverCtx.isUseQualifiedModuleNames() ? gradleModule.getGradleProject().getName() : gradleModule.getName();
        if (moduleName == null) {
            throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
        }
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        String mainModuleConfigPath = GradleProjectResolverUtil.getModuleConfigPath(resolverCtx, gradleModule, projectData.getLinkedExternalProjectPath());
        String ideProjectPath = resolverCtx.getIdeProjectPath();
        String relativePath = FileUtil.isAncestor((String)projectData.getLinkedExternalProjectPath(), (String)mainModuleConfigPath, (boolean)false) ? FileUtil.getRelativePath((String)projectData.getLinkedExternalProjectPath(), (String)mainModuleConfigPath, (char)'/') : String.valueOf(FileUtil.pathHashCode((String)mainModuleConfigPath));
        String string2 = ideProjectPath == null ? mainModuleConfigPath : (mainModuleFileDirectoryPath = ideProjectPath + '/' + (relativePath == null || relativePath.equals(".") ? "" : relativePath));
        if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
            LOG.info(String.format("Creating module data ('%s') with the external config path: '%s'", gradleModule.getGradleProject().getPath(), mainModuleConfigPath));
        }
        String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule);
        ModuleData moduleData = new ModuleData(mainModuleId, GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), moduleName, mainModuleFileDirectoryPath, mainModuleConfigPath);
        ExternalProject externalProject = resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            moduleData.setInternalName(GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, resolverCtx));
            moduleData.setGroup(externalProject.getGroup());
            moduleData.setVersion(externalProject.getVersion());
            moduleData.setDescription(externalProject.getDescription());
            moduleData.setModuleName(moduleName);
            if (!resolverCtx.isResolveModulePerSourceSet()) {
                moduleData.setArtifacts(externalProject.getArtifacts());
                moduleData.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
            }
        }
        DataNode dataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        if (dataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(3);
        }
        return dataNode;
    }

    public static String getDefaultModuleTypeId() {
        ModuleType moduleType = ModuleTypeManager.getInstance().getDefaultModuleType();
        return moduleType.getId();
    }

    @NotNull
    static String getInternalModuleName(@NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @NotNull ProjectResolverContext resolverCtx) {
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(4);
        }
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(5);
        }
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(6);
        }
        return GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, null, resolverCtx);
    }

    @NotNull
    static String getInternalModuleName(@NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @Nullable String sourceSetName, @NotNull ProjectResolverContext resolverCtx) {
        String delimiter;
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(7);
        }
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(8);
        }
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(9);
        }
        StringBuilder moduleName = new StringBuilder();
        String buildSrcGroup = resolverCtx.getBuildSrcGroup();
        if (resolverCtx.isUseQualifiedModuleNames()) {
            delimiter = ".";
            if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                moduleName.append(buildSrcGroup).append(delimiter);
            }
            moduleName.append(GradleProjectResolverUtil.gradlePathToQualifiedName(gradleModule.getProject().getName(), externalProject.getQName()));
        } else {
            delimiter = "_";
            if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                moduleName.append(buildSrcGroup).append(delimiter);
            }
            moduleName.append(gradleModule.getName());
        }
        if (sourceSetName != null) {
            assert (!sourceSetName.isEmpty());
            moduleName.append(delimiter);
            moduleName.append(sourceSetName);
        }
        String string = PathUtilRt.suggestFileName((String)moduleName.toString(), (boolean)true, (boolean)false);
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String gradlePathToQualifiedName(@NotNull String rootName, @NotNull String gradlePath) {
        if (rootName == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(11);
        }
        if (gradlePath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(12);
        }
        String string = (gradlePath.startsWith(":") ? rootName + "." : "") + Arrays.stream(gradlePath.split(":")).filter(s -> !s.isEmpty()).collect(Collectors.joining("."));
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String getModuleConfigPath(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull String rootProjectPath) {
        ExternalProject externalProject;
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(14);
        }
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(15);
        }
        if (rootProjectPath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(16);
        }
        if ((externalProject = resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) != null) {
            String string;
            File projectDir = externalProject.getProjectDir();
            try {
                string = ExternalSystemApiUtil.toCanonicalPath((String)projectDir.getCanonicalPath());
            }
            catch (IOException e) {
                LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
            }
            if (string == null) {
                GradleProjectResolverUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = GradleUtil.getConfigPath(gradleModule.getGradleProject(), rootProjectPath);
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext resolverCtx, @NotNull Build build, @NotNull Project project) {
        boolean isRootPath;
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(19);
        }
        if (build == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(20);
        }
        if (project == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(21);
        }
        ProjectIdentifier projectIdentifier = project.getProjectIdentifier();
        String gradlePath = projectIdentifier.getProjectPath();
        String compositePrefix = "";
        boolean bl = isRootPath = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath);
        if (!StringUtil.isEmpty((String)resolverCtx.getBuildSrcGroup())) {
            compositePrefix = resolverCtx.getBuildSrcGroup() + (isRootPath ? ":" : ":buildSrc");
        } else if (!isRootPath && build != resolverCtx.getModels().getMainBuild()) {
            compositePrefix = build.getName();
        }
        String string = compositePrefix + GradleProjectResolverUtil.getModuleId(gradlePath, project.getName());
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule) {
        boolean isRootPath;
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(23);
        }
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(24);
        }
        GradleProject gradleProject = gradleModule.getGradleProject();
        String gradlePath = gradleProject.getPath();
        String compositePrefix = "";
        IdeaProject ideaProject = gradleModule.getProject();
        boolean bl = isRootPath = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath);
        if (!StringUtil.isEmpty((String)resolverCtx.getBuildSrcGroup())) {
            compositePrefix = resolverCtx.getBuildSrcGroup() + (isRootPath ? ":" : ":buildSrc");
        } else if (!isRootPath && ideaProject != resolverCtx.getModels().getModel(IdeaProject.class)) {
            compositePrefix = ideaProject.getName();
        }
        String string = compositePrefix + GradleProjectResolverUtil.getModuleId(gradlePath, gradleModule.getName());
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static String getModuleId(String gradlePath, String moduleName) {
        String string = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath) ? moduleName : gradlePath;
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ExternalProject externalProject) {
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(27);
        }
        String string = externalProject.getId();
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ExternalProject externalProject, @NotNull ExternalSourceSet sourceSet) {
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(29);
        }
        if (sourceSet == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(30);
        }
        String mainModuleId = GradleProjectResolverUtil.getModuleId(externalProject);
        String string = mainModuleId + ":" + sourceSet.getName();
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull ExternalSourceSet sourceSet) {
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(32);
        }
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(33);
        }
        if (sourceSet == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(34);
        }
        String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule);
        String string = mainModuleId + ":" + sourceSet.getName();
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ExternalProjectDependency projectDependency) {
        String moduleId;
        if (projectDependency == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(36);
        }
        DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(projectDependency.getScope());
        String projectPath = projectDependency.getProjectPath();
        String string = moduleId = StringUtil.isEmpty((String)projectPath) || ":".equals(projectPath) ? projectDependency.getName() : projectPath;
        moduleId = "default".equals(projectDependency.getConfigurationName()) ? moduleId + (dependencyScope == DependencyScope.TEST ? ":test" : ":main") : moduleId + ':' + projectDependency.getConfigurationName();
        String string2 = moduleId;
        if (string2 == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(37);
        }
        return string2;
    }

    @Nullable
    public static String getSourceSetName(Module module) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        if (!"sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) {
            return null;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            return null;
        }
        int i2 = externalProjectId.lastIndexOf(58);
        if (i2 == -1 || externalProjectId.length() < i2 + 1) {
            return null;
        }
        return externalProjectId.substring(i2 + 1);
    }

    @Nullable
    public static String getGradlePath(Module module) {
        String join;
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            return null;
        }
        String moduleType = ExternalSystemApiUtil.getExternalModuleType((Module)module);
        boolean trimSourceSet = "sourceSet".equals(moduleType);
        List pathParts = StringUtil.split((String)externalProjectId, (String)":");
        if (!externalProjectId.startsWith(":") && !pathParts.isEmpty()) {
            pathParts.remove(0);
        }
        if (trimSourceSet && !pathParts.isEmpty()) {
            pathParts.remove(pathParts.size() - 1);
        }
        return (join = StringUtil.join((Collection)pathParts, (String)":")).isEmpty() ? ":" : ":" + join;
    }

    @NotNull
    public static String getGradlePath(@NotNull ModuleData moduleData) {
        int colonIndex;
        String moduleId;
        if (moduleData == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(38);
        }
        String gradlePath = (moduleId = moduleData.getId()).charAt(0) != ':' ? ((colonIndex = moduleId.indexOf(58)) > 0 ? moduleId.substring(colonIndex) : ":") : moduleId;
        String string = gradlePath;
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    public static DependencyScope getDependencyScope(@Nullable String scope) {
        DependencyScope dependencyScope = scope != null ? DependencyScope.valueOf((String)scope) : DependencyScope.COMPILE;
        if (dependencyScope == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(40);
        }
        return dependencyScope;
    }

    public static void attachGradleSdkSources(@NotNull IdeaModule gradleModule, @Nullable File libFile, @NotNull LibraryData library, @NotNull ProjectResolverContext resolverCtx) {
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(41);
        }
        if (library == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(42);
        }
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(43);
        }
        if (libFile == null || !libFile.getName().startsWith("gradle-")) {
            return;
        }
        BuildScriptClasspathModel buildScriptClasspathModel = resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class);
        if (buildScriptClasspathModel == null) {
            return;
        }
        File gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
        if (gradleHomeDir == null) {
            return;
        }
        GradleVersion gradleVersion = GradleVersion.version((String)buildScriptClasspathModel.getGradleVersion());
        GradleProjectResolverUtil.attachGradleSdkSources(libFile, library, gradleHomeDir, gradleVersion);
    }

    public static void attachGradleSdkSources(@Nullable File libFile, @NotNull LibraryData library, @NotNull File gradleHomeDir, @NotNull GradleVersion gradleVersion) {
        if (library == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(44);
        }
        if (gradleHomeDir == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(45);
        }
        if (gradleVersion == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(46);
        }
        if (libFile == null || !libFile.getName().startsWith("gradle-")) {
            return;
        }
        if (!FileUtil.isAncestor((File)gradleHomeDir, (File)libFile, (boolean)true)) {
            File libFileParent = libFile.getParentFile();
            if (libFileParent == null || !StringUtil.equals((CharSequence)"generated-gradle-jars", (CharSequence)libFileParent.getName())) {
                return;
            }
            if (("gradle-api-" + gradleVersion.getVersion() + ".jar").equals(libFile.getName())) {
                File gradleSrc = new File(gradleHomeDir, "src");
                File[] gradleSrcRoots = gradleSrc.listFiles();
                if (gradleSrcRoots == null) {
                    return;
                }
                for (File srcRoot : gradleSrcRoots) {
                    library.addPath(LibraryPathType.SOURCE, srcRoot.getAbsolutePath());
                }
            }
            return;
        }
        File libOrPluginsFile = libFile.getParentFile();
        if (libOrPluginsFile != null && "plugins".equals(libOrPluginsFile.getName())) {
            libOrPluginsFile = libOrPluginsFile.getParentFile();
        }
        if (libOrPluginsFile != null && "lib".equals(libOrPluginsFile.getName()) && libOrPluginsFile.getParentFile() != null) {
            int endIndex;
            File srcDir = new File(libOrPluginsFile.getParentFile(), "src");
            if (gradleVersion.compareTo(GradleVersion.version((String)"1.9")) >= 0 && (endIndex = libFile.getName().indexOf(gradleVersion.getVersion())) != -1) {
                String srcDirChild = libFile.getName().substring("gradle-".length(), endIndex - 1);
                srcDir = new File(srcDir, srcDirChild);
            }
            if (srcDir.isDirectory()) {
                library.addPath(LibraryPathType.SOURCE, srcDir.getAbsolutePath());
            }
        }
    }

    public static void attachSourcesAndJavadocFromGradleCacheIfNeeded(File gradleUserHomeDir, LibraryData libraryData) {
        GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(null, gradleUserHomeDir, libraryData);
    }

    public static void attachSourcesAndJavadocFromGradleCacheIfNeeded(ProjectResolverContext context, File gradleUserHomeDir, LibraryData libraryData) {
        boolean docResolved;
        boolean sourceResolved = !libraryData.getPaths(LibraryPathType.SOURCE).isEmpty();
        boolean bl = docResolved = !libraryData.getPaths(LibraryPathType.DOC).isEmpty();
        if (sourceResolved && docResolved) {
            return;
        }
        Map pathsCache = null;
        if (context != null) {
            Set libsCache = (Set)context.getUserData(LIBRARIES_CACHE);
            if (libsCache == null) {
                libsCache = (Set)context.putUserDataIfAbsent(LIBRARIES_CACHE, new THashSet(ContainerUtil.identityStrategy()));
            }
            if (!libsCache.add(libraryData)) {
                return;
            }
            pathsCache = (Map)context.getUserData(PATHS_CACHE);
            if (pathsCache == null) {
                pathsCache = (Map)context.putUserDataIfAbsent(PATHS_CACHE, new THashMap());
            }
        }
        for (String path : libraryData.getPaths(LibraryPathType.BINARY)) {
            Map collectedPaths;
            if (!FileUtil.isAncestor((String)gradleUserHomeDir.getPath(), (String)path, (boolean)true)) continue;
            Map map = collectedPaths = pathsCache == null ? null : (Map)pathsCache.get(path);
            if (collectedPaths == null) {
                collectedPaths = new THashMap();
                if (pathsCache != null) {
                    pathsCache.put(path, collectedPaths);
                }
                GradleProjectResolverUtil.collectSourcesAndJavadocsFor(path, collectedPaths, sourceResolved, docResolved);
            }
            for (Map.Entry each : collectedPaths.entrySet()) {
                for (String cachedPath : (List)each.getValue()) {
                    libraryData.addPath((LibraryPathType)each.getKey(), cachedPath);
                }
            }
        }
    }

    private static void collectSourcesAndJavadocsFor(@NonNls @NotNull String binaryPath, @NotNull Map<LibraryPathType, List<String>> collect, boolean sourceResolved, boolean docResolved) {
        if (binaryPath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(47);
        }
        if (collect == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(48);
        }
        if (sourceResolved && docResolved) {
            return;
        }
        try {
            if (binaryPath.contains("/.gradle/caches/modules-2/files-2.1/")) {
                GradleProjectResolverUtil.collectSourcesAndJavadocsFromGradleCache(binaryPath, collect, sourceResolved, docResolved);
            } else {
                GradleProjectResolverUtil.collectSourcesAndJavadocsFromTheSameFolder(binaryPath, collect, sourceResolved, docResolved);
            }
        }
        catch (IOException | InvalidPathException e) {
            LOG.debug((Throwable)e);
        }
    }

    private static void collectSourcesAndJavadocsFromGradleCache(@NotNull String binaryPath, final @NotNull Map<LibraryPathType, List<String>> collect, boolean sourceResolved, boolean docResolved) throws IOException {
        if (binaryPath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(49);
        }
        if (collect == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(50);
        }
        Path file = Paths.get(binaryPath, new String[0]);
        final Path binaryFileParent = file.getParent();
        final Path grandParentFile = binaryFileParent.getParent();
        final boolean[] sourceFound = new boolean[]{sourceResolved};
        final boolean[] docFound = new boolean[]{docResolved};
        Files.walkFileTree(grandParentFile, EnumSet.noneOf(FileVisitOption.class), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (binaryFileParent.equals(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path sourceCandidate, BasicFileAttributes attrs) throws IOException {
                if (!sourceCandidate.getParent().getParent().equals(grandParentFile)) {
                    return FileVisitResult.SKIP_SIBLINGS;
                }
                if (attrs.isRegularFile()) {
                    String candidateFileName = sourceCandidate.getFileName().toString();
                    if (!sourceFound[0] && StringUtil.endsWith((CharSequence)candidateFileName, (CharSequence)GradleProjectResolverUtil.SOURCE_JAR_SUFFIX)) {
                        collect.computeIfAbsent(LibraryPathType.SOURCE, type -> new SmartList()).add(sourceCandidate.toFile().getAbsolutePath());
                        sourceFound[0] = true;
                    } else if (!docFound[0] && StringUtil.endsWith((CharSequence)candidateFileName, (CharSequence)GradleProjectResolverUtil.JAVADOC_JAR_SUFFIX)) {
                        collect.computeIfAbsent(LibraryPathType.DOC, type -> new SmartList()).add(sourceCandidate.toFile().getAbsolutePath());
                        docFound[0] = true;
                    }
                }
                if (sourceFound[0] && docFound[0]) {
                    return FileVisitResult.TERMINATE;
                }
                return super.visitFile(sourceCandidate, attrs);
            }
        });
    }

    private static void collectSourcesAndJavadocsFromTheSameFolder(@NotNull String binaryPath, @NotNull Map<LibraryPathType, List<String>> collect, boolean sourceResolved, boolean docResolved) throws IOException {
        Path file;
        Path binaryFileParent;
        if (binaryPath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(51);
        }
        if (collect == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(52);
        }
        if (!Files.isDirectory(binaryFileParent = (file = Paths.get(binaryPath, new String[0])).getParent(), new LinkOption[0])) {
            return;
        }
        try (Stream<Path> list = Files.list(binaryFileParent);){
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Path p = (Path)it.next();
                if (!Files.isRegularFile(p, new LinkOption[0])) continue;
                String name = p.getFileName().toString();
                if (!sourceResolved && name.endsWith(SOURCE_JAR_SUFFIX)) {
                    collect.computeIfAbsent(LibraryPathType.SOURCE, type -> new SmartList()).add(p.toFile().getAbsolutePath());
                    sourceResolved = true;
                } else if (!docResolved && name.endsWith(JAVADOC_JAR_SUFFIX)) {
                    collect.computeIfAbsent(LibraryPathType.DOC, type -> new SmartList()).add(p.toFile().getAbsolutePath());
                    docResolved = true;
                }
                if (!sourceResolved || !docResolved) continue;
                return;
            }
        }
    }

    public static void buildDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull Map<String, String> artifactsMap, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, @NotNull Collection<ExternalDependency> dependencies, @Nullable DataNode<ProjectData> ideProject) throws IllegalStateException {
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(53);
        }
        if (sourceSetMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(54);
        }
        if (artifactsMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(55);
        }
        if (ownerDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(56);
        }
        if (dependencies == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(57);
        }
        HashMap<ExternalDependencyId, ExternalDependency> dependencyMap = new HashMap<ExternalDependencyId, ExternalDependency>();
        LinkedList<ExternalDependency> queue = new LinkedList<ExternalDependency>(dependencies);
        while (!queue.isEmpty()) {
            ExternalDependency dependency = (ExternalDependency)queue.remove();
            DefaultExternalDependencyId key = new DefaultExternalDependencyId(dependency.getId());
            ExternalDependency seenDependency = (ExternalDependency)dependencyMap.get(key);
            if (seenDependency != null) {
                DependencyScope currentScope;
                if (dependency instanceof ExternalLibraryDependency) {
                    DefaultExternalMultiLibraryDependency mergedDependency;
                    if (seenDependency instanceof ExternalLibraryDependency && !FileUtil.filesEqual((File)((ExternalLibraryDependency)seenDependency).getFile(), (File)((ExternalLibraryDependency)dependency).getFile())) {
                        mergedDependency = new DefaultExternalMultiLibraryDependency();
                        mergedDependency.setName(dependency.getId().getName());
                        mergedDependency.setGroup(dependency.getId().getGroup());
                        mergedDependency.setVersion(dependency.getId().getVersion());
                        mergedDependency.setPackaging(dependency.getId().getPackaging());
                        mergedDependency.setClassifier(dependency.getId().getClassifier());
                        mergedDependency.setScope(dependency.getScope());
                        mergedDependency.setClasspathOrder(dependency.getClasspathOrder());
                        mergedDependency.getDependencies().addAll(dependency.getDependencies());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getFiles(), (Object)((ExternalLibraryDependency)seenDependency).getFile());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getFiles(), (Object)((ExternalLibraryDependency)dependency).getFile());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getSources(), (Object)((ExternalLibraryDependency)seenDependency).getSource());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getSources(), (Object)((ExternalLibraryDependency)dependency).getSource());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getJavadoc(), (Object)((ExternalLibraryDependency)seenDependency).getJavadoc());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getJavadoc(), (Object)((ExternalLibraryDependency)dependency).getJavadoc());
                        dependencyMap.put(dependency.getId(), (ExternalDependency)mergedDependency);
                        continue;
                    }
                    if (seenDependency instanceof DefaultExternalMultiLibraryDependency) {
                        mergedDependency = (DefaultExternalMultiLibraryDependency)seenDependency;
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getFiles(), (Object)((ExternalLibraryDependency)dependency).getFile());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getSources(), (Object)((ExternalLibraryDependency)dependency).getSource());
                        ContainerUtil.addIfNotNull((Collection)mergedDependency.getJavadoc(), (Object)((ExternalLibraryDependency)dependency).getJavadoc());
                        continue;
                    }
                }
                DependencyScope prevScope = seenDependency.getScope() == null ? DependencyScope.COMPILE : DependencyScope.valueOf((String)seenDependency.getScope());
                DependencyScope dependencyScope = currentScope = dependency.getScope() == null ? DependencyScope.COMPILE : DependencyScope.valueOf((String)dependency.getScope());
                if (prevScope.isForProductionCompile() || prevScope.isForProductionRuntime() && currentScope.isForProductionRuntime()) continue;
            }
            dependencyMap.put((ExternalDependencyId)key, dependency);
            queue.addAll(dependency.getDependencies());
        }
        GradleProjectResolverUtil.doBuildDependencies(resolverCtx, sourceSetMap, artifactsMap, dependencyMap, ownerDataNode, dependencies, ideProject);
    }

    private static void doBuildDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull Map<String, String> artifactsMap, @NotNull Map<ExternalDependencyId, ExternalDependency> mergedDependencyMap, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, @NotNull Collection<ExternalDependency> dependencies, @Nullable DataNode<ProjectData> ideProject) throws IllegalStateException {
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(58);
        }
        if (sourceSetMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(59);
        }
        if (artifactsMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(60);
        }
        if (mergedDependencyMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(61);
        }
        if (ownerDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(62);
        }
        if (dependencies == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(63);
        }
        int classpathOrderShift = 0;
        LinkedHashMap<ExternalDependencyId, ExternalDependency> dependencyMap = new LinkedHashMap<ExternalDependencyId, ExternalDependency>();
        for (ExternalDependency dependency : dependencies) {
            ExternalDependency dep = (ExternalDependency)dependencyMap.get(dependency.getId());
            if (dep instanceof AbstractExternalDependency) {
                dep.getDependencies().addAll(ContainerUtil.subtract((Collection)dependency.getDependencies(), (Collection)dep.getDependencies()));
                continue;
            }
            dependencyMap.put(dependency.getId(), dependency);
        }
        for (ExternalDependency dependency : dependencyMap.values()) {
            File file3;
            LibraryData library;
            String libraryName;
            LibraryLevel level;
            Object level2;
            LibraryData library2;
            String libraryName2;
            LibraryDependencyData libraryDependencyData;
            Collection transitiveDependencies = dependency.getDependencies();
            ExternalDependency mergedDependency = (ExternalDependency)ContainerUtil.getOrElse(mergedDependencyMap, (Object)dependency.getId(), (Object)dependency);
            DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(mergedDependency.getScope());
            ModuleData ownerModule = null;
            if (ownerDataNode.getData() instanceof ModuleData) {
                ownerModule = (ModuleData)ownerDataNode.getData();
            } else if (ownerDataNode.getData() instanceof DependencyData) {
                ownerModule = ((DependencyData)ownerDataNode.getData()).getOwnerModule();
            }
            assert (ownerModule != null);
            DataNode depOwnerDataNode = null;
            if (mergedDependency instanceof ExternalProjectDependency) {
                ExternalProjectDependency projectDependency = (ExternalProjectDependency)mergedDependency;
                ArrayList<ProjectDependencyInfo> projectDependencyInfos = new ArrayList<ProjectDependencyInfo>();
                String selectionReason = projectDependency.getSelectionReason();
                if ("composite build substitution".equals(selectionReason) && resolverCtx.getSettings() != null) {
                    GradleExecutionWorkspace executionWorkspace = resolverCtx.getSettings().getExecutionWorkspace();
                    ModuleData moduleData = executionWorkspace.findModuleDataByArtifacts(projectDependency.getProjectDependencyArtifacts());
                    if (moduleData != null) {
                        projectDependencyInfos.add(new ProjectDependencyInfo(moduleData, null, projectDependency.getProjectDependencyArtifacts()));
                    }
                } else {
                    MultiMap projectPairs = new MultiMap((Map)new Reference2ObjectLinkedOpenHashMap());
                    for (File file2 : projectDependency.getProjectDependencyArtifacts()) {
                        Pair<DataNode<GradleSourceSetData>, ExternalSourceSet> projectPair;
                        String moduleId = artifactsMap.get(ExternalSystemApiUtil.toCanonicalPath((String)file2.getAbsolutePath()));
                        if (moduleId == null || (projectPair = sourceSetMap.get(moduleId)) == null) continue;
                        projectPairs.putValue(projectPair, (Object)file2);
                    }
                    for (Map.Entry entry : projectPairs.entrySet()) {
                        projectDependencyInfos.add(new ProjectDependencyInfo((ModuleData)((DataNode)((Pair)entry.getKey()).first).getData(), (ExternalSourceSet)((Pair)entry.getKey()).second, (Collection)entry.getValue()));
                    }
                    String moduleIdFromDependency = GradleProjectResolverUtil.getModuleId(projectDependency);
                    Pair<DataNode<GradleSourceSetData>, ExternalSourceSet> projectPairFromMap = sourceSetMap.get(moduleIdFromDependency);
                    if (projectPairFromMap != null && GradleProjectResolverUtil.doesNotContainDependencyOn(projectDependencyInfos, (GradleSourceSetData)((Object)((DataNode)projectPairFromMap.first).getData()))) {
                        Collection artifacts = projectDependency.getProjectDependencyArtifacts();
                        artifacts.removeAll(GradleProjectResolverUtil.collectProcessedArtifacts(projectDependencyInfos));
                        projectDependencyInfos.add(new ProjectDependencyInfo((ModuleData)((DataNode)projectPairFromMap.first).getData(), (ExternalSourceSet)projectPairFromMap.second, artifacts));
                    }
                }
                if (projectDependencyInfos.isEmpty()) {
                    LibraryLevel level3 = LibraryLevel.MODULE;
                    LibraryData library3 = new LibraryData(GradleConstants.SYSTEM_ID, "");
                    libraryDependencyData = new LibraryDependencyData(ownerModule, library3, level3);
                    libraryDependencyData.setScope(dependencyScope);
                    libraryDependencyData.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                    libraryDependencyData.setExported(mergedDependency.getExported());
                    if (!projectDependency.getProjectDependencyArtifacts().isEmpty()) {
                        for (File artifact : projectDependency.getProjectDependencyArtifacts()) {
                            library3.addPath(LibraryPathType.BINARY, artifact.getPath());
                        }
                        depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
                    } else {
                        depOwnerDataNode = ownerDataNode;
                    }
                } else {
                    int i2 = 0;
                    for (ProjectDependencyInfo projectDependencyInfo : projectDependencyInfos) {
                        if (i2++ > 0 && transitiveDependencies.isEmpty()) {
                            ++classpathOrderShift;
                        }
                        ModuleDependencyData moduleDependencyData = new ModuleDependencyData(ownerModule, projectDependencyInfo.myModuleData);
                        moduleDependencyData.setScope(dependencyScope);
                        if (projectDependencyInfo.mySourceSet != null && GradleProjectResolverUtil.isTestSourceSet(projectDependencyInfo.mySourceSet)) {
                            moduleDependencyData.setProductionOnTestDependency(true);
                        }
                        moduleDependencyData.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                        moduleDependencyData.setExported(mergedDependency.getExported());
                        moduleDependencyData.setModuleDependencyArtifacts((Collection)ContainerUtil.map(projectDependencyInfo.dependencyArtifacts, File::getPath));
                        depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
                    }
                    if (projectDependencyInfos.size() > 1) {
                        depOwnerDataNode = ownerDataNode;
                    }
                }
            } else if (mergedDependency instanceof ExternalLibraryDependency) {
                File javaDocPath;
                libraryName2 = mergedDependency.getId().getPresentableName();
                library2 = new LibraryData(GradleConstants.SYSTEM_ID, libraryName2);
                library2.setArtifactId(mergedDependency.getId().getName());
                library2.setGroup(mergedDependency.getId().getGroup());
                library2.setVersion(mergedDependency.getId().getVersion());
                library2.addPath(LibraryPathType.BINARY, ((ExternalLibraryDependency)mergedDependency).getFile().getAbsolutePath());
                File sourcePath = ((ExternalLibraryDependency)mergedDependency).getSource();
                if (sourcePath != null) {
                    library2.addPath(LibraryPathType.SOURCE, sourcePath.getAbsolutePath());
                }
                if ((javaDocPath = ((ExternalLibraryDependency)mergedDependency).getJavadoc()) != null) {
                    library2.addPath(LibraryPathType.DOC, javaDocPath.getAbsolutePath());
                }
                Object object = level2 = StringUtil.isNotEmpty((String)libraryName2) ? LibraryLevel.PROJECT : LibraryLevel.MODULE;
                if (StringUtil.isEmpty((String)libraryName2) || !GradleProjectResolverUtil.linkProjectLibrary(resolverCtx, ideProject, library2)) {
                    level2 = LibraryLevel.MODULE;
                }
                libraryDependencyData = new LibraryDependencyData(ownerModule, library2, (LibraryLevel)level2);
                libraryDependencyData.setScope(dependencyScope);
                libraryDependencyData.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                libraryDependencyData.setExported(mergedDependency.getExported());
                depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
            } else if (mergedDependency instanceof ExternalMultiLibraryDependency) {
                level = LibraryLevel.MODULE;
                libraryName = mergedDependency.getId().getPresentableName();
                library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName);
                library.setArtifactId(mergedDependency.getId().getName());
                library.setGroup(mergedDependency.getId().getGroup());
                library.setVersion(mergedDependency.getId().getVersion());
                LibraryDependencyData libraryDependencyData2 = new LibraryDependencyData(ownerModule, library, level);
                libraryDependencyData2.setScope(dependencyScope);
                libraryDependencyData2.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                libraryDependencyData2.setExported(mergedDependency.getExported());
                for (File file3 : ((ExternalMultiLibraryDependency)mergedDependency).getFiles()) {
                    library.addPath(LibraryPathType.BINARY, file3.getAbsolutePath());
                }
                for (File file3 : ((ExternalMultiLibraryDependency)mergedDependency).getSources()) {
                    library.addPath(LibraryPathType.SOURCE, file3.getAbsolutePath());
                }
                level2 = ((ExternalMultiLibraryDependency)mergedDependency).getJavadoc().iterator();
                while (level2.hasNext()) {
                    file3 = (File)level2.next();
                    library.addPath(LibraryPathType.DOC, file3.getAbsolutePath());
                }
                depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData2);
            } else if (mergedDependency instanceof FileCollectionDependency) {
                level = LibraryLevel.MODULE;
                libraryName = "";
                library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName);
                LibraryDependencyData libraryDependencyData3 = new LibraryDependencyData(ownerModule, library, level);
                libraryDependencyData3.setScope(dependencyScope);
                libraryDependencyData3.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                libraryDependencyData3.setExported(mergedDependency.getExported());
                level2 = ((FileCollectionDependency)mergedDependency).getFiles().iterator();
                while (level2.hasNext()) {
                    file3 = (File)level2.next();
                    library.addPath(LibraryPathType.BINARY, file3.getAbsolutePath());
                    if (!(mergedDependency instanceof DefaultFileCollectionDependency) || !((DefaultFileCollectionDependency)mergedDependency).isExcludedFromIndexing()) continue;
                    library.addPath(LibraryPathType.EXCLUDED, file3.getAbsolutePath());
                }
                ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData3);
            } else if (mergedDependency instanceof UnresolvedExternalDependency) {
                libraryName2 = mergedDependency.getId().getPresentableName();
                library2 = new LibraryData(GradleConstants.SYSTEM_ID, libraryName2, true);
                String failureMessage = ((UnresolvedExternalDependency)mergedDependency).getFailureMessage();
                if (failureMessage != null) {
                    library2.addPath(LibraryPathType.BINARY, failureMessage);
                }
                boolean isOfflineWork = resolverCtx.getSettings() != null && resolverCtx.getSettings().isOfflineWork();
                UnresolvedDependencySyncIssue buildIssue = new UnresolvedDependencySyncIssue(libraryName2, failureMessage, resolverCtx.getProjectPath(), isOfflineWork);
                resolverCtx.report(MessageEvent.Kind.ERROR, buildIssue);
                LibraryLevel level4 = GradleProjectResolverUtil.linkProjectLibrary(resolverCtx, ideProject, library2) ? LibraryLevel.PROJECT : LibraryLevel.MODULE;
                LibraryDependencyData libraryDependencyData4 = new LibraryDependencyData(ownerModule, library2, level4);
                libraryDependencyData4.setScope(dependencyScope);
                libraryDependencyData4.setOrder(mergedDependency.getClasspathOrder() + classpathOrderShift);
                ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData4);
            }
            if (depOwnerDataNode == null || transitiveDependencies.isEmpty()) continue;
            GradleProjectResolverUtil.doBuildDependencies(resolverCtx, sourceSetMap, artifactsMap, mergedDependencyMap, depOwnerDataNode, transitiveDependencies, ideProject);
        }
    }

    private static boolean isTestSourceSet(@NotNull ExternalSourceSet sourceSet) {
        if (sourceSet == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(64);
        }
        if (sourceSet.getSources().isEmpty()) {
            return false;
        }
        return sourceSet.getSources().keySet().stream().allMatch(IExternalSystemSourceType::isTest);
    }

    private static Collection<File> collectProcessedArtifacts(Collection<ProjectDependencyInfo> infos) {
        return infos.stream().flatMap(info -> info.dependencyArtifacts.stream()).collect(Collectors.toSet());
    }

    private static boolean doesNotContainDependencyOn(Collection<ProjectDependencyInfo> infos, GradleSourceSetData data) {
        return infos.stream().noneMatch(info -> info.myModuleData.equals((Object)data));
    }

    @Deprecated
    public static boolean linkProjectLibrary(@Nullable DataNode<ProjectData> ideProject, @NotNull LibraryData library) {
        if (library == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(65);
        }
        return GradleProjectResolverUtil.linkProjectLibrary(null, ideProject, library);
    }

    public static boolean linkProjectLibrary(ProjectResolverContext context, @Nullable DataNode<ProjectData> ideProject, @NotNull LibraryData library) {
        if (library == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(66);
        }
        if (ideProject == null) {
            return false;
        }
        String libraryName = library.getExternalName();
        DataNode libraryData = ExternalSystemApiUtil.find(ideProject, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY, node -> libraryName.equals(((LibraryData)node.getData()).getExternalName()));
        if (libraryData == null) {
            ideProject.createChild(ProjectKeys.LIBRARY, (Object)library);
            return true;
        }
        return ((LibraryData)libraryData.getData()).equals((Object)library);
    }

    public static boolean isIdeaTask(String taskName, @Nullable String group) {
        if ((group == null || "ide".equalsIgnoreCase(group)) && StringUtil.containsIgnoreCase((String)taskName, (String)"idea")) {
            return true;
        }
        return "other".equalsIgnoreCase(group) && StringUtil.containsIgnoreCase((String)taskName, (String)"idea");
    }

    @Nullable
    public static DataNode<ModuleData> findModule(@Nullable DataNode<ProjectData> projectNode, @NotNull String modulePath) {
        if (modulePath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(67);
        }
        if (projectNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(projectNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE, node -> ((ModuleData)node.getData()).getLinkedExternalProjectPath().equals(modulePath));
    }

    @Nullable
    public static DataNode<ModuleData> findModuleById(@Nullable DataNode<ProjectData> projectNode, @NotNull String path) {
        if (path == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(68);
        }
        if (projectNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(projectNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE, node -> ((ModuleData)node.getData()).getId().equals(path));
    }

    @ApiStatus.Internal
    public static Stream<GradleProjectResolverExtension> createProjectResolvers(@Nullable ProjectResolverContext projectResolverContext) {
        return GradleProjectResolverExtension.EP_NAME.extensions().map(extension -> {
            try {
                GradleProjectResolverExtension resolverExtension = (GradleProjectResolverExtension)extension.getClass().newInstance();
                if (projectResolverContext != null) {
                    resolverExtension.setProjectResolverContext(projectResolverContext);
                }
                return resolverExtension;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }).sorted(ExternalSystemApiUtil.ORDER_AWARE_COMPARATOR);
    }

    @Nullable
    public static DataNode<TaskData> findTask(@Nullable DataNode<ProjectData> projectNode, @NotNull String modulePath, @NotNull String taskPath) {
        String taskName;
        DataNode<ModuleData> moduleNode;
        if (modulePath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(69);
        }
        if (taskPath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(70);
        }
        if (StringUtil.startsWith((CharSequence)taskPath, (CharSequence)":")) {
            int i2 = taskPath.lastIndexOf(58);
            DataNode<ModuleData> dataNode = moduleNode = i2 == 0 ? null : GradleProjectResolverUtil.findModuleById(projectNode, taskPath.substring(0, i2));
            if (moduleNode == null) {
                moduleNode = GradleProjectResolverUtil.findModule(projectNode, modulePath);
            }
            taskName = i2 + 1 <= taskPath.length() ? taskPath.substring(i2 + 1) : taskPath;
        } else {
            moduleNode = GradleProjectResolverUtil.findModule(projectNode, modulePath);
            taskName = taskPath;
        }
        if (moduleNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.TASK, node -> {
            String name = ((TaskData)node.getData()).getName();
            return name.equals(taskName) || name.equals(taskPath);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverCtx";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: 
            case 24: 
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil";
                break;
            }
            case 5: 
            case 8: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: 
            case 34: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDependency";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 42: 
            case 44: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleHomeDir";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 47: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 48: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collect";
                break;
            }
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetMap";
                break;
            }
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactsMap";
                break;
            }
            case 56: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerDataNode";
                break;
            }
            case 57: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedDependencyMap";
                break;
            }
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalModuleName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "gradlePathToQualifiedName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleConfigPath";
                break;
            }
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleId";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradlePath";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createMainModule";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 40: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInternalModuleName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "gradlePathToQualifiedName";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModuleConfigPath";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getModuleId";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getGradlePath";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "attachGradleSdkSources";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "collectSourcesAndJavadocsFor";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "collectSourcesAndJavadocsFromGradleCache";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "collectSourcesAndJavadocsFromTheSameFolder";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "buildDependencies";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "doBuildDependencies";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isTestSourceSet";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "linkProjectLibrary";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "findModuleById";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ProjectDependencyInfo {
        @NotNull
        final ModuleData myModuleData;
        @Nullable
        final ExternalSourceSet mySourceSet;
        final Collection<File> dependencyArtifacts;

        ProjectDependencyInfo(@NotNull ModuleData moduleData, @Nullable ExternalSourceSet sourceSet, Collection<File> dependencyArtifacts) {
            if (moduleData == null) {
                ProjectDependencyInfo.$$$reportNull$$$0(0);
            }
            this.myModuleData = moduleData;
            this.mySourceSet = sourceSet;
            this.dependencyArtifacts = dependencyArtifacts;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil$ProjectDependencyInfo", "<init>"));
        }
    }
}

