/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.externalSystem.util.environment.Environment;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.util.GradleProperties;
import org.jetbrains.plugins.gradle.util.GradlePropertiesImpl;
import org.jetbrains.plugins.gradle.util.GradlePropertiesUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0006\u001a\n\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"GRADLE_CACHE_DIR_NAME", "", "GRADLE_JAVA_HOME_PROPERTY", "PROPERTIES_FILE_NAME", "USER_HOME", "getGradleHomePropertiesPath", "Ljava/nio/file/Path;", "getGradleProjectPropertiesPath", "externalProjectPath", "getGradleProperties", "Lorg/jetbrains/plugins/gradle/util/GradleProperties;", "getGradleServiceDirectoryPath", "getPossiblePropertiesFiles", "", "loadGradleProperties", "propertiesPath", "loadProperties", "Ljava/util/Properties;", "propertiesFile", "mergeGradleProperties", "most", "other", "intellij.gradle.common"})
@JvmName(name="GradlePropertiesUtil")
public final class GradlePropertiesUtil {
    @NotNull
    public static final String USER_HOME = "user.home";
    @NotNull
    public static final String GRADLE_CACHE_DIR_NAME = ".gradle";
    @NotNull
    public static final String PROPERTIES_FILE_NAME = "gradle.properties";
    @NotNull
    public static final String GRADLE_JAVA_HOME_PROPERTY = "org.gradle.java.home";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GradleProperties getGradleProperties(@NotNull Path externalProjectPath) {
        Intrinsics.checkParameterIsNotNull((Object)externalProjectPath, (String)"externalProjectPath");
        Sequence $this$reduce$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)GradlePropertiesUtil.getPossiblePropertiesFiles(externalProjectPath)), (Function1)getGradleProperties.1.INSTANCE), (Function1)getGradleProperties.2.INSTANCE);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p2;
            GradleProperties gradleProperties = (GradleProperties)iterator$iv.next();
            GradleProperties p1 = (GradleProperties)accumulator$iv;
            boolean bl = false;
            accumulator$iv = GradlePropertiesUtil.mergeGradleProperties(p1, (GradleProperties)p2);
        }
        return (GradleProperties)accumulator$iv;
    }

    private static final List<Path> getPossiblePropertiesFiles(Path externalProjectPath) {
        return CollectionsKt.listOfNotNull((Object[])new Path[]{GradlePropertiesUtil.getGradleServiceDirectoryPath(), GradlePropertiesUtil.getGradleHomePropertiesPath(), GradlePropertiesUtil.getGradleProjectPropertiesPath(externalProjectPath)});
    }

    private static final Path getGradleServiceDirectoryPath() {
        GradleSystemSettings gradleSystemSettings = GradleSystemSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleSystemSettings, (String)"GradleSystemSettings.getInstance()");
        GradleSystemSettings systemSettings = gradleSystemSettings;
        String gradleUserHome = systemSettings.getServiceDirectoryPath();
        if (gradleUserHome == null) {
            return null;
        }
        return Paths.get(gradleUserHome, PROPERTIES_FILE_NAME);
    }

    private static final Path getGradleHomePropertiesPath() {
        String gradleUserHome = Environment.Companion.getVariable("GRADLE_USER_HOME");
        if (gradleUserHome != null) {
            return Paths.get(gradleUserHome, PROPERTIES_FILE_NAME);
        }
        String userHome = Environment.Companion.getProperty(USER_HOME);
        if (userHome != null) {
            return Paths.get(userHome, GRADLE_CACHE_DIR_NAME, PROPERTIES_FILE_NAME);
        }
        return null;
    }

    private static final Path getGradleProjectPropertiesPath(Path externalProjectPath) {
        Path path = externalProjectPath.resolve(PROPERTIES_FILE_NAME);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"externalProjectPath.resolve(PROPERTIES_FILE_NAME)");
        return path;
    }

    private static final GradleProperties loadGradleProperties(Path propertiesPath) {
        GradleProperties.GradleProperty<String> gradleProperty;
        String javaHome;
        Properties properties = GradlePropertiesUtil.loadProperties(propertiesPath);
        if (properties == null) {
            return GradleProperties.EMPTY.INSTANCE;
        }
        Properties properties2 = properties;
        String string = javaHome = properties2.getProperty(GRADLE_JAVA_HOME_PROPERTY);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            gradleProperty = new GradleProperties.GradleProperty<String>(it, ((Object)propertiesPath).toString());
        } else {
            gradleProperty = null;
        }
        GradleProperties.GradleProperty<String> javaHomeProperty = gradleProperty;
        return new GradlePropertiesImpl(javaHomeProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadProperties(Path propertiesFile) {
        if (!PathKt.isFile((Path)propertiesFile) || !PathKt.exists((Path)propertiesFile)) {
            return null;
        }
        Properties properties = new Properties();
        Closeable closeable = PathKt.inputStream((Path)propertiesFile);
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            properties.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return properties;
    }

    private static final GradleProperties mergeGradleProperties(GradleProperties most, GradleProperties other) {
        GradleProperties gradleProperties;
        if (most instanceof GradleProperties.EMPTY) {
            gradleProperties = other;
        } else if (other instanceof GradleProperties.EMPTY) {
            gradleProperties = most;
        } else {
            GradleProperties.GradleProperty<String> gradleProperty = most.getJavaHomeProperty();
            if (gradleProperty == null) {
                gradleProperty = other.getJavaHomeProperty();
            }
            gradleProperties = new GradlePropertiesImpl(gradleProperty);
        }
        return gradleProperties;
    }

    public static final /* synthetic */ GradleProperties access$loadGradleProperties(Path propertiesPath) {
        return GradlePropertiesUtil.loadGradleProperties(propertiesPath);
    }
}

