/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.MessageLite;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.io.BaseOutputReader;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.javac.CompilationPaths;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacMessageHandler;
import org.jetbrains.jps.javac.ExternalJavacProcess;
import org.jetbrains.jps.javac.ExternalJavacRunResult;
import org.jetbrains.jps.javac.JavacProtoUtil;
import org.jetbrains.jps.javac.JavacRemoteProto;
import org.jetbrains.jps.javac.ModulePath;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;

public class ExternalJavacManager
extends ProcessAdapter {
    private static final Logger LOG = Logger.getInstance(ExternalJavacManager.class);
    public static final GlobalContextKey<ExternalJavacManager> KEY = GlobalContextKey.create("_external_javac_server_");
    public static final int DEFAULT_SERVER_PORT = 7878;
    public static final String STDOUT_LINE_PREFIX = "JAVAC_PROCESS[STDOUT]";
    public static final String STDERR_LINE_PREFIX = "JAVAC_PROCESS[STDERR]";
    private static final AttributeKey<UUID> PROCESS_ID_KEY = AttributeKey.valueOf((String)"ExternalJavacServer.ProcessId");
    private static final Key<Integer> PROCESS_HASH = Key.create((String)"ExternalJavacServer.SdkHomePath");
    private final File myWorkingDir;
    private final ChannelRegistrar myChannelRegistrar;
    private int myListenPort;
    private final Map<UUID, CompileSession> mySessions;
    private final Map<UUID, ExternalJavacProcessHandler> myRunningProcesses;
    private final Map<UUID, Channel> myConnections;
    private final Executor myExecutor;
    private boolean myOwnExecutor;
    private final long myKeepAliveTimeout;

    @Deprecated
    public ExternalJavacManager(@NotNull File workingDir) {
        if (workingDir == null) {
            ExternalJavacManager.$$$reportNull$$$0(0);
        }
        this(workingDir, ConcurrencyUtil.newSingleThreadExecutor((String)"Javac server event loop pool"));
        this.myOwnExecutor = true;
    }

    public ExternalJavacManager(@NotNull File workingDir, @NotNull Executor executor) {
        if (workingDir == null) {
            ExternalJavacManager.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            ExternalJavacManager.$$$reportNull$$$0(2);
        }
        this(workingDir, executor, 300000L);
    }

    public ExternalJavacManager(@NotNull File workingDir, @NotNull Executor executor, long keepAliveTimeout) {
        if (workingDir == null) {
            ExternalJavacManager.$$$reportNull$$$0(3);
        }
        if (executor == null) {
            ExternalJavacManager.$$$reportNull$$$0(4);
        }
        this.myListenPort = 7878;
        this.mySessions = Collections.synchronizedMap(new HashMap());
        this.myRunningProcesses = Collections.synchronizedMap(new HashMap());
        this.myConnections = Collections.synchronizedMap(new HashMap());
        this.myWorkingDir = workingDir;
        this.myChannelRegistrar = new ChannelRegistrar();
        this.myExecutor = executor;
        this.myKeepAliveTimeout = keepAliveTimeout;
    }

    public void start(int listenPort) {
        CompilationRequestsHandler compilationRequestsHandler = new CompilationRequestsHandler();
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(1, this.myExecutor)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer((ChannelHandler)compilationRequestsHandler){
            final /* synthetic */ ChannelHandler val$compilationRequestsHandler;
            {
                this.val$compilationRequestsHandler = channelHandler;
            }

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{ExternalJavacManager.this.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)JavacRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), this.val$compilationRequestsHandler});
            }
        });
        try {
            InetAddress loopback = InetAddress.getByName(null);
            this.myChannelRegistrar.add(bootstrap.bind(loopback, listenPort).syncUninterruptibly().channel());
            this.myListenPort = listenPort;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public boolean forkJavac(String javaHome, int heapSize, List<String> vmOptions, List<String> options, Collection<? extends File> platformCp, Collection<? extends File> classpath, Collection<? extends File> upgradeModulePath, Collection<? extends File> modulePath, Collection<? extends File> sourcePath, Collection<? extends File> files, Map<File, Set<File>> outs, DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, JavaCompilingTool compilingTool, CanceledStatus cancelStatus) {
        return this.forkJavac(javaHome, heapSize, vmOptions, options, CompilationPaths.create(platformCp, classpath, upgradeModulePath, ModulePath.create(modulePath), sourcePath), files, outs, diagnosticSink, outputSink, compilingTool, cancelStatus, false).get();
    }

    public ExternalJavacRunResult forkJavac(String javaHome, int heapSize, List<String> vmOptions, List<String> options, CompilationPaths paths, Collection<? extends File> files, Map<File, Set<File>> outs, DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, JavaCompilingTool compilingTool, CanceledStatus cancelStatus, boolean keepProcessAlive) {
        try {
            ExternalJavacProcessHandler running = this.findRunningProcess(ExternalJavacManager.processHash(javaHome, vmOptions, compilingTool));
            ExternalJavacProcessHandler processHandler = running != null ? running : this.launchExternalJavacProcess(javaHome, heapSize, this.myListenPort, this.myWorkingDir, vmOptions, compilingTool, keepProcessAlive);
            Channel channel = this.lookupChannel(processHandler.getProcessId());
            if (channel != null) {
                CompileSession session = new CompileSession(processHandler.getProcessId(), new ExternalJavacMessageHandler(diagnosticSink, outputSink, ExternalJavacManager.getEncodingName(options)), cancelStatus);
                this.mySessions.put(session.getId(), session);
                channel.writeAndFlush((Object)JavacProtoUtil.toMessage((UUID)session.getId(), (JavacRemoteProto.Message.Request)JavacProtoUtil.createCompilationRequest(options, files, paths.getClasspath(), paths.getPlatformClasspath(), (ModulePath)paths.getModulePath(), paths.getUpgradeModulePath(), paths.getSourcePath(), outs)));
                return session;
            }
            LOG.warn("Failed to connect to javac process");
        }
        catch (Throwable e) {
            LOG.info(e);
            diagnosticSink.report((Diagnostic)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
        }
        return ExternalJavacRunResult.FAILURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean waitForAllProcessHandlers(long time, @NotNull TimeUnit timeUnit) {
        ArrayList<ExternalJavacProcessHandler> processes;
        if (timeUnit == null) {
            ExternalJavacManager.$$$reportNull$$$0(5);
        }
        Map<UUID, ExternalJavacProcessHandler> map = this.myRunningProcesses;
        synchronized (map) {
            processes = new ArrayList<ExternalJavacProcessHandler>(this.myRunningProcesses.values());
        }
        for (ProcessHandler processHandler : processes) {
            void unit;
            if (processHandler.waitFor(unit.toMillis(time))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean awaitNettyThreadPoolTermination(long time, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            ExternalJavacManager.$$$reportNull$$$0(6);
        }
        if (this.myOwnExecutor && this.myExecutor instanceof ExecutorService) {
            try {
                void unit;
                return ((ExecutorService)this.myExecutor).awaitTermination(time, (TimeUnit)unit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExternalJavacProcessHandler findRunningProcess(int processHash) {
        ExternalJavacManager.debug(() -> "findRunningProcess: looking for hash " + processHash);
        ArrayList<ExternalJavacProcessHandler> idleProcesses = null;
        try {
            Map<UUID, ExternalJavacProcessHandler> map = this.myRunningProcesses;
            synchronized (map) {
                for (Map.Entry<UUID, ExternalJavacProcessHandler> entry : this.myRunningProcesses.entrySet()) {
                    ExternalJavacProcessHandler process = entry.getValue();
                    if (!process.isKeepProcessAlive()) continue;
                    Integer hash = (Integer)PROCESS_HASH.get((UserDataHolder)process);
                    if (hash != null && hash == processHash && process.lock()) {
                        ExternalJavacManager.debug(() -> "findRunningProcess: returning process " + process.getProcessId() + " for hash " + processHash);
                        ExternalJavacProcessHandler externalJavacProcessHandler = process;
                        return externalJavacProcessHandler;
                    }
                    if (process.getIdleTime() <= this.myKeepAliveTimeout) continue;
                    if (idleProcesses == null) {
                        idleProcesses = new ArrayList<ExternalJavacProcessHandler>();
                    }
                    ExternalJavacManager.debug(() -> "findRunningProcess: adding " + process.getProcessId() + " to idle list");
                    idleProcesses.add(process);
                }
            }
            ExternalJavacManager.debug(() -> "findRunningProcess: no running process for " + processHash + " is found");
            map = null;
            return map;
        }
        finally {
            if (idleProcesses != null) {
                for (ExternalJavacProcessHandler process : idleProcesses) {
                    this.shutdownProcess(process);
                }
            }
        }
    }

    private static <T> void debug(T data, Function<T, String> message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message.apply(data));
        }
    }

    private static void debug(Supplier<String> message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message.get());
        }
    }

    private static int processHash(String sdkHomePath, List<String> vmOptions, JavaCompilingTool tool) {
        return Objects.hash(sdkHomePath.replace(File.separatorChar, '/'), vmOptions, tool.getId());
    }

    @Nullable
    private static String getEncodingName(List<String> options) {
        int p = options.indexOf("-encoding");
        return p >= 0 && p < options.size() - 1 ? options.get(p + 1) : null;
    }

    public boolean isRunning() {
        return !this.myChannelRegistrar.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Map<UUID, Channel> map = this.myConnections;
        synchronized (map) {
            for (Map.Entry<UUID, Channel> entry : this.myConnections.entrySet()) {
                entry.getValue().writeAndFlush((Object)JavacProtoUtil.toMessage((UUID)entry.getKey(), (JavacRemoteProto.Message.Request)JavacProtoUtil.createShutdownRequest()));
            }
        }
        this.myChannelRegistrar.close().awaitUninterruptibly();
        if (this.myOwnExecutor && this.myExecutor instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)this.myExecutor;
            service.shutdown();
            try {
                service.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownIdleProcesses() {
        ArrayList<ExternalJavacProcessHandler> idleProcesses = null;
        Map<UUID, ExternalJavacProcessHandler> map = this.myRunningProcesses;
        synchronized (map) {
            for (ExternalJavacProcessHandler process : this.myRunningProcesses.values()) {
                long idle = process.getIdleTime();
                if (idle <= this.myKeepAliveTimeout) continue;
                if (idleProcesses == null) {
                    idleProcesses = new ArrayList<ExternalJavacProcessHandler>();
                }
                idleProcesses.add(process);
            }
        }
        if (idleProcesses != null) {
            for (ExternalJavacProcessHandler process : idleProcesses) {
                this.shutdownProcess(process);
            }
        }
    }

    private boolean shutdownProcess(ExternalJavacProcessHandler process) {
        UUID processId = process.getProcessId();
        ExternalJavacManager.debug(() -> "shutdownProcess: shutting down " + processId);
        Channel conn = this.myConnections.get(processId);
        if (conn != null && process.lock()) {
            ExternalJavacManager.debug(() -> "shutdownProcess: sending shutdown request to " + processId);
            conn.writeAndFlush((Object)JavacProtoUtil.toMessage((UUID)processId, (JavacRemoteProto.Message.Request)JavacProtoUtil.createShutdownRequest()));
            return true;
        }
        return false;
    }

    private ExternalJavacProcessHandler launchExternalJavacProcess(String sdkHomePath, int heapSize, int port, File workingDir, List<String> vmOptions, JavaCompilingTool compilingTool, boolean keepProcessAlive) throws Exception {
        UUID processId = UUID.randomUUID();
        ArrayList<String> cmdLine = new ArrayList<String>();
        ExternalJavacManager.appendParam(cmdLine, ExternalJavacManager.getVMExecutablePath(sdkHomePath));
        ExternalJavacManager.appendParam(cmdLine, "-Djava.awt.headless=true");
        if (heapSize > 0) {
            int xms = heapSize / 2;
            if (xms > 32) {
                ExternalJavacManager.appendParam(cmdLine, "-Xms" + xms + "m");
            }
            ExternalJavacManager.appendParam(cmdLine, "-Xmx" + heapSize + "m");
        }
        ExternalJavacManager.copyProperty(cmdLine, "file.encoding");
        ExternalJavacManager.copyProperty(cmdLine, "user.language");
        ExternalJavacManager.copyProperty(cmdLine, "user.country");
        ExternalJavacManager.copyProperty(cmdLine, "user.region");
        ExternalJavacManager.copyProperty(cmdLine, "io.netty.noUnsafe");
        ExternalJavacManager.appendParam(cmdLine, "-Djps.java.compiling.tool=" + compilingTool.getId());
        ExternalJavacManager.appendParam(cmdLine, "-Djava.ext.dirs=");
        ExternalJavacManager.appendParam(cmdLine, "-Dlog4j.defaultInitOverride=true");
        for (String option : vmOptions) {
            ExternalJavacManager.appendParam(cmdLine, option);
        }
        ExternalJavacManager.appendParam(cmdLine, "-classpath");
        List<File> cp = ClasspathBootstrap.getExternalJavacProcessClasspath(sdkHomePath, compilingTool);
        ExternalJavacManager.appendParam(cmdLine, cp.stream().map(File::getPath).collect(Collectors.joining(File.pathSeparator)));
        ExternalJavacManager.appendParam(cmdLine, ExternalJavacProcess.class.getName());
        ExternalJavacManager.appendParam(cmdLine, processId.toString());
        ExternalJavacManager.appendParam(cmdLine, "127.0.0.1");
        ExternalJavacManager.appendParam(cmdLine, Integer.toString(port));
        ExternalJavacManager.appendParam(cmdLine, Boolean.toString(keepProcessAlive));
        ExternalJavacManager.appendParam(cmdLine, FileUtil.toSystemIndependentName((String)workingDir.getPath()));
        ExternalJavacManager.debug(() -> "starting external compiler: " + cmdLine);
        FileUtil.createDirectory((File)workingDir);
        int processHash = ExternalJavacManager.processHash(sdkHomePath, vmOptions, compilingTool);
        ExternalJavacProcessHandler processHandler = this.createProcessHandler(processId, new ProcessBuilder(cmdLine).directory(workingDir).start(), StringUtil.join(cmdLine, (String)" "), keepProcessAlive);
        PROCESS_HASH.set((UserDataHolder)processHandler, (Object)processHash);
        processHandler.lock();
        this.myRunningProcesses.put(processId, processHandler);
        ExternalJavacManager.debug(() -> "external compiler process registered: id=" + processId + ", hash=" + processHash);
        processHandler.addProcessListener((ProcessListener)this);
        processHandler.startNotify();
        return processHandler;
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            ExternalJavacManager.$$$reportNull$$$0(7);
        }
        UUID processId = ((ExternalJavacProcessHandler)event.getProcessHandler()).getProcessId();
        ExternalJavacManager.debug(() -> "process " + processId + " terminated");
        this.myRunningProcesses.remove(processId);
        if (this.myConnections.get(processId) == null) {
            this.cleanSessions(processId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanSessions(UUID processId) {
        Map<UUID, CompileSession> map = this.mySessions;
        synchronized (map) {
            Iterator<Map.Entry<UUID, CompileSession>> it = this.mySessions.entrySet().iterator();
            while (it.hasNext()) {
                CompileSession session = it.next().getValue();
                if (!processId.equals(session.getProcessId())) continue;
                session.setDone();
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        String text;
        if (event == null) {
            ExternalJavacManager.$$$reportNull$$$0(8);
        }
        if (outputType == null) {
            ExternalJavacManager.$$$reportNull$$$0(9);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(text = event.getText()))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("text from javac: " + text);
            }
            String prefix = null;
            if (outputType == ProcessOutputTypes.STDOUT) {
                prefix = STDOUT_LINE_PREFIX;
            } else if (outputType == ProcessOutputTypes.STDERR) {
                prefix = STDERR_LINE_PREFIX;
            }
            if (prefix != null) {
                ArrayList<DiagnosticOutputConsumer> consumers = null;
                UUID processId = ((ExternalJavacProcessHandler)event.getProcessHandler()).getProcessId();
                Map<UUID, CompileSession> map = this.mySessions;
                synchronized (map) {
                    for (CompileSession session : this.mySessions.values()) {
                        if (!processId.equals(session.getProcessId())) continue;
                        if (consumers == null) {
                            consumers = new ArrayList<DiagnosticOutputConsumer>();
                        }
                        consumers.add(session.myHandler.getDiagnosticSink());
                    }
                }
                if (consumers != null) {
                    String msg = prefix + ": " + text;
                    for (DiagnosticOutputConsumer consumer : consumers) {
                        consumer.outputLineAvailable(msg);
                    }
                }
            }
        }
    }

    protected ExternalJavacProcessHandler createProcessHandler(UUID processId, @NotNull Process process, @NotNull String commandLine, boolean keepProcessAlive) {
        if (process == null) {
            ExternalJavacManager.$$$reportNull$$$0(10);
        }
        if (commandLine == null) {
            ExternalJavacManager.$$$reportNull$$$0(11);
        }
        return new ExternalJavacProcessHandler(processId, process, commandLine, keepProcessAlive);
    }

    private static void appendParam(List<? super String> cmdLine, String parameter) {
        if (SystemInfo.isWindows) {
            if (parameter.contains("\"")) {
                parameter = StringUtil.replace((String)parameter, (String)"\"", (String)"\\\"");
            } else if (parameter.length() == 0) {
                parameter = "\"\"";
            }
        }
        cmdLine.add(parameter);
    }

    private static void copyProperty(List<? super String> cmdLine, String name) {
        String value = System.getProperty(name);
        if (value != null) {
            ExternalJavacManager.appendParam(cmdLine, "-D" + name + '=' + value);
        }
    }

    private static String getVMExecutablePath(String sdkHome) {
        return sdkHome + "/bin/java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel lookupChannel(UUID processId) {
        Channel channel = null;
        Map<UUID, Channel> map = this.myConnections;
        synchronized (map) {
            channel = this.myConnections.get(processId);
            ExternalJavacManager.debug(channel, ch -> "lookupChannel: channel for " + processId + " is " + ch);
            while (channel == null) {
                if (!this.myRunningProcesses.containsKey(processId)) {
                    ExternalJavacManager.debug(() -> "lookupChannel: no process for " + processId);
                    break;
                }
                try {
                    this.myConnections.wait(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                channel = this.myConnections.get(processId);
                ExternalJavacManager.debug(channel, ch -> "lookupChannel: after wait channel for " + processId + " is " + ch);
            }
        }
        return channel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/javac/ExternalJavacManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForAllProcessHandlers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "awaitNettyThreadPoolTermination";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "onTextAvailable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createProcessHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CompileSession
    extends ExternalJavacRunResult {
        private final UUID myId;
        private final UUID myProcessId;
        private final CanceledStatus myCancelStatus;
        private final ExternalJavacMessageHandler myHandler;
        private final Semaphore myDone;

        CompileSession(@NotNull UUID processId, ExternalJavacMessageHandler handler, CanceledStatus cancelStatus) {
            if (processId == null) {
                CompileSession.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                CompileSession.$$$reportNull$$$0(1);
            }
            this.myDone = new Semaphore();
            this.myProcessId = processId;
            this.myCancelStatus = cancelStatus;
            this.myId = UUID.randomUUID();
            this.myHandler = handler;
            this.myDone.down();
        }

        @NotNull
        public UUID getId() {
            UUID uUID = this.myId;
            if (uUID == null) {
                CompileSession.$$$reportNull$$$0(2);
            }
            return uUID;
        }

        @NotNull
        public UUID getProcessId() {
            UUID uUID = this.myProcessId;
            if (uUID == null) {
                CompileSession.$$$reportNull$$$0(3);
            }
            return uUID;
        }

        @Override
        public boolean isDone() {
            return this.myDone.isUp();
        }

        public void setDone() {
            this.myDone.up();
        }

        public boolean isTerminatedSuccessfully() {
            return this.myHandler.isTerminatedSuccessfully();
        }

        boolean isCancelRequested() {
            return this.myCancelStatus.isCanceled();
        }

        @Override
        @NotNull
        public Boolean get() {
            while (true) {
                try {
                    if (this.myDone.waitForUnsafe(300L)) {
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.notifyCancelled();
            }
            boolean successfully = this.isTerminatedSuccessfully();
            if (!successfully) {
                ExternalJavacManager.debug(() -> "Javac compile session " + this.myId + " in process " + this.myProcessId + "didn't terminate successfully");
            }
            Boolean bl = successfully;
            if (bl == null) {
                CompileSession.$$$reportNull$$$0(4);
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Boolean get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, TimeoutException {
            void unit;
            if (timeUnit == null) {
                CompileSession.$$$reportNull$$$0(5);
            }
            if (!this.myDone.waitForUnsafe(unit.toMillis(timeout))) {
                this.notifyCancelled();
                throw new TimeoutException();
            }
            boolean successfully = this.isTerminatedSuccessfully();
            if (!successfully) {
                ExternalJavacManager.debug(() -> "Javac compile session " + this.myId + " in process " + this.myProcessId + "didn't terminate successfully");
            }
            Boolean bl = successfully;
            if (bl == null) {
                CompileSession.$$$reportNull$$$0(6);
            }
            return bl;
        }

        private void notifyCancelled() {
            Channel channel;
            if (this.isCancelRequested() && ExternalJavacManager.this.myRunningProcesses.containsKey(this.myProcessId) && (channel = (Channel)ExternalJavacManager.this.myConnections.get(this.myProcessId)) != null) {
                channel.writeAndFlush((Object)JavacProtoUtil.toMessage((UUID)this.myId, (JavacRemoteProto.Message.Request)JavacProtoUtil.createCancelRequest()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/ExternalJavacManager$CompileSession";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/ExternalJavacManager$CompileSession";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessId";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ChannelHandler.Sharable
    private static final class ChannelRegistrar
    extends ChannelInboundHandlerAdapter {
        private final ChannelGroup openChannels = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);

        private ChannelRegistrar() {
        }

        public boolean isEmpty() {
            return this.openChannels.isEmpty();
        }

        public void add(@NotNull Channel serverChannel) {
            if (serverChannel == null) {
                ChannelRegistrar.$$$reportNull$$$0(0);
            }
            assert (serverChannel instanceof ServerChannel);
            this.openChannels.add((Object)serverChannel);
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            this.openChannels.add((Object)context.channel());
            super.channelActive(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelGroupFuture close() {
            EventLoopGroup eventLoopGroup = null;
            for (Channel channel : this.openChannels) {
                if (!(channel instanceof ServerChannel)) continue;
                eventLoopGroup = channel.eventLoop().parent();
                break;
            }
            try {
                Iterator iterator = this.openChannels.close();
                return iterator;
            }
            finally {
                if (eventLoopGroup != null) {
                    eventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverChannel", "org/jetbrains/jps/javac/ExternalJavacManager$ChannelRegistrar", "add"));
        }
    }

    @ChannelHandler.Sharable
    private class CompilationRequestsHandler
    extends SimpleChannelInboundHandler<JavacRemoteProto.Message> {
        private CompilationRequestsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelInactive(ChannelHandlerContext context) throws Exception {
            try {
                Channel channel = context.channel();
                UUID processId = (UUID)channel.attr(PROCESS_ID_KEY).get();
                if (processId != null) {
                    ExternalJavacManager.this.cleanSessions(processId);
                    ExternalJavacManager.this.myConnections.remove(processId);
                }
            }
            finally {
                super.channelInactive(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead0(ChannelHandlerContext context, JavacRemoteProto.Message message) throws Exception {
            UUID msgUuid = JavacProtoUtil.fromProtoUUID((JavacRemoteProto.Message.UUID)message.getSessionId());
            CompileSession session = (CompileSession)ExternalJavacManager.this.mySessions.get(msgUuid);
            ExternalJavacMessageHandler handler = session != null ? session.myHandler : null;
            JavacRemoteProto.Message.Type messageType = message.getMessageType();
            JavacRemoteProto.Message reply = null;
            try {
                if (messageType == JavacRemoteProto.Message.Type.RESPONSE) {
                    JavacRemoteProto.Message.Response response = message.getResponse();
                    JavacRemoteProto.Message.Response.Type responseType = response.getResponseType();
                    if (responseType == JavacRemoteProto.Message.Response.Type.REQUEST_ACK) {
                        Channel channel = context.channel();
                        channel.attr(PROCESS_ID_KEY).set((Object)msgUuid);
                        Map map = ExternalJavacManager.this.myConnections;
                        synchronized (map) {
                            ExternalJavacManager.this.myConnections.put(msgUuid, channel);
                            ExternalJavacManager.this.myConnections.notifyAll();
                        }
                    } else if (handler != null) {
                        boolean terminateOk = handler.handleMessage((MessageLite)message);
                        if (terminateOk) {
                            session.setDone();
                            ExternalJavacManager.this.mySessions.remove(session.getId());
                            ExternalJavacProcessHandler process = (ExternalJavacProcessHandler)((Object)ExternalJavacManager.this.myRunningProcesses.get(session.getProcessId()));
                            if (process != null) {
                                process.unlock();
                            }
                        } else if (session.isCancelRequested()) {
                            reply = JavacProtoUtil.toMessage((UUID)msgUuid, (JavacRemoteProto.Message.Request)JavacProtoUtil.createCancelRequest());
                        }
                    } else {
                        reply = JavacProtoUtil.toMessage((UUID)msgUuid, (JavacRemoteProto.Message.Request)JavacProtoUtil.createCancelRequest());
                    }
                } else {
                    reply = JavacProtoUtil.toMessage((UUID)msgUuid, (JavacRemoteProto.Message.Failure)JavacProtoUtil.createFailure((String)("Unsupported message: " + messageType.name()), null));
                }
                if (reply == null) return;
            }
            catch (Throwable throwable) {
                if (reply == null) throw throwable;
                context.channel().writeAndFlush(reply);
                throw throwable;
            }
            context.channel().writeAndFlush((Object)reply);
        }
    }

    protected static class ExternalJavacProcessHandler
    extends BaseOSProcessHandler {
        private long myIdleSince;
        private final UUID myProcessId;
        private final boolean myKeepProcessAlive;
        private boolean myIsBusy;

        protected ExternalJavacProcessHandler(UUID processId, @NotNull Process process, @NotNull String commandLine, boolean keepProcessAlive) {
            if (process == null) {
                ExternalJavacProcessHandler.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                ExternalJavacProcessHandler.$$$reportNull$$$0(1);
            }
            super(process, commandLine, null);
            this.myProcessId = processId;
            this.myKeepProcessAlive = keepProcessAlive;
        }

        public UUID getProcessId() {
            return this.myProcessId;
        }

        public synchronized long getIdleTime() {
            long idleSince = this.myIdleSince;
            return idleSince == -42L ? 0L : TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - idleSince);
        }

        public synchronized void unlock() {
            this.myIdleSince = System.nanoTime();
            this.myIsBusy = false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized boolean lock() {
            this.myIdleSince = -42L;
            if (this.myIsBusy) return false;
            this.myIsBusy = true;
            if (!true) return false;
            return true;
        }

        public boolean isKeepProcessAlive() {
            return this.myKeepProcessAlive;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = this.myKeepProcessAlive ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
            if (options == null) {
                ExternalJavacProcessHandler.$$$reportNull$$$0(2);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/ExternalJavacManager$ExternalJavacProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/ExternalJavacManager$ExternalJavacProcessHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

