/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.InvalidMarkException;

public abstract class Buffer {
    static final int SPLITERATOR_CHARACTERISTICS = 16464;
    private int mark = -1;
    private int position = 0;
    private int limit;
    private int capacity;
    long address;

    Buffer(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            throw new IllegalArgumentException("Negative capacity: " + n4);
        }
        this.capacity = n4;
        this.limit(n3);
        this.position(n2);
        if (n >= 0) {
            if (n > n2) {
                throw new IllegalArgumentException("mark > position: (" + n + " > " + n2 + ")");
            }
            this.mark = n;
        }
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final Buffer position(int n) {
        if (n > this.limit || n < 0) {
            throw new IllegalArgumentException();
        }
        this.position = n;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int n) {
        if (n > this.capacity || n < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = n;
        if (this.position > n) {
            this.position = n;
        }
        if (this.mark > n) {
            this.mark = -1;
        }
        return this;
    }

    public final Buffer mark() {
        this.mark = this.position;
        return this;
    }

    public final Buffer reset() {
        int n = this.mark;
        if (n < 0) {
            throw new InvalidMarkException();
        }
        this.position = n;
        return this;
    }

    public final Buffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final Buffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public abstract boolean isReadOnly();

    public abstract boolean hasArray();

    public abstract Object array();

    public abstract int arrayOffset();

    public abstract boolean isDirect();

    final int nextGetIndex() {
        int n = this.position;
        if (n >= this.limit) {
            throw new BufferUnderflowException();
        }
        this.position = n + 1;
        return n;
    }

    final int nextGetIndex(int n) {
        int n2 = this.position;
        if (this.limit - n2 < n) {
            throw new BufferUnderflowException();
        }
        this.position = n2 + n;
        return n2;
    }

    final int nextPutIndex() {
        int n = this.position;
        if (n >= this.limit) {
            throw new BufferOverflowException();
        }
        this.position = n + 1;
        return n;
    }

    final int nextPutIndex(int n) {
        int n2 = this.position;
        if (this.limit - n2 < n) {
            throw new BufferOverflowException();
        }
        this.position = n2 + n;
        return n2;
    }

    final int checkIndex(int n) {
        if (n < 0 || n >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return n;
    }

    final int checkIndex(int n, int n2) {
        if (n < 0 || n2 > this.limit - n) {
            throw new IndexOutOfBoundsException();
        }
        return n;
    }

    final int markValue() {
        return this.mark;
    }

    final void truncate() {
        this.mark = -1;
        this.position = 0;
        this.limit = 0;
        this.capacity = 0;
    }

    final void discardMark() {
        this.mark = -1;
    }

    static void checkBounds(int n, int n2, int n3) {
        if ((n | n2 | n + n2 | n3 - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

