/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.OsmIdTextField;
import org.openstreetmap.josm.gui.widgets.OsmPrimitiveTypesComboBox;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class OsmIdSelectionDialog
extends ExtendedDialog
implements WindowListener {
    protected final JPanel panel = new JPanel();
    protected final OsmPrimitiveTypesComboBox cbType = new OsmPrimitiveTypesComboBox();
    protected final OsmIdTextField tfId = new OsmIdTextField();
    protected final HistoryComboBox cbId = new HistoryComboBox();
    protected final transient GroupLayout layout = new GroupLayout(this.panel);

    public OsmIdSelectionDialog(Component parent, String title, String ... buttonTexts) {
        super(parent, title, buttonTexts);
    }

    public OsmIdSelectionDialog(Component parent, String title, String[] buttonTexts, boolean modal) {
        super(parent, title, buttonTexts, modal);
    }

    public OsmIdSelectionDialog(Component parent, String title, String[] buttonTexts, boolean modal, boolean disposeOnClose) {
        super(parent, title, buttonTexts, modal, disposeOnClose);
    }

    protected void init() {
        this.panel.setLayout(this.layout);
        this.layout.setAutoCreateGaps(true);
        this.layout.setAutoCreateContainerGaps(true);
        JLabel lbl1 = new JLabel(I18n.tr("Object type:", new Object[0]));
        lbl1.setLabelFor(this.cbType);
        this.cbType.addItem(I18n.trc("osm object types", "mixed"));
        this.cbType.setToolTipText(I18n.tr("Choose the OSM object type", new Object[0]));
        JLabel lbl2 = new JLabel(I18n.tr("Object ID:", new Object[0]));
        lbl2.setLabelFor(this.cbId);
        this.cbId.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JosmTextField createEditorComponent() {
                return OsmIdSelectionDialog.this.tfId;
            }
        });
        this.cbId.setToolTipText(I18n.tr("Enter the ID of the object that should be downloaded", new Object[0]));
        this.restorePrimitivesHistory(this.cbId);
        this.tfId.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0, false));
        this.tfId.setPreferredSize(new Dimension(400, this.tfId.getPreferredSize().height));
        String help1 = I18n.tr("Object IDs can be separated by comma or space, for instance: {0}", "<b>" + Utils.joinAsHtmlUnorderedList(Arrays.asList("1 2 5", "1,2,5")) + "</b>");
        String help2 = I18n.tr("In mixed mode, specify objects like this: {0}<br/>({1} stands for <i>node</i>, {2} for <i>way</i>, and {3} for <i>relation</i>)", "<b>w123, n110, w12, r15</b>", "<b>n</b>", "<b>w</b>", "<b>r</b>");
        String help3 = I18n.tr("Ranges of object IDs are specified with a hyphen, for instance: {0}", "<b>" + Utils.joinAsHtmlUnorderedList(Arrays.asList("w1-5", "n30-37", "r501-5")) + "</b>");
        HtmlPanel help = new HtmlPanel(help1 + "<br/>" + help2 + "<br/><br/>" + help3);
        help.setBorder(BorderFactory.createEtchedBorder(1));
        this.cbType.addItemListener(e -> {
            this.tfId.setType(this.cbType.getType());
            this.tfId.performValidation();
        });
        GroupLayout.SequentialGroup sequentialGroup = this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup().addComponent(lbl1).addComponent(this.cbType, -2, -2, -2)).addGroup(this.layout.createParallelGroup().addComponent(lbl2).addComponent(this.cbId, -2, -2, -2));
        GroupLayout.ParallelGroup parallelGroup = this.layout.createParallelGroup().addGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup().addComponent(lbl1).addComponent(lbl2)).addGroup(this.layout.createParallelGroup().addComponent(this.cbType).addComponent(this.cbId)));
        for (Component i : this.getComponentsBeforeHelp()) {
            sequentialGroup.addComponent(i);
            parallelGroup.addComponent(i);
        }
        this.layout.setVerticalGroup(sequentialGroup.addComponent(help));
        this.layout.setHorizontalGroup(parallelGroup.addComponent(help));
    }

    protected Collection<Component> getComponentsBeforeHelp() {
        return Collections.emptySet();
    }

    public int getContinueButtonIndex() {
        return 1;
    }

    protected void restorePrimitivesHistory(HistoryComboBox cbHistory) {
        LinkedList<String> cmtHistory = new LinkedList<String>(Config.getPref().getList(this.getClass().getName() + ".primitivesHistory", new LinkedList<String>()));
        Collections.reverse(cmtHistory);
        cbHistory.setPossibleItems(cmtHistory);
    }

    protected void remindPrimitivesHistory(HistoryComboBox cbHistory) {
        cbHistory.addCurrentItemToHistory();
        Config.getPref().putList(this.getClass().getName() + ".primitivesHistory", cbHistory.getHistory());
    }

    public final List<PrimitiveId> getOsmIds() {
        return this.tfId.getIds();
    }

    @Override
    public void setupDialog() {
        this.setContent(this.panel, false);
        try {
            this.cbType.setSelectedIndex(Config.getPref().getInt("downloadprimitive.lasttype", 0));
        }
        catch (IllegalArgumentException e) {
            this.cbType.setSelectedIndex(0);
            Logging.warn(e);
        }
        this.tfId.setType(this.cbType.getType());
        if (Config.getPref().getBoolean("downloadprimitive.autopaste", true)) {
            this.tryToPasteFromClipboard(this.tfId, this.cbType);
        }
        this.setDefaultButton(this.getContinueButtonIndex());
        this.addWindowListener(this);
        super.setupDialog();
    }

    protected void tryToPasteFromClipboard(OsmIdTextField tfId, OsmPrimitiveTypesComboBox cbType) {
        String buf = ClipboardUtils.getClipboardStringContent();
        if (buf == null || buf.isEmpty()) {
            return;
        }
        if (buf.length() > Config.getPref().getInt("downloadprimitive.max-autopaste-length", 2000)) {
            return;
        }
        List<SimplePrimitiveId> ids = SimplePrimitiveId.fuzzyParse(buf);
        if (!ids.isEmpty()) {
            String parsedText = ids.stream().map(x -> x.getType().getAPIName().charAt(0) + String.valueOf(x.getUniqueId())).collect(Collectors.joining(", "));
            tfId.tryToPasteFrom(parsedText);
            EnumSet types = ids.stream().map(SimplePrimitiveId::getType).collect(Collectors.toCollection(() -> EnumSet.noneOf(OsmPrimitiveType.class)));
            if (types.size() == 1) {
                cbType.setSelectedItem(types.iterator().next());
            } else {
                cbType.setSelectedIndex(3);
            }
        } else if (buf.matches("[\\d,v\\s]+")) {
            tfId.tryToPasteFrom(buf);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (e != null && e.getComponent() == this && this.getValue() == this.getContinueButtonIndex()) {
            Config.getPref().putInt("downloadprimitive.lasttype", this.cbType.getSelectedIndex());
            if (!this.tfId.readIds()) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Invalid ID list specified\nCannot continue.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                return;
            }
            this.remindPrimitivesHistory(this.cbId);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

