function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { memo } from 'react';
import PropTypes from "prop-types";
import classnames from 'classnames';
import { EuiDataGridCell } from './data_grid_cell';
import { EuiText } from '../text';

var DefaultColumnFormatter = function DefaultColumnFormatter(_ref) {
  var children = _ref.children;
  return React.createElement(EuiText, null, children);
};

var EuiDataGridDataRow = memo(function (props) {
  var leadingControlColumns = props.leadingControlColumns,
      trailingControlColumns = props.trailingControlColumns,
      columns = props.columns,
      schema = props.schema,
      popoverContents = props.popoverContents,
      columnWidths = props.columnWidths,
      defaultColumnWidth = props.defaultColumnWidth,
      className = props.className,
      renderCellValue = props.renderCellValue,
      rowIndex = props.rowIndex,
      focusedCellPositionInTheRow = props.focusedCellPositionInTheRow,
      onCellFocus = props.onCellFocus,
      interactiveCellId = props.interactiveCellId,
      _dataTestSubj = props['data-test-subj'],
      visibleRowIndex = props.visibleRowIndex,
      rest = _objectWithoutProperties(props, ["leadingControlColumns", "trailingControlColumns", "columns", "schema", "popoverContents", "columnWidths", "defaultColumnWidth", "className", "renderCellValue", "rowIndex", "focusedCellPositionInTheRow", "onCellFocus", "interactiveCellId", "data-test-subj", "visibleRowIndex"]);

  var classes = classnames('euiDataGridRow', className);
  var dataTestSubj = classnames('dataGridRow', _dataTestSubj);
  return React.createElement("div", _extends({
    role: "row",
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (leadingColumn, i) {
    var id = leadingColumn.id,
        rowCellRender = leadingColumn.rowCellRender;
    return React.createElement(EuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: i,
      columnId: id,
      popoverContent: DefaultColumnFormatter,
      width: leadingColumn.width,
      renderCellValue: rowCellRender,
      onCellFocus: onCellFocus,
      isFocused: focusedCellPositionInTheRow === i,
      interactiveCellId: interactiveCellId,
      isExpandable: false,
      className: "euiDataGridRowCell--controlColumn"
    });
  }), columns.map(function (props, i) {
    var id = props.id;
    var columnType = schema[id] ? schema[id].columnType : null;
    var isExpandable = props.isExpandable !== undefined ? props.isExpandable : true;
    var popoverContent = popoverContents[columnType] || DefaultColumnFormatter;
    var width = columnWidths[id] || defaultColumnWidth;
    var columnPosition = i + leadingControlColumns.length;
    return React.createElement(EuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: columnPosition,
      columnId: id,
      columnType: columnType,
      popoverContent: popoverContent,
      width: width || undefined,
      renderCellValue: renderCellValue,
      onCellFocus: onCellFocus,
      isFocused: focusedCellPositionInTheRow === columnPosition,
      interactiveCellId: interactiveCellId,
      isExpandable: isExpandable
    });
  }), trailingControlColumns.map(function (leadingColumn, i) {
    var id = leadingColumn.id,
        rowCellRender = leadingColumn.rowCellRender;
    var colIndex = i + columns.length + leadingControlColumns.length;
    return React.createElement(EuiDataGridCell, {
      key: "".concat(id, "-").concat(rowIndex),
      rowIndex: rowIndex,
      visibleRowIndex: visibleRowIndex,
      colIndex: colIndex,
      columnId: id,
      popoverContent: DefaultColumnFormatter,
      width: leadingColumn.width,
      renderCellValue: rowCellRender,
      onCellFocus: onCellFocus,
      isFocused: focusedCellPositionInTheRow === colIndex,
      interactiveCellId: interactiveCellId,
      isExpandable: false,
      className: "euiDataGridRowCell--controlColumn"
    });
  }));
});
EuiDataGridDataRow.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  rowIndex: PropTypes.number.isRequired,
  leadingControlColumns: PropTypes.arrayOf(PropTypes.shape({
    /**
       * Used as the React `key` when rendering content
       */
    id: PropTypes.string.isRequired,

    /**
       * Component to render in the column header
       */
    headerCellRender: PropTypes.elementType.isRequired,

    /**
       * Component to render for each row in the column
       */
    rowCellRender: PropTypes.oneOfType([PropTypes.func.isRequired, PropTypes.func.isRequired]).isRequired,

    /**
       * Width of the column, uses are unable to change this
       */
    width: PropTypes.number.isRequired
  }).isRequired).isRequired,
  trailingControlColumns: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.string.isRequired,
    headerCellRender: PropTypes.elementType.isRequired,
    rowCellRender: PropTypes.oneOfType([PropTypes.func.isRequired, PropTypes.func.isRequired]).isRequired,
    width: PropTypes.number.isRequired
  }).isRequired).isRequired,
  columns: PropTypes.arrayOf(PropTypes.shape({
    /**
       * The unique identifier for this column
       */
    id: PropTypes.string.isRequired,

    /**
       * A `ReactNode` used when rendering the column header. When providing complicated content, please make sure to utilize CSS to respect truncation as space allows. Check the docs example.
       */
    display: PropTypes.node,

    /**
       * A Schema to use for the column. Built-in values are ['boolean', 'currency', 'datetime', 'numeric', 'json'] but can be expanded by defining your own #EuiDataGrid `schemaDetectors` (for in-memory detection). In general, it is advised to pass in a value here when you are sure of the schema ahead of time, so that you don't need to rely on the automatic detection.
       */
    schema: PropTypes.string,

    /**
       * Defaults to true. Defines whether or not the column's cells can be expanded with a popup onClick / keydown.
       */
    isExpandable: PropTypes.bool,

    /**
       * Whether this column's width can be changed by the user, defaults to true
       */
    isResizable: PropTypes.bool,

    /**
       * Initial width (in pixels) of the column
       */
    initialWidth: PropTypes.number,

    /**
       * Whether this column is sortable
       */
    isSortable: PropTypes.bool,

    /**
       * Default sort direction of the column
       */
    defaultSortDirection: PropTypes.oneOf(["asc", "desc"]),

    /**
       * Display name as text for column. This can be used to display column name in column selector and column sorting where `display` won't be used. If not used `id` will be shown as column name in column selector and column sorting.
       */
    displayAsText: PropTypes.string
  }).isRequired).isRequired,
  schema: PropTypes.shape({}).isRequired,
  popoverContents: PropTypes.shape({}).isRequired,
  columnWidths: PropTypes.shape({}).isRequired,
  defaultColumnWidth: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.oneOf([null])]),
  focusedCellPositionInTheRow: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.oneOf([null])]),
  renderCellValue: PropTypes.oneOfType([PropTypes.func.isRequired, PropTypes.func.isRequired]).isRequired,
  onCellFocus: PropTypes.func.isRequired,
  interactiveCellId: PropTypes.string.isRequired,
  visibleRowIndex: PropTypes.number.isRequired
};
export { EuiDataGridDataRow };