/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get } from 'lodash';
import { getPhraseFilterValue, getPhraseFilterField, FILTERS, isScriptedPhraseFilter, isPhraseFilter } from '../../../../../common';

var getScriptedPhraseValue = function getScriptedPhraseValue(filter) {
  return get(filter, ['script', 'script', 'params', 'value']);
};

var getFormattedValueFn = function getFormattedValueFn(value) {
  return function (formatter) {
    return formatter ? formatter.convert(value) : value;
  };
};

var getParams = function getParams(filter) {
  var scriptedPhraseValue = getScriptedPhraseValue(filter);
  var isScriptedFilter = Boolean(scriptedPhraseValue);
  var key = isScriptedFilter ? filter.meta.field || '' : getPhraseFilterField(filter);
  var query = scriptedPhraseValue || getPhraseFilterValue(filter);
  var params = {
    query: query
  };
  return {
    key: key,
    params: params,
    type: FILTERS.PHRASE,
    value: getFormattedValueFn(query)
  };
};

export var isMapPhraseFilter = function isMapPhraseFilter(filter) {
  return isPhraseFilter(filter) || isScriptedPhraseFilter(filter);
};
export var mapPhrase = function mapPhrase(filter) {
  if (!isMapPhraseFilter(filter)) {
    throw filter;
  }

  return getParams(filter);
};