function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
// @ts-ignore
import { TableHeaderColumn } from './table_header_column';
import { getDisplayedColumns } from './helpers';
import { getDefaultSort } from '../../lib/get_default_sort';
export function TableHeader(_ref) {
  var columns = _ref.columns,
      defaultSortOrder = _ref.defaultSortOrder,
      hideTimeColumn = _ref.hideTimeColumn,
      indexPattern = _ref.indexPattern,
      isShortDots = _ref.isShortDots,
      onChangeSortOrder = _ref.onChangeSortOrder,
      onMoveColumn = _ref.onMoveColumn,
      onRemoveColumn = _ref.onRemoveColumn,
      sortOrder = _ref.sortOrder;
  var displayedColumns = getDisplayedColumns(columns, indexPattern, hideTimeColumn, isShortDots);
  return /*#__PURE__*/React.createElement("tr", {
    "data-test-subj": "docTableHeader",
    className: "kbnDocTableHeader"
  }, /*#__PURE__*/React.createElement("th", {
    style: {
      width: '24px'
    }
  }), displayedColumns.map(function (col) {
    return /*#__PURE__*/React.createElement(TableHeaderColumn, _extends({
      key: col.name
    }, col, {
      sortOrder: sortOrder.length ? sortOrder : getDefaultSort(indexPattern, defaultSortOrder),
      onMoveColumn: onMoveColumn,
      onRemoveColumn: onRemoveColumn,
      onChangeSortOrder: onChangeSortOrder
    }));
  }));
}