function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useEffect } from 'react';
import { i18n } from '@kbn/i18n';
import { NumberInputOption, SwitchOption } from '../../../../../charts/public';
import { YExtents } from './y_extents';

function CustomExtentsOptions(_ref) {
  var axisScale = _ref.axisScale,
      setMultipleValidity = _ref.setMultipleValidity,
      setValueAxis = _ref.setValueAxis,
      setValueAxisScale = _ref.setValueAxisScale;
  var invalidBoundsMarginMessage = i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.scaleToDataBounds.minNeededBoundsMargin', {
    defaultMessage: 'Bounds margin must be greater than or equal to 0.'
  });
  var isBoundsMarginValid = !axisScale.defaultYExtents || !axisScale.boundsMargin || axisScale.boundsMargin >= 0;
  var setBoundsMargin = useCallback(function (paramName, value) {
    return setValueAxisScale(paramName, value === '' ? undefined : value);
  }, [setValueAxisScale]);
  var onDefaultYExtentsChange = useCallback(function (paramName, value) {
    var scale = _objectSpread(_objectSpread({}, axisScale), {}, _defineProperty({}, paramName, value));

    if (!scale.defaultYExtents) {
      delete scale.boundsMargin;
    }

    setValueAxis('scale', scale);
  }, [axisScale, setValueAxis]);
  var onSetYExtentsChange = useCallback(function (paramName, value) {
    var scale = _objectSpread(_objectSpread({}, axisScale), {}, _defineProperty({}, paramName, value));

    if (!scale.setYExtents) {
      delete scale.min;
      delete scale.max;
    }

    setValueAxis('scale', scale);
  }, [axisScale, setValueAxis]);
  useEffect(function () {
    setMultipleValidity('boundsMargin', isBoundsMarginValid);
    return function () {
      return setMultipleValidity('boundsMargin', true);
    };
  }, [isBoundsMarginValid, setMultipleValidity]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.scaleToDataBoundsLabel', {
      defaultMessage: 'Scale to data bounds'
    }),
    paramName: "defaultYExtents",
    value: axisScale.defaultYExtents,
    setValue: onDefaultYExtentsChange
  }), axisScale.defaultYExtents && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(NumberInputOption, {
    error: !isBoundsMarginValid && invalidBoundsMarginMessage,
    isInvalid: !isBoundsMarginValid,
    label: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.scaleToDataBounds.boundsMargin', {
      defaultMessage: 'Bounds margin'
    }),
    step: 0.1,
    min: 0,
    paramName: "boundsMargin",
    value: axisScale.boundsMargin,
    setValue: setBoundsMargin
  })), /*#__PURE__*/React.createElement(SwitchOption, {
    "data-test-subj": "yAxisSetYExtents",
    label: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.setAxisExtentsLabel', {
      defaultMessage: 'Set axis extents'
    }),
    paramName: "setYExtents",
    value: axisScale.setYExtents,
    setValue: onSetYExtentsChange
  }), axisScale.setYExtents && /*#__PURE__*/React.createElement(YExtents, {
    scale: axisScale,
    setScale: setValueAxisScale,
    setMultipleValidity: setMultipleValidity
  }));
}

export { CustomExtentsOptions };