function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useMemo } from 'react';
import { i18n } from '@kbn/i18n';
import { EuiSpacer, EuiAccordion, EuiHorizontalRule } from '@elastic/eui';
import { Positions } from '../../../utils/collections';
import { SelectOption, SwitchOption, TextInputOption } from '../../../../../charts/public';
import { LabelOptions } from './label_options';
import { CustomExtentsOptions } from './custom_extents_options';
import { isAxisHorizontal } from './utils';

function ValueAxisOptions(_ref) {
  var axis = _ref.axis,
      index = _ref.index,
      isCategoryAxisHorizontal = _ref.isCategoryAxisHorizontal,
      valueAxis = _ref.valueAxis,
      vis = _ref.vis,
      onValueAxisPositionChanged = _ref.onValueAxisPositionChanged,
      setParamByIndex = _ref.setParamByIndex,
      setMultipleValidity = _ref.setMultipleValidity;
  var setValueAxis = useCallback(function (paramName, value) {
    return setParamByIndex('valueAxes', index, paramName, value);
  }, [setParamByIndex, index]);
  var setValueAxisTitle = useCallback(function (paramName, value) {
    var title = _objectSpread(_objectSpread({}, valueAxis.title), {}, _defineProperty({}, paramName, value));

    setParamByIndex('valueAxes', index, 'title', title);
  }, [valueAxis.title, setParamByIndex, index]);
  var setValueAxisScale = useCallback(function (paramName, value) {
    var scale = _objectSpread(_objectSpread({}, valueAxis.scale), {}, _defineProperty({}, paramName, value));

    setParamByIndex('valueAxes', index, 'scale', scale);
  }, [valueAxis.scale, setParamByIndex, index]);
  var setAxisLabel = useCallback(function (paramName, value) {
    var labels = _objectSpread(_objectSpread({}, valueAxis.labels), {}, _defineProperty({}, paramName, value));

    setParamByIndex('valueAxes', index, 'labels', labels);
  }, [valueAxis.labels, setParamByIndex, index]);
  var onPositionChanged = useCallback(function (paramName, value) {
    onValueAxisPositionChanged(index, value);
  }, [index, onValueAxisPositionChanged]);
  var isPositionDisabled = useCallback(function (position) {
    if (isCategoryAxisHorizontal) {
      return isAxisHorizontal(position);
    }

    return [Positions.LEFT, Positions.RIGHT].includes(position);
  }, [isCategoryAxisHorizontal]);
  var positions = useMemo(function () {
    return vis.type.editorConfig.collections.positions.map(function (position) {
      return _objectSpread(_objectSpread({}, position), {}, {
        disabled: isPositionDisabled(position.value)
      });
    });
  }, [vis.type.editorConfig.collections.positions, isPositionDisabled]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SelectOption, {
    label: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.positionLabel', {
      defaultMessage: 'Position'
    }),
    options: positions,
    paramName: "position",
    value: axis.position,
    setValue: onPositionChanged
  }), /*#__PURE__*/React.createElement(SelectOption, {
    id: "valueAxisMode".concat(index),
    label: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.modeLabel', {
      defaultMessage: 'Mode'
    }),
    options: vis.type.editorConfig.collections.axisModes,
    paramName: "mode",
    value: axis.scale.mode,
    setValue: setValueAxisScale
  }), /*#__PURE__*/React.createElement(SelectOption, {
    id: "scaleSelectYAxis-".concat(axis.id),
    label: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.scaleTypeLabel', {
      defaultMessage: 'Scale type'
    }),
    options: vis.type.editorConfig.collections.scaleTypes,
    paramName: "type",
    value: axis.scale.type,
    setValue: setValueAxisScale
  }), /*#__PURE__*/React.createElement(EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.showLabel', {
      defaultMessage: 'Show axis lines and labels'
    }),
    "data-test-subj": "valueAxisShow-".concat(axis.id),
    paramName: "show",
    value: axis.show,
    setValue: setValueAxis
  }), axis.show ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(TextInputOption, {
    "data-test-subj": "valueAxisTitle".concat(index),
    label: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.titleLabel', {
      defaultMessage: 'Title'
    }),
    paramName: "text",
    value: axis.title.text,
    setValue: setValueAxisTitle
  }), /*#__PURE__*/React.createElement(LabelOptions, {
    axisLabels: axis.labels,
    axisFilterCheckboxName: "yAxisFilterLabelsCheckbox-".concat(axis.id),
    setAxisLabel: setAxisLabel
  })) : /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/React.createElement(EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/React.createElement(EuiAccordion, {
    id: "yAxisOptionsAccordion".concat(axis.id),
    className: "visEditorSidebar__section visEditorSidebar__collapsible",
    initialIsOpen: false,
    buttonContentClassName: "euiText euiText--small",
    buttonContent: i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.customExtentsLabel', {
      defaultMessage: 'Custom extents'
    }),
    "aria-label": i18n.translate('visTypeVislib.controls.pointSeries.valueAxes.toggleCustomExtendsAriaLabel', {
      defaultMessage: 'Toggle custom extents'
    })
  }, /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(CustomExtentsOptions, {
    axisScale: axis.scale,
    setMultipleValidity: setMultipleValidity,
    setValueAxisScale: setValueAxisScale,
    setValueAxis: setValueAxis
  }))));
}

export { ValueAxisOptions };