/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.xml.parsers.ParserConfigurationException;
import org.directwebremoting.Container;
import org.directwebremoting.HubFactory;
import org.directwebremoting.ServerContext;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.annotations.AnnotationsConfigurator;
import org.directwebremoting.event.ScriptSessionListener;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.CallbackHelperFactory;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.ContainerAbstraction;
import org.directwebremoting.extend.ContainerConfigurationException;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.ModuleManager;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.extend.TaskDispatcherFactory;
import org.directwebremoting.impl.DefaultContainer;
import org.directwebremoting.impl.DwrXmlConfigurator;
import org.directwebremoting.impl.TransientScriptSessionManager;
import org.directwebremoting.json.parse.JsonParserFactory;
import org.directwebremoting.json.serialize.JsonSerializerFactory;
import org.directwebremoting.util.FakeServletConfig;
import org.directwebremoting.util.FakeServletContextFactory;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Loggers;
import org.directwebremoting.util.VersionUtil;
import org.xml.sax.SAXException;

public class StartupUtil {
    public static final String INIT_CONFIG = "config";
    public static final String INIT_SKIP_DEFAULT = "skipDefaultConfig";
    public static final String INIT_LOGLEVEL = "logLevel";
    public static final String INIT_CUSTOM_CONFIGURATOR = "customConfigurator";
    public static final String ATTRIBUTE_CONTAINER_LIST = "org.directwebremoting.ContainerList";
    private static ServerContext singletonServerContext;
    private static final Map<String, ServerContext> contextMap;
    private static int foundContexts;

    public static Container outOfContainerInit() throws ContainerConfigurationException {
        try {
            FakeServletConfig servletConfig = new FakeServletConfig("test", FakeServletContextFactory.create(new Object[0]));
            StartupUtil.logStartup("DWR:OutOfContainer", servletConfig);
            Container container = StartupUtil.createAndSetupDefaultContainer(servletConfig);
            StartupUtil.configureContainerFully(container, servletConfig);
            return container;
        }
        catch (ContainerConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContainerConfigurationException(ex);
        }
    }

    public static void outOfContainerDestroy(Container container) {
        WebContextFactory.WebContextBuilder webContextBuilder = container.getBean(WebContextFactory.WebContextBuilder.class);
        if (webContextBuilder != null) {
            webContextBuilder.disengageThread();
        }
    }

    public static void logStartup(String name, ServletConfig config) {
        ServletContext servletContext = config.getServletContext();
        String contextPath = LocalUtil.getProperty(servletContext, "ContextPath", String.class);
        contextPath = contextPath == null ? "" : " at " + contextPath;
        Loggers.STARTUP.info((Object)("Starting: " + name + " v" + VersionUtil.getLabel() + " on " + servletContext.getServerInfo() + " / JDK " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + contextPath));
    }

    public static Container createAndSetupDefaultContainer(ServletConfig servletConfig) throws ContainerConfigurationException {
        Container container;
        try {
            String typeName = servletConfig.getInitParameter(LocalUtil.originalDwrClassName(Container.class.getName()));
            if (typeName == null) {
                container = new DefaultContainer();
            } else {
                Loggers.STARTUP.debug((Object)("Using alternate Container implementation: " + typeName));
                Class<?> type = LocalUtil.classForName(typeName);
                container = (Container)type.newInstance();
            }
            if (container instanceof DefaultContainer) {
                DefaultContainer defaultContainer = container;
                StartupUtil.setupDefaultContainer(defaultContainer, servletConfig);
            }
        }
        catch (Exception ex) {
            throw new ContainerConfigurationException(ex);
        }
        return container;
    }

    public static DefaultContainer createDefaultContainer(ServletConfig servletConfig) throws ContainerConfigurationException {
        try {
            String typeName = servletConfig.getInitParameter(LocalUtil.originalDwrClassName(Container.class.getName()));
            if (typeName == null) {
                return new DefaultContainer();
            }
            Loggers.STARTUP.debug((Object)("Using alternate Container implementation: " + typeName));
            Class<?> type = LocalUtil.classForName(typeName);
            return (DefaultContainer)type.newInstance();
        }
        catch (Exception ex) {
            throw new ContainerConfigurationException(ex);
        }
    }

    public static void setupDefaultContainer(DefaultContainer container, ServletConfig servletConfig) throws ContainerConfigurationException {
        Loggers.STARTUP.debug((Object)"Setup: Getting parameters from defaults.properties:");
        StartupUtil.setupDefaults(container);
        Loggers.STARTUP.debug((Object)"Setup: Getting parameters from environment:");
        container.addBean(Container.class, container);
        container.addBean(ServletConfig.class, servletConfig);
        container.addBean(ServletContext.class, servletConfig.getServletContext());
        Loggers.STARTUP.debug((Object)"Setup: Getting parameters from ServletConfig:");
        StartupUtil.setupFromServletConfig(container, servletConfig);
        Loggers.STARTUP.debug((Object)"Setup: Applying long versions of shortcut parameters:");
        StartupUtil.applyParameterShortcuts(container);
        Loggers.STARTUP.debug((Object)"Setup: Resolving multiple implementations:");
        StartupUtil.resolveMultipleImplementations(container, servletConfig);
        Loggers.STARTUP.debug((Object)"Setup: Autowire beans");
        container.setupFinished();
        Loggers.STARTUP.debug((Object)"Setup: Resolving listener implementations:");
        StartupUtil.resolveListenerImplementations(container, servletConfig);
        Loggers.STARTUP.debug((Object)"Setup: Initializing Factories:");
        ServerContext serverContext = ServerContextFactory.attach(container);
        WebContextFactory.attach(container);
        HubFactory.attach(container);
        JsonParserFactory.attach(container);
        JsonSerializerFactory.attach(container);
        CallbackHelperFactory.attach(container);
        TaskDispatcherFactory.attach(container);
        WebContextFactory.WebContextBuilder webContextBuilder = container.getBean(WebContextFactory.WebContextBuilder.class);
        ServletContext servletContext = servletConfig.getServletContext();
        servletContext.setAttribute(Container.class.getName(), (Object)container);
        servletContext.setAttribute(WebContextFactory.WebContextBuilder.class.getName(), (Object)webContextBuilder);
        servletContext.setAttribute(ServletConfig.class.getName(), (Object)servletConfig);
        StartupUtil.publishContainer(container, serverContext, servletConfig);
    }

    private static void applyParameterShortcuts(DefaultContainer container) {
        Object bean = container.getBean("interactivity");
        if (bean != null) {
            if (bean instanceof String) {
                String level = (String)bean;
                if ("stateless".equals(level)) {
                    container.addImplementation(ScriptSessionManager.class, TransientScriptSessionManager.class);
                } else if (!"passiveReverseAjax".equals(level)) {
                    if ("activeReverseAjax".equals(level)) {
                        container.addParameter("activeReverseAjaxEnabled", "true");
                    } else {
                        Loggers.STARTUP.error((Object)("Illegal value for 'interactivity' parameter of '" + level + "'. Valid values are [stateless|passiveReverseAjax|activeReverseAjax]. Ignoring."));
                    }
                }
            } else {
                Loggers.STARTUP.error((Object)"Found non-string value for 'interactivity' parameter. Ignoring.");
            }
        }
        String allowGetForSafariButMakeForgeryEasier = container.getParameter("allowGetForSafariButMakeForgeryEasier");
        String allowGetButMakeForgeryEasier = container.getParameter("allowGetButMakeForgeryEasier");
        if (allowGetForSafariButMakeForgeryEasier != null && allowGetButMakeForgeryEasier == null) {
            container.addParameter("allowGetButMakeForgeryEasier", allowGetForSafariButMakeForgeryEasier);
        }
    }

    public static void resolveMultipleImplementations(DefaultContainer container, ServletConfig servletConfig) throws ContainerConfigurationException {
        try {
            StartupUtil.resolveMultipleImplementation(container, LocalUtil.originalDwrClassName("org.directwebremoting.dwrp.FileUpload"));
        }
        catch (Exception fue) {
            Loggers.STARTUP.debug((Object)("A FileUpload implementation is not available. Details: " + fue), (Throwable)fue);
        }
        try {
            StartupUtil.resolveMultipleImplementation(container, LocalUtil.originalDwrClassName("org.directwebremoting.extend.Compressor"));
        }
        catch (Exception ce) {
            Loggers.STARTUP.debug((Object)("A Compressor implemenation is not available. Details: " + ce), (Throwable)ce);
        }
        Object value = container.getBean(LocalUtil.originalDwrClassName(ContainerAbstraction.class.getName()));
        ArrayList<Object> abstractionImpls = new ArrayList<Object>();
        if (value instanceof String) {
            Collections.addAll(abstractionImpls, ((String)value).replace(",", " ").split(" "));
        } else {
            abstractionImpls.add(value);
        }
        Loggers.STARTUP.debug((Object)("- Selecting a " + ContainerAbstraction.class.getSimpleName() + " from " + abstractionImpls));
        for (Object e : abstractionImpls) {
            try {
                ContainerAbstraction abstraction;
                if (e == null) continue;
                if (e instanceof String) {
                    String abstractionImplName = (String)e;
                    if (abstractionImplName.trim().length() == 0) continue;
                    Class<?> abstractionClass = LocalUtil.classForName(abstractionImplName);
                    abstraction = (ContainerAbstraction)abstractionClass.newInstance();
                } else {
                    abstraction = (ContainerAbstraction)e;
                }
                if (!abstraction.isNativeEnvironment(servletConfig)) continue;
                Loggers.STARTUP.info((Object)("Starting: Using container abstraction " + abstraction.getClass().getName()));
                container.addImplementation(ContainerAbstraction.class, abstraction.getClass());
                String loadMonitorImplName = container.getParameter(LocalUtil.originalDwrClassName(ServerLoadMonitor.class.getName()));
                if (loadMonitorImplName == null) {
                    Class<? extends ServerLoadMonitor> loadMonitorImpl = abstraction.getServerLoadMonitorImplementation();
                    container.addImplementation(ServerLoadMonitor.class, loadMonitorImpl);
                }
                return;
            }
            catch (Exception ex) {
                Loggers.STARTUP.debug((Object)("  - Can't use : " + e + " to implement " + ContainerAbstraction.class.getName() + ". This is probably not an error unless you were expecting to use it. Reason: " + ex));
            }
            catch (NoClassDefFoundError ex) {
                Loggers.STARTUP.debug((Object)("  - Can't use : " + e + " to implement " + ContainerAbstraction.class.getName() + ". This is probably not an error unless you were expecting to use it. Reason: " + ex));
            }
        }
        throw new ContainerConfigurationException("None of the configured ContainerAbstractions claims isNativeEnvironment=true. Implementations tested: " + abstractionImpls);
    }

    protected static void resolveMultipleImplementation(DefaultContainer container, String toResolveString) {
        Class<?> toResolve = null;
        try {
            toResolve = LocalUtil.classForName(toResolveString);
        }
        catch (Exception ex) {
            Loggers.STARTUP.debug((Object)(toResolveString + " is not available. Details: " + ex));
        }
        Object implObjs = container.getBean(toResolveString);
        if (implObjs == null || !(implObjs instanceof String)) {
            return;
        }
        String implNames = (String)implObjs;
        Loggers.STARTUP.debug((Object)("- Selecting a " + toResolveString + " from " + implNames));
        implNames = implNames.replace(',', ' ');
        for (String implName : implNames.split(" ")) {
            if (implName.equals("")) continue;
            try {
                Class<?> impl = LocalUtil.classForName(implName);
                if (!toResolve.isAssignableFrom(impl)) {
                    Loggers.STARTUP.error((Object)("  - Can't cast: " + impl.getName() + " to " + toResolve.getName()));
                }
                impl.newInstance();
                container.addParameter(LocalUtil.originalDwrClassName(toResolve.getName()), impl.getName());
                return;
            }
            catch (Exception ex) {
                Loggers.STARTUP.debug((Object)("  - Can't use : " + implName + " to implement " + toResolve.getName() + ". This is probably not an error unless you were expecting to use it. Reason: " + ex));
            }
            catch (Throwable t) {
                Loggers.STARTUP.debug((Object)("  - Can't use : " + implName + " to implement " + toResolve.getName() + ". This is probably not an error unless you were expecting to use it. Reason: " + t));
            }
        }
    }

    public static void resolveListenerImplementations(DefaultContainer container, ServletConfig servletConfig) throws ContainerConfigurationException {
        ScriptSessionManager manager = container.getBean(ScriptSessionManager.class);
        Object scriptSessionListenerClasses = container.getBean(LocalUtil.originalDwrClassName(ScriptSessionListener.class.getName()));
        if (scriptSessionListenerClasses == null) {
            Loggers.STARTUP.debug((Object)("- No implementations of " + ScriptSessionListener.class.getSimpleName() + " to register"));
            return;
        }
        if (!(scriptSessionListenerClasses instanceof String)) {
            return;
        }
        String implNames = (String)scriptSessionListenerClasses;
        Loggers.STARTUP.debug((Object)("- Creating list of " + ScriptSessionListener.class.getSimpleName() + " from " + implNames));
        implNames = implNames.replace(',', ' ');
        for (String implName : implNames.split(" ")) {
            if (implName.equals("")) continue;
            try {
                Class<?> impl = LocalUtil.classForName(implName);
                if (!ScriptSessionListener.class.isAssignableFrom(impl)) {
                    Loggers.STARTUP.error((Object)("  - Can't cast: " + impl.getName() + " to " + ScriptSessionListener.class.getName()));
                    continue;
                }
                Class<?> i = impl;
                ScriptSessionListener instance = (ScriptSessionListener)i.newInstance();
                manager.addScriptSessionListener(instance);
            }
            catch (Exception ex) {
                Loggers.STARTUP.error((Object)("  - Can't use : " + implName + " to implement " + ScriptSessionListener.class.getName() + ". Reason: " + ex));
            }
            catch (NoClassDefFoundError ex) {
                Loggers.STARTUP.error((Object)("  - Can't use : " + implName + " to implement " + ScriptSessionListener.class.getName() + ". Reason: " + ex));
            }
        }
    }

    public static void setupDefaults(DefaultContainer container) throws ContainerConfigurationException {
        try {
            InputStream in = LocalUtil.getInternalResourceAsStream("/org/directwebremoting/defaults.properties");
            Properties defaults = new Properties();
            defaults.load(in);
            for (Map.Entry<Object, Object> entry : defaults.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                container.addParameter(key, value);
            }
        }
        catch (IOException ex) {
            throw new ContainerConfigurationException("Failed to load system defaults", ex);
        }
    }

    public static void createPathMapping(DefaultContainer container, String url, Class<? extends Handler> handler, String propertyName) throws ContainerConfigurationException {
        container.addParameter("url:" + url, handler.getName());
        if (propertyName != null) {
            container.addParameter(propertyName, url);
        }
    }

    public static void createPathMapping(DefaultContainer container, String url, Class<? extends Handler> handler) throws ContainerConfigurationException {
        StartupUtil.createPathMapping(container, url, handler, null);
    }

    public static void setupFromServletConfig(DefaultContainer container, ServletConfig servletConfig) throws ContainerConfigurationException {
        Enumeration en = servletConfig.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = servletConfig.getInitParameter(name);
            container.addParameter(name, value);
        }
    }

    public static void configureFromSystemDwrXml(Container container) throws IOException, ParserConfigurationException, SAXException {
        DwrXmlConfigurator system = new DwrXmlConfigurator();
        system.setClassResourceName("/org/directwebremoting/dwr.xml");
        system.configure(container);
    }

    public static void configureFromDefaultDwrXml(Container container, ServletConfig servletConfig) throws IOException, ParserConfigurationException, SAXException {
        DwrXmlConfigurator local = new DwrXmlConfigurator();
        local.setServletResourceName(servletConfig.getServletContext(), "/WEB-INF/dwr.xml");
        local.configure(container);
    }

    public static boolean configureFromInitParams(Container container, ServletConfig servletConfig) throws IOException, ParserConfigurationException, SAXException {
        Enumeration en = servletConfig.getInitParameterNames();
        boolean foundConfig = false;
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = servletConfig.getInitParameter(name);
            if (name.startsWith(INIT_CONFIG)) {
                foundConfig = true;
                StringTokenizer st = new StringTokenizer(value, "\n,");
                while (st.hasMoreTokens()) {
                    String fileName = st.nextToken().trim();
                    DwrXmlConfigurator local = new DwrXmlConfigurator();
                    local.setServletResourceName(servletConfig.getServletContext(), fileName);
                    local.configure(container);
                }
                continue;
            }
            if (!name.equals(INIT_CUSTOM_CONFIGURATOR)) continue;
            foundConfig = true;
            try {
                Configurator configurator = LocalUtil.classNewInstance(INIT_CUSTOM_CONFIGURATOR, value, Configurator.class);
                configurator.configure(container);
                Loggers.STARTUP.debug((Object)("Loaded config from: " + value));
            }
            catch (Exception ex) {
                Loggers.STARTUP.error((Object)"Failed to start custom configurator", (Throwable)ex);
            }
        }
        return foundConfig;
    }

    public static boolean configureFromAnnotations(Container container) {
        Object data = container.getBean("classes");
        if (null != data) {
            AnnotationsConfigurator configurator = new AnnotationsConfigurator();
            configurator.configure(container);
            Loggers.STARTUP.debug((Object)"Java5 AnnotationsConfigurator enabled");
            return true;
        }
        return false;
    }

    public static void configure(Container container, List<Configurator> configurators) {
        for (Configurator configurator : configurators) {
            Loggers.STARTUP.debug((Object)("Adding config from " + configurator));
            configurator.configure(container);
        }
    }

    public static void configureContainerFully(Container container, ServletConfig servletConfig) throws IOException, ParserConfigurationException, SAXException {
        StartupUtil.configureFromSystemDwrXml(container);
        boolean foundConfig = StartupUtil.configureFromInitParams(container, servletConfig);
        boolean skip = Boolean.valueOf(servletConfig.getInitParameter(INIT_SKIP_DEFAULT));
        IOException delayedIOException = null;
        if (!foundConfig && !skip) {
            try {
                StartupUtil.configureFromDefaultDwrXml(container, servletConfig);
            }
            catch (IOException ex) {
                delayedIOException = ex;
            }
        }
        if (!StartupUtil.configureFromAnnotations(container)) {
            Loggers.STARTUP.debug((Object)"Java5 AnnotationsConfigurator disabled");
            if (delayedIOException != null) {
                throw delayedIOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishContainer(Container container, ServerContext serverContext, ServletConfig servletConfig) {
        ServletContext servletContext = servletConfig.getServletContext();
        SerializableContainerListWrapper containers = (SerializableContainerListWrapper)servletContext.getAttribute(ATTRIBUTE_CONTAINER_LIST);
        if (containers == null) {
            containers = new SerializableContainerListWrapper();
        }
        containers.add(container);
        servletContext.setAttribute(ATTRIBUTE_CONTAINER_LIST, (Object)containers);
        Map<String, ServerContext> map = contextMap;
        synchronized (map) {
            switch (foundContexts) {
                case 0: {
                    singletonServerContext = serverContext;
                    break;
                }
                case 1: {
                    singletonServerContext = null;
                    Loggers.STARTUP.debug((Object)"Multiple instances of DWR detected.");
                    break;
                }
            }
            String name = servletConfig.getServletName();
            contextMap.put(name, serverContext);
            Loggers.STARTUP.debug((Object)("Adding to contextMap, a serverContext called " + name));
            ++foundContexts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerContext getSingletonServerContext() {
        Map<String, ServerContext> map = contextMap;
        synchronized (map) {
            return singletonServerContext;
        }
    }

    public static Collection<ServerContext> getAllServerContexts() {
        ArrayList<ServerContext> reply = new ArrayList<ServerContext>();
        reply.addAll(contextMap.values());
        return Collections.unmodifiableCollection(reply);
    }

    public static List<Container> getAllPublishedContainers(ServletContext servletContext) {
        ArrayList<Container> reply = new ArrayList<Container>();
        SerializableContainerListWrapper containers = (SerializableContainerListWrapper)servletContext.getAttribute(ATTRIBUTE_CONTAINER_LIST);
        if (containers != null) {
            reply.addAll(containers.getAll());
        }
        return reply;
    }

    public static void debugConfig(Container container) {
        if (Loggers.STARTUP.isDebugEnabled()) {
            Loggers.STARTUP.debug((Object)"Container");
            Loggers.STARTUP.debug((Object)("  Type: " + container.getClass().getName()));
            for (String name : container.getBeanNames()) {
                Object object = container.getBean(name);
                if (object instanceof String) {
                    Loggers.STARTUP.debug((Object)("  Param: " + name + " = " + object + " (" + object.getClass().getName() + ")"));
                    continue;
                }
                Loggers.STARTUP.debug((Object)("  Bean: " + name + " = " + object + " (" + object.getClass().getName() + ")"));
            }
            AccessControl accessControl = container.getBean(AccessControl.class);
            Loggers.STARTUP.debug((Object)"AccessControl");
            Loggers.STARTUP.debug((Object)("  Type: " + accessControl.getClass().getName()));
            AjaxFilterManager ajaxFilterManager = container.getBean(AjaxFilterManager.class);
            Loggers.STARTUP.debug((Object)"AjaxFilterManager");
            Loggers.STARTUP.debug((Object)("  Type: " + ajaxFilterManager.getClass().getName()));
            ConverterManager converterManager = container.getBean(ConverterManager.class);
            Loggers.STARTUP.debug((Object)"ConverterManager");
            Loggers.STARTUP.debug((Object)("  Type: " + converterManager.getClass().getName()));
            CreatorManager creatorManager = container.getBean(CreatorManager.class);
            Loggers.STARTUP.debug((Object)"CreatorManager");
            Loggers.STARTUP.debug((Object)("  Type: " + creatorManager.getClass().getName()));
            for (String creatorName : creatorManager.getCreatorNames(false)) {
                Creator creator = creatorManager.getCreator(creatorName, false);
                Loggers.STARTUP.debug((Object)("  Creator: " + creatorName + " = " + creator + " (" + creator.getClass().getName() + ")"));
            }
            ModuleManager moduleManager = container.getBean(ModuleManager.class);
            Loggers.STARTUP.debug((Object)"ModuleManager");
            Loggers.STARTUP.debug((Object)("  Type: " + moduleManager.getClass().getName()));
        }
    }

    static {
        contextMap = new HashMap<String, ServerContext>();
        foundContexts = 0;
    }

    public static class SerializableContainerListWrapper
    implements Serializable {
        transient List<Container> list = null;

        public void add(Container container) {
            this.ensureCreated();
            this.list.add(container);
        }

        public Collection<Container> getAll() {
            this.ensureCreated();
            return this.list;
        }

        private void ensureCreated() {
            if (this.list == null) {
                this.list = new ArrayList<Container>();
            }
        }
    }
}

