/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import de.escape.quincunx.gimmicks.CancelAdapter;
import de.escape.quincunx.gimmicks.CancelListener;
import de.escape.quincunx.gimmicks.InsetPanel;
import de.escape.quincunx.gimmicks.LowerArea;
import de.escape.quincunx.gimmicks.MultiLineLabel;
import de.escape.quincunx.gimmicks.OkAdapter;
import de.escape.quincunx.gimmicks.OkListener;
import de.escape.quincunx.gimmicks.Utility;
import de.escape.quincunx.i18n.I18n;
import de.escape.quincunx.i18n.RButton;
import de.escape.quincunx.i18n.RPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class YesNoBox
extends Dialog
implements OkListener,
CancelListener {
    private boolean answeredYes = false;

    private void doInit(Component compo, String question) {
        Frame parent = Utility.getFrame(compo);
        MultiLineLabel ml = new MultiLineLabel(question);
        InsetPanel show = new InsetPanel((LayoutManager)new BorderLayout(), 10);
        this.setLayout(new BorderLayout());
        this.add(show);
        show.add("Center", ml);
        RPanel panel = new RPanel(new FlowLayout(1));
        RPanel buttonPanel = new RPanel(new GridLayout(1, 0, 10, 10));
        panel.add(buttonPanel);
        RButton yes = new RButton("Yes");
        buttonPanel.add(yes);
        RButton no = new RButton("No");
        buttonPanel.add(no);
        this.add((Component)new LowerArea(panel), "South");
        yes.addActionListener(new OkAdapter(this));
        no.addActionListener(new CancelAdapter(this));
        this.setModal(true);
        this.pack();
        Rectangle pBounds = parent.getBounds();
        if (pBounds.width == 0 || pBounds.height == 0) {
            Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
            pBounds = new Rectangle(0, 0, screensize.width, screensize.height);
        }
        Dimension size = this.getSize();
        ((Component)this).setLocation(pBounds.x + (pBounds.width - size.width) / 2, pBounds.y + (pBounds.height - size.height) / 2);
    }

    public YesNoBox(Component compo, String question) {
        super(Utility.getFrame(compo), I18n.getString("Question"));
        this.doInit(compo, question);
    }

    public YesNoBox(Component compo, String title, String question) {
        super(Utility.getFrame(compo), title);
        this.doInit(compo, question);
    }

    public void okPressed() {
        this.answeredYes = true;
        this.dispose();
    }

    public void cancelPressed() {
        this.answeredYes = false;
        this.dispose();
    }

    public boolean answer() {
        this.show();
        return this.answeredYes;
    }
}

