/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diff.DiffContentFactoryImpl;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class VcsFileStatusProvider
implements FileStatusProvider,
VcsBaseContentProvider {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(VcsFileStatusProvider.class);

    public static VcsFileStatusProvider getInstance(@NotNull Project project) {
        if (project == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(0);
        }
        return (VcsFileStatusProvider)project.getService(VcsFileStatusProvider.class);
    }

    VcsFileStatusProvider(@NotNull Project project) {
        if (project == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ChangeListListener.TOPIC, (Object)new ChangeListAdapter(){

            public void changeListAdded(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListRemoved(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListUpdateDone() {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }
        });
        VcsBaseContentProvider.EP_NAME.addChangeListener((AreaInstance)this.myProject, this::fileStatusesChanged, (Disposable)this.myProject);
    }

    private void fileStatusesChanged() {
        FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
    }

    @NotNull
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        AbstractVcs vcs;
        if (virtualFile == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(2);
        }
        if ((vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(virtualFile)) == null) {
            if (ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                FileStatus fileStatus = FileStatus.SUPPRESSED;
                if (fileStatus == null) {
                    VcsFileStatusProvider.$$$reportNull$$$0(3);
                }
                return fileStatus;
            }
            FileStatus fileStatus = FileStatusManagerImpl.getDefaultStatus(virtualFile);
            if (fileStatus == null) {
                VcsFileStatusProvider.$$$reportNull$$$0(4);
            }
            return fileStatus;
        }
        FileStatus status = ChangeListManager.getInstance((Project)this.myProject).getStatus(virtualFile);
        if (status == FileStatus.NOT_CHANGED && VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            FileStatus fileStatus = FileStatus.MODIFIED;
            if (fileStatus == null) {
                VcsFileStatusProvider.$$$reportNull$$$0(5);
            }
            return fileStatus;
        }
        if (status == FileStatus.NOT_CHANGED) {
            FileStatus fileStatus = FileStatusManagerImpl.getDefaultStatus(virtualFile);
            if (fileStatus == null) {
                VcsFileStatusProvider.$$$reportNull$$$0(6);
            }
            return fileStatus;
        }
        FileStatus fileStatus = status;
        if (fileStatus == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(7);
        }
        return fileStatus;
    }

    private static boolean isDocumentModified(VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return false;
        }
        return FileDocumentManager.getInstance().isFileModified(virtualFile);
    }

    public void refreshFileStatusFromDocument(@NotNull VirtualFile virtualFile, @NotNull Document doc) {
        ChangeProvider cp;
        boolean isStatusChanged;
        RollbackEnvironment rollbackEnvironment;
        AbstractVcs vcs;
        if (virtualFile == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(8);
        }
        if (doc == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(9);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("refreshFileStatusFromDocument: file.getModificationStamp()=" + virtualFile.getModificationStamp() + ", document.getModificationStamp()=" + doc.getModificationStamp());
        }
        if ((vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(virtualFile)) == null) {
            return;
        }
        FileStatusManagerImpl fileStatusManager = (FileStatusManagerImpl)FileStatusManager.getInstance((Project)this.myProject);
        FileStatus cachedStatus = fileStatusManager.getCachedStatus(virtualFile);
        boolean isDocumentModified = VcsFileStatusProvider.isDocumentModified(virtualFile);
        if (cachedStatus == FileStatus.MODIFIED && !isDocumentModified && !((ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject)).getState().SHOW_DIALOG && (rollbackEnvironment = vcs.getRollbackEnvironment()) != null) {
            rollbackEnvironment.rollbackIfUnchanged(virtualFile);
        }
        boolean bl = isStatusChanged = cachedStatus != null && cachedStatus != FileStatus.NOT_CHANGED;
        if (isStatusChanged != isDocumentModified) {
            fileStatusManager.fileStatusChanged(virtualFile);
        }
        if ((cp = vcs.getChangeProvider()) != null && cp.isModifiedDocumentTrackingRequired()) {
            boolean isClmStatusChanged;
            FileStatus status = ChangeListManager.getInstance((Project)this.myProject).getStatus(virtualFile);
            boolean bl2 = isClmStatusChanged = status != FileStatus.NOT_CHANGED;
            if (isClmStatusChanged != isDocumentModified) {
                VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(virtualFile);
            }
        }
    }

    @NotNull
    public ThreeState getNotChangedDirectoryParentingStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(10);
        }
        if (VcsConfiguration.getInstance((Project)this.myProject).SHOW_DIRTY_RECURSIVELY) {
            ThreeState threeState = ChangeListManager.getInstance((Project)this.myProject).haveChangesUnder(virtualFile);
            if (threeState == null) {
                VcsFileStatusProvider.$$$reportNull$$$0(11);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(12);
        }
        return threeState;
    }

    @Override
    @Nullable
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file) {
        if (file == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(13);
        }
        if (!this.isHandledByVcs(file)) {
            VcsBaseContentProvider provider = this.findProviderFor(file);
            return provider == null ? null : provider.getBaseRevision(file);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        Change change = changeListManager.getChange(file);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            return beforeRevision == null ? null : VcsFileStatusProvider.createBaseContent(this.myProject, beforeRevision);
        }
        FileStatus status = changeListManager.getStatus(file);
        if (status == FileStatus.HIJACKED) {
            DiffProvider diffProvider;
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file);
            DiffProvider diffProvider2 = diffProvider = vcs != null ? vcs.getDiffProvider() : null;
            if (diffProvider != null) {
                VcsRevisionNumber currentRevision = diffProvider.getCurrentRevision(file);
                return currentRevision == null ? null : new HijackedBaseContent(this.myProject, diffProvider, file, currentRevision);
            }
        }
        return null;
    }

    @Nullable
    private VcsBaseContentProvider findProviderFor(@NotNull VirtualFile file) {
        if (file == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(14);
        }
        return (VcsBaseContentProvider)VcsBaseContentProvider.EP_NAME.findFirstSafe((AreaInstance)this.myProject, it -> it.isSupported(file));
    }

    @Override
    public boolean isSupported(@NotNull VirtualFile file) {
        if (file == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(15);
        }
        return this.isHandledByVcs(file) || this.findProviderFor(file) != null;
    }

    private boolean isHandledByVcs(@NotNull VirtualFile file) {
        if (file == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(16);
        }
        return file.isInLocalFileSystem() && ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file) != null;
    }

    @NotNull
    public static VcsBaseContentProvider.BaseContent createBaseContent(@NotNull Project project, @NotNull ContentRevision contentRevision) {
        if (project == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(17);
        }
        if (contentRevision == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(18);
        }
        return new BaseContentImpl(project, contentRevision);
    }

    @Nullable
    private static String loadContentRevision(@Nullable Project project, @NotNull ContentRevision contentRevision) {
        if (contentRevision == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(19);
        }
        try {
            if (contentRevision instanceof ByteBackedContentRevision) {
                byte[] revisionContent = ((ByteBackedContentRevision)contentRevision).getContentAsBytes();
                FilePath filePath = contentRevision.getFile();
                if (revisionContent != null) {
                    Charset charset = DiffContentFactoryImpl.guessCharset((Project)project, (byte[])revisionContent, (FilePath)filePath);
                    return CharsetToolkit.decodeString((byte[])revisionContent, (Charset)charset);
                }
                return null;
            }
            return contentRevision.getContent();
        }
        catch (VcsException ex) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotChangedDirectoryParentingStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileStatus";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refreshFileStatusFromDocument";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNotChangedDirectoryParentingStatus";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBaseRevision";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findProviderFor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isHandledByVcs";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createBaseContent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadContentRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HijackedBaseContent
    implements VcsBaseContentProvider.BaseContent {
        @Nullable
        private final Project myProject;
        @NotNull
        private final DiffProvider myDiffProvider;
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final VcsRevisionNumber myRevision;

        HijackedBaseContent(@Nullable Project project, @NotNull DiffProvider diffProvider, @NotNull VirtualFile file, @NotNull VcsRevisionNumber revision) {
            if (diffProvider == null) {
                HijackedBaseContent.$$$reportNull$$$0(0);
            }
            if (file == null) {
                HijackedBaseContent.$$$reportNull$$$0(1);
            }
            if (revision == null) {
                HijackedBaseContent.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myDiffProvider = diffProvider;
            this.myFile = file;
            this.myRevision = revision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevision;
            if (vcsRevisionNumber == null) {
                HijackedBaseContent.$$$reportNull$$$0(3);
            }
            return vcsRevisionNumber;
        }

        @Override
        @Nullable
        public String loadContent() {
            ContentRevision contentRevision = this.myDiffProvider.createFileContent(this.myRevision, this.myFile);
            if (contentRevision == null) {
                return null;
            }
            return VcsFileStatusProvider.loadContentRevision(this.myProject, contentRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider$HijackedBaseContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider$HijackedBaseContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BaseContentImpl
    implements VcsBaseContentProvider.BaseContent {
        @Nullable
        private final Project myProject;
        @NotNull
        private final ContentRevision myContentRevision;

        BaseContentImpl(@NotNull Project project, @NotNull ContentRevision contentRevision) {
            if (project == null) {
                BaseContentImpl.$$$reportNull$$$0(0);
            }
            if (contentRevision == null) {
                BaseContentImpl.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myContentRevision = contentRevision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myContentRevision.getRevisionNumber();
            if (vcsRevisionNumber == null) {
                BaseContentImpl.$$$reportNull$$$0(2);
            }
            return vcsRevisionNumber;
        }

        @Override
        @Nullable
        public String loadContent() {
            return VcsFileStatusProvider.loadContentRevision(this.myProject, this.myContentRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRevision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider$BaseContentImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider$BaseContentImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

