/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.statistic.eventLog;

import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventScheduler;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventSchedulerKt;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEvents;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\b\u001a\u00020\tH\u0002\u001a,\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a<\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0002\u001a\u0018\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u001e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"EDT_EXECUTOR", "Ljava/util/concurrent/Executor;", "INITIAL_DELAY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PERIOD_DELAY", "logConfigStateEvents", "", "logInitializedComponent", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "project", "Lcom/intellij/openapi/project/Project;", "info", "Lcom/intellij/configurationStore/ComponentInfo;", "name", "", "logInitializedComponentsAndContinue", "components", "", "names", "Ljava/util/ArrayDeque;", "logInitializedProjectComponents", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "logProjectInitializedComponentsAndContinue", "projects", "intellij.platform.configurationStore.impl"})
public final class FeatureUsageSettingsEventSchedulerKt {
    private static final Logger LOG;
    private static final int PERIOD_DELAY = 1440;
    private static final int INITIAL_DELAY = 1440;
    private static final Executor EDT_EXECUTOR;

    private static final void logConfigStateEvents() {
        ProjectManagerEx projectManager;
        if (!FeatureUsageLogger.INSTANCE.isEnabled()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        FeatureUsageSettingsEventSchedulerKt.logInitializedProjectComponents((ComponentManager)application);
        ProjectManagerEx projectManagerEx = projectManager = ProjectManagerEx.getInstanceEx();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManagerEx, (String)"projectManager");
        Object[] objectArray = projectManagerEx.getOpenProjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"projectManager.openProjects");
        ArrayDeque<Project> projects = new ArrayDeque<Project>(ArraysKt.toList((Object[])objectArray));
        if (projectManager.isDefaultProjectInitialized()) {
            projects.addFirst(projectManager.getDefaultProject());
        }
        FeatureUsageSettingsEventSchedulerKt.logProjectInitializedComponentsAndContinue(projects);
    }

    private static final CompletableFuture<Void> logProjectInitializedComponentsAndContinue(ArrayDeque<Project> projects) {
        Project project = projects.pollFirst();
        if (project == null || !project.isInitialized() || project.isDisposed()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(null)");
            return completableFuture;
        }
        CompletionStage completionStage = FeatureUsageSettingsEventSchedulerKt.logInitializedProjectComponents((ComponentManager)project).thenCompose(new Function<T, CompletionStage<U>>(projects){
            final /* synthetic */ ArrayDeque $projects;

            @NotNull
            public final CompletableFuture<Void> apply(@Nullable Void it) {
                return FeatureUsageSettingsEventSchedulerKt.access$logProjectInitializedComponentsAndContinue(this.$projects);
            }
            {
                this.$projects = arrayDeque;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"logInitializedProjectCom\u2026ontinue(projects)\n      }");
        return completionStage;
    }

    private static final CompletableFuture<Void> logInitializedProjectComponents(ComponentManager componentManager) {
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)componentManager);
        if (!(iComponentStore instanceof ComponentStoreImpl)) {
            iComponentStore = null;
        }
        ComponentStoreImpl componentStoreImpl = (ComponentStoreImpl)iComponentStore;
        if (componentStoreImpl == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(null)");
            return completableFuture;
        }
        ComponentStoreImpl stateStore = componentStoreImpl;
        Map<String, ComponentInfo> components = stateStore.getComponents$intellij_platform_configurationStore_impl();
        ComponentManager componentManager2 = componentManager;
        if (!(componentManager2 instanceof Project)) {
            componentManager2 = null;
        }
        return FeatureUsageSettingsEventSchedulerKt.logInitializedComponentsAndContinue((Project)componentManager2, components, new ArrayDeque<String>((Collection)components.keySet()));
    }

    private static final CompletableFuture<Void> logInitializedComponentsAndContinue(Project project, Map<String, ? extends ComponentInfo> components, ArrayDeque<String> names) {
        CompletableFuture<Void> completableFuture;
        while (true) {
            String nextComponentName;
            if (names.pollFirst() == null) {
                CompletableFuture<Object> completableFuture2 = CompletableFuture.completedFuture(null);
                Intrinsics.checkExpressionValueIsNotNull(completableFuture2, (String)"CompletableFuture.completedFuture(null)");
                return completableFuture2;
            }
            ComponentInfo componentInfo = components.get(nextComponentName);
            if (componentInfo == null) {
                continue;
            }
            completableFuture = FeatureUsageSettingsEventSchedulerKt.logInitializedComponent(project, componentInfo, nextComponentName);
            if (completableFuture != null) break;
        }
        CompletableFuture<Void> future = completableFuture;
        CompletionStage completionStage = future.thenCompose(new Function<T, CompletionStage<U>>(project, components, names){
            final /* synthetic */ Project $project;
            final /* synthetic */ Map $components;
            final /* synthetic */ ArrayDeque $names;

            @NotNull
            public final CompletableFuture<Void> apply(@Nullable Void it) {
                return FeatureUsageSettingsEventSchedulerKt.access$logInitializedComponentsAndContinue(this.$project, this.$components, this.$names);
            }
            {
                this.$project = project;
                this.$components = map;
                this.$names = arrayDeque;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"future\n      .thenCompos\u2026omponents, names)\n      }");
        return completionStage;
    }

    private static final CompletableFuture<Void> logInitializedComponent(Project project, ComponentInfo info, String name) {
        State stateSpec = info.getStateSpec();
        if (stateSpec == null || !stateSpec.reportStatistic()) {
            return null;
        }
        Object object = info.getComponent();
        if (!(object instanceof PersistentStateComponent)) {
            object = null;
        }
        PersistentStateComponent persistentStateComponent = (PersistentStateComponent)object;
        if (persistentStateComponent == null) {
            return null;
        }
        PersistentStateComponent component = persistentStateComponent;
        return CompletableFuture.runAsync(new Runnable(component, name, project){
            final /* synthetic */ PersistentStateComponent $component;
            final /* synthetic */ String $name;
            final /* synthetic */ Project $project;

            public final void run() {
                try {
                    Object object = this.$component.getState();
                    if (object != null) {
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        FeatureUsageSettingsEvents.INSTANCE.logConfigurationState(this.$name, it, this.$project);
                    }
                }
                catch (Exception e) {
                    FeatureUsageSettingsEventSchedulerKt.access$getLOG$p().warn("Error during configuration recording", (Throwable)e);
                }
            }
            {
                this.$component = persistentStateComponent;
                this.$name = string;
                this.$project = project;
            }
        }, EDT_EXECUTOR);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FeatureUsageSettingsEventScheduler.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        EDT_EXECUTOR = EDT_EXECUTOR.1.INSTANCE;
    }

    public static final /* synthetic */ void access$logConfigStateEvents() {
        FeatureUsageSettingsEventSchedulerKt.logConfigStateEvents();
    }

    public static final /* synthetic */ CompletableFuture access$logProjectInitializedComponentsAndContinue(ArrayDeque projects) {
        return FeatureUsageSettingsEventSchedulerKt.logProjectInitializedComponentsAndContinue(projects);
    }

    public static final /* synthetic */ CompletableFuture access$logInitializedComponentsAndContinue(Project project, Map components, ArrayDeque names) {
        return FeatureUsageSettingsEventSchedulerKt.logInitializedComponentsAndContinue(project, components, names);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

