/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.LazyKt;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0018H\u0007J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u001e\u001a\u00020\u001dH\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0018H\u0007J\b\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0018H\u0007J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%H\u0007J\f\u0010&\u001a\u00020\u0004*\u00020\u0004H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R!\u0010\t\u001a\u00020\n8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\b\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\b\u001a\u0004\b\u0010\u0010\u0006R\u001b\u0010\u0012\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\b\u001a\u0004\b\u0013\u0010\u0006R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/util/io/DigestUtil;", "", "()V", "md5", "Ljava/security/MessageDigest;", "getMd5", "()Ljava/security/MessageDigest;", "md5$delegate", "Lkotlin/Lazy;", "random", "Ljava/security/SecureRandom;", "random$annotations", "getRandom", "()Ljava/security/SecureRandom;", "random$delegate", "sha1", "getSha1", "sha1$delegate", "sha256", "getSha256", "sha256$delegate", "sunSecurityProvider", "Ljava/security/Provider;", "calculateContentHash", "", "digest", "bytes", "getMessageDigest", "algorithm", "", "randomToken", "sha1Hex", "input", "sha256Hex", "updateContentHash", "", "path", "Ljava/nio/file/Path;", "cloneDigest", "intellij.platform.util.ex"})
public final class DigestUtil {
    private static final Provider sunSecurityProvider;
    @NotNull
    private static final Lazy random$delegate;
    private static final Lazy md5$delegate;
    private static final Lazy sha1$delegate;
    private static final Lazy sha256$delegate;
    public static final DigestUtil INSTANCE;

    @JvmStatic
    public static /* synthetic */ void random$annotations() {
    }

    @NotNull
    public static final SecureRandom getRandom() {
        Lazy lazy = random$delegate;
        DigestUtil digestUtil = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (SecureRandom)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final String randomToken() {
        String string = new BigInteger(130, DigestUtil.getRandom()).toString(32);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BigInteger(130, random).toString(32)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest md5() {
        return INSTANCE.cloneDigest(INSTANCE.getMd5());
    }

    private final MessageDigest getMd5() {
        Lazy lazy = md5$delegate;
        DigestUtil digestUtil = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha1() {
        return INSTANCE.cloneDigest(INSTANCE.getSha1());
    }

    private final MessageDigest getSha1() {
        Lazy lazy = sha1$delegate;
        DigestUtil digestUtil = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha256() {
        return INSTANCE.cloneDigest(INSTANCE.getSha256());
    }

    private final MessageDigest getSha256() {
        Lazy lazy = sha256$delegate;
        DigestUtil digestUtil = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final String sha256Hex(@NotNull byte[] input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        byte[] byArray = DigestUtil.sha256().digest(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sha256().digest(input)");
        return DigestUtilKt.access$bytesToHex(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String sha1Hex(@NotNull byte[] input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        byte[] byArray = DigestUtil.sha1().digest(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sha1().digest(input)");
        return DigestUtilKt.access$bytesToHex(byArray);
    }

    @Deprecated(message="Current implementation is very specific: it mixes length of the array to the hash.In general, it is enough to hash only bytes of the array. Implement the hashing yourself. Also make sure that you create new or reset the MessageDigest")
    @JvmStatic
    @NotNull
    public static final byte[] calculateContentHash(@NotNull MessageDigest digest, @NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        MessageDigest resetDigest = INSTANCE.cloneDigest(digest);
        String string = String.valueOf(bytes.length);
        MessageDigest messageDigest = resetDigest;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        messageDigest.update(byArray2);
        string = "\u0000";
        messageDigest = resetDigest;
        charset = Charsets.UTF_8;
        bl = false;
        byte[] byArray3 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byArray2 = byArray3;
        messageDigest.update(byArray2);
        resetDigest.update(bytes);
        byte[] byArray4 = resetDigest.digest();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"resetDigest.digest()");
        return byArray4;
    }

    private final MessageDigest cloneDigest(@NotNull MessageDigest $this$cloneDigest) {
        MessageDigest messageDigest;
        try {
            Object object = $this$cloneDigest.clone();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.MessageDigest");
            }
            messageDigest = (MessageDigest)object;
        }
        catch (CloneNotSupportedException e) {
            throw (Throwable)new IllegalArgumentException("Message digest is not cloneable: " + $this$cloneDigest);
        }
        return messageDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        byte[] buff = new byte[524288];
        try {
            Closeable closeable = PathKt.inputStream(path);
            boolean bl = false;
            Throwable throwable = null;
            try {
                int sz;
                InputStream iz = (InputStream)closeable;
                boolean bl2 = false;
                while ((sz = iz.read(buff)) > 0) {
                    digest.update(buff, 0, sz);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Failed to read " + path + ". " + e.getMessage(), e);
        }
    }

    private final MessageDigest getMessageDigest(String algorithm) {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm, sunSecurityProvider);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageDigest, (String)"MessageDigest.getInstanc\u2026thm, sunSecurityProvider)");
        return messageDigest;
    }

    private DigestUtil() {
    }

    static {
        DigestUtil digestUtil;
        INSTANCE = digestUtil = new DigestUtil();
        Provider provider = Security.getProvider("SUN");
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"java.security.Security.getProvider(\"SUN\")");
        sunSecurityProvider = provider;
        random$delegate = kotlin.LazyKt.lazy((Function0)random.2.INSTANCE);
        md5$delegate = LazyKt.lazyPub(md5.2.INSTANCE);
        sha1$delegate = LazyKt.lazyPub(sha1.2.INSTANCE);
        sha256$delegate = LazyKt.lazyPub(sha256.2.INSTANCE);
    }

    public static final /* synthetic */ MessageDigest access$getMessageDigest(DigestUtil $this, String algorithm) {
        return $this.getMessageDigest(algorithm);
    }
}

