/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.ElementPresentationTemplate;
import com.intellij.util.xml.Stubbed;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.ElementPresentationTemplateImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomExtensionImpl;
import gnu.trove.THashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomChildDescriptionImpl
implements AbstractDomChildrenDescription,
Comparable<AbstractDomChildDescriptionImpl> {
    private final Type myType;
    private Map<Class, Annotation> myCustomAnnotations;
    @Nullable
    private Map myUserMap;
    private volatile Ref<ElementPresentationTemplate> myPresentationTemplate = null;
    private volatile Boolean myStubbed;

    @Nullable
    private ElementPresentationTemplate calcPresentationTemplate() {
        Class clazz = ReflectionUtil.getRawType((Type)this.getType());
        Presentation presentation = DomApplicationComponent.getInstance().getInvocationCache(clazz).getClassAnnotation(Presentation.class);
        return presentation == null ? null : new ElementPresentationTemplateImpl(presentation, clazz);
    }

    protected AbstractDomChildDescriptionImpl(Type type) {
        this.myType = type;
    }

    public final void addCustomAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(0);
        }
        if (this.myCustomAnnotations == null) {
            this.myCustomAnnotations = new THashMap();
        }
        this.myCustomAnnotations.put(annotation.annotationType(), annotation);
    }

    private boolean calcStubbed() {
        return this.myType instanceof Class && DomReflectionUtil.findAnnotationDFS((Class)((Class)this.myType), Stubbed.class) != null || this.getAnnotation(Stubbed.class) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDomChildDescriptionImpl that = (AbstractDomChildDescriptionImpl)o;
        if (this.myCustomAnnotations != null ? !this.myCustomAnnotations.equals(that.myCustomAnnotations) : that.myCustomAnnotations != null) {
            return false;
        }
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        return !(this.myUserMap != null ? !this.myUserMap.equals(that.myUserMap) : that.myUserMap != null);
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + (this.myCustomAnnotations != null ? this.myCustomAnnotations.hashCode() : 0);
        result = 31 * result + (this.myUserMap != null ? this.myUserMap.hashCode() : 0);
        return result;
    }

    public void setUserMap(Map userMap) {
        this.myUserMap = userMap;
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)(this.myCustomAnnotations == null ? null : this.myCustomAnnotations.get(annotationClass));
    }

    public <T> T getUserData(Key<T> key) {
        return this.myUserMap == null ? null : (T)this.myUserMap.get(key);
    }

    @NotNull
    public final List<? extends DomElement> getStableValues(@NotNull DomElement parent) {
        if (parent == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(1);
        }
        List list = this.getValues(parent);
        ArrayList<DomElement> result = new ArrayList<DomElement>(list.size());
        DomManager domManager = parent.getManager();
        int i = 0;
        while (i < list.size()) {
            int i1 = i++;
            result.add(domManager.createStableValue(() -> {
                if (!parent.isValid()) {
                    return null;
                }
                List domElements = this.getValues(parent);
                return domElements.size() > i1 ? (DomElement)domElements.get(i1) : null;
            }));
        }
        ArrayList<DomElement> arrayList = result;
        if (arrayList == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public final Type getType() {
        Type type = this.myType;
        if (type == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(3);
        }
        return type;
    }

    @NotNull
    public DomNameStrategy getDomNameStrategy(@NotNull DomElement parent) {
        DomNameStrategy strategy;
        if (parent == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(4);
        }
        DomNameStrategy domNameStrategy = (strategy = DomImplUtil.getDomNameStrategy(ReflectionUtil.getRawType((Type)this.getType()), false)) == null ? parent.getNameStrategy() : strategy;
        if (domNameStrategy == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(5);
        }
        return domNameStrategy;
    }

    public boolean isValid() {
        return true;
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    @Nullable
    public ElementPresentationTemplate getPresentationTemplate() {
        Ref ref = this.myPresentationTemplate;
        if (ref == null) {
            this.myPresentationTemplate = ref = Ref.create((Object)this.calcPresentationTemplate());
        }
        return (ElementPresentationTemplate)ref.get();
    }

    @Nullable
    public PsiElement getDeclaration(Project project) {
        PsiElement element;
        DomElement domDeclaration = this.getDomDeclaration();
        if (domDeclaration != null) {
            DomTarget target = DomTarget.getTarget((DomElement)domDeclaration);
            if (target != null) {
                return PomService.convertToPsi((PsiTarget)target);
            }
            return domDeclaration.getXmlElement();
        }
        DomAnchor<?> anchor = this.getUserData(DomExtensionImpl.KEY_DOM_DECLARATION);
        if (anchor != null) {
            return anchor.getContainingFile();
        }
        SmartPsiElementPointer<?> pointer = this.getUserData(DomExtensionImpl.DECLARING_ELEMENT_KEY);
        if (pointer != null && (element = pointer.getElement()) != null) {
            return element;
        }
        return PomService.convertToPsi((Project)project, (PomTarget)this);
    }

    public DomElement getDomDeclaration() {
        DomAnchor<?> anchor = this.getUserData(DomExtensionImpl.KEY_DOM_DECLARATION);
        if (anchor != null) {
            return anchor.retrieveDomElement();
        }
        return null;
    }

    public boolean isStubbed() {
        Boolean stubbed = this.myStubbed;
        if (stubbed == null) {
            this.myStubbed = stubbed = Boolean.valueOf(this.calcStubbed());
        }
        return stubbed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStableValues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomNameStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCustomAnnotation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStableValues";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDomNameStrategy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

