/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PyParametersRenameFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            PyParametersRenameFactory.$$$reportNull$$$0(0);
        }
        if (element instanceof PyParameter) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            return function != null && function.getContainingClass() != null;
        }
        return false;
    }

    public String getOptionName() {
        return PyBundle.message("refactoring.rename.parameters.in.hierarchy", new Object[0]);
    }

    public boolean isEnabled() {
        return PyCodeInsightSettings.getInstance().RENAME_PARAMETERS_IN_HIERARCHY;
    }

    public void setEnabled(boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_PARAMETERS_IN_HIERARCHY = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new PyParametersRenamer((PyParameter)element, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/rename/PyParametersRenameFactory", "isApplicable"));
    }

    public static class PyParametersRenamer
    extends AutomaticRenamer {
        public PyParametersRenamer(PyParameter element, String newName) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            PyOverridingMethodsSearch.search(function, true).forEach(pyFunction -> {
                PyParameter[] parameters;
                for (PyParameter parameter : parameters = pyFunction.getParameterList().getParameters()) {
                    PyNamedParameter named = parameter.getAsNamed();
                    if (named == null || !Objects.equals(named.getName(), element.getName())) continue;
                    this.myElements.add(named);
                }
                return true;
            });
            this.suggestAllNames(element.getName(), newName);
        }

        public String getDialogTitle() {
            return PyBundle.message("refactoring.rename.parameters.title", new Object[0]);
        }

        public String getDialogDescription() {
            return PyBundle.message("refactoring.rename.parameter.in.hierarchy.to", new Object[0]);
        }

        public String entityName() {
            return "Parameter";
        }

        public boolean isSelectedByDefault() {
            return true;
        }
    }
}

