/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization.stateProperties;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.JsonSchemaType;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.components.StoredPropertyBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001d\u0010\u000b\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u000b\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\u0003\u001a\u00028\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004\u00a8\u0006\u001c"}, d2={"Lcom/intellij/serialization/stateProperties/ObjectStateStoredPropertyBase;", "T", "Lcom/intellij/openapi/components/StoredPropertyBase;", "value", "(Ljava/lang/Object;)V", "jsonType", "Lcom/intellij/openapi/components/JsonSchemaType;", "getJsonType", "()Lcom/intellij/openapi/components/JsonSchemaType;", "getValue", "()Ljava/lang/Object;", "setValue", "Ljava/lang/Object;", "equals", "", "other", "", "thisRef", "Lcom/intellij/openapi/components/BaseState;", "(Lcom/intellij/openapi/components/BaseState;)Ljava/lang/Object;", "hashCode", "", "", "newValue", "(Lcom/intellij/openapi/components/BaseState;Ljava/lang/Object;)V", "Lcom/intellij/openapi/components/StoredProperty;", "toString", "", "intellij.platform.objectSerializer"})
public abstract class ObjectStateStoredPropertyBase<T>
extends StoredPropertyBase<T> {
    private T value;

    @NotNull
    public JsonSchemaType getJsonType() {
        return JsonSchemaType.OBJECT;
    }

    public T getValue(@NotNull BaseState thisRef) {
        Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
        return this.value;
    }

    public void setValue(@NotNull BaseState thisRef, T newValue) {
        Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
        if (Intrinsics.areEqual(this.value, newValue) ^ true) {
            thisRef.intIncrementModificationCount();
            this.value = newValue;
        }
    }

    public boolean setValue(@NotNull StoredProperty<T> other) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        T newValue = ((ObjectStateStoredPropertyBase)other).value;
        if (Intrinsics.areEqual(newValue, this.value)) {
            bl = false;
        } else {
            this.value = newValue;
            bl = true;
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ObjectStateStoredPropertyBase && Intrinsics.areEqual(this.value, ((ObjectStateStoredPropertyBase)((Object)other)).value);
    }

    public int hashCode() {
        T t = this.value;
        return t != null ? t.hashCode() : 0;
    }

    @NotNull
    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append(this.getName()).append(" = ");
        if (this.isEqualToDefault()) {
            string = "";
        } else {
            string = this.value;
            if (string == null || (string = string.toString()) == null) {
                string = super.toString();
            }
        }
        return stringBuilder.append(string).toString();
    }

    protected final T getValue() {
        return this.value;
    }

    protected final void setValue(T t) {
        this.value = t;
    }

    public ObjectStateStoredPropertyBase(T value) {
        this.value = value;
    }
}

