/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiChangeUtils;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPsiImplUtils {
    static final Key<List<Pair<TextRange, String>>> STRING_FRAGMENTS = new Key("JSON string fragments");
    private static final String ourEscapesTable = "\"\"\\\\//b\bf\fn\nr\rt\t";

    @NotNull
    public static String getName(@NotNull JsonProperty property) {
        if (property == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(0);
        }
        String string = StringUtil.unescapeStringCharacters((String)JsonPsiUtil.stripQuotes(property.getNameElement().getText()));
        if (string == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static JsonValue getNameElement(@NotNull JsonProperty property) {
        if (property == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(2);
        }
        PsiElement firstChild = property.getFirstChild();
        assert (firstChild instanceof JsonLiteral || firstChild instanceof JsonReferenceExpression);
        JsonValue jsonValue = (JsonValue)firstChild;
        if (jsonValue == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(3);
        }
        return jsonValue;
    }

    @Nullable
    public static JsonValue getValue(@NotNull JsonProperty property) {
        if (property == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(4);
        }
        return (JsonValue)PsiTreeUtil.getNextSiblingOfType((PsiElement)JsonPsiImplUtils.getNameElement(property), JsonValue.class);
    }

    public static boolean isQuotedString(@NotNull JsonLiteral literal) {
        if (literal == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(5);
        }
        return literal.getNode().findChildByType(JsonParserDefinition.STRING_LITERALS) != null;
    }

    @Nullable
    public static ItemPresentation getPresentation(final @NotNull JsonProperty property) {
        if (property == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(6);
        }
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return property.getName();
            }

            @Nullable
            public String getLocationString() {
                JsonValue value = property.getValue();
                return value instanceof JsonLiteral ? value.getText() : null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                if (property.getValue() instanceof JsonArray) {
                    return AllIcons.Json.Array;
                }
                if (property.getValue() instanceof JsonObject) {
                    return AllIcons.Json.Object;
                }
                return PlatformIcons.PROPERTY_ICON;
            }
        };
    }

    @Nullable
    public static ItemPresentation getPresentation(@NotNull JsonArray array) {
        if (array == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(7);
        }
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return JsonBundle.message("json.array", new Object[0]);
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Json.Array;
            }
        };
    }

    @Nullable
    public static ItemPresentation getPresentation(@NotNull JsonObject object) {
        if (object == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(8);
        }
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return JsonBundle.message("json.object", new Object[0]);
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Json.Object;
            }
        };
    }

    @NotNull
    public static List<Pair<TextRange, String>> getTextFragments(@NotNull JsonStringLiteral literal) {
        List<Pair<TextRange, String>> result;
        if (literal == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(9);
        }
        if ((result = (ArrayList<Pair<TextRange, String>>)literal.getUserData(STRING_FRAGMENTS)) == null) {
            int contentEnd;
            result = new ArrayList<Pair<TextRange, String>>();
            String text = literal.getText();
            int length = text.length();
            int pos = 1;
            int unescapedSequenceStart = 1;
            while (pos < length) {
                if (text.charAt(pos) == '\\') {
                    if (unescapedSequenceStart != pos) {
                        result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(unescapedSequenceStart, pos), (Object)text.substring(unescapedSequenceStart, pos)));
                    }
                    if (pos == length - 1) {
                        result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, pos + 1), (Object)"\\"));
                        break;
                    }
                    char next = text.charAt(pos + 1);
                    switch (next) {
                        case '\"': 
                        case '/': 
                        case '\\': 
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            int idx = ourEscapesTable.indexOf(next);
                            result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, pos + 2), (Object)ourEscapesTable.substring(idx + 1, idx + 2)));
                            pos += 2;
                            break;
                        }
                        case 'u': {
                            int i;
                            for (i = pos + 2; i < pos + 6 && i != length && StringUtil.isHexDigit((char)text.charAt(i)); ++i) {
                            }
                            result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, i), (Object)text.substring(pos, i)));
                            pos = i;
                            break;
                        }
                        case 'x': {
                            Language language = JsonDialectUtil.getLanguageOrDefaultJson(literal);
                            if (language instanceof JsonLanguage && ((JsonLanguage)language).hasPermissiveStrings()) {
                                int i2;
                                for (i2 = pos + 2; i2 < pos + 4 && i2 != length && StringUtil.isHexDigit((char)text.charAt(i2)); ++i2) {
                                }
                                result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, i2), (Object)text.substring(pos, i2)));
                                pos = i2;
                                break;
                            }
                        }
                        default: {
                            result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, pos + 2), (Object)text.substring(pos, pos + 2)));
                            pos += 2;
                        }
                    }
                    unescapedSequenceStart = pos;
                    continue;
                }
                ++pos;
            }
            int n = contentEnd = text.charAt(0) == text.charAt(length - 1) ? length - 1 : length;
            if (unescapedSequenceStart < contentEnd) {
                result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(unescapedSequenceStart, contentEnd), (Object)text.substring(unescapedSequenceStart, contentEnd)));
            }
            result = Collections.unmodifiableList(result);
            literal.putUserData(STRING_FRAGMENTS, result);
        }
        ArrayList<Pair<TextRange, String>> arrayList = result;
        if (arrayList == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public static void delete(@NotNull JsonProperty property) {
        if (property == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(11);
        }
        ASTNode myNode = property.getNode();
        JsonPsiChangeUtils.removeCommaSeparatedFromList(myNode, myNode.getTreeParent());
    }

    @NotNull
    public static String getValue(@NotNull JsonStringLiteral literal) {
        if (literal == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(12);
        }
        String string = StringUtil.unescapeStringCharacters((String)JsonPsiUtil.stripQuotes(literal.getText()));
        if (string == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static boolean isPropertyName(@NotNull JsonStringLiteral literal) {
        PsiElement parent;
        if (literal == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(14);
        }
        return (parent = literal.getParent()) instanceof JsonProperty && ((JsonProperty)parent).getNameElement() == literal;
    }

    public static boolean getValue(@NotNull JsonBooleanLiteral literal) {
        if (literal == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(15);
        }
        return literal.textMatches("true");
    }

    public static double getValue(@NotNull JsonNumberLiteral literal) {
        if (literal == null) {
            JsonPsiImplUtils.$$$reportNull$$$0(16);
        }
        return Double.parseDouble(literal.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/psi/impl/JsonPsiImplUtils";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/psi/impl/JsonPsiImplUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFragments";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNameElement";
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextFragments";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

