/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.rename;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TextOccurrencesRenamer {
    private final Editor myEditor;
    private final String myOldName;
    private final List<TextRange> myOccurrences;
    private final TextRange myOccurrenceAtCaret;
    private final long myInitialModificationStamp;

    TextOccurrencesRenamer(@NotNull Editor editor, @NotNull String occurrenceText, @NotNull Collection<TextRange> occurrences, @NotNull TextRange occurrenceAtCaret) {
        if (editor == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(0);
        }
        if (occurrenceText == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(1);
        }
        if (occurrences == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(2);
        }
        if (occurrenceAtCaret == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(3);
        }
        this.myEditor = editor;
        this.myOldName = occurrenceText;
        this.myOccurrences = new ArrayList<TextRange>(occurrences);
        this.myOccurrences.sort(Comparator.comparingInt(TextRange::getStartOffset));
        this.myOccurrenceAtCaret = occurrenceAtCaret;
        this.myInitialModificationStamp = this.myEditor.getDocument().getModificationStamp();
    }

    @NotNull
    public String getOldName() {
        String string = this.myOldName;
        if (string == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(5);
        }
        return editor;
    }

    public void renameTo(@NotNull String newName) {
        if (newName == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(6);
        }
        Document document = this.myEditor.getDocument();
        CharSequence documentText = document.getImmutableCharSequence();
        if (document.getModificationStamp() != this.myInitialModificationStamp || !this.isValid(documentText)) {
            return;
        }
        String result = this.getNewDocumentText(documentText, newName);
        WriteAction.run(() -> {
            int prevCount = (int)this.myOccurrences.stream().filter(range -> range.getStartOffset() < this.myOccurrenceAtCaret.getStartOffset()).count();
            Caret caret = this.myEditor.getCaretModel().getPrimaryCaret();
            int newCaretOffset = caret.getOffset() + (newName.length() - this.myOldName.length()) * prevCount;
            CommandProcessor.getInstance().executeCommand(this.myEditor.getProject(), () -> {
                document.setText((CharSequence)result);
                caret.moveToOffset(newCaretOffset);
            }, null, null, document);
        });
    }

    @NotNull
    private String getNewDocumentText(@NotNull CharSequence documentText, @NotNull String newName) {
        if (documentText == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(7);
        }
        if (newName == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(8);
        }
        TextRange prevOccurrence = null;
        StringBuilder result = new StringBuilder(documentText.length() + (newName.length() - this.myOldName.length()) * this.myOccurrences.size());
        for (TextRange occurrence : this.myOccurrences) {
            result.append(documentText.subSequence(prevOccurrence != null ? prevOccurrence.getEndOffset() : 0, occurrence.getStartOffset()));
            result.append(newName);
            prevOccurrence = occurrence;
        }
        result.append(documentText.subSequence(prevOccurrence != null ? prevOccurrence.getEndOffset() : 0, documentText.length()));
        String string = result.toString();
        if (string == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(9);
        }
        return string;
    }

    private boolean isValid(@NotNull CharSequence text) {
        if (text == null) {
            TextOccurrencesRenamer.$$$reportNull$$$0(10);
        }
        for (TextRange occurrence : this.myOccurrences) {
            if (StringUtil.startsWith((CharSequence)text, (int)occurrence.getStartOffset(), (CharSequence)this.myOldName)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrenceText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrenceAtCaret";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/rename/TextOccurrencesRenamer";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentText";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/rename/TextOccurrencesRenamer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewDocumentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameTo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNewDocumentText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

