/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.cellvalidators;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.cellvalidators.CellComponentProvider;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CellTooltipManager {
    private static final Pattern HTML_A_TAG_PATTERN = Pattern.compile("(?i)<a([^>]+)>(.+?)</a>");
    private final Disposable parentDisposable;
    private CellComponentProvider cellComponentProvider;
    private HyperlinkListener hyperlinkListener;
    private final Alarm popupAlarm;
    private ValidationInfo validationInfo;
    private boolean closeWithDelay;
    private ComponentPopupBuilder popupBuilder;
    private JBPopup cellPopup;
    private Rectangle cellRect;
    private Dimension popupSize;
    private boolean isOverPopup;
    private boolean isClosing;

    @ApiStatus.Experimental
    public CellTooltipManager(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            CellTooltipManager.$$$reportNull$$$0(0);
        }
        this.popupAlarm = new Alarm();
        this.parentDisposable = parentDisposable;
    }

    @ApiStatus.Experimental
    public CellTooltipManager withCellComponentProvider(@NotNull CellComponentProvider cellComponentProvider) {
        if (cellComponentProvider == null) {
            CellTooltipManager.$$$reportNull$$$0(1);
        }
        this.cellComponentProvider = cellComponentProvider;
        return this;
    }

    @ApiStatus.Experimental
    public CellTooltipManager withHyperlinkListener(@NotNull HyperlinkListener hyperlinkListener) {
        if (hyperlinkListener == null) {
            CellTooltipManager.$$$reportNull$$$0(2);
        }
        this.hyperlinkListener = hyperlinkListener;
        return this;
    }

    @ApiStatus.Experimental
    public void installOn(@NotNull JComponent component) {
        if (component == null) {
            CellTooltipManager.$$$reportNull$$$0(3);
        }
        ValidationMouseListener mouseListener = new ValidationMouseListener();
        PropertyChangeListener propertyChangeListener = e -> {
            if (this.cellComponentProvider != null && this.cellComponentProvider.isEditingStarted(e)) {
                this.hidePopup(true, null);
            }
        };
        component.addMouseListener(mouseListener);
        component.addMouseMotionListener(mouseListener);
        component.addPropertyChangeListener(propertyChangeListener);
        Disposer.register((Disposable)this.parentDisposable, () -> {
            this.hidePopup(true, null);
            component.removeMouseListener(mouseListener);
            component.removeMouseMotionListener(mouseListener);
            component.removePropertyChangeListener(propertyChangeListener);
            this.cellComponentProvider = null;
            this.validationInfo = null;
            this.popupBuilder = null;
        });
    }

    private void handleMouseEvent(MouseEvent e) {
        if (this.cellComponentProvider != null) {
            ValidationInfo info;
            JComponent cellRenderer = this.cellComponentProvider.getCellRendererComponent(e);
            ValidationInfo validationInfo = info = cellRenderer != null ? (ValidationInfo)cellRenderer.getClientProperty("CellRenderer.validationInfo") : null;
            if (info != null) {
                Rectangle cellRect;
                if (!info.equals(this.validationInfo)) {
                    this.validationInfo = info;
                    this.closeWithDelay = CellTooltipManager.hasATag(this.validationInfo.message);
                    this.popupBuilder = ComponentValidator.createPopupBuilder(this.validationInfo, tipComponent -> {
                        if (this.closeWithDelay) {
                            tipComponent.addHyperlinkListener(this.hyperlinkListener);
                            tipComponent.addMouseListener(new TipComponentMouseListener());
                        }
                        this.popupSize = tipComponent.getPreferredSize();
                    }).setCancelOnMouseOutCallback(me -> me.getID() == 501 && !ComponentValidator.withinComponent(this.validationInfo, me) && (this.cellRect == null || !this.cellRect.contains(me.getPoint())));
                    this.hidePopup(false, () -> this.showPopup(e));
                } else if (!this.isShowing()) {
                    this.showPopup(e);
                } else if (!this.isClosing && !(cellRect = this.cellComponentProvider.getCellRect(e)).equals(this.cellRect)) {
                    this.cellRect = cellRect;
                    Point point = new Point(this.cellRect.x + JBUIScale.scale((int)40), this.cellRect.y - JBUIScale.scale((int)6) - this.popupSize.height);
                    SwingUtilities.convertPointToScreen(point, this.cellComponentProvider.getOwner());
                    this.cellPopup.setLocation(point);
                }
            } else {
                this.validationInfo = null;
                this.hidePopup(false, null);
            }
        }
    }

    private static boolean hasATag(@NotNull String string) {
        if (string == null) {
            CellTooltipManager.$$$reportNull$$$0(4);
        }
        return HTML_A_TAG_PATTERN.matcher(string).find();
    }

    private void showPopup(MouseEvent e) {
        if (!this.cellComponentProvider.isEditing(e)) {
            this.cellPopup = this.popupBuilder.createPopup();
            this.cellRect = this.cellComponentProvider.getCellRect(e);
            JComponent c = this.cellComponentProvider.getCellRendererComponent(e);
            Object i = c != null ? c.getInsets() : JBUI.emptyInsets();
            Point point = new Point(this.cellRect.x + JBUIScale.scale((int)40), this.cellRect.y + i.top - JBUIScale.scale((int)6) - this.popupSize.height);
            this.cellPopup.show(new RelativePoint(this.cellComponentProvider.getOwner(), point));
        }
    }

    private void hidePopup(boolean now, @Nullable Runnable onHidden) {
        if (this.isShowing()) {
            if (now || this.hyperlinkListener == null || !this.closeWithDelay) {
                this.cellPopup.cancel();
                this.cellPopup = null;
                this.cellRect = null;
                if (onHidden != null) {
                    onHidden.run();
                }
            } else if (!this.isClosing) {
                this.isClosing = true;
                this.popupAlarm.addRequest(() -> {
                    this.isClosing = false;
                    if (!this.isOverPopup) {
                        this.hidePopup(true, onHidden);
                    }
                }, Registry.intValue((String)"ide.tooltip.initialDelay.highlighter"));
            }
        } else if (onHidden != null) {
            onHidden.run();
        }
    }

    private boolean isShowing() {
        return this.cellPopup != null && this.cellPopup.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellComponentProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/cellvalidators/CellTooltipManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withCellComponentProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withHyperlinkListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installOn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasATag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class TipComponentMouseListener
    extends MouseAdapter {
        private TipComponentMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            CellTooltipManager.this.isOverPopup = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            CellTooltipManager.this.isOverPopup = false;
            CellTooltipManager.this.hidePopup(true, null);
        }
    }

    private class ValidationMouseListener
    extends MouseAdapter {
        private ValidationMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            CellTooltipManager.this.handleMouseEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            CellTooltipManager.this.hidePopup(false, null);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            CellTooltipManager.this.handleMouseEvent(e);
        }
    }
}

