/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiInvalidElementAccessException
extends RuntimeException
implements ExceptionWithAttachments {
    private static final Key<Object> INVALIDATION_TRACE = Key.create((String)"INVALIDATION_TRACE");
    private static final Key<Boolean> REPORTING_EXCEPTION = Key.create((String)"REPORTING_EXCEPTION");
    private final SoftReference<PsiElement> myElementReference;
    private final Attachment[] myDiagnostic;
    private final String myMessage;

    public PsiInvalidElementAccessException(@Nullable PsiElement element) {
        this(element, null, null);
    }

    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable String message) {
        this(element, message, null);
    }

    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable Throwable cause) {
        this(element, null, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable String message, @Nullable Throwable cause) {
        super(null, cause);
        this.myElementReference = new SoftReference<PsiElement>(element);
        if (element == null) {
            this.myMessage = message;
            this.myDiagnostic = Attachment.EMPTY_ARRAY;
        } else if (element == PsiUtilCore.NULL_PSI_ELEMENT) {
            this.myMessage = "NULL_PSI_ELEMENT ;" + message;
            this.myDiagnostic = Attachment.EMPTY_ARRAY;
        } else {
            boolean recursiveInvocation = Boolean.TRUE.equals(element.getUserData(REPORTING_EXCEPTION));
            element.putUserData(REPORTING_EXCEPTION, Boolean.TRUE);
            try {
                Object trace = recursiveInvocation ? null : PsiInvalidElementAccessException.getPsiInvalidationTrace(element);
                this.myMessage = PsiInvalidElementAccessException.getMessageWithReason(element, message, recursiveInvocation, trace);
                this.myDiagnostic = PsiInvalidElementAccessException.createAttachments(trace);
            }
            finally {
                element.putUserData(REPORTING_EXCEPTION, null);
            }
        }
    }

    private PsiInvalidElementAccessException(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(0);
        }
        this.myElementReference = new SoftReference<Object>(null);
        IElementType elementType = node.getElementType();
        this.myMessage = "Element " + node.getClass() + " of type " + elementType + " (" + elementType.getClass() + ")" + (message == null ? "" : "; " + message);
        this.myDiagnostic = PsiInvalidElementAccessException.createAttachments(PsiInvalidElementAccessException.findInvalidationTrace(node));
    }

    public static PsiInvalidElementAccessException createByNode(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(1);
        }
        return new PsiInvalidElementAccessException(node, message);
    }

    private static Attachment @NotNull [] createAttachments(@Nullable Object trace) {
        Attachment[] attachmentArray;
        if (trace == null) {
            attachmentArray = Attachment.EMPTY_ARRAY;
        } else {
            Attachment[] attachmentArray2 = new Attachment[1];
            attachmentArray = attachmentArray2;
            Attachment attachment = attachmentArray2[0] = trace instanceof Throwable ? new Attachment("invalidation", (Throwable)trace) : new Attachment("diagnostic.txt", trace.toString());
        }
        if (attachmentArray == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(2);
        }
        return attachmentArray;
    }

    @Nullable
    private static Object getPsiInvalidationTrace(@NotNull PsiElement element) {
        Object trace;
        if (element == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(3);
        }
        if ((trace = PsiInvalidElementAccessException.getInvalidationTrace(element)) != null) {
            return trace;
        }
        if (element instanceof PsiFile) {
            return PsiInvalidElementAccessException.getInvalidationTrace(((PsiFile)element).getOriginalFile());
        }
        return PsiInvalidElementAccessException.findInvalidationTrace(element.getNode());
    }

    private static String getMessageWithReason(@NotNull PsiElement element, @Nullable String message, boolean recursiveInvocation, @Nullable Object trace) {
        if (element == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(4);
        }
        String reason = "Element: " + element.getClass();
        if (!recursiveInvocation) {
            try {
                reason = reason + " #" + PsiInvalidElementAccessException.getLanguage(element).getID() + " ";
            }
            catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                // empty catch block
            }
            String traceText = !PsiInvalidElementAccessException.isTrackingInvalidation() ? "disabled" : (trace != null ? "see attachment" : "no info");
            try {
                reason = reason + " because: " + PsiInvalidElementAccessException.findOutInvalidationReason(element);
            }
            catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                // empty catch block
            }
            reason = reason + "\ninvalidated at: " + traceText;
        }
        return reason + (message == null ? "" : "; " + message);
    }

    @NotNull
    private static Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(5);
        }
        Language language = element instanceof ASTNode ? ((ASTNode)((Object)element)).getElementType().getLanguage() : element.getLanguage();
        if (language == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(6);
        }
        return language;
    }

    @Override
    public String getMessage() {
        return this.myMessage;
    }

    public Attachment @NotNull [] getAttachments() {
        if (this.myDiagnostic == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(7);
        }
        return this.myDiagnostic;
    }

    public static Object findInvalidationTrace(@Nullable ASTNode element) {
        while (element != null) {
            Object trace = element.getUserData(INVALIDATION_TRACE);
            if (trace != null) {
                return trace;
            }
            ASTNode parent = element.getTreeParent();
            if (parent == null && element instanceof FileASTNode) {
                PsiElement psi = element.getPsi();
                Object object = trace = psi == null ? null : psi.getUserData(INVALIDATION_TRACE);
                if (trace != null) {
                    return trace;
                }
            }
            element = parent;
        }
        return null;
    }

    @NonNls
    @NotNull
    public static String findOutInvalidationReason(@NotNull PsiElement root) {
        PsiElement context;
        PsiElement element;
        if (root == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(8);
        }
        if (root == PsiUtilCore.NULL_PSI_ELEMENT) {
            return "NULL_PSI_ELEMENT";
        }
        PsiElement psiElement = element = root instanceof PsiFile ? root : root.getParent();
        if (element == null) {
            String m = "parent is null";
            if (root instanceof StubBasedPsiElement) {
                for (Object stub = ((StubBasedPsiElement)root).getStub(); stub != null; stub = stub.getParentStub()) {
                    m = m + "\n  each stub=" + stub;
                    if (!(stub instanceof PsiFileStub)) continue;
                    m = m + "; fileStub.psi=" + stub.getPsi() + "; reason=" + ((PsiFileStub)stub).getInvalidationReason();
                }
            }
            String string = m;
            if (string == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(9);
            }
            return string;
        }
        while (element != null && !(element instanceof PsiFile)) {
            element = element.getParent();
        }
        PsiFile file = (PsiFile)element;
        if (file == null) {
            return "containing file is null";
        }
        FileViewProvider provider = file.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        if (!vFile.isValid()) {
            String string = vFile + " is invalid";
            if (string == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (!provider.isPhysical() && (context = file.getContext()) != null && !context.isValid()) {
            String string = "invalid context: " + PsiInvalidElementAccessException.findOutInvalidationReason(context);
            if (string == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(11);
            }
            return string;
        }
        PsiFile original = file.getOriginalFile();
        if (original != file && !original.isValid()) {
            String string = "invalid original: " + PsiInvalidElementAccessException.findOutInvalidationReason(original);
            if (string == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(12);
            }
            return string;
        }
        PsiManager manager = file.getManager();
        if (manager.getProject().isDisposed()) {
            String string = "project is disposed: " + manager.getProject();
            if (string == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(13);
            }
            return string;
        }
        Language language = file.getLanguage();
        if (language != provider.getBaseLanguage()) {
            String string = "File language:" + (Object)((Object)language) + " != Provider base language:" + (Object)((Object)provider.getBaseLanguage());
            if (string == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(14);
            }
            return string;
        }
        FileViewProvider p = manager.findViewProvider(vFile);
        if (provider != p) {
            String string = "different providers: " + provider + "(" + PsiInvalidElementAccessException.id(provider) + "); " + p + "(" + PsiInvalidElementAccessException.id(p) + ")";
            if (string == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (!provider.isPhysical()) {
            String string = "non-physical provider: " + provider;
            if (string == null) {
                PsiInvalidElementAccessException.$$$reportNull$$$0(16);
            }
            return string;
        }
        return "psi is outdated";
    }

    private static String id(FileViewProvider provider) {
        return Integer.toHexString(System.identityHashCode(provider));
    }

    public static void setInvalidationTrace(@NotNull UserDataHolder element, Object trace) {
        if (element == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(17);
        }
        element.putUserData(INVALIDATION_TRACE, trace);
    }

    public static Object getInvalidationTrace(@NotNull UserDataHolder element) {
        if (element == null) {
            PsiInvalidElementAccessException.$$$reportNull$$$0(18);
        }
        return element.getUserData(INVALIDATION_TRACE);
    }

    public static boolean isTrackingInvalidation() {
        return Registry.is((String)"psi.track.invalidation");
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myElementReference.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiInvalidElementAccessException";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiInvalidElementAccessException";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachments";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findOutInvalidationReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createByNode";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiInvalidationTrace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMessageWithReason";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOutInvalidationReason";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setInvalidationTrace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidationTrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

