/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.treetable;

import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ListTreeTableModel
extends DefaultTreeModel
implements TreeTableModel {
    private final ColumnInfo[] myColumns;

    public ListTreeTableModel(TreeNode root, ColumnInfo[] columns) {
        super(root);
        this.myColumns = columns;
    }

    @Override
    public int getColumnCount() {
        return this.myColumns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    @Override
    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public Class getColumnClass(int column) {
        return this.myColumns[column].getColumnClass();
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.myColumns[column].isCellEditable(node);
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        this.myColumns[column].setValue(node, aValue);
    }

    @Override
    public void setTree(JTree tree) {
    }
}

