/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.util.XmlTagUtilBase;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlTagUtil
extends XmlTagUtilBase {
    private static final Object2IntMap<String> ourCharacterEntities = new Object2IntOpenHashMap();

    public static String getCDATAQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&\n";
        int textLength = text.length();
        if (textLength > 0 && (Character.isWhitespace(text.charAt(0)) || Character.isWhitespace(text.charAt(textLength - 1)))) {
            return "<![CDATA[" + text + "]]>";
        }
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static String getInlineQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&";
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static CharSequence composeTagText(@NonNls String tagName, @NonNls String tagValue) {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(tagName);
        if (StringUtil.isEmpty((String)tagValue)) {
            builder.append("/>");
        } else {
            builder.append('>').append(XmlTagUtil.getCDATAQuote(tagValue)).append("</").append(tagName).append('>');
        }
        return builder;
    }

    public static String[] getCharacterEntityNames() {
        return ArrayUtilRt.toStringArray((Collection)ourCharacterEntities.keySet());
    }

    public static char getCharacterByEntityName(String entityName) {
        return (char)ourCharacterEntities.getInt((Object)entityName);
    }

    @Nullable
    public static XmlToken getStartTagNameElement(@NotNull XmlTag tag) {
        IElementType elementType;
        ASTNode current;
        ASTNode node;
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(0);
        }
        if ((node = tag.getNode()) == null) {
            return null;
        }
        for (current = node.getFirstChildNode(); current != null && (elementType = current.getElementType()) != XmlTokenType.XML_NAME && elementType != XmlTokenType.XML_TAG_NAME; current = current.getTreeNext()) {
        }
        return current == null ? null : (XmlToken)current.getPsi();
    }

    @Nullable
    public static XmlToken getEndTagNameElement(@NotNull XmlTag tag) {
        ASTNode current;
        ASTNode node;
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(1);
        }
        if ((node = tag.getNode()) == null) {
            return null;
        }
        ASTNode prev = current = node.getLastChildNode();
        while (current != null) {
            IElementType elementType = prev.getElementType();
            if ((elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) && current.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return (XmlToken)prev.getPsi();
            }
            prev = current;
            current = TemplateLanguageUtil.getSameLanguageTreePrev(current);
        }
        return null;
    }

    @NotNull
    public static TextRange getTrimmedValueRange(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(2);
        }
        XmlTagValue tagValue = tag.getValue();
        String text = tagValue.getText();
        String trimmed = text.trim();
        int index = text.indexOf(trimmed);
        int startOffset = tagValue.getTextRange().getStartOffset() - tag.getTextRange().getStartOffset() + index;
        return new TextRange(startOffset, startOffset + trimmed.length());
    }

    @Nullable
    public static TextRange getStartTagRange(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(3);
        }
        XmlToken tagName = XmlTagUtil.getStartTagNameElement(tag);
        return XmlTagUtil.getTagRange(tagName, XmlTokenType.XML_START_TAG_START);
    }

    @Nullable
    public static TextRange getEndTagRange(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(4);
        }
        XmlToken tagName = XmlTagUtil.getEndTagNameElement(tag);
        return XmlTagUtil.getTagRange(tagName, XmlTokenType.XML_END_TAG_START);
    }

    @Nullable
    private static TextRange getTagRange(@Nullable XmlToken tagName, IElementType tagStart) {
        PsiElement f;
        PsiElement s;
        if (tagName == null) {
            return null;
        }
        for (s = tagName.getPrevSibling(); s != null && s.getNode().getElementType() != tagStart; s = s.getPrevSibling()) {
        }
        for (f = tagName.getNextSibling(); f != null && f.getNode().getElementType() != XmlTokenType.XML_TAG_END && f.getNode().getElementType() != XmlTokenType.XML_EMPTY_ELEMENT_END; f = f.getNextSibling()) {
        }
        if (s != null && f != null) {
            return new TextRange(s.getTextRange().getStartOffset(), f.getTextRange().getEndOffset());
        }
        return null;
    }

    static {
        ourCharacterEntities.put((Object)"lt", 60);
        ourCharacterEntities.put((Object)"gt", 62);
        ourCharacterEntities.put((Object)"apos", 39);
        ourCharacterEntities.put((Object)"quot", 34);
        ourCharacterEntities.put((Object)"nbsp", 160);
        ourCharacterEntities.put((Object)"amp", 38);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "tag";
        objectArray2[1] = "com/intellij/xml/util/XmlTagUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartTagNameElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getEndTagNameElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTrimmedValueRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartTagRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEndTagRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

