/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.documentation.render.DocRenderImageManager;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemUpdater;
import com.intellij.codeInsight.documentation.render.DocRendererMemoryManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DocRenderer
implements EditorCustomElementRenderer {
    private static final Logger LOG = Logger.getInstance(DocRenderer.class);
    private static final DocRendererMemoryManager MEMORY_MANAGER = new DocRendererMemoryManager();
    private static final DocRenderImageManager IMAGE_MANAGER = new DocRenderImageManager();
    private static final int MIN_WIDTH = 350;
    private static final int MAX_WIDTH = 680;
    private static final int LEFT_INSET = 14;
    private static final int RIGHT_INSET = 12;
    private static final int TOP_BOTTOM_INSETS = 2;
    private static final int TOP_BOTTOM_MARGINS = 4;
    private static final int LINE_WIDTH = 2;
    private static final int ARC_RADIUS = 5;
    private static StyleSheet ourCachedStyleSheet;
    private static String ourCachedStyleSheetLinkColor;
    private static String ourCachedStyleSheetMonoFont;
    private final DocRenderItem myItem;
    private boolean myContentUpdateNeeded;
    private EditorPane myPane;

    DocRenderer(@NotNull DocRenderItem item) {
        if (item == null) {
            DocRenderer.$$$reportNull$$$0(0);
        }
        this.myItem = item;
    }

    void updateContent() {
        Inlay<DocRenderer> inlay = this.myItem.inlay;
        if (inlay != null) {
            this.myContentUpdateNeeded = true;
            inlay.update();
        }
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(1);
        }
        return DocRenderer.calcInlayWidth(inlay.getEditor());
    }

    public int calcHeightInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(2);
        }
        Editor editor = inlay.getEditor();
        int width = Math.max(0, DocRenderer.calcInlayWidth(editor) - this.calcInlayStartX() + editor.getInsets().left - DocRenderer.scale(14) - DocRenderer.scale(12));
        EditorPane component2 = this.getRendererComponent(inlay, width);
        return Math.max(editor.getLineHeight(), ((JComponent)component2).getPreferredSize().height + DocRenderer.scale(2) * 2 + DocRenderer.scale(4) * 2);
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Color bgColor;
        int endX;
        int startX;
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(3);
        }
        if (g == null) {
            DocRenderer.$$$reportNull$$$0(4);
        }
        if (targetRegion == null) {
            DocRenderer.$$$reportNull$$$0(5);
        }
        if (textAttributes == null) {
            DocRenderer.$$$reportNull$$$0(6);
        }
        if ((startX = this.calcInlayStartX()) >= (endX = targetRegion.x + targetRegion.width)) {
            return;
        }
        int margin = DocRenderer.scale(4);
        int filledHeight = targetRegion.height - margin * 2;
        if (filledHeight <= 0) {
            return;
        }
        int filledStartY = targetRegion.y + margin;
        EditorEx editor = (EditorEx)inlay.getEditor();
        Color defaultBgColor = editor.getBackgroundColor();
        Color currentBgColor = textAttributes.getBackgroundColor();
        Color color = bgColor = currentBgColor == null ? defaultBgColor : ColorUtil.mix((Color)defaultBgColor, (Color)textAttributes.getBackgroundColor(), (double)0.5);
        if (currentBgColor != null) {
            g.setColor(bgColor);
            int arcDiameter = 10;
            if (endX - startX >= arcDiameter) {
                g.fillRect(startX, filledStartY, endX - startX - 5, filledHeight);
                Object savedHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fillRoundRect(endX - arcDiameter, filledStartY, arcDiameter, filledHeight, arcDiameter, arcDiameter);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedHint);
            } else {
                g.fillRect(startX, filledStartY, endX - startX, filledHeight);
            }
        }
        g.setColor(editor.getColorsScheme().getColor(DefaultLanguageHighlighterColors.DOC_COMMENT_GUIDE));
        g.fillRect(startX, filledStartY, DocRenderer.scale(2), filledHeight);
        int topBottomInset = DocRenderer.scale(2);
        int componentWidth = endX - startX - DocRenderer.scale(14) - DocRenderer.scale(12);
        int componentHeight = filledHeight - topBottomInset * 2;
        if (componentWidth > 0 && componentHeight > 0) {
            EditorPane component2 = this.getRendererComponent(inlay, componentWidth);
            component2.setBackground(bgColor);
            Graphics dg = g.create(startX + DocRenderer.scale(14), filledStartY + topBottomInset, componentWidth, componentHeight);
            UISettings.setupAntialiasing((Graphics)dg);
            ((JComponent)component2).paint(dg);
            dg.dispose();
        }
    }

    public GutterIconRenderer calcGutterIconRenderer(@NotNull Inlay inlay) {
        DocRenderItem.MyGutterIconRenderer myGutterIconRenderer;
        DocRenderItem.MyGutterIconRenderer highlighterIconRenderer;
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(7);
        }
        if ((highlighterIconRenderer = (DocRenderItem.MyGutterIconRenderer)this.myItem.highlighter.getGutterIconRenderer()) == null) {
            myGutterIconRenderer = null;
        } else {
            DocRenderItem docRenderItem = this.myItem;
            Objects.requireNonNull(docRenderItem);
            myGutterIconRenderer = docRenderItem.new DocRenderItem.MyGutterIconRenderer(AllIcons.Gutter.JavadocEdit, highlighterIconRenderer.isIconVisible());
        }
        return myGutterIconRenderer;
    }

    public ActionGroup getContextMenuGroup(@NotNull Inlay inlay) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(8);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new CopySelection());
        group.addSeparator();
        group.add(this.myItem.createToggleAction());
        AnAction toggleRenderAllAction = ActionManager.getInstance().getAction("ToggleRenderedDocPresentationForAll");
        if (toggleRenderAllAction != null) {
            group.add(toggleRenderAllAction);
        }
        group.add((AnAction)new DocRenderItem.ChangeFontSize());
        return group;
    }

    private static int scale(int value2) {
        return (int)((float)value2 * UISettings.getDefFontScale());
    }

    static int calcInlayWidth(@NotNull Editor editor) {
        int availableWidth;
        if (editor == null) {
            DocRenderer.$$$reportNull$$$0(9);
        }
        if ((availableWidth = editor.getScrollingModel().getVisibleArea().width) <= 0) {
            return 680;
        }
        return Math.max(DocRenderer.scale(350), Math.min(DocRenderer.scale(680), availableWidth));
    }

    private int calcInlayStartX() {
        Document document;
        int nextLineNumber;
        Editor editor = this.myItem.editor;
        RangeHighlighter highlighter = this.myItem.highlighter;
        if (highlighter.isValid() && (nextLineNumber = (document = editor.getDocument()).getLineNumber(highlighter.getEndOffset()) + 1) < document.getLineCount()) {
            int lineStartOffset = document.getLineStartOffset(nextLineNumber);
            int contentStartOffset = CharArrayUtil.shiftForward((CharSequence)document.getImmutableCharSequence(), (int)lineStartOffset, (String)" \t\n");
            return editor.offsetToXY((int)contentStartOffset, (boolean)false, (boolean)true).x;
        }
        return editor.getInsets().left;
    }

    Rectangle getEditorPaneBoundsWithinInlay(Inlay inlay) {
        int relativeX = this.calcInlayStartX() - this.myItem.editor.getInsets().left + DocRenderer.scale(14);
        int relativeY = DocRenderer.scale(4) + DocRenderer.scale(2);
        return new Rectangle(relativeX, relativeY, inlay.getWidthInPixels() - relativeX - DocRenderer.scale(12), inlay.getHeightInPixels() - relativeY * 2);
    }

    EditorPane getRendererComponent(Inlay inlay, int width) {
        boolean newInstance = false;
        EditorEx editor = (EditorEx)inlay.getEditor();
        if (this.myPane == null || this.myContentUpdateNeeded) {
            newInstance = true;
            this.clearCachedComponent();
            this.myPane = new EditorPane();
            this.myPane.setEditable(false);
            this.myPane.getCaret().setSelectionVisible(true);
            this.myPane.putClientProperty("caretWidth", 0);
            this.myPane.setEditorKit(DocRenderer.createEditorKit(editor));
            this.myPane.setBorder((Border)JBUI.Borders.empty());
            HashMap<TextAttribute, Integer> fontAttributes = new HashMap<TextAttribute, Integer>();
            fontAttributes.put(TextAttribute.SIZE, JBUIScale.scale((int)DocumentationComponent.getQuickDocFontSize().getSize()));
            fontAttributes.put(TextAttribute.KERNING, 0);
            this.myPane.setFont(this.myPane.getFont().deriveFont(fontAttributes));
            Color textColor = DocRenderer.getTextColor(editor.getColorsScheme());
            this.myPane.setForeground(textColor);
            this.myPane.setSelectedTextColor(textColor);
            this.myPane.setSelectionColor(editor.getSelectionModel().getTextAttributes().getBackgroundColor());
            UIUtil.enableEagerSoftWrapping((JTextComponent)this.myPane);
            String textToRender = this.myItem.textToRender;
            if (textToRender == null) {
                textToRender = CodeInsightBundle.message((String)"doc.render.loading.text", (Object[])new Object[0]);
            }
            this.myPane.setText(textToRender);
            this.myPane.addHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    this.activateLink(e);
                }
            });
            this.myPane.getDocument().putProperty("imageCache", IMAGE_MANAGER.getImageProvider());
            this.myContentUpdateNeeded = false;
        }
        AppUIUtil.targetToDevice(this.myPane, editor.getContentComponent());
        this.myPane.setSize(width, 10000000);
        if (newInstance) {
            this.myPane.getPreferredSize();
            this.myPane.startImageTracking();
        }
        return this.myPane;
    }

    void clearCachedComponent() {
        if (this.myPane != null) {
            this.myPane.dispose();
            this.myPane = null;
        }
    }

    void dispose() {
        this.clearCachedComponent();
    }

    @NotNull
    private static Color getTextColor(@NotNull EditorColorsScheme scheme) {
        TextAttributes attributes;
        if (scheme == null) {
            DocRenderer.$$$reportNull$$$0(10);
        }
        Color color = (attributes = scheme.getAttributes(DefaultLanguageHighlighterColors.DOC_COMMENT)) == null ? null : attributes.getForegroundColor();
        Color color2 = color == null ? scheme.getDefaultForeground() : color;
        if (color2 == null) {
            DocRenderer.$$$reportNull$$$0(11);
        }
        return color2;
    }

    private void activateLink(HyperlinkEvent event) {
        Element element2 = event.getSourceElement();
        if (element2 == null) {
            return;
        }
        Rectangle location = null;
        try {
            location = ((JEditorPane)event.getSource()).modelToView(element2.getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (location == null) {
            return;
        }
        PsiDocCommentBase comment = this.myItem.getComment();
        if (comment == null) {
            return;
        }
        PsiElement context = (PsiElement)ObjectUtils.notNull((Object)comment.getOwner(), (Object)comment);
        String url = event.getDescription();
        if (DocRenderer.isGotoDeclarationEvent()) {
            DocRenderer.navigateToDeclaration(context, url);
        } else {
            this.showDocumentation(this.myItem.editor, context, url, location);
        }
    }

    private static boolean isGotoDeclarationEvent() {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null) {
            return false;
        }
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (!(event instanceof MouseEvent)) {
            return false;
        }
        MouseShortcut mouseShortcut = KeymapUtil.createMouseShortcut((MouseEvent)((MouseEvent)event));
        return keymapManager2.getActiveKeymap().getActionIds(mouseShortcut).contains("GotoDeclaration");
    }

    private static void navigateToDeclaration(@NotNull PsiElement context, @NotNull String linkUrl) {
        PsiElement targetElement;
        if (context == null) {
            DocRenderer.$$$reportNull$$$0(12);
        }
        if (linkUrl == null) {
            DocRenderer.$$$reportNull$$$0(13);
        }
        if ((targetElement = DocumentationManager.getInstance(context.getProject()).getTargetElement(context, linkUrl)) instanceof Navigatable) {
            ((Navigatable)targetElement).navigate(true);
        }
    }

    private void showDocumentation(@NotNull Editor editor, @NotNull PsiElement context, @NotNull String linkUrl, @NotNull Rectangle linkLocationWithinInlay) {
        DocumentationComponent component2;
        if (editor == null) {
            DocRenderer.$$$reportNull$$$0(14);
        }
        if (context == null) {
            DocRenderer.$$$reportNull$$$0(15);
        }
        if (linkUrl == null) {
            DocRenderer.$$$reportNull$$$0(16);
        }
        if (linkLocationWithinInlay == null) {
            DocRenderer.$$$reportNull$$$0(17);
        }
        Project project = context.getProject();
        final DocumentationManager documentationManager = DocumentationManager.getInstance(project);
        if (QuickDocUtil.getActiveDocComponent(project) == null) {
            Inlay<DocRenderer> inlay = this.myItem.inlay;
            Point inlayPosition = Objects.requireNonNull(inlay.getBounds()).getLocation();
            Rectangle relativeBounds = this.getEditorPaneBoundsWithinInlay(inlay);
            editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, (Object)new Point(inlayPosition.x + relativeBounds.x + linkLocationWithinInlay.x, inlayPosition.y + relativeBounds.y + linkLocationWithinInlay.y + linkLocationWithinInlay.height));
            documentationManager.showJavaDocInfo(editor, context, context, () -> editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, null), "", false, true);
        }
        if ((component2 = QuickDocUtil.getActiveDocComponent(project)) != null) {
            if (!documentationManager.hasActiveDockedDocWindow()) {
                component2.startWait();
            }
            documentationManager.navigateByLink(component2, linkUrl);
        }
        if (documentationManager.getDocInfoHint() == null) {
            editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, null);
        }
        if (documentationManager.hasActiveDockedDocWindow()) {
            documentationManager.setAllowContentUpdateFromContext(false);
            final Disposable disposable2 = Disposer.newDisposable();
            editor.getCaretModel().addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    documentationManager.resetAutoUpdateState();
                    Disposer.dispose((Disposable)disposable2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderer$1", "caretPositionChanged"));
                }
            }, disposable2);
        }
    }

    private static EditorKit createEditorKit(@NotNull Editor editor) {
        if (editor == null) {
            DocRenderer.$$$reportNull$$$0(18);
        }
        MyEditorKit editorKit = new MyEditorKit();
        ((HTMLEditorKit)((Object)editorKit)).getStyleSheet().addStyleSheet(DocRenderer.getStyleSheet(editor));
        return editorKit;
    }

    private static StyleSheet getStyleSheet(@NotNull Editor editor) {
        String linkColorHex;
        if (editor == null) {
            DocRenderer.$$$reportNull$$$0(19);
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        String editorFontName = (String)ObjectUtils.notNull((Object)colorsScheme.getEditorFontName(), (Object)"Monospaced");
        Color linkColor = colorsScheme.getColor(DefaultLanguageHighlighterColors.DOC_COMMENT_LINK);
        if (linkColor == null) {
            linkColor = DocRenderer.getTextColor(colorsScheme);
        }
        if (!Objects.equals(linkColorHex = ColorUtil.toHex((Color)linkColor), ourCachedStyleSheetLinkColor) || !Objects.equals(editorFontName, ourCachedStyleSheetMonoFont)) {
            String escapedFontName = StringUtil.escapeQuotes((String)editorFontName);
            ourCachedStyleSheet = StartupUiUtil.createStyleSheet((String)("body {overflow-wrap: anywhere}code {font-family: \"" + escapedFontName + "\"}pre {font-family: \"" + escapedFontName + "\";white-space: pre-wrap}h1, h2, h3, h4, h5, h6 {margin-top: 0; padding-top: 1}a {color: #" + linkColorHex + "; text-decoration: none}p {padding: 7 0 2 0}ol {padding: 0 20 0 0}ul {padding: 0 20 0 0}li {padding: 1 0 2 0}li p {padding-top: 0}table p {padding-bottom: 0}th {text-align: left}td {padding: 2 0 2 0}td p {padding-top: 0}.sections {border-spacing: 0}.section {padding-right: 5; white-space: nowrap}.content {padding: 2 0 2 0}"));
            ourCachedStyleSheetLinkColor = linkColorHex;
            ourCachedStyleSheetMonoFont = editorFontName;
        }
        return ourCachedStyleSheet;
    }

    static {
        ourCachedStyleSheetLinkColor = "non-existing";
        ourCachedStyleSheetMonoFont = "non-existing";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 9: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/render/DocRenderer";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkUrl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkLocationWithinInlay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calcWidthInPixels";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcHeightInPixels";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcGutterIconRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContextMenuGroup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcInlayWidth";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTextColor";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDeclaration";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showDocumentation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createEditorKit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStyleSheet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CopySelection
    extends DumbAwareAction {
        CopySelection() {
            super(CodeInsightBundle.messagePointer((String)"doc.render.copy.action.text", (Object[])new Object[0]), AllIcons.Actions.Copy);
            AnAction copyAction = ActionManager.getInstance().getAction("$Copy");
            if (copyAction != null) {
                this.copyShortcutFrom(copyAction);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopySelection.$$$reportNull$$$0(0);
            }
            e.getPresentation().setVisible(DocRenderer.this.myPane != null && DocRenderer.this.myPane.hasSelection());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String text;
            if (e == null) {
                CopySelection.$$$reportNull$$$0(1);
            }
            String string = text = DocRenderer.this.myPane == null ? null : DocRenderer.this.myPane.getSelectedText();
            if (!StringUtil.isEmpty((String)text)) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderer$CopySelection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyScalingImageView
    extends ImageView {
        private int myAvailableWidth;

        private MyScalingImageView(Element element2) {
            super(element2);
        }

        @Override
        public int getResizeWeight(int axis) {
            return 1;
        }

        @Override
        public float getMaximumSpan(int axis) {
            return this.getPreferredSpan(axis);
        }

        @Override
        public float getPreferredSpan(int axis) {
            float baseSpan = super.getPreferredSpan(axis);
            if (axis == 0) {
                return baseSpan;
            }
            int availableWidth = this.getAvailableWidth();
            if (availableWidth <= 0) {
                return baseSpan;
            }
            float baseXSpan = super.getPreferredSpan(0);
            if (baseXSpan <= 0.0f) {
                return baseSpan;
            }
            if ((float)availableWidth > baseXSpan) {
                availableWidth = (int)baseXSpan;
            }
            if (this.myAvailableWidth > 0 && availableWidth != this.myAvailableWidth) {
                this.preferenceChanged(null, false, true);
            }
            this.myAvailableWidth = availableWidth;
            return baseSpan * (float)availableWidth / baseXSpan;
        }

        private int getAvailableWidth() {
            View v = this;
            while (v != null) {
                View parent = v.getParent();
                if (parent instanceof FlowView) {
                    int childCount = parent.getViewCount();
                    for (int i2 = 0; i2 < childCount; ++i2) {
                        if (parent.getView(i2) != v) continue;
                        return ((FlowView)parent).getFlowSpan(i2);
                    }
                }
                v = parent;
            }
            return 0;
        }

        @Override
        public void paint(Graphics g, Shape a) {
            final Rectangle targetRect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            Graphics2DDelegate scalingGraphics = new Graphics2DDelegate((Graphics2D)g){

                public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
                    int maxWidth = Math.max(0, targetRect.width - 2 * (x - targetRect.x));
                    int maxHeight = Math.max(0, targetRect.height - 2 * (y - targetRect.y));
                    if (width > maxWidth) {
                        height = height * maxWidth / width;
                        width = maxWidth;
                    }
                    if (height > maxHeight) {
                        width = width * maxHeight / height;
                        height = maxHeight;
                    }
                    return super.drawImage(img, x, y, width, height, observer);
                }
            };
            super.paint((Graphics)scalingGraphics, a);
        }
    }

    private static class MyViewFactory
    extends JBHtmlEditorKit.JBHtmlFactory {
        private static final MyViewFactory INSTANCE = new MyViewFactory();

        private MyViewFactory() {
        }

        public View create(Element elem) {
            View view = super.create(elem);
            return view instanceof ImageView ? new MyScalingImageView(elem) : view;
        }
    }

    private static class MyEditorKit
    extends JBHtmlEditorKit {
        private MyEditorKit() {
        }

        public ViewFactory getViewFactory() {
            return MyViewFactory.INSTANCE;
        }
    }

    class EditorPane
    extends JEditorPane {
        private final List<Image> myImages = new ArrayList<Image>();
        private final AtomicBoolean myUpdateScheduled = new AtomicBoolean();
        private final AtomicBoolean myRepaintScheduled = new AtomicBoolean();
        private final ImageObserver myImageObserver = new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if ((infoflags & 3) != 0) {
                    EditorPane.this.scheduleUpdate();
                    return false;
                }
                return true;
            }
        };
        private boolean myRepaintRequested;

        EditorPane() {
            MEMORY_MANAGER.register(DocRenderer.this, 50);
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
            this.myRepaintRequested = true;
        }

        void doWithRepaintTracking(Runnable task2) {
            this.myRepaintRequested = false;
            task2.run();
            if (this.myRepaintRequested) {
                this.repaintInlay();
            }
        }

        private void repaintInlay() {
            Inlay<DocRenderer> inlay = ((DocRenderer)DocRenderer.this).myItem.inlay;
            if (inlay != null) {
                inlay.repaint();
            }
        }

        @Override
        public void paint(Graphics g) {
            MEMORY_MANAGER.notifyPainted(DocRenderer.this);
            for (Image image : this.myImages) {
                IMAGE_MANAGER.notifyPainted(image);
            }
            super.paint(g);
        }

        Editor getEditor() {
            return ((DocRenderer)DocRenderer.this).myItem.editor;
        }

        void removeSelection() {
            this.doWithRepaintTracking(() -> this.select(0, 0));
        }

        boolean hasSelection() {
            return this.getSelectionStart() != this.getSelectionEnd();
        }

        @Nullable
        Point getSelectionPositionInEditor() {
            Rectangle locationInPane;
            if (DocRenderer.this.myPane != this || ((DocRenderer)DocRenderer.this).myItem.inlay == null || ((DocRenderer)DocRenderer.this).myItem.inlay.getRenderer() != DocRenderer.this) {
                return null;
            }
            Rectangle inlayBounds = ((DocRenderer)DocRenderer.this).myItem.inlay.getBounds();
            if (inlayBounds == null) {
                return null;
            }
            Rectangle boundsWithinInlay = DocRenderer.this.getEditorPaneBoundsWithinInlay(((DocRenderer)DocRenderer.this).myItem.inlay);
            try {
                locationInPane = this.modelToView(this.getSelectionStart());
            }
            catch (BadLocationException e) {
                LOG.error((Throwable)e);
                locationInPane = new Rectangle();
            }
            return new Point(inlayBounds.x + boundsWithinInlay.x + locationInPane.x, inlayBounds.y + boundsWithinInlay.y + locationInPane.y);
        }

        private void scheduleUpdate() {
            if (this.myUpdateScheduled.compareAndSet(false, true)) {
                SwingUtilities.invokeLater(() -> {
                    this.myRepaintScheduled.set(false);
                    this.myUpdateScheduled.set(false);
                    Inlay<DocRenderer> inlay = ((DocRenderer)DocRenderer.this).myItem.inlay;
                    if (this == DocRenderer.this.myPane && inlay != null) {
                        DocRenderItemUpdater.getInstance().updateInlays(Collections.singleton(inlay), false);
                    }
                });
            }
        }

        private void scheduleRepaint() {
            if (!this.myUpdateScheduled.get() && this.myRepaintScheduled.compareAndSet(false, true)) {
                SwingUtilities.invokeLater(() -> {
                    this.myRepaintScheduled.set(false);
                    if (this == DocRenderer.this.myPane) {
                        this.repaintInlay();
                    }
                });
            }
        }

        void startImageTracking() {
            this.collectImages(this.getUI().getRootView(this));
            boolean update2 = false;
            for (Image image : this.myImages) {
                IMAGE_MANAGER.setCompletionListener(image, this::scheduleRepaint);
                update2 |= image.getWidth(this.myImageObserver) >= 0 || image.getHeight(this.myImageObserver) >= 0;
            }
            if (update2) {
                this.myImageObserver.imageUpdate(null, 3, 0, 0, 0, 0);
            }
        }

        private void collectImages(View view) {
            Image image;
            if (view instanceof ImageView && (image = ((ImageView)view).getImage()) != null) {
                this.myImages.add(image);
            }
            int childCount = view.getViewCount();
            for (int i2 = 0; i2 < childCount; ++i2) {
                this.collectImages(view.getView(i2));
            }
        }

        void dispose() {
            MEMORY_MANAGER.unregister(DocRenderer.this);
            this.myImages.forEach(image -> IMAGE_MANAGER.dispose((Image)image));
        }
    }
}

