/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ConsoleTitleGen;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.CommonActionsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConsoleRunnerWithHistory<T extends LanguageConsoleView> {
    private final String myConsoleTitle;
    private ProcessHandler myProcessHandler;
    private final String myWorkingDir;
    private T myConsoleView;
    @NotNull
    private final Project myProject;
    private ProcessBackedConsoleExecuteActionHandler myConsoleExecuteActionHandler;

    public AbstractConsoleRunnerWithHistory(@NotNull Project project, @NotNull String consoleTitle, @Nullable String workingDir) {
        if (project == null) {
            AbstractConsoleRunnerWithHistory.$$$reportNull$$$0(0);
        }
        if (consoleTitle == null) {
            AbstractConsoleRunnerWithHistory.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myConsoleTitle = consoleTitle;
        this.myWorkingDir = workingDir;
    }

    public void initAndRun() throws ExecutionException {
        Process process2 = this.createProcess();
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myConsoleView = this.createConsoleView();
            if (this.myConsoleView instanceof JComponent) {
                ((JComponent)this.myConsoleView).setBorder((Border)new SideBorder(JBColor.border(), 1));
            }
            this.myProcessHandler = this.createProcessHandler(process2);
            this.myConsoleExecuteActionHandler = this.createExecuteActionHandler();
            ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AbstractConsoleRunnerWithHistory.this.finishConsole();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory$1", "processTerminated"));
                }
            });
            this.myConsoleView.attachToProcess(this.myProcessHandler);
            this.createContentDescriptorAndActions();
            this.myProcessHandler.startNotify();
        });
    }

    protected Executor getExecutor() {
        return DefaultRunExecutor.getRunExecutorInstance();
    }

    protected void createContentDescriptorAndActions() {
        Executor defaultExecutor = this.getExecutor();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ConsoleRunner", (ActionGroup)toolbarActions, false);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)actionToolbar.getComponent(), "West");
        panel2.add((Component)this.myConsoleView.getComponent(), "Center");
        actionToolbar.setTargetComponent((JComponent)panel2);
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(this.myConsoleView, this.myProcessHandler, (JComponent)panel2, this.constructConsoleTitle(this.myConsoleTitle), this.getConsoleIcon());
        contentDescriptor.setFocusComputable(() -> this.getConsoleView().getConsoleEditor().getContentComponent());
        contentDescriptor.setAutoFocusContent(this.isAutoFocusContent());
        List<AnAction> actions = this.fillToolBarActions(toolbarActions, defaultExecutor, contentDescriptor);
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions, this.getConsoleView().getConsoleEditor().getComponent());
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions, panel2);
        this.showConsole(defaultExecutor, contentDescriptor);
    }

    @Nullable
    protected Icon getConsoleIcon() {
        return null;
    }

    protected String constructConsoleTitle(@NotNull String consoleTitle) {
        if (consoleTitle == null) {
            AbstractConsoleRunnerWithHistory.$$$reportNull$$$0(2);
        }
        return new ConsoleTitleGen(this.myProject, consoleTitle, this.shouldAddNumberToTitle()).makeTitle();
    }

    public boolean isAutoFocusContent() {
        return true;
    }

    protected boolean shouldAddNumberToTitle() {
        return false;
    }

    protected void showConsole(Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            AbstractConsoleRunnerWithHistory.$$$reportNull$$$0(3);
        }
        RunContentManager.getInstance((Project)this.myProject).showRunContent(defaultExecutor, contentDescriptor);
    }

    protected void finishConsole() {
        this.myConsoleView.setEditable(false);
    }

    protected abstract T createConsoleView();

    @Nullable
    protected abstract Process createProcess() throws ExecutionException;

    protected abstract OSProcessHandler createProcessHandler(Process var1);

    public static void registerActionShortcuts(List<? extends AnAction> actions, JComponent component2) {
        for (AnAction anAction : actions) {
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), component2);
        }
    }

    protected List<AnAction> fillToolBarActions(DefaultActionGroup toolbarActions, Executor defaultExecutor, RunContentDescriptor contentDescriptor) {
        ArrayList<AnAction> actionList = new ArrayList<AnAction>();
        actionList.add(this.createStopAction());
        actionList.add(this.createCloseAction(defaultExecutor, contentDescriptor));
        actionList.add(this.createConsoleExecAction(this.myConsoleExecuteActionHandler));
        actionList.add(CommonActionsManager.getInstance().createHelpAction("interactive_console"));
        toolbarActions.addAll(actionList);
        return actionList;
    }

    protected AnAction createCloseAction(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        return new CloseAction(defaultExecutor, myDescriptor, this.myProject);
    }

    protected AnAction createStopAction() {
        return ActionManager.getInstance().getAction("Stop");
    }

    protected AnAction createConsoleExecAction(@NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        if (consoleExecuteActionHandler == null) {
            AbstractConsoleRunnerWithHistory.$$$reportNull$$$0(4);
        }
        String emptyAction = consoleExecuteActionHandler.getEmptyExecuteAction();
        return new ConsoleExecuteAction((LanguageConsoleView)this.myConsoleView, consoleExecuteActionHandler, emptyAction, consoleExecuteActionHandler);
    }

    @NotNull
    protected abstract ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler();

    public T getConsoleView() {
        return this.myConsoleView;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractConsoleRunnerWithHistory.$$$reportNull$$$0(5);
        }
        return project;
    }

    public String getConsoleTitle() {
        return this.myConsoleTitle;
    }

    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public ProcessBackedConsoleExecuteActionHandler getConsoleExecuteActionHandler() {
        return this.myConsoleExecuteActionHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleTitle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleExecuteActionHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/AbstractConsoleRunnerWithHistory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "constructConsoleTitle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showConsole";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleExecAction";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

