/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunContentManagerImplKt;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.execution.ui.layout.impl.DockableGridContainerFactory;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 K2\u00020\u0001:\u0002JKB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u001a\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0012H\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0018\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00102\u0006\u0010(\u001a\u00020)H\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\b\u00102\u001a\u000201H\u0002J*\u00103\u001a\u0002012\b\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\u001bH\u0002J\u0016\u00106\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0010J#\u00107\u001a\u0002012\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020109H\u0082\bJ\u0018\u0010:\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010;\u001a\u00020/H\u0002J\u0018\u0010<\u001a\u00020=2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010>\u001a\u0002012\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0018\u0010?\u001a\u0002012\u0006\u0010@\u001a\u00020=2\u0006\u0010A\u001a\u00020,H\u0002J\u0018\u0010B\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\"\u0010B\u001a\u0002012\u0006\u0010C\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00102\b\u0010D\u001a\u0004\u0018\u00010\u0010H\u0016J \u0010B\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010E\u001a\u00020FH\u0002J\u0018\u0010G\u001a\u0002012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010G\u001a\u0002012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0018\u0010H\u001a\u0002012\u0006\u0010I\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020=H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/intellij/execution/ui/RunContentManagerImpl;", "Lcom/intellij/execution/ui/RunContentManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "syncPublisher", "Lcom/intellij/execution/ui/RunContentWithExecutorListener;", "getSyncPublisher", "()Lcom/intellij/execution/ui/RunContentWithExecutorListener;", "toolWindowIdToBaseIcon", "", "", "Ljavax/swing/Icon;", "toolWindowIdZBuffer", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "findContentDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "requestor", "Lcom/intellij/execution/Executor;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "getAllDescriptors", "", "getContentDescriptorToolWindowId", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getContentManagerByToolWindowId", "Lcom/intellij/ui/content/ContentManager;", "toolWindowId", "getContentManagerForRunner", "executor", "descriptor", "getDescriptorBy", "runnerInfo", "getOrCreateContentManagerForToolWindow", "id", "getReuseCondition", "Ljava/util/function/Predicate;", "Lcom/intellij/ui/content/Content;", "getReuseContent", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getSelectedContent", "getToolWindowByDescriptor", "Lcom/intellij/openapi/wm/ToolWindow;", "getToolWindowIdByEnvironment", "getToolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "hideRunContent", "", "init", "initToolWindow", "toolWindowIcon", "contentManager", "moveContent", "processToolWindowContentManagers", "processor", "Lkotlin/Function2;", "registerToolWindow", "toolWindowManager", "removeRunContent", "", "selectRunContent", "setToolWindowIcon", "alive", "toolWindow", "showRunContent", "info", "contentToReuse", "executionId", "", "toFrontRunContent", "updateToolWindowIcon", "contentManagerToUpdate", "CloseListener", "Companion", "intellij.platform.execution.impl"})
public final class RunContentManagerImpl
implements RunContentManager {
    private final Map<String, Icon> toolWindowIdToBaseIcon;
    private final ConcurrentLinkedDeque<String> toolWindowIdZBuffer;
    private final Project project;
    @JvmField
    @NotNull
    public static final Key<Boolean> ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<RunnerAndConfigurationSettings> TEMPORARY_CONFIGURATION_KEY;
    public static final Companion Companion;

    private final void init() {
        this.project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(this){
            final /* synthetic */ RunContentManagerImpl this$0;

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkParameterIsNotNull((Object)toolWindowManager, (String)"toolWindowManager");
                RunContentManagerImpl.access$getToolWindowIdZBuffer$p(this.this$0).retainAll(toolWindowManager.getToolWindowIdSet());
                String activeToolWindowId = toolWindowManager.getActiveToolWindowId();
                if (activeToolWindowId != null && RunContentManagerImpl.access$getToolWindowIdZBuffer$p(this.this$0).remove(activeToolWindowId)) {
                    RunContentManagerImpl.access$getToolWindowIdZBuffer$p(this.this$0).addFirst(activeToolWindowId);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final ContentManager registerToolWindow(Executor executor, ToolWindowManager toolWindowManager) {
        String string = executor.getToolWindowId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"executor.toolWindowId");
        String toolWindowId = string;
        ToolWindow toolWindow = toolWindowManager.getToolWindow(toolWindowId);
        if (toolWindow != null) {
            ContentManager contentManager2 = toolWindow.getContentManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)contentManager2, (String)"toolWindow.contentManager");
            return contentManager2;
        }
        toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(toolWindowId, null, null, false, false, false, false, null, executor.getToolWindowIcon(), null, 766, null));
        ContentManager contentManager3 = toolWindow.getContentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentManager3, (String)"toolWindow.contentManager");
        ContentManager contentManager4 = contentManager3;
        contentManager4.addDataProvider(new DataProvider(executor, contentManager4){
            private int insideGetData;
            final /* synthetic */ Executor $executor;
            final /* synthetic */ ContentManager $contentManager;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public Object getData(@NotNull String dataId) {
                Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
                int n = this.insideGetData;
                this.insideGetData = n + 1;
                try {
                    String string = PlatformDataKeys.HELP_ID.is(dataId) ? this.$executor.getHelpId() : (this.insideGetData == 1 ? DataManager.getInstance().getDataContext((Component)this.$contentManager.getComponent()).getData(dataId) : null);
                    return string;
                }
                finally {
                    int n2 = this.insideGetData;
                    this.insideGetData = n2 + -1;
                }
            }
            {
                this.$executor = $captured_local_variable$0;
                this.$contentManager = $captured_local_variable$1;
            }
        });
        ContentManagerWatcher.watchContentManager(toolWindow, contentManager4);
        Icon icon2 = executor.getToolWindowIcon();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"executor.toolWindowIcon");
        this.initToolWindow(executor, toolWindowId, icon2, contentManager4);
        return contentManager4;
    }

    private final void initToolWindow(Executor executor, String toolWindowId, Icon toolWindowIcon, ContentManager contentManager2) {
        this.toolWindowIdToBaseIcon.put(toolWindowId, toolWindowIcon);
        contentManager2.addContentManagerListener(new ContentManagerListener(this, executor){
            final /* synthetic */ RunContentManagerImpl this$0;
            final /* synthetic */ Executor $executor;

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                    return;
                }
                Content content2 = event.getContent();
                Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"event.content");
                Content content3 = content2;
                Executor executor = this.$executor;
                if (executor == null && (executor = RunContentManagerImpl.Companion.getExecutorByContent(content3)) == null) {
                    Intrinsics.throwNpe();
                }
                Executor contentExecutor = executor;
                RunContentManagerImpl.access$getSyncPublisher$p(this.this$0).contentSelected(RunContentManagerImpl.Companion.getRunContentDescriptorByContent(content3), contentExecutor);
                content3.setHelpId(contentExecutor.getHelpId());
            }
            {
                this.this$0 = $outer;
                this.$executor = $captured_local_variable$1;
            }
        });
        Disposer.register((Disposable)((Disposable)contentManager2), (Disposable)new Disposable(this, contentManager2, toolWindowId){
            final /* synthetic */ RunContentManagerImpl this$0;
            final /* synthetic */ ContentManager $contentManager;
            final /* synthetic */ String $toolWindowId;

            public final void dispose() {
                this.$contentManager.removeAllContents(true);
                RunContentManagerImpl.access$getToolWindowIdZBuffer$p(this.this$0).remove(this.$toolWindowId);
                RunContentManagerImpl.access$getToolWindowIdToBaseIcon$p(this.this$0).remove(this.$toolWindowId);
            }
            {
                this.this$0 = runContentManagerImpl;
                this.$contentManager = contentManager2;
                this.$toolWindowId = string;
            }
        });
        this.toolWindowIdZBuffer.addLast(toolWindowId);
    }

    private final RunContentWithExecutorListener getSyncPublisher() {
        Object object = this.project.getMessageBus().syncPublisher(RunContentManager.TOPIC);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.messageBus.syncP\u2026(RunContentManager.TOPIC)");
        return (RunContentWithExecutorListener)object;
    }

    public void toFrontRunContent(@NotNull Executor requestor, @NotNull ProcessHandler handler2) {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        RunContentDescriptor runContentDescriptor = this.getDescriptorBy(handler2, requestor);
        if (runContentDescriptor == null) {
            return;
        }
        RunContentDescriptor descriptor2 = runContentDescriptor;
        this.toFrontRunContent(requestor, descriptor2);
    }

    public void toFrontRunContent(@NotNull Executor requestor, @NotNull RunContentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        ApplicationManager.getApplication().invokeLater(new Runnable(this, requestor, descriptor2){
            final /* synthetic */ RunContentManagerImpl this$0;
            final /* synthetic */ Executor $requestor;
            final /* synthetic */ RunContentDescriptor $descriptor;

            public final void run() {
                ContentManager contentManager2 = RunContentManagerImpl.access$getContentManagerForRunner(this.this$0, this.$requestor, this.$descriptor);
                Content content2 = RunContentManagerImplKt.access$getRunContentByDescriptor(contentManager2, this.$descriptor);
                if (content2 != null) {
                    contentManager2.setSelectedContent(content2);
                    ToolWindow toolWindow = RunContentManagerImpl.access$getToolWindowManager(this.this$0).getToolWindow(RunContentManagerImplKt.access$getToolWindowIdForRunner(this.$requestor, this.$descriptor));
                    if (toolWindow == null) {
                        Intrinsics.throwNpe();
                    }
                    toolWindow.show(null);
                }
            }
            {
                this.this$0 = runContentManagerImpl;
                this.$requestor = executor;
                this.$descriptor = runContentDescriptor;
            }
        }, this.project.getDisposed());
    }

    public void hideRunContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        ApplicationManager.getApplication().invokeLater(new Runnable(this, executor, descriptor2){
            final /* synthetic */ RunContentManagerImpl this$0;
            final /* synthetic */ Executor $executor;
            final /* synthetic */ RunContentDescriptor $descriptor;

            public final void run() {
                block0: {
                    ToolWindow toolWindow;
                    ToolWindow toolWindow2 = toolWindow = RunContentManagerImpl.access$getToolWindowManager(this.this$0).getToolWindow(RunContentManagerImplKt.access$getToolWindowIdForRunner(this.$executor, this.$descriptor));
                    if (toolWindow2 == null) break block0;
                    toolWindow2.hide(null);
                }
            }
            {
                this.this$0 = runContentManagerImpl;
                this.$executor = executor;
                this.$descriptor = runContentDescriptor;
            }
        }, this.project.getDisposed());
    }

    @Nullable
    public RunContentDescriptor getSelectedContent() {
        Iterator<String> iterator2 = this.toolWindowIdZBuffer.iterator();
        while (iterator2.hasNext()) {
            ContentManager contentManager2;
            String activeWindow;
            String string = activeWindow = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"activeWindow");
            if (this.getContentManagerByToolWindowId(string) == null) {
                continue;
            }
            Content content2 = contentManager2.getSelectedContent();
            if (content2 == null) {
                if (contentManager2.getContentCount() != 0) break;
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"contentManager.selectedC\u2026                        }");
            Content selectedContent = content2;
            return Companion.getRunContentDescriptorByContent(selectedContent);
        }
        return null;
    }

    public boolean removeRunContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        ContentManager contentManager2 = this.getContentManagerForRunner(executor, descriptor2);
        Content content2 = RunContentManagerImplKt.access$getRunContentByDescriptor(contentManager2, descriptor2);
        return content2 != null && contentManager2.removeContent(content2, true);
    }

    public void showRunContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        this.showRunContent(executor, descriptor2, descriptor2.getExecutionId());
    }

    private final void showRunContent(Executor executor, RunContentDescriptor descriptor2, long executionId) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        ContentManager contentManager2 = this.getContentManagerForRunner(executor, descriptor2);
        String toolWindowId = RunContentManagerImplKt.access$getToolWindowIdForRunner(executor, descriptor2);
        RunContentDescriptor oldDescriptor = RunContentManagerImplKt.access$chooseReuseContentForDescriptor(contentManager2, descriptor2, executionId, descriptor2.getDisplayName(), this.getReuseCondition(toolWindowId));
        Content content2 = null;
        if (oldDescriptor == null) {
            content2 = RunContentManagerImplKt.access$createNewContent(descriptor2, executor);
        } else {
            Content content3 = oldDescriptor.getAttachedContent();
            if (content3 == null) {
                Intrinsics.throwNpe();
            }
            content2 = content3;
            this.getSyncPublisher().contentRemoved(oldDescriptor, executor);
            Disposer.dispose((Disposable)((Disposable)oldDescriptor));
        }
        content2.setExecutionId(executionId);
        content2.setComponent(descriptor2.getComponent());
        content2.setPreferredFocusedComponent(descriptor2.getPreferredFocusComputable());
        content2.putUserData(RunContentDescriptor.DESCRIPTOR_KEY, (Object)descriptor2);
        content2.putUserData(RunContentManagerImplKt.access$getEXECUTOR_KEY$p(), (Object)executor);
        content2.setDisplayName(descriptor2.getDisplayName());
        descriptor2.setAttachedContent(content2);
        ToolWindow toolWindow = this.getToolWindowManager().getToolWindow(toolWindowId);
        ProcessHandler processHandler2 = descriptor2.getProcessHandler();
        if (processHandler2 != null) {
            ProcessAdapter processAdapter2 = new ProcessAdapter(this, content2, descriptor2, toolWindow, toolWindowId, executor){
                final /* synthetic */ RunContentManagerImpl this$0;
                final /* synthetic */ Content $content;
                final /* synthetic */ RunContentDescriptor $descriptor;
                final /* synthetic */ ToolWindow $toolWindow;
                final /* synthetic */ String $toolWindowId;
                final /* synthetic */ Executor $executor;

                public void startNotified(@NotNull ProcessEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
                        final /* synthetic */ showRunContent.processAdapter.1 this$0;

                        public final void run() {
                            this.this$0.$content.setIcon(ExecutionUtil.getLiveIndicator((Icon)this.this$0.$descriptor.getIcon()));
                            ToolWindow toolWindow = this.this$0.$toolWindow;
                            if (toolWindow == null) {
                                Intrinsics.throwNpe();
                            }
                            toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)((Icon)RunContentManagerImpl.access$getToolWindowIdToBaseIcon$p(this.this$0.this$0).get(this.this$0.$toolWindowId))));
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    AppUIUtil.invokeLaterIfProjectAlive(RunContentManagerImpl.access$getProject$p(this.this$0), new Runnable(this){
                        final /* synthetic */ showRunContent.processAdapter.1 this$0;

                        public final void run() {
                            ContentManager contentManager2 = RunContentManagerImpl.access$getContentManagerByToolWindowId(this.this$0.this$0, this.this$0.$toolWindowId);
                            if (contentManager2 == null) {
                                return;
                            }
                            ContentManager manager = contentManager2;
                            boolean alive = RunContentManagerImplKt.access$isAlive(manager);
                            RunContentManagerImpl runContentManagerImpl = this.this$0.this$0;
                            ToolWindow toolWindow = this.this$0.$toolWindow;
                            if (toolWindow == null) {
                                Intrinsics.throwNpe();
                            }
                            RunContentManagerImpl.access$setToolWindowIcon(runContentManagerImpl, alive, toolWindow);
                            Icon icon2 = this.this$0.$descriptor.getIcon();
                            this.this$0.$content.setIcon(icon2 == null ? this.this$0.$executor.getDisabledIcon() : IconLoader.getTransparentIcon((Icon)icon2));
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = $outer;
                    this.$content = $captured_local_variable$1;
                    this.$descriptor = $captured_local_variable$2;
                    this.$toolWindow = $captured_local_variable$3;
                    this.$toolWindowId = $captured_local_variable$4;
                    this.$executor = $captured_local_variable$5;
                }
            };
            processHandler2.addProcessListener((ProcessListener)processAdapter2);
            Disposable disposer = content2.getDisposer();
            if (disposer != null) {
                Disposer.register((Disposable)disposer, (Disposable)new Disposable(processHandler2, processAdapter2){
                    final /* synthetic */ ProcessHandler $processHandler;
                    final /* synthetic */ showRunContent.processAdapter.1 $processAdapter;

                    public final void dispose() {
                        this.$processHandler.removeProcessListener((ProcessListener)this.$processAdapter);
                    }
                    {
                        this.$processHandler = processHandler2;
                        this.$processAdapter = var2_2;
                    }
                });
            }
        }
        if (oldDescriptor == null) {
            contentManager2.addContent(content2);
            content2.putUserData(RunContentManagerImplKt.access$getCLOSE_LISTENER_KEY$p(), (Object)new CloseListener(content2, executor));
        }
        if (descriptor2.isSelectContentWhenAdded() || oldDescriptor != null && contentManager2.isSelected(content2)) {
            ContentManager contentManager3 = content2.getManager();
            if (contentManager3 == null) {
                Intrinsics.throwNpe();
            }
            contentManager3.setSelectedContent(content2);
        }
        if (!descriptor2.isActivateToolWindowWhenAdded()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(this, toolWindowId, descriptor2){
            final /* synthetic */ RunContentManagerImpl this$0;
            final /* synthetic */ String $toolWindowId;
            final /* synthetic */ RunContentDescriptor $descriptor;

            public final void run() {
                ToolWindow toolWindow = RunContentManagerImpl.access$getToolWindowManager(this.this$0).getToolWindow(this.$toolWindowId);
                if (toolWindow == null) {
                    Intrinsics.throwNpe();
                }
                toolWindow.activate(this.$descriptor.getActivationCallback(), this.$descriptor.isAutoFocusContent(), this.$descriptor.isAutoFocusContent());
            }
            {
                this.this$0 = runContentManagerImpl;
                this.$toolWindowId = string;
                this.$descriptor = runContentDescriptor;
            }
        }, this.project.getDisposed());
    }

    private final ContentManager getContentManagerByToolWindowId(String toolWindowId) {
        Project $this$serviceIfCreated$iv = this.project;
        boolean $i$f$serviceIfCreated = false;
        RunDashboardManager runDashboardManager = (RunDashboardManager)$this$serviceIfCreated$iv.getServiceIfCreated(RunDashboardManager.class);
        if (runDashboardManager != null) {
            RunDashboardManager runDashboardManager2 = runDashboardManager;
            boolean bl = false;
            boolean bl2 = false;
            RunDashboardManager it = runDashboardManager2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it.getToolWindowId(), (Object)toolWindowId)) {
                Map<String, Icon> map2 = this.toolWindowIdToBaseIcon;
                String string = toolWindowId;
                boolean bl4 = false;
                Map<String, Icon> map3 = map2;
                boolean bl5 = false;
                return map3.containsKey(string) ? it.getDashboardContentManager() : null;
            }
        }
        ToolWindow toolWindow = this.getToolWindowManager().getToolWindow(toolWindowId);
        return toolWindow != null ? toolWindow.getContentManagerIfCreated() : null;
    }

    @Nullable
    public RunContentDescriptor getReuseContent(@NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkParameterIsNotNull((Object)executionEnvironment, (String)"executionEnvironment");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return null;
        }
        RunContentDescriptor contentToReuse = executionEnvironment.getContentToReuse();
        if (contentToReuse != null) {
            return contentToReuse;
        }
        String toolWindowId = this.getContentDescriptorToolWindowId(executionEnvironment);
        Predicate<Content> reuseCondition = null;
        ContentManager contentManager2 = null;
        if (toolWindowId == null) {
            Executor executor = executionEnvironment.getExecutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"executionEnvironment.executor");
            contentManager2 = this.getContentManagerForRunner(executor, null);
            reuseCondition = null;
        } else {
            Executor executor = executionEnvironment.getExecutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"executionEnvironment.executor");
            contentManager2 = this.getOrCreateContentManagerForToolWindow(toolWindowId, executor);
            reuseCondition = this.getReuseCondition(toolWindowId);
        }
        return RunContentManagerImplKt.access$chooseReuseContentForDescriptor(contentManager2, null, executionEnvironment.getExecutionId(), executionEnvironment.toString(), reuseCondition);
    }

    private final Predicate<Content> getReuseCondition(String toolWindowId) {
        RunDashboardManager runDashboardManager;
        RunDashboardManager runDashboardManager2 = runDashboardManager = RunDashboardManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)runDashboardManager2, (String)"runDashboardManager");
        return Intrinsics.areEqual((Object)runDashboardManager2.getToolWindowId(), (Object)toolWindowId) ? runDashboardManager.getReuseCondition() : null;
    }

    @Nullable
    public RunContentDescriptor findContentDescriptor(@NotNull Executor requestor, @NotNull ProcessHandler handler2) {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        return this.getDescriptorBy(handler2, requestor);
    }

    public void showRunContent(@NotNull Executor info, @NotNull RunContentDescriptor descriptor2, @Nullable RunContentDescriptor contentToReuse) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Companion.copyContentAndBehavior(descriptor2, contentToReuse);
        this.showRunContent(info, descriptor2, descriptor2.getExecutionId());
    }

    private final ContentManager getContentManagerForRunner(Executor executor, RunContentDescriptor descriptor2) {
        return this.getOrCreateContentManagerForToolWindow(RunContentManagerImplKt.access$getToolWindowIdForRunner(executor, descriptor2), executor);
    }

    private final ContentManager getOrCreateContentManagerForToolWindow(String id2, Executor executor) {
        RunDashboardManager dashboardManager;
        ContentManager contentManager2 = this.getContentManagerByToolWindowId(id2);
        if (contentManager2 != null) {
            return contentManager2;
        }
        RunDashboardManager runDashboardManager = dashboardManager = RunDashboardManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)runDashboardManager, (String)"dashboardManager");
        if (Intrinsics.areEqual((Object)runDashboardManager.getToolWindowId(), (Object)id2)) {
            String string = dashboardManager.getToolWindowId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dashboardManager.toolWindowId");
            Icon icon2 = dashboardManager.getToolWindowIcon();
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"dashboardManager.toolWindowIcon");
            ContentManager contentManager3 = dashboardManager.getDashboardContentManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)contentManager3, (String)"dashboardManager.dashboardContentManager");
            this.initToolWindow(null, string, icon2, contentManager3);
            ContentManager contentManager4 = dashboardManager.getDashboardContentManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)contentManager4, (String)"dashboardManager.dashboardContentManager");
            return contentManager4;
        }
        return this.registerToolWindow(executor, this.getToolWindowManager());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ToolWindow getToolWindowByDescriptor(@NotNull RunContentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        String string = descriptor2.getContentToolWindowId();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            return this.getToolWindowManager().getToolWindow(it);
        }
        RunContentManagerImpl this_$iv = this;
        boolean $i$f$processToolWindowContentManagers = false;
        ToolWindowManager toolWindowManager$iv = this_$iv.getToolWindowManager();
        ExtensionPointName extensionPointName = Executor.EXECUTOR_EXTENSION_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"Executor.EXECUTOR_EXTENSION_NAME");
        Iterator it = extensionPointName.getExtensionList().iterator();
        while (it.hasNext()) {
            ToolWindow toolWindow;
            void contentManager2;
            ToolWindow toolWindow$iv;
            Executor executor$iv;
            Executor executor = executor$iv = (Executor)it.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"executor");
            if (toolWindowManager$iv.getToolWindow(executor.getId()) == null) {
                continue;
            }
            if (toolWindow$iv.getContentManagerIfCreated() == null) {
                continue;
            }
            boolean bl = false;
            if (RunContentManagerImplKt.access$getRunContentByDescriptor((ContentManager)contentManager2, descriptor2) == null) continue;
            return toolWindow;
        }
        Project $this$serviceIfCreated$iv$iv = this_$iv.project;
        boolean $i$f$serviceIfCreated = false;
        RunDashboardManager runDashboardManager = (RunDashboardManager)$this$serviceIfCreated$iv$iv.getServiceIfCreated(RunDashboardManager.class);
        if (runDashboardManager != null) {
            RunDashboardManager runDashboardManager2 = runDashboardManager;
            boolean bl = false;
            boolean bl4 = false;
            RunDashboardManager it$iv = runDashboardManager2;
            boolean bl5 = false;
            String string3 = it$iv.getToolWindowId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.toolWindowId");
            String toolWindowId$iv = string3;
            Map map2 = this_$iv.toolWindowIdToBaseIcon;
            boolean bl6 = false;
            Map map3 = map2;
            boolean bl7 = false;
            if (map3.containsKey(toolWindowId$iv)) {
                ToolWindow toolWindow = toolWindowManager$iv.getToolWindow(toolWindowId$iv);
                if (toolWindow == null) {
                } else {
                    void contentManager3;
                    ContentManager contentManager4 = it$iv.getDashboardContentManager();
                    Intrinsics.checkExpressionValueIsNotNull((Object)contentManager4, (String)"it.dashboardContentManager");
                    ContentManager contentManager5 = contentManager4;
                    ToolWindow toolWindow2 = toolWindow;
                    boolean bl8 = false;
                    if (RunContentManagerImplKt.access$getRunContentByDescriptor((ContentManager)contentManager3, descriptor2) != null) {
                        return toolWindow2;
                    }
                }
            }
        }
        return null;
    }

    private final void processToolWindowContentManagers(Function2<? super ToolWindow, ? super ContentManager, Unit> processor2) {
        block5: {
            int $i$f$processToolWindowContentManagers = 0;
            ToolWindowManager toolWindowManager = this.getToolWindowManager();
            ExtensionPointName extensionPointName = Executor.EXECUTOR_EXTENSION_NAME;
            Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"Executor.EXECUTOR_EXTENSION_NAME");
            Iterator iterator2 = extensionPointName.getExtensionList().iterator();
            while (iterator2.hasNext()) {
                ToolWindow toolWindow;
                Executor executor;
                Executor executor2 = executor = (Executor)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)executor2, (String)"executor");
                if (toolWindowManager.getToolWindow(executor2.getId()) == null) {
                    continue;
                }
                ContentManager contentManager2 = toolWindow.getContentManagerIfCreated();
                if (contentManager2 == null) {
                    continue;
                }
                processor2.invoke((Object)toolWindow, (Object)contentManager2);
            }
            Project $this$serviceIfCreated$iv = this.project;
            boolean $i$f$serviceIfCreated = false;
            RunDashboardManager runDashboardManager = (RunDashboardManager)$this$serviceIfCreated$iv.getServiceIfCreated(RunDashboardManager.class);
            if (runDashboardManager == null) break block5;
            RunDashboardManager runDashboardManager2 = runDashboardManager;
            boolean bl = false;
            boolean bl2 = false;
            RunDashboardManager it = runDashboardManager2;
            boolean bl3 = false;
            String string = it.getToolWindowId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toolWindowId");
            String toolWindowId = string;
            Map map2 = this.toolWindowIdToBaseIcon;
            boolean bl4 = false;
            Map map3 = map2;
            boolean bl5 = false;
            if (map3.containsKey(toolWindowId)) {
                ToolWindow toolWindow = toolWindowManager.getToolWindow(toolWindowId);
                if (toolWindow == null) {
                    return;
                }
                ContentManager contentManager3 = it.getDashboardContentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)contentManager3, (String)"it.dashboardContentManager");
                processor2.invoke((Object)toolWindow, (Object)contentManager3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<RunContentDescriptor> getAllDescriptors() {
        List descriptors;
        block8: {
            Content[] contentArray;
            int n;
            int n2;
            descriptors = (List)new SmartList();
            RunContentManagerImpl this_$iv = this;
            boolean $i$f$processToolWindowContentManagers = false;
            ToolWindowManager toolWindowManager$iv = this_$iv.getToolWindowManager();
            ExtensionPointName extensionPointName = Executor.EXECUTOR_EXTENSION_NAME;
            Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"Executor.EXECUTOR_EXTENSION_NAME");
            Iterator iterator2 = extensionPointName.getExtensionList().iterator();
            while (iterator2.hasNext()) {
                void contentManager2;
                ToolWindow toolWindow$iv;
                Executor executor$iv;
                Executor executor = executor$iv = (Executor)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"executor");
                if (toolWindowManager$iv.getToolWindow(executor.getId()) == null) {
                    continue;
                }
                if (toolWindow$iv.getContentManagerIfCreated() == null) {
                    continue;
                }
                boolean bl = false;
                Content[] contentArray2 = contentManager2.getContents();
                int n3 = contentArray2.length;
                for (int j = 0; j < n3; ++j) {
                    Content content2;
                    Content content3 = content2 = contentArray2[j];
                    Intrinsics.checkExpressionValueIsNotNull((Object)content3, (String)"content");
                    if (Companion.getRunContentDescriptorByContent(content3) == null) continue;
                    n2 = 0;
                    n = 0;
                    Content[] it = contentArray;
                    boolean bl2 = false;
                    descriptors.add(it);
                }
            }
            Project $this$serviceIfCreated$iv$iv = this_$iv.project;
            boolean $i$f$serviceIfCreated = false;
            RunDashboardManager runDashboardManager = (RunDashboardManager)$this$serviceIfCreated$iv$iv.getServiceIfCreated(RunDashboardManager.class);
            if (runDashboardManager == null) break block8;
            RunDashboardManager runDashboardManager2 = runDashboardManager;
            boolean bl = false;
            boolean bl3 = false;
            RunDashboardManager it$iv = runDashboardManager2;
            boolean bl4 = false;
            String string = it$iv.getToolWindowId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toolWindowId");
            String toolWindowId$iv = string;
            Map map2 = this_$iv.toolWindowIdToBaseIcon;
            boolean bl5 = false;
            Map map3 = map2;
            boolean bl6 = false;
            if (map3.containsKey(toolWindowId$iv)) {
                ToolWindow toolWindow = toolWindowManager$iv.getToolWindow(toolWindowId$iv);
                if (toolWindow == null) {
                } else {
                    void contentManager3;
                    ContentManager contentManager4 = it$iv.getDashboardContentManager();
                    Intrinsics.checkExpressionValueIsNotNull((Object)contentManager4, (String)"it.dashboardContentManager");
                    ContentManager contentManager5 = contentManager4;
                    ToolWindow $noName_0 = toolWindow;
                    boolean bl7 = false;
                    contentArray = contentManager3.getContents();
                    n2 = contentArray.length;
                    for (n = 0; n < n2; ++n) {
                        RunContentDescriptor runContentDescriptor;
                        Content content4;
                        Content content5 = content4 = contentArray[n];
                        Intrinsics.checkExpressionValueIsNotNull((Object)content5, (String)"content");
                        if (Companion.getRunContentDescriptorByContent(content5) == null) continue;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        RunContentDescriptor it = runContentDescriptor;
                        boolean bl10 = false;
                        descriptors.add(it);
                    }
                }
            }
        }
        return descriptors;
    }

    /*
     * WARNING - void declaration
     */
    public void selectRunContent(@NotNull RunContentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        RunContentManagerImpl this_$iv = this;
        boolean $i$f$processToolWindowContentManagers = false;
        ToolWindowManager toolWindowManager$iv = this_$iv.getToolWindowManager();
        ExtensionPointName extensionPointName = Executor.EXECUTOR_EXTENSION_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"Executor.EXECUTOR_EXTENSION_NAME");
        Iterator iterator2 = extensionPointName.getExtensionList().iterator();
        while (iterator2.hasNext()) {
            void contentManager2;
            ToolWindow toolWindow$iv;
            Executor executor$iv;
            Executor executor = executor$iv = (Executor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"executor");
            if (toolWindowManager$iv.getToolWindow(executor.getId()) == null) {
                continue;
            }
            if (toolWindow$iv.getContentManagerIfCreated() == null) {
                continue;
            }
            boolean bl = false;
            Content content2 = RunContentManagerImplKt.access$getRunContentByDescriptor((ContentManager)contentManager2, descriptor2);
            if (content2 == null) {
                continue;
            }
            Content content3 = content2;
            contentManager2.setSelectedContent(content3);
            return;
        }
        Project $this$serviceIfCreated$iv$iv = this_$iv.project;
        boolean $i$f$serviceIfCreated = false;
        RunDashboardManager runDashboardManager = (RunDashboardManager)$this$serviceIfCreated$iv$iv.getServiceIfCreated(RunDashboardManager.class);
        if (runDashboardManager != null) {
            RunDashboardManager runDashboardManager2 = runDashboardManager;
            boolean bl = false;
            boolean bl2 = false;
            RunDashboardManager it$iv = runDashboardManager2;
            boolean bl3 = false;
            String string = it$iv.getToolWindowId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toolWindowId");
            String toolWindowId$iv = string;
            Map map2 = this_$iv.toolWindowIdToBaseIcon;
            boolean bl4 = false;
            Map map3 = map2;
            boolean bl5 = false;
            if (map3.containsKey(toolWindowId$iv)) {
                ToolWindow toolWindow = toolWindowManager$iv.getToolWindow(toolWindowId$iv);
                if (toolWindow == null) {
                } else {
                    void contentManager3;
                    ContentManager contentManager4 = it$iv.getDashboardContentManager();
                    Intrinsics.checkExpressionValueIsNotNull((Object)contentManager4, (String)"it.dashboardContentManager");
                    ContentManager contentManager5 = contentManager4;
                    ToolWindow $noName_0 = toolWindow;
                    boolean bl6 = false;
                    Content content4 = RunContentManagerImplKt.access$getRunContentByDescriptor((ContentManager)contentManager3, descriptor2);
                    if (content4 == null) {
                    } else {
                        Content content5 = content4;
                        contentManager3.setSelectedContent(content5);
                        return;
                    }
                }
            }
        }
    }

    private final ToolWindowManager getToolWindowManager() {
        return ToolWindowManager.Companion.getInstance(this.project);
    }

    @Nullable
    public String getContentDescriptorToolWindowId(@Nullable RunConfiguration configuration) {
        RunDashboardManager runDashboardManager;
        if (configuration != null && (runDashboardManager = RunDashboardManager.getInstance((Project)this.project)).isShowInDashboard(configuration)) {
            RunDashboardManager runDashboardManager2 = runDashboardManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)runDashboardManager2, (String)"runDashboardManager");
            return runDashboardManager2.getToolWindowId();
        }
        return null;
    }

    @NotNull
    public String getToolWindowIdByEnvironment(@NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkParameterIsNotNull((Object)executionEnvironment, (String)"executionEnvironment");
        String toolWindowId = this.getContentDescriptorToolWindowId(executionEnvironment);
        String string = toolWindowId;
        if (string == null) {
            Executor executor = executionEnvironment.getExecutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"executionEnvironment.executor");
            String string2 = executor.getToolWindowId();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"executionEnvironment.executor.toolWindowId");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final RunContentDescriptor getDescriptorBy(ProcessHandler handler2, Executor runnerInfo) {
        void $this$serviceIfCreated$iv;
        Function1<Content[], RunContentDescriptor> $fun$find$1 = new Function1<Content[], RunContentDescriptor>(handler2){
            final /* synthetic */ ProcessHandler $handler;

            @Nullable
            public final RunContentDescriptor invoke(@NotNull Content[] contents) {
                Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
                for (Content content2 : contents) {
                    RunContentDescriptor runContentDescriptor;
                    RunContentDescriptor runContentDescriptor2 = runContentDescriptor = RunContentManagerImpl.Companion.getRunContentDescriptorByContent(content2);
                    if ((runContentDescriptor2 != null ? runContentDescriptor2.getProcessHandler() : null) != this.$handler) continue;
                    return runContentDescriptor;
                }
                return null;
            }
            {
                this.$handler = processHandler2;
                super(1);
            }
        };
        Content[] contentArray = this.getContentManagerForRunner(runnerInfo, null).getContents();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentArray, (String)"getContentManagerForRunn\u2026unnerInfo, null).contents");
        RunContentDescriptor runContentDescriptor = $fun$find$1.invoke(contentArray);
        if (runContentDescriptor != null) {
            RunContentDescriptor runContentDescriptor2 = runContentDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            RunContentDescriptor it = runContentDescriptor2;
            boolean bl3 = false;
            return it;
        }
        Project project = this.project;
        RunContentManagerImpl runContentManagerImpl = this;
        Function1<Content[], RunContentDescriptor> function1 = $fun$find$1;
        boolean $i$f$serviceIfCreated = false;
        Object object = $this$serviceIfCreated$iv.getServiceIfCreated(RunDashboardManager.class);
        Object object2 = (RunDashboardManager)object;
        if (object2 == null || (object2 = object2.getToolWindowId()) == null) {
            return null;
        }
        Content[] contentArray2 = runContentManagerImpl.getContentManagerByToolWindowId((String)object2);
        if (contentArray2 == null || (contentArray2 = contentArray2.getContents()) == null) {
            return null;
        }
        RunContentDescriptor runContentDescriptor3 = function1.invoke(contentArray2);
        if (runContentDescriptor3 != null) {
            project = runContentDescriptor3;
            boolean bl = false;
            boolean bl4 = false;
            Project it = project;
            boolean bl5 = false;
            return it;
        }
        return null;
    }

    public final void moveContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Content content2 = descriptor2.getAttachedContent();
        if (content2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"descriptor.attachedContent ?: return");
        Content content3 = content2;
        ContentManager oldContentManager = content3.getManager();
        ContentManager newContentManager = this.getContentManagerForRunner(executor, descriptor2);
        if (oldContentManager == null || oldContentManager == newContentManager) {
            return;
        }
        ContentManagerListener listener2 = (ContentManagerListener)content3.getUserData(RunContentManagerImplKt.access$getCLOSE_LISTENER_KEY$p());
        if (listener2 != null) {
            oldContentManager.removeContentManagerListener(listener2);
        }
        oldContentManager.removeContent(content3, false);
        if (RunContentManagerImplKt.access$isAlive(descriptor2)) {
            if (!RunContentManagerImplKt.access$isAlive(oldContentManager)) {
                this.updateToolWindowIcon(oldContentManager, false);
            }
            if (!RunContentManagerImplKt.access$isAlive(newContentManager)) {
                this.updateToolWindowIcon(newContentManager, true);
            }
        }
        newContentManager.addContent(content3);
        if (listener2 != null) {
            newContentManager.addContentManagerListener(listener2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateToolWindowIcon(ContentManager contentManagerToUpdate, boolean alive) {
        RunContentManagerImpl this_$iv = this;
        boolean $i$f$processToolWindowContentManagers = false;
        ToolWindowManager toolWindowManager$iv = this_$iv.getToolWindowManager();
        ExtensionPointName extensionPointName = Executor.EXECUTOR_EXTENSION_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"Executor.EXECUTOR_EXTENSION_NAME");
        Iterator iterator2 = extensionPointName.getExtensionList().iterator();
        while (iterator2.hasNext()) {
            ToolWindow toolWindow;
            void contentManager2;
            ToolWindow toolWindow$iv;
            Executor executor$iv;
            Executor executor = executor$iv = (Executor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"executor");
            if (toolWindowManager$iv.getToolWindow(executor.getId()) == null) {
                continue;
            }
            if (toolWindow$iv.getContentManagerIfCreated() == null) {
                continue;
            }
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)contentManagerToUpdate, (Object)contentManager2)) continue;
            this.setToolWindowIcon(alive, toolWindow);
            return;
        }
        Project $this$serviceIfCreated$iv$iv = this_$iv.project;
        boolean $i$f$serviceIfCreated = false;
        RunDashboardManager runDashboardManager = (RunDashboardManager)$this$serviceIfCreated$iv$iv.getServiceIfCreated(RunDashboardManager.class);
        if (runDashboardManager != null) {
            RunDashboardManager runDashboardManager2 = runDashboardManager;
            boolean bl = false;
            boolean bl2 = false;
            RunDashboardManager it$iv = runDashboardManager2;
            boolean bl3 = false;
            String string = it$iv.getToolWindowId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toolWindowId");
            String toolWindowId$iv = string;
            Map map2 = this_$iv.toolWindowIdToBaseIcon;
            boolean bl4 = false;
            Map map3 = map2;
            boolean bl5 = false;
            if (map3.containsKey(toolWindowId$iv)) {
                ToolWindow toolWindow = toolWindowManager$iv.getToolWindow(toolWindowId$iv);
                if (toolWindow == null) {
                } else {
                    void contentManager3;
                    ContentManager contentManager4 = it$iv.getDashboardContentManager();
                    Intrinsics.checkExpressionValueIsNotNull((Object)contentManager4, (String)"it.dashboardContentManager");
                    ContentManager contentManager5 = contentManager4;
                    ToolWindow toolWindow2 = toolWindow;
                    boolean bl6 = false;
                    if (Intrinsics.areEqual((Object)contentManagerToUpdate, (Object)contentManager3)) {
                        this.setToolWindowIcon(alive, toolWindow2);
                        return;
                    }
                }
            }
        }
    }

    private final void setToolWindowIcon(boolean alive, ToolWindow toolWindow) {
        Icon base = this.toolWindowIdToBaseIcon.get(toolWindow.getId());
        toolWindow.setIcon(alive ? ExecutionUtil.getLiveIndicator((Icon)base) : (Icon)ObjectUtils.notNull((Object)base, (Object)EmptyIcon.ICON_13));
    }

    public RunContentManagerImpl(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.toolWindowIdToBaseIcon = new HashMap();
        this.toolWindowIdZBuffer = new ConcurrentLinkedDeque();
        DockableGridContainerFactory containerFactory = new DockableGridContainerFactory();
        DockManager.getInstance((Project)this.project).register("runner-grid", (DockContainerFactory)containerFactory, (Disposable)this.project);
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.project)).submit(new Runnable(){

            @Override
            public final void run() {
                this.init();
            }
        });
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Boolean>(\"ALW\u2026_STOPPING_BEHAVIOUR_KEY\")");
        ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY = key;
        Key key2 = Key.create((String)"TemporaryConfiguration");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<RunnerAndConf\u2026\"TemporaryConfiguration\")");
        TEMPORARY_CONFIGURATION_KEY = key2;
    }

    public static final /* synthetic */ ConcurrentLinkedDeque access$getToolWindowIdZBuffer$p(RunContentManagerImpl $this) {
        return $this.toolWindowIdZBuffer;
    }

    public static final /* synthetic */ ContentManager access$getContentManagerForRunner(RunContentManagerImpl $this, Executor executor, RunContentDescriptor descriptor2) {
        return $this.getContentManagerForRunner(executor, descriptor2);
    }

    public static final /* synthetic */ ContentManager access$getContentManagerByToolWindowId(RunContentManagerImpl $this, String toolWindowId) {
        return $this.getContentManagerByToolWindowId(toolWindowId);
    }

    public static final /* synthetic */ void access$setToolWindowIcon(RunContentManagerImpl $this, boolean alive, ToolWindow toolWindow) {
        $this.setToolWindowIcon(alive, toolWindow);
    }

    @JvmStatic
    public static final void copyContentAndBehavior(@NotNull RunContentDescriptor descriptor2, @Nullable RunContentDescriptor contentToReuse) {
        Companion.copyContentAndBehavior(descriptor2, contentToReuse);
    }

    @JvmStatic
    public static final boolean isTerminated(@NotNull Content content2) {
        return Companion.isTerminated(content2);
    }

    @JvmStatic
    @Nullable
    public static final RunContentDescriptor getRunContentDescriptorByContent(@NotNull Content content2) {
        return Companion.getRunContentDescriptorByContent(content2);
    }

    @JvmStatic
    @Nullable
    public static final Executor getExecutorByContent(@NotNull Content content2) {
        return Companion.getExecutorByContent(content2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\bH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/ui/RunContentManagerImpl$CloseListener;", "Lcom/intellij/execution/ui/BaseContentCloseListener;", "content", "Lcom/intellij/ui/content/Content;", "myExecutor", "Lcom/intellij/execution/Executor;", "(Lcom/intellij/execution/ui/RunContentManagerImpl;Lcom/intellij/ui/content/Content;Lcom/intellij/execution/Executor;)V", "closeQuery", "", "projectClosing", "disposeContent", "", "intellij.platform.execution.impl"})
    private final class CloseListener
    extends BaseContentCloseListener {
        private final Executor myExecutor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void disposeContent(@NotNull Content content2) {
            Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
            try {
                RunContentDescriptor descriptor2 = Companion.getRunContentDescriptorByContent(content2);
                RunContentManagerImpl.this.getSyncPublisher().contentRemoved(descriptor2, this.myExecutor);
                if (descriptor2 != null) {
                    Disposer.dispose((Disposable)((Disposable)descriptor2));
                }
            }
            finally {
                content2.release();
            }
        }

        @Override
        protected boolean closeQuery(@NotNull Content content2, boolean projectClosing2) {
            Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
            RunContentDescriptor runContentDescriptor = Companion.getRunContentDescriptorByContent(content2);
            if (runContentDescriptor == null) {
                return true;
            }
            RunContentDescriptor descriptor2 = runContentDescriptor;
            ProcessHandler processHandler2 = descriptor2.getProcessHandler();
            if (processHandler2 == null || processHandler2.isProcessTerminated()) {
                return true;
            }
            String sessionName = descriptor2.getDisplayName();
            boolean killable = processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess();
            BaseContentCloseListener.WaitForProcessTask task2 = new BaseContentCloseListener.WaitForProcessTask(this, killable, processHandler2, sessionName, projectClosing2, processHandler2, sessionName, projectClosing2, RunContentManagerImpl.this.project){
                final /* synthetic */ CloseListener this$0;
                final /* synthetic */ boolean $killable;
                final /* synthetic */ ProcessHandler $processHandler;
                final /* synthetic */ String $sessionName;
                final /* synthetic */ boolean $projectClosing;

                public void onCancel() {
                    if (this.$killable && !this.$processHandler.isProcessTerminated()) {
                        ProcessHandler processHandler2 = this.$processHandler;
                        if (processHandler2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.KillableProcess");
                        }
                        ((KillableProcess)processHandler2).killProcess();
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$killable = $captured_local_variable$1;
                    this.$processHandler = $captured_local_variable$2;
                    this.$sessionName = $captured_local_variable$3;
                    this.$projectClosing = $captured_local_variable$4;
                    super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
                }
            };
            if (killable) {
                String string = ExecutionBundle.message((String)"terminating.process.progress.kill", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ExecutionBundle.message(\u2026g.process.progress.kill\")");
                String cancelText = string;
                task2.setCancelText(cancelText);
                task2.setCancelTooltipText(cancelText);
            }
            return this.askUserAndWait(processHandler2, sessionName, task2);
        }

        public CloseListener(@NotNull Content content2, Executor myExecutor) {
            Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)myExecutor, (String)"myExecutor");
            super(content2, RunContentManagerImpl.this.project);
            this.myExecutor = myExecutor;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R#\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t0\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/ui/RunContentManagerImpl$Companion;", "", "()V", "ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "TEMPORARY_CONFIGURATION_KEY", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "copyContentAndBehavior", "", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "contentToReuse", "getExecutorByContent", "Lcom/intellij/execution/Executor;", "content", "Lcom/intellij/ui/content/Content;", "getRunContentDescriptorByContent", "isTerminated", "intellij.platform.execution.impl"})
    public static final class Companion {
        @JvmStatic
        public final void copyContentAndBehavior(@NotNull RunContentDescriptor descriptor2, @Nullable RunContentDescriptor contentToReuse) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (contentToReuse != null) {
                Content attachedContent = contentToReuse.getAttachedContent();
                if (attachedContent != null && attachedContent.isValid()) {
                    descriptor2.setAttachedContent(attachedContent);
                }
                if (contentToReuse.isReuseToolWindowActivation()) {
                    descriptor2.setActivateToolWindowWhenAdded(contentToReuse.isActivateToolWindowWhenAdded());
                }
                descriptor2.setContentToolWindowId(contentToReuse.getContentToolWindowId());
                descriptor2.setSelectContentWhenAdded(contentToReuse.isSelectContentWhenAdded());
            }
        }

        @JvmStatic
        public final boolean isTerminated(@NotNull Content content2) {
            Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
            RunContentDescriptor runContentDescriptor = this.getRunContentDescriptorByContent(content2);
            if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                return true;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)runContentDescriptor, (String)"getRunContentDescriptorB\u2026essHandler ?: return true");
            RunContentDescriptor processHandler2 = runContentDescriptor;
            return processHandler2.isProcessTerminated();
        }

        @JvmStatic
        @Nullable
        public final RunContentDescriptor getRunContentDescriptorByContent(@NotNull Content content2) {
            Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
            return (RunContentDescriptor)content2.getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
        }

        @JvmStatic
        @Nullable
        public final Executor getExecutorByContent(@NotNull Content content2) {
            Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
            return (Executor)content2.getUserData(RunContentManagerImplKt.access$getEXECUTOR_KEY$p());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

