/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.replaceInProject;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.FindInPathAction;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.AdapterProcessor;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceInProjectManager {
    private static final NotificationGroup NOTIFICATION_GROUP = FindInPathAction.NOTIFICATION_GROUP;
    private final Project myProject;
    private boolean myIsFindInProgress;

    public static ReplaceInProjectManager getInstance(Project project) {
        return (ReplaceInProjectManager)ServiceManager.getService((Project)project, ReplaceInProjectManager.class);
    }

    public ReplaceInProjectManager(Project project) {
        this.myProject = project;
    }

    private static boolean hasReadOnlyUsages(Collection<? extends Usage> usages) {
        for (Usage usage : usages) {
            if (!usage.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public void replaceInProject(@NotNull DataContext dataContext, @Nullable FindModel model) {
        FindModel findModel;
        boolean isOpenInNewTabEnabled;
        boolean toOpenInNewTab;
        if (dataContext == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(0);
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        Content selectedContent = UsageViewContentManager.getInstance((Project)this.myProject).getSelectedContent(true);
        if (selectedContent != null && selectedContent.isPinned()) {
            toOpenInNewTab = true;
            isOpenInNewTabEnabled = false;
        } else {
            toOpenInNewTab = FindSettings.getInstance().isShowResultsInSeparateView();
            boolean bl = isOpenInNewTabEnabled = UsageViewContentManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        }
        if (model == null) {
            findModel = findManager.getFindInProjectModel().clone();
            findModel.setReplaceState(true);
            findModel.setOpenInNewTabEnabled(isOpenInNewTabEnabled);
            findModel.setOpenInNewTab(toOpenInNewTab);
            FindInProjectUtil.setDirectoryName(findModel, dataContext);
            FindInProjectUtil.initStringToFindFromDataContext(findModel, dataContext);
        } else {
            findModel = model;
            findModel.setOpenInNewTabEnabled(isOpenInNewTabEnabled);
        }
        findManager.showFindDialog(findModel, () -> {
            if (findModel.isReplaceState()) {
                this.replaceInPath(findModel);
            } else {
                FindInProjectManager.getInstance(this.myProject).findInPath(findModel);
            }
        });
    }

    public void replaceInPath(@NotNull FindModel findModel) {
        if (findModel == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(1);
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        if (!findModel.isProjectScope() && FindInProjectUtil.getDirectory(findModel) == null && findModel.getModuleName() == null && findModel.getCustomScope() == null) {
            return;
        }
        UsageViewManager manager = UsageViewManager.getInstance((Project)this.myProject);
        if (manager == null) {
            return;
        }
        findManager.getFindInProjectModel().copyFrom(findModel);
        FindModel findModelCopy = findModel.clone();
        UsageViewPresentation presentation2 = FindInProjectUtil.setupViewPresentation(findModelCopy);
        FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, true, presentation2);
        processPresentation.setShowFindOptionsPrompt(findModel.isPromptOnReplace());
        UsageSearcherFactory factory2 = new UsageSearcherFactory(findModelCopy, processPresentation);
        this.searchAndShowUsages(manager, factory2, findModelCopy, presentation2, processPresentation);
    }

    public void searchAndShowUsages(final @NotNull UsageViewManager manager, final @NotNull Factory<UsageSearcher> usageSearcherFactory, final @NotNull FindModel findModelCopy, final @NotNull UsageViewPresentation presentation2, final @NotNull FindUsagesProcessPresentation processPresentation) {
        if (manager == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(2);
        }
        if (usageSearcherFactory == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(3);
        }
        if (findModelCopy == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(4);
        }
        if (presentation2 == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(5);
        }
        if (processPresentation == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(6);
        }
        presentation2.setMergeDupLinesAvailable(false);
        ReplaceInProjectTarget target2 = new ReplaceInProjectTarget(this.myProject, findModelCopy);
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager().addToHistory(target2);
        final ReplaceContext[] context = new ReplaceContext[1];
        manager.searchAndShowUsages(new UsageTarget[]{target2}, usageSearcherFactory, processPresentation, presentation2, new UsageViewManager.UsageViewStateListener(){

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    1.$$$reportNull$$$0(0);
                }
                context[0] = new ReplaceContext(usageView, findModelCopy);
                ReplaceInProjectManager.this.addReplaceActions(context[0]);
                usageView.setRerunAction((Action)new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UsageViewPresentation rerunPresentation = presentation2.copy();
                        rerunPresentation.setOpenInNewTab(false);
                        ReplaceInProjectManager.this.searchAndShowUsages(manager, (Factory<UsageSearcher>)usageSearcherFactory, findModelCopy, rerunPresentation, processPresentation);
                    }
                });
            }

            public void findingUsagesFinished(UsageView usageView) {
                if (context[0] != null && !processPresentation.isShowFindOptionsPrompt()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ReplaceInProjectManager.this.replaceUsagesUnderCommand(context[0], usageView.getUsages());
                        context[0].invalidateExcludedSetCache();
                    }, ReplaceInProjectManager.this.myProject.getDisposed());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/replaceInProject/ReplaceInProjectManager$1", "usageViewCreated"));
            }
        });
    }

    public boolean showReplaceAllConfirmDialog(@NotNull String usagesCount, @NotNull String stringToFind, @NotNull String filesCount, @NotNull String stringToReplace) {
        if (usagesCount == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(7);
        }
        if (stringToFind == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(8);
        }
        if (filesCount == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(9);
        }
        if (stringToReplace == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(10);
        }
        String message = stringToFind.length() < 400 && stringToReplace.length() < 400 ? FindBundle.message("find.replace.all.confirmation", usagesCount, StringUtil.escapeXmlEntities((String)stringToFind), filesCount, StringUtil.escapeXmlEntities((String)stringToReplace)) : FindBundle.message("find.replace.all.confirmation.long.text", usagesCount, StringUtil.trimMiddle((String)StringUtil.escapeXmlEntities((String)stringToFind), (int)400), filesCount, StringUtil.trimMiddle((String)StringUtil.escapeXmlEntities((String)stringToReplace), (int)400));
        return 0 == ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)FindBundle.message("find.replace.all.confirmation.title", new Object[0]), (String)message).yesText(FindBundle.message("find.replace.command", new Object[0]))).project(this.myProject)).noText(Messages.getCancelButton())).show();
    }

    private static Set<VirtualFile> getFiles(@NotNull ReplaceContext replaceContext, boolean selectedOnly) {
        Set usages;
        if (replaceContext == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(11);
        }
        Set set = usages = selectedOnly ? replaceContext.getUsageView().getSelectedUsages() : replaceContext.getUsageView().getUsages();
        if (usages.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        for (Usage usage : usages) {
            if (!(usage instanceof UsageInfo2UsageAdapter)) continue;
            files2.add(((UsageInfo2UsageAdapter)usage).getFile());
        }
        return files2;
    }

    private static Set<Usage> getAllUsagesForFile(@NotNull ReplaceContext replaceContext, @NotNull VirtualFile file2) {
        if (replaceContext == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(13);
        }
        Set usages = replaceContext.getUsageView().getUsages();
        LinkedHashSet<Usage> result2 = new LinkedHashSet<Usage>();
        for (Usage usage : usages) {
            if (!(usage instanceof UsageInfo2UsageAdapter) || !Comparing.equal((Object)((UsageInfo2UsageAdapter)usage).getFile(), (Object)file2)) continue;
            result2.add(usage);
        }
        return result2;
    }

    private void addReplaceActions(final ReplaceContext replaceContext) {
        AbstractAction replaceAllAction = new AbstractAction(FindBundle.message("find.replace.all.action", new Object[0])){
            {
                super(arg0);
                KeyStroke altShiftEnter = KeyStroke.getKeyStroke(10, 576);
                this.putValue("AcceleratorKey", altShiftEnter);
                this.putValue("ShortDescription", KeymapUtil.getKeystrokeText((KeyStroke)altShiftEnter));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Set usages = replaceContext.getUsageView().getUsages();
                if (usages.isEmpty()) {
                    return;
                }
                Set files2 = ReplaceInProjectManager.getFiles(replaceContext, false);
                if (files2.size() < 2 || ReplaceInProjectManager.this.showReplaceAllConfirmDialog(String.valueOf(usages.size()), replaceContext.getFindModel().getStringToFind(), String.valueOf(files2.size()), replaceContext.getFindModel().getStringToReplace())) {
                    ReplaceInProjectManager.this.replaceUsagesUnderCommand(replaceContext, usages);
                }
            }

            @Override
            public boolean isEnabled() {
                return !replaceContext.getUsageView().getUsages().isEmpty();
            }
        };
        replaceContext.getUsageView().addButtonToLowerPane((Action)replaceAllAction);
        AbstractAction replaceSelectedAction = new AbstractAction(){
            {
                KeyStroke altEnter = KeyStroke.getKeyStroke(10, 512);
                this.putValue("AcceleratorKey", altEnter);
                this.putValue("LongDescription", KeymapUtil.getKeystrokeText((KeyStroke)altEnter));
                this.putValue("ShortDescription", KeymapUtil.getKeystrokeText((KeyStroke)altEnter));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceInProjectManager.this.replaceUsagesUnderCommand(replaceContext, replaceContext.getUsageView().getSelectedUsages());
            }

            @Override
            public Object getValue(String key) {
                return "Name".equals(key) ? FindBundle.message("find.replace.selected.action", replaceContext.getUsageView().getSelectedUsages().size()) : super.getValue(key);
            }

            @Override
            public boolean isEnabled() {
                return !replaceContext.getUsageView().getSelectedUsages().isEmpty();
            }
        };
        replaceContext.getUsageView().addButtonToLowerPane((Action)replaceSelectedAction);
        AbstractAction replaceAllInThisFileAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 576));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Set files2 = ReplaceInProjectManager.getFiles(replaceContext, true);
                if (files2.size() == 1) {
                    ReplaceInProjectManager.this.replaceUsagesUnderCommand(replaceContext, ReplaceInProjectManager.getAllUsagesForFile(replaceContext, (VirtualFile)files2.iterator().next()));
                }
            }

            @Override
            public Object getValue(String key) {
                return "Name".equals(key) ? FindBundle.message("find.replace.this.file.action", replaceContext.getUsageView().getSelectedUsages().size()) : super.getValue(key);
            }

            @Override
            public boolean isEnabled() {
                return ReplaceInProjectManager.getFiles(replaceContext, true).size() == 1;
            }
        };
        AbstractAction skipThisFileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set files2 = ReplaceInProjectManager.getFiles(replaceContext, true);
                if (files2.size() != 1) {
                    return;
                }
                VirtualFile selectedFile = (VirtualFile)files2.iterator().next();
                Set toSkip = ReplaceInProjectManager.getAllUsagesForFile(replaceContext, selectedFile);
                Usage usageToSelect = ((UsageViewImpl)replaceContext.getUsageView()).getNextToSelect((Collection)toSkip);
                replaceContext.getUsageView().excludeUsages(toSkip.toArray(Usage.EMPTY_ARRAY));
                if (usageToSelect != null) {
                    replaceContext.getUsageView().selectUsages(new Usage[]{usageToSelect});
                } else {
                    replaceContext.getUsageView().selectUsages(Usage.EMPTY_ARRAY);
                }
            }

            @Override
            public Object getValue(String key) {
                return "Name".equals(key) ? FindBundle.message("find.replace.skip.this.file.action", replaceContext.getUsageView().getSelectedUsages().size()) : super.getValue(key);
            }

            @Override
            public boolean isEnabled() {
                Set files2 = ReplaceInProjectManager.getFiles(replaceContext, true);
                if (files2.size() != 1) {
                    return false;
                }
                VirtualFile selectedFile = (VirtualFile)files2.iterator().next();
                Set toSkip = ReplaceInProjectManager.getAllUsagesForFile(replaceContext, selectedFile);
                return ((UsageViewImpl)replaceContext.getUsageView()).getNextToSelect((Collection)toSkip) != null;
            }
        };
    }

    private boolean replaceUsages(@NotNull ReplaceContext replaceContext, @NotNull Collection<Usage> usages) {
        if (replaceContext == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(14);
        }
        if (usages == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(15);
        }
        if (!this.ensureUsagesWritable(replaceContext, usages)) {
            return true;
        }
        int[] replacedCount = new int[]{0};
        boolean[] success = new boolean[]{true};
        success[0] = success[0] & ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(FindBundle.message("find.replace.all.confirmation.title", new Object[0]), this.myProject, null, (Consumer<? super ProgressIndicator>)((Consumer)indicator -> {
            indicator.setIndeterminate(false);
            int processed2 = 0;
            VirtualFile lastFile = null;
            for (Usage usage : usages) {
                VirtualFile virtualFile;
                indicator.checkCanceled();
                indicator.setFraction((double)((float)(++processed2) / (float)usages.size()));
                if (usage instanceof UsageInFile && (virtualFile = ((UsageInFile)usage).getFile()) != null && !virtualFile.equals(lastFile)) {
                    indicator.setText2(virtualFile.getPresentableUrl());
                    lastFile = virtualFile;
                }
                ProgressManager.getInstance().executeNonCancelableSection(() -> {
                    try {
                        if (this.replaceUsage(usage, replaceContext.getFindModel(), replaceContext.getExcludedSetCached(), false)) {
                            replacedCount[0] = replacedCount[0] + 1;
                        }
                    }
                    catch (FindManager.MalformedReplacementStringException ex) {
                        ReplaceInProjectManager.markAsMalformedReplacement(replaceContext, usage);
                        success[0] = false;
                    }
                });
            }
        }));
        replaceContext.getUsageView().removeUsagesBulk(usages);
        ReplaceInProjectManager.reportNumberReplacedOccurrences(this.myProject, replacedCount[0]);
        return success[0];
    }

    private static void markAsMalformedReplacement(ReplaceContext replaceContext, Usage usage) {
        replaceContext.getUsageView().excludeUsages(new Usage[]{usage});
    }

    public static void reportNumberReplacedOccurrences(Project project, int occurrences) {
        StatusBar statusBar;
        if (occurrences != 0 && (statusBar = WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar.setInfo(FindBundle.message("0.occurrences.replaced", occurrences));
        }
    }

    public boolean replaceUsage(@NotNull Usage usage, @NotNull FindModel findModel, @NotNull Set<Usage> excludedSet, boolean justCheck) throws FindManager.MalformedReplacementStringException {
        if (usage == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(16);
        }
        if (findModel == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(17);
        }
        if (excludedSet == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(18);
        }
        Ref exceptionResult = Ref.create();
        boolean result2 = (Boolean)WriteAction.compute(() -> {
            if (excludedSet.contains(usage)) {
                return false;
            }
            Document document = ((UsageInfo2UsageAdapter)usage).getDocument();
            if (!document.isWritable()) {
                return false;
            }
            return ((UsageInfo2UsageAdapter)usage).processRangeMarkers(segment -> {
                int textOffset = segment.getStartOffset();
                int textEndOffset = segment.getEndOffset();
                Ref stringToReplace = Ref.create();
                try {
                    if (!this.getStringToReplace(textOffset, textEndOffset, document, findModel, (Ref<? super String>)stringToReplace)) {
                        return true;
                    }
                    if (!stringToReplace.isNull() && !justCheck) {
                        document.replaceString(textOffset, textEndOffset, (CharSequence)stringToReplace.get());
                    }
                }
                catch (FindManager.MalformedReplacementStringException e) {
                    exceptionResult.set((Object)e);
                    return false;
                }
                return true;
            });
        });
        if (!exceptionResult.isNull()) {
            throw (FindManager.MalformedReplacementStringException)((Object)exceptionResult.get());
        }
        return result2;
    }

    private boolean getStringToReplace(int textOffset, int textEndOffset, Document document, FindModel findModel, Ref<? super String> stringToReplace) throws FindManager.MalformedReplacementStringException {
        if (textOffset < 0 || textOffset >= document.getTextLength()) {
            return false;
        }
        if (textEndOffset < 0 || textEndOffset > document.getTextLength()) {
            return false;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        CharSequence foundString = document.getCharsSequence().subSequence(textOffset, textEndOffset);
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        FindResult findResult = findManager.findString(document.getCharsSequence(), textOffset, findModel, file2 != null ? file2.getVirtualFile() : null);
        if (!findResult.isStringFound() || findResult.getStartOffset() < textOffset || findResult.getEndOffset() > textEndOffset) {
            return false;
        }
        stringToReplace.set((Object)FindManager.getInstance((Project)this.myProject).getStringToReplace(foundString.toString(), findModel, textOffset, (CharSequence)document.getText()));
        return true;
    }

    private void replaceUsagesUnderCommand(@NotNull ReplaceContext replaceContext, @NotNull Set<? extends Usage> usagesSet) {
        if (replaceContext == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(19);
        }
        if (usagesSet == null) {
            ReplaceInProjectManager.$$$reportNull$$$0(20);
        }
        if (usagesSet.isEmpty()) {
            return;
        }
        ArrayList<? extends Usage> usages = new ArrayList<Usage>(usagesSet);
        usages.sort(UsageViewImpl.USAGE_COMPARATOR);
        if (!this.ensureUsagesWritable(replaceContext, usages)) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            boolean success = this.replaceUsages(replaceContext, usages);
            UsageView usageView = replaceContext.getUsageView();
            if (this.closeUsageViewIfEmpty(usageView, success)) {
                return;
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)usageView.getPreferredFocusableComponent(), true));
        }, FindBundle.message("find.replace.command", new Object[0]), null);
        replaceContext.invalidateExcludedSetCache();
    }

    private boolean ensureUsagesWritable(ReplaceContext replaceContext, Collection<? extends Usage> selectedUsages) {
        int result2;
        HashSet<VirtualFile> readOnlyFiles = null;
        for (Usage usage : selectedUsages) {
            VirtualFile file2 = ((UsageInFile)usage).getFile();
            if (file2 == null || file2.isWritable()) continue;
            if (readOnlyFiles == null) {
                readOnlyFiles = new HashSet<VirtualFile>();
            }
            readOnlyFiles.add(file2);
        }
        if (readOnlyFiles != null) {
            ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(readOnlyFiles);
        }
        return !ReplaceInProjectManager.hasReadOnlyUsages(selectedUsages) || (result2 = Messages.showOkCancelDialog((Component)replaceContext.getUsageView().getComponent(), (String)FindBundle.message("find.replace.occurrences.in.read.only.files.prompt", new Object[0]), (String)FindBundle.message("find.replace.occurrences.in.read.only.files.title", new Object[0]), (Icon)Messages.getWarningIcon())) == 0;
    }

    private boolean closeUsageViewIfEmpty(UsageView usageView, boolean success) {
        if (usageView.getUsages().isEmpty()) {
            usageView.close();
            return true;
        }
        if (!success) {
            NOTIFICATION_GROUP.createNotification(FindBundle.message("notification.content.one.or.more.malformed.replacement.strings", new Object[0]), MessageType.ERROR).notify(this.myProject);
        }
        return false;
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !FindInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageSearcherFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModelCopy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesCount";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToFind";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesCount";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToReplace";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedSet";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesSet";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/replaceInProject/ReplaceInProjectManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceInProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceInPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "searchAndShowUsages";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "showReplaceAllConfirmDialog";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getFiles";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllUsagesForFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceUsages";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceUsage";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceUsagesUnderCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class UsageSearcherFactory
    implements Factory<UsageSearcher> {
        private final FindModel myFindModelCopy;
        private final FindUsagesProcessPresentation myProcessPresentation;

        private UsageSearcherFactory(@NotNull FindModel findModelCopy, FindUsagesProcessPresentation processPresentation) {
            if (findModelCopy == null) {
                UsageSearcherFactory.$$$reportNull$$$0(0);
            }
            if (processPresentation == null) {
                UsageSearcherFactory.$$$reportNull$$$0(1);
            }
            this.myFindModelCopy = findModelCopy;
            this.myProcessPresentation = processPresentation;
        }

        public UsageSearcher create() {
            return processor2 -> {
                try {
                    ReplaceInProjectManager.this.myIsFindInProgress = true;
                    FindInProjectUtil.findUsages(this.myFindModelCopy, ReplaceInProjectManager.this.myProject, (Processor<? super UsageInfo>)new AdapterProcessor(processor2, (Function)UsageInfo2UsageAdapter.CONVERTER), this.myProcessPresentation);
                }
                finally {
                    ReplaceInProjectManager.this.myIsFindInProgress = false;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "findModelCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processPresentation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/find/replaceInProject/ReplaceInProjectManager$UsageSearcherFactory";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReplaceInProjectTarget
    extends FindInProjectUtil.StringUsageTarget {
        ReplaceInProjectTarget(@NotNull Project project, @NotNull FindModel findModel) {
            if (project == null) {
                ReplaceInProjectTarget.$$$reportNull$$$0(0);
            }
            if (findModel == null) {
                ReplaceInProjectTarget.$$$reportNull$$$0(1);
            }
            super(project, findModel);
        }

        @Override
        @NotNull
        public String getLongDescriptiveName() {
            UsageViewPresentation presentation2 = FindInProjectUtil.setupViewPresentation(this.myFindModel);
            String string = StringUtil.decapitalize((String)presentation2.getToolwindowTitle());
            if (string == null) {
                ReplaceInProjectTarget.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public KeyboardShortcut getShortcut() {
            return ActionManager.getInstance().getKeyboardShortcut("ReplaceInPath");
        }

        @Override
        public void showSettings() {
            Content selectedContent = UsageViewContentManager.getInstance((Project)this.myProject).getSelectedContent(true);
            JComponent component2 = selectedContent == null ? null : selectedContent.getComponent();
            ReplaceInProjectManager findInProjectManager = ReplaceInProjectManager.getInstance(this.myProject);
            findInProjectManager.replaceInProject(DataManager.getInstance().getDataContext((Component)component2), this.myFindModel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "findModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceInProjectTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceInProjectTarget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLongDescriptiveName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ReplaceContext {
        private final UsageView usageView;
        private final FindModel findModel;
        private Set<Usage> excludedSet;

        ReplaceContext(@NotNull UsageView usageView, @NotNull FindModel findModel) {
            if (usageView == null) {
                ReplaceContext.$$$reportNull$$$0(0);
            }
            if (findModel == null) {
                ReplaceContext.$$$reportNull$$$0(1);
            }
            this.usageView = usageView;
            this.findModel = findModel;
        }

        @NotNull
        public FindModel getFindModel() {
            FindModel findModel = this.findModel;
            if (findModel == null) {
                ReplaceContext.$$$reportNull$$$0(2);
            }
            return findModel;
        }

        @NotNull
        public UsageView getUsageView() {
            UsageView usageView = this.usageView;
            if (usageView == null) {
                ReplaceContext.$$$reportNull$$$0(3);
            }
            return usageView;
        }

        @NotNull
        Set<Usage> getExcludedSetCached() {
            if (this.excludedSet == null) {
                this.excludedSet = this.usageView.getExcludedUsages();
            }
            Set<Usage> set = this.excludedSet;
            if (set == null) {
                ReplaceContext.$$$reportNull$$$0(4);
            }
            return set;
        }

        void invalidateExcludedSetCache() {
            this.excludedSet = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "findModel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/replaceInProject/ReplaceInProjectManager$ReplaceContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFindModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsageView";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExcludedSetCached";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

