/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.ActiveWindowsWatcher;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.ApplicationActivationStateManager;
import com.intellij.ide.IdeKeyboardFocusManager;
import com.intellij.ide.IdePopupManager;
import com.intellij.ide.actions.MaximizeActiveDialogAction;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.InvocationUtil;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.swing.CellRendererPane;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public final class IdeEventQueue
extends EventQueue {
    private static final Set<Class<? extends Runnable>> ourRunnablesWoWrite = ContainerUtil.set((Object[])new Class[]{InvocationUtil.REPAINT_PROCESSING_CLASS});
    private static final Set<Class<? extends Runnable>> ourRunnablesWithWrite = ContainerUtil.set((Object[])new Class[]{InvocationUtil.FLUSH_NOW_CLASS});
    private static final boolean ourDefaultEventWithWrite = true;
    private static final Logger LOG = Logger.getInstance(IdeEventQueue.class);
    private static final Logger TYPEAHEAD_LOG = Logger.getInstance((String)(IdeEventQueue.class.getName() + ".typeahead"));
    private static final Logger FOCUS_AWARE_RUNNABLES_LOG = Logger.getInstance((String)(IdeEventQueue.class.getName() + ".runnables"));
    private static final boolean JAVA11_ON_MAC = SystemInfo.isMac && SystemInfo.isJavaVersionAtLeast((int)11, (int)0, (int)0);
    private static final boolean ourActionAwareTypeaheadEnabled = SystemProperties.getBooleanProperty((String)"action.aware.typeAhead", (boolean)true);
    private static final boolean ourTypeAheadSearchEverywhereEnabled = SystemProperties.getBooleanProperty((String)"action.aware.typeAhead.searchEverywhere", (boolean)false);
    private static final boolean ourSkipTypedEvent = SystemProperties.getBooleanProperty((String)"skip.typed.event", (boolean)true);
    private static final boolean ourSkipMetaPressOnLinux = SystemProperties.getBooleanProperty((String)"keymap.skip.meta.press.on.linux", (boolean)false);
    private static TransactionGuardImpl ourTransactionGuard;
    private static ProgressManager ourProgressManager;
    private static PerformanceWatcher ourPerformanceWatcher;
    private final Object myLock = new Object();
    private final List<Runnable> myIdleListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Runnable> myActivityListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Alarm myIdleRequestsAlarm = new Alarm();
    private final Map<Runnable, MyFireIdleRequest> myListenerToRequest = new THashMap();
    private final IdeKeyEventDispatcher myKeyEventDispatcher = new IdeKeyEventDispatcher(this);
    private final IdeMouseEventDispatcher myMouseEventDispatcher = new IdeMouseEventDispatcher();
    private final IdePopupManager myPopupManager = new IdePopupManager();
    private int myEventCount;
    final AtomicInteger myKeyboardEventsPosted = new AtomicInteger();
    final AtomicInteger myKeyboardEventsDispatched = new AtomicInteger();
    private boolean myIsInInputEvent;
    @NotNull
    private AWTEvent myCurrentEvent = new InvocationEvent((Object)this, EmptyRunnable.getInstance());
    @Nullable
    private AWTEvent myCurrentSequencedEvent;
    private volatile long myLastActiveTime = System.nanoTime();
    private long myLastEventTime = System.currentTimeMillis();
    private WindowManagerEx myWindowManager;
    private final List<EventDispatcher> myDispatchers = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<EventDispatcher> myPostProcessors = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<Runnable> myReady = new THashSet();
    private boolean myKeyboardBusy;
    private boolean myWinMetaPressed;
    private int myInputMethodLock;
    private final com.intellij.util.EventDispatcher<PostEventHook> myPostEventListeners = com.intellij.util.EventDispatcher.create(PostEventHook.class);
    private final Map<AWTEvent, List<Runnable>> myRunnablesWaitingFocusChange = new THashMap();
    private MyLastShortcut myLastShortcut;
    private static boolean ourAppIsLoaded;
    private boolean skipTypedEvents;
    private final Queue<AWTEvent> focusEventsList = new ConcurrentLinkedQueue<AWTEvent>();
    private final AtomicLong ourLastTimePressed = new AtomicLong(0L);
    private SearchEverywhereTypeaheadState mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DEACTIVATED;
    private final Set<Shortcut> shortcutsShowingPopups = new HashSet<Shortcut>();
    private WeakReference<Keymap> lastActiveKeymap = new WeakReference<Object>(null);
    private final List<String> actionsShowingPopupsList = new ArrayList<String>();
    private long lastTypeaheadTimestamp = -1L;
    private final Queue<KeyEvent> myDelayedKeyEvents = new ConcurrentLinkedQueue<KeyEvent>();
    private final AtomicBoolean delayKeyEvents = new AtomicBoolean();
    private Boolean myTestMode;

    public void executeWhenAllFocusEventsLeftTheQueue(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            IdeEventQueue.$$$reportNull$$$0(0);
        }
        this.ifFocusEventsInTheQueue(e -> {
            List<Runnable> runnables = this.myRunnablesWaitingFocusChange.get(e);
            if (runnables != null) {
                if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                    FOCUS_AWARE_RUNNABLES_LOG.debug("We have already had a runnable for the event: " + e);
                }
                runnables.add(runnable2);
            } else {
                runnables = new ArrayList<Runnable>();
                runnables.add(runnable2);
                this.myRunnablesWaitingFocusChange.put((AWTEvent)e, runnables);
            }
        }, runnable2);
    }

    @NotNull
    public String runnablesWaitingForFocusChangeState() {
        String string = StringUtil.join(this.focusEventsList, event -> "[" + event.getID() + "; " + event.getSource().getClass().getName() + "]", (String)", ");
        if (string == null) {
            IdeEventQueue.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void ifFocusEventsInTheQueue(@NotNull Consumer<? super AWTEvent> yes, @NotNull Runnable no) {
        if (yes == null) {
            IdeEventQueue.$$$reportNull$$$0(2);
        }
        if (no == null) {
            IdeEventQueue.$$$reportNull$$$0(3);
        }
        if (!this.focusEventsList.isEmpty()) {
            AWTEvent first;
            if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                FOCUS_AWARE_RUNNABLES_LOG.debug("Focus event list (trying to execute runnable): " + this.runnablesWaitingForFocusChangeState());
            }
            if ((first = (AWTEvent)ContainerUtil.find(this.focusEventsList, e -> e.getID() == 1004)) != null) {
                if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                    FOCUS_AWARE_RUNNABLES_LOG.debug("    runnable saved for : [" + first.getID() + "; " + first.getSource() + "] -> " + no.getClass().getName());
                }
                yes.accept(first);
            } else {
                if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                    FOCUS_AWARE_RUNNABLES_LOG.debug("    runnable is run on EDT if needed : " + no.getClass().getName());
                }
                UIUtil.invokeLaterIfNeeded((Runnable)no);
            }
        } else {
            if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                FOCUS_AWARE_RUNNABLES_LOG.debug("Focus event list is empty: runnable is run right away : " + no.getClass().getName());
            }
            UIUtil.invokeLaterIfNeeded((Runnable)no);
        }
    }

    public static IdeEventQueue getInstance() {
        return IdeEventQueueHolder.INSTANCE;
    }

    private IdeEventQueue() {
        EventQueue systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        assert (!(systemEventQueue instanceof IdeEventQueue)) : systemEventQueue;
        systemEventQueue.push(this);
        EDT.updateEdt();
        IdeKeyboardFocusManager keyboardFocusManager = IdeKeyboardFocusManager.replaceDefault();
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", e -> {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                return;
            }
            application.assertIsDispatchThread();
        });
        this.addDispatcher(new WindowsAltSuppressor(), null);
        if (SystemInfo.isWin7OrNewer && SystemProperties.getBooleanProperty((String)"keymap.windows.up.to.maximize.dialogs", (boolean)true)) {
            this.addDispatcher(new WindowsUpMaximizer(), null);
        }
        this.addDispatcher(new EditingCanceller(), null);
        this.abracadabraDaberBoreh();
        IdeKeyEventDispatcher.addDumbModeWarningListener(() -> this.flushDelayedKeyEvents());
        if (SystemProperties.getBooleanProperty((String)"skip.move.resize.events", (boolean)true)) {
            this.myPostEventListeners.addListener(IdeEventQueue::skipMoveResizeEvents);
        }
        ((IdeKeyboardFocusManager)KeyboardFocusManager.getCurrentKeyboardFocusManager()).setTypeaheadHandler(ke -> {
            if (this.myKeyEventDispatcher.dispatchKeyEvent((KeyEvent)ke)) {
                ke.consume();
            }
        });
    }

    private static boolean skipMoveResizeEvents(AWTEvent event) {
        switch (event.getID()) {
            case 100: 
            case 101: 
            case 1401: 
            case 1402: {
                Object source = event.getSource();
                if (!(source instanceof Component) || ComponentUtil.getParentOfType(CellRendererPane.class, (Component)((Component)source)) == null) break;
                return true;
            }
        }
        return false;
    }

    private void abracadabraDaberBoreh() {
        try {
            Class<?> aClass = Class.forName("sun.awt.PostEventQueue");
            Constructor<?> constructor = aClass.getDeclaredConstructor(EventQueue.class);
            constructor.setAccessible(true);
            Object postEventQueue = constructor.newInstance(this);
            AppContext.getAppContext().put("PostEventQueue", postEventQueue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setWindowManager(@NotNull WindowManagerEx windowManager) {
        if (windowManager == null) {
            IdeEventQueue.$$$reportNull$$$0(4);
        }
        this.myWindowManager = windowManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleListener(@NotNull Runnable runnable2, int timeoutMillis) {
        if (runnable2 == null) {
            IdeEventQueue.$$$reportNull$$$0(5);
        }
        if (timeoutMillis <= 0 || TimeUnit.MILLISECONDS.toHours(timeoutMillis) >= 24L) {
            throw new IllegalArgumentException("This timeout value is unsupported: " + timeoutMillis);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myIdleListeners.add(runnable2);
            MyFireIdleRequest request2 = new MyFireIdleRequest(runnable2, timeoutMillis);
            this.myListenerToRequest.put(runnable2, request2);
            UIUtil.invokeLaterIfNeeded(() -> this.myIdleRequestsAlarm.addRequest((Runnable)request2, timeoutMillis));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            IdeEventQueue.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            MyFireIdleRequest request2;
            boolean wasRemoved = this.myIdleListeners.remove(runnable2);
            if (!wasRemoved) {
                LOG.error("unknown runnable: " + runnable2);
            }
            LOG.assertTrue((request2 = this.myListenerToRequest.remove(runnable2)) != null);
            this.myIdleRequestsAlarm.cancelRequest((Runnable)request2);
        }
    }

    public void addActivityListener(@NotNull Runnable runnable2, @NotNull Disposable parentDisposable) {
        if (runnable2 == null) {
            IdeEventQueue.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            IdeEventQueue.$$$reportNull$$$0(8);
        }
        ContainerUtil.add((Object)runnable2, this.myActivityListeners, (Disposable)parentDisposable);
    }

    public void addDispatcher(@NotNull EventDispatcher dispatcher, Disposable parent) {
        if (dispatcher == null) {
            IdeEventQueue.$$$reportNull$$$0(9);
        }
        IdeEventQueue._addProcessor(dispatcher, parent, this.myDispatchers);
    }

    public void removeDispatcher(@NotNull EventDispatcher dispatcher) {
        if (dispatcher == null) {
            IdeEventQueue.$$$reportNull$$$0(10);
        }
        this.myDispatchers.remove(dispatcher);
    }

    public boolean containsDispatcher(@NotNull EventDispatcher dispatcher) {
        if (dispatcher == null) {
            IdeEventQueue.$$$reportNull$$$0(11);
        }
        return this.myDispatchers.contains(dispatcher);
    }

    public void addPostprocessor(@NotNull EventDispatcher dispatcher, @Nullable Disposable parent) {
        if (dispatcher == null) {
            IdeEventQueue.$$$reportNull$$$0(12);
        }
        IdeEventQueue._addProcessor(dispatcher, parent, this.myPostProcessors);
    }

    public void removePostprocessor(@NotNull EventDispatcher dispatcher) {
        if (dispatcher == null) {
            IdeEventQueue.$$$reportNull$$$0(13);
        }
        this.myPostProcessors.remove(dispatcher);
    }

    private static void _addProcessor(@NotNull EventDispatcher dispatcher, Disposable parent, @NotNull Collection<? super EventDispatcher> set) {
        if (dispatcher == null) {
            IdeEventQueue.$$$reportNull$$$0(14);
        }
        if (set == null) {
            IdeEventQueue.$$$reportNull$$$0(15);
        }
        set.add(dispatcher);
        if (parent != null) {
            Disposer.register((Disposable)parent, () -> set.remove(dispatcher));
        }
    }

    public int getEventCount() {
        return this.myEventCount;
    }

    public void setEventCount(int evCount) {
        this.myEventCount = evCount;
    }

    @NotNull
    public AWTEvent getTrueCurrentEvent() {
        AWTEvent aWTEvent = this.myCurrentEvent;
        if (aWTEvent == null) {
            IdeEventQueue.$$$reportNull$$$0(16);
        }
        return aWTEvent;
    }

    private static boolean appIsLoaded() {
        if (ourAppIsLoaded) {
            return true;
        }
        if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
            ourAppIsLoaded = true;
            return true;
        }
        return ourAppIsLoaded;
    }

    public static void applicationClose() {
        ourAppIsLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(17);
        }
        long startedAt = System.currentTimeMillis();
        PerformanceWatcher performanceWatcher = IdeEventQueue.obtainPerformanceWatcher();
        EventWatcher eventWatcher = EventWatcher.getInstance();
        try {
            if (performanceWatcher != null) {
                performanceWatcher.edtEventStarted();
            }
            if (eventWatcher != null) {
                eventWatcher.edtEventStarted(e);
            }
            this.fixNestedSequenceEvent(e);
            EDT.updateEdt();
            if (e.getID() == 205 || e.getID() == 204 || e.getID() == 200) {
                ActiveWindowsWatcher.addActiveWindow((Window)e.getSource());
            }
            if (ourSkipTypedEvent && this.skipTypedKeyEventsIfFocusReturnsToOwner(e)) {
                return;
            }
            if (IdeEventQueue.isMetaKeyPressedOnLinux(e)) {
                return;
            }
            if (this.isSpecialSymbolMatchingShortcut(e)) {
                return;
            }
            if (e.getSource() instanceof TrayIcon) {
                IdeEventQueue.dispatchTrayIconEvent(e);
                return;
            }
            this.checkForTimeJump(startedAt);
            if (!IdeEventQueue.appIsLoaded()) {
                try {
                    super.dispatchEvent(e);
                }
                catch (Throwable t) {
                    this.processException(t);
                }
                return;
            }
            AWTEvent metaEvent = this.mapMetaState(e = IdeEventQueue.mapEvent(e));
            if (metaEvent != null && Registry.is((String)"keymap.windows.as.meta")) {
                e = metaEvent;
            }
            if (JAVA11_ON_MAC && e instanceof InputEvent) {
                IdeEventQueue.disableAltGrUnsupportedOnMac(e);
            }
            boolean wasInputEvent = this.myIsInInputEvent;
            this.myIsInInputEvent = IdeEventQueue.isInputEvent(e);
            AWTEvent oldEvent = this.myCurrentEvent;
            this.myCurrentEvent = e;
            AWTEvent finalE1 = e;
            Runnable runnable2 = InvocationUtil.extractRunnable(e);
            Class runnableClass = runnable2 != null ? runnable2.getClass() : Runnable.class;
            Runnable processEventRunnable = () -> {
                try {
                    try (AccessToken ignored = IdeEventQueue.startActivity(finalE1);){
                        ProgressManager progressManager = IdeEventQueue.obtainProgressManager();
                        if (progressManager != null) {
                            progressManager.computePrioritized(() -> {
                                this._dispatchEvent(this.myCurrentEvent);
                                return null;
                            });
                        } else {
                            this._dispatchEvent(this.myCurrentEvent);
                        }
                    }
                    this.myIsInInputEvent = wasInputEvent;
                    this.myCurrentEvent = oldEvent;
                    if (this.myCurrentSequencedEvent == finalE1) {
                        this.myCurrentSequencedEvent = null;
                    }
                }
                catch (Throwable t) {
                    try {
                        this.processException(t);
                        this.myIsInInputEvent = wasInputEvent;
                        this.myCurrentEvent = oldEvent;
                        if (this.myCurrentSequencedEvent == finalE1) {
                            this.myCurrentSequencedEvent = null;
                        }
                    }
                    catch (Throwable throwable) {
                        this.myIsInInputEvent = wasInputEvent;
                        this.myCurrentEvent = oldEvent;
                        if (this.myCurrentSequencedEvent == finalE1) {
                            this.myCurrentSequencedEvent = null;
                        }
                        for (EventDispatcher each : this.myPostProcessors) {
                            each.dispatch(finalE1);
                        }
                        if (finalE1 instanceof KeyEvent) {
                            this.maybeReady();
                        }
                        if (eventWatcher != null && runnableClass != InvocationUtil.FLUSH_NOW_CLASS) {
                            eventWatcher.logTimeMillis(runnableClass != Runnable.class ? runnableClass.getName() : finalE1.toString(), startedAt, runnableClass);
                        }
                        throw throwable;
                    }
                    for (EventDispatcher each : this.myPostProcessors) {
                        each.dispatch(finalE1);
                    }
                    if (finalE1 instanceof KeyEvent) {
                        this.maybeReady();
                    }
                    if (eventWatcher != null && runnableClass != InvocationUtil.FLUSH_NOW_CLASS) {
                        eventWatcher.logTimeMillis(runnableClass != Runnable.class ? runnableClass.getName() : finalE1.toString(), startedAt, runnableClass);
                    }
                }
                for (EventDispatcher each : this.myPostProcessors) {
                    each.dispatch(finalE1);
                }
                if (finalE1 instanceof KeyEvent) {
                    this.maybeReady();
                }
                if (eventWatcher != null && runnableClass != InvocationUtil.FLUSH_NOW_CLASS) {
                    eventWatcher.logTimeMillis(runnableClass != Runnable.class ? runnableClass.getName() : finalE1.toString(), startedAt, runnableClass);
                }
                if (IdeEventQueue.isFocusEvent(finalE1)) {
                    this.onFocusEvent(finalE1);
                }
            };
            if (runnableClass != Runnable.class) {
                if (ourRunnablesWoWrite.contains(runnableClass)) {
                    processEventRunnable.run();
                    return;
                }
                if (ourRunnablesWithWrite.contains(runnableClass)) {
                    ApplicationManagerEx.getApplicationEx().runIntendedWriteActionOnCurrentThread(processEventRunnable);
                    return;
                }
            }
            ApplicationManagerEx.getApplicationEx().runIntendedWriteActionOnCurrentThread(processEventRunnable);
        }
        finally {
            if (performanceWatcher != null) {
                performanceWatcher.edtEventFinished();
            }
            if (eventWatcher != null) {
                eventWatcher.edtEventFinished(e, startedAt);
            }
        }
    }

    private void fixNestedSequenceEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(18);
        }
        if (e.getClass() == SequencedEventNestedFieldHolder.SEQUENCED_EVENT_CLASS) {
            if (this.myCurrentSequencedEvent != null) {
                AWTEvent sequenceEventToDispose = this.myCurrentSequencedEvent;
                this.myCurrentSequencedEvent = null;
                SequencedEventNestedFieldHolder.invokeDispose(sequenceEventToDispose);
            }
            this.myCurrentSequencedEvent = e;
        }
    }

    private static void dispatchTrayIconEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(19);
        }
        if (e instanceof ActionEvent) {
            for (ActionListener listener2 : ((TrayIcon)e.getSource()).getActionListeners()) {
                listener2.actionPerformed((ActionEvent)e);
            }
        }
    }

    private static void disableAltGrUnsupportedOnMac(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(20);
        }
        if (e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 65406) {
            ((KeyEvent)e).setKeyCode(18);
        }
        IdeKeyEventDispatcher.removeAltGraph((InputEvent)e);
    }

    private void onFocusEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(21);
        }
        TouchBarsManager.onFocusEvent(e);
        if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
            FOCUS_AWARE_RUNNABLES_LOG.debug("Focus event list (execute on focus event): " + this.runnablesWaitingForFocusChangeState());
        }
        ArrayList<AWTEvent> events = new ArrayList<AWTEvent>();
        while (!this.focusEventsList.isEmpty()) {
            AWTEvent f = this.focusEventsList.poll();
            events.add(f);
            if (!f.equals(e)) continue;
            break;
        }
        events.stream().map(entry -> this.myRunnablesWaitingFocusChange.remove(entry)).filter(lor -> lor != null).flatMap(listOfRunnables -> listOfRunnables.stream()).filter(r -> r != null).filter(r -> !(r instanceof ExpirableRunnable) || !((ExpirableRunnable)r).isExpired()).forEach(runnable2 -> {
            try {
                runnable2.run();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        });
    }

    private boolean isSpecialSymbolMatchingShortcut(AWTEvent e) {
        MyLastShortcut shortcut = this.myLastShortcut;
        if (shortcut != null && e instanceof KeyEvent && e.getID() == 400) {
            KeyEvent symbol = (KeyEvent)e;
            long time = symbol.getWhen() - shortcut.when;
            return time < 17L && shortcut.keyChar == symbol.getKeyChar();
        }
        return false;
    }

    public void onActionInvoked(@NotNull KeyEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(22);
        }
        this.myLastShortcut = new MyLastShortcut(e.getWhen(), e.getKeyChar());
    }

    @Nullable
    private static ProgressManager obtainProgressManager() {
        Application app;
        ProgressManager manager = ourProgressManager;
        if (manager == null && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            ourProgressManager = manager = (ProgressManager)ServiceManager.getService(ProgressManager.class);
        }
        return manager;
    }

    @Nullable
    private static PerformanceWatcher obtainPerformanceWatcher() {
        Application app;
        PerformanceWatcher watcher = ourPerformanceWatcher;
        if (watcher == null && LoadingState.COMPONENTS_LOADED.isOccurred() && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            ourPerformanceWatcher = watcher = PerformanceWatcher.getInstance();
        }
        return watcher;
    }

    private static boolean isMetaKeyPressedOnLinux(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(23);
        }
        if (!ourSkipMetaPressOnLinux) {
            return false;
        }
        boolean metaIsPressed = e instanceof InputEvent && (((InputEvent)e).getModifiersEx() & 0x100) != 0;
        boolean typedKeyEvent = e.getID() == 400;
        return SystemInfo.isLinux && typedKeyEvent && metaIsPressed;
    }

    private boolean skipTypedKeyEventsIfFocusReturnsToOwner(@NotNull AWTEvent e) {
        WindowEvent wfe;
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(24);
        }
        if (e.getID() == 208 && (wfe = (WindowEvent)e).getWindow().getParent() != null && wfe.getWindow().getParent() == wfe.getOppositeWindow()) {
            this.skipTypedEvents = true;
        }
        if (this.skipTypedEvents && e instanceof KeyEvent) {
            if (e.getID() == 400) {
                ((KeyEvent)e).consume();
                return true;
            }
            this.skipTypedEvents = false;
        }
        return false;
    }

    private void checkForTimeJump(long now) {
        if (this.myLastEventTime > now + 1000L) {
            LOG.warn("System clock's jumped back by ~" + (this.myLastEventTime - now) / 1000L + " sec");
        }
        this.myLastEventTime = now;
    }

    private static boolean isInputEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(25);
        }
        return e instanceof InputEvent || e instanceof InputMethodEvent || e instanceof WindowEvent || e instanceof ActionEvent;
    }

    @Override
    @NotNull
    public AWTEvent getNextEvent() throws InterruptedException {
        AWTEvent event;
        AWTEvent aWTEvent = event = IdeEventQueue.appIsLoaded() ? (AWTEvent)ApplicationManagerEx.getApplicationEx().runUnlockingIntendedWrite(() -> super.getNextEvent()) : super.getNextEvent();
        if (IdeEventQueue.isKeyboardEvent(event) && this.myKeyboardEventsDispatched.incrementAndGet() > this.myKeyboardEventsPosted.get()) {
            throw new RuntimeException(event + "; posted: " + this.myKeyboardEventsPosted + "; dispatched: " + this.myKeyboardEventsDispatched);
        }
        AWTEvent aWTEvent2 = event;
        if (aWTEvent2 == null) {
            IdeEventQueue.$$$reportNull$$$0(26);
        }
        return aWTEvent2;
    }

    @Nullable
    static AccessToken startActivity(@NotNull AWTEvent e) {
        Application app;
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(27);
        }
        if (ourTransactionGuard == null && IdeEventQueue.appIsLoaded() && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            ourTransactionGuard = (TransactionGuardImpl)TransactionGuard.getInstance();
        }
        return ourTransactionGuard == null ? null : ourTransactionGuard.startActivity(IdeEventQueue.isInputEvent(e) || e instanceof ItemEvent || e instanceof FocusEvent);
    }

    private void processException(@NotNull Throwable t) {
        if (t == null) {
            IdeEventQueue.$$$reportNull$$$0(28);
        }
        if (this.isTestMode()) {
            ExceptionUtil.rethrow((Throwable)t);
        }
        StartupAbortedException.processException((Throwable)t);
    }

    @NotNull
    private static AWTEvent mapEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(29);
        }
        AWTEvent aWTEvent = SystemInfo.isXWindow && e instanceof MouseEvent && ((MouseEvent)e).getButton() > 3 ? IdeEventQueue.mapXWindowMouseEvent((MouseEvent)e) : e;
        if (aWTEvent == null) {
            IdeEventQueue.$$$reportNull$$$0(30);
        }
        return aWTEvent;
    }

    @NotNull
    private static AWTEvent mapXWindowMouseEvent(MouseEvent src) {
        if (src.getButton() < 6) {
            return new MouseWheelEvent(src.getComponent(), 507, src.getWhen(), src.getModifiers() | 0x40, src.getX(), src.getY(), 0, false, 0, src.getClickCount(), src.getButton() == 4 ? -1 : 1);
        }
        return new MouseEvent(src.getComponent(), src.getID(), src.getWhen(), src.getModifiers() | 1 << 8 + src.getButton(), src.getX(), src.getY(), 1, src.isPopupTrigger(), src.getButton() - 2);
    }

    @Nullable
    private AWTEvent mapMetaState(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(31);
        }
        if (this.myWinMetaPressed) {
            Application app = ApplicationManager.getApplication();
            boolean weAreNotActive = app == null || !app.isActive();
            if (weAreNotActive |= e instanceof FocusEvent && ((FocusEvent)e).getOppositeComponent() == null) {
                this.myWinMetaPressed = false;
                return null;
            }
        }
        if (e instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)e;
            if (ke.getKeyCode() == 524) {
                if (ke.getID() == 401) {
                    this.myWinMetaPressed = true;
                }
                if (ke.getID() == 402) {
                    this.myWinMetaPressed = false;
                }
                return null;
            }
            if (this.myWinMetaPressed) {
                return new KeyEvent(ke.getComponent(), ke.getID(), ke.getWhen(), ke.getModifiers() | ke.getModifiersEx() | 4, ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation());
            }
        }
        if (this.myWinMetaPressed && e instanceof MouseEvent && ((MouseEvent)e).getButton() != 0) {
            MouseEvent me = (MouseEvent)e;
            return new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers() | me.getModifiersEx() | 4, me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton());
        }
        return null;
    }

    private void _dispatchEvent(@NotNull AWTEvent e) {
        DnDManagerImpl dndManager;
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(32);
        }
        if (e.getID() == 506 && LoadingState.COMPONENTS_LOADED.isOccurred() && (dndManager = (DnDManagerImpl)DnDManager.getInstance()) != null) {
            dndManager.setLastDropHandler(null);
        }
        ++this.myEventCount;
        if (e instanceof WindowEvent) {
            IdeEventQueue.processAppActivationEvent((WindowEvent)e);
        }
        boolean bl = this.myKeyboardBusy = e instanceof KeyEvent || this.myKeyboardEventsPosted.get() > this.myKeyboardEventsDispatched.get();
        if (e instanceof KeyEvent && e.getID() == 402 && ((KeyEvent)e).getKeyCode() == 16) {
            this.myMouseEventDispatcher.resetHorScrollingTracker();
        }
        if (e instanceof MouseWheelEvent && IdeEventQueue.processMouseWheelEvent((MouseWheelEvent)e)) {
            return;
        }
        if (e instanceof WindowEvent || e instanceof FocusEvent || e instanceof InputEvent) {
            ActivityTracker.getInstance().inc();
            if (e instanceof InputEvent) {
                this.processIdleActivityListeners(e);
            }
        }
        if (e.getID() == 400 && this.myKeyEventDispatcher.isPressedWasProcessed()) {
            assert (e instanceof KeyEvent);
            ((KeyEvent)e).consume();
        }
        if (this.myPopupManager.isPopupActive() && this.myPopupManager.dispatch(e)) {
            if (this.myKeyEventDispatcher.isWaitingForSecondKeyStroke()) {
                this.myKeyEventDispatcher.setState(KeyState.STATE_INIT);
            }
            return;
        }
        if (e instanceof InputEvent && SystemInfo.isMac) {
            TouchBarsManager.onInputEvent((InputEvent)e);
        }
        if (this.dispatchByCustomDispatchers(e)) {
            return;
        }
        if (e instanceof InputMethodEvent && SystemInfo.isMac && this.myKeyEventDispatcher.isWaitingForSecondKeyStroke()) {
            return;
        }
        if (e instanceof ComponentEvent && this.myWindowManager != null) {
            this.myWindowManager.dispatchComponentEvent((ComponentEvent)e);
        }
        if (e instanceof KeyEvent) {
            this.dispatchKeyEvent(e);
        } else if (e instanceof MouseEvent) {
            this.dispatchMouseEvent(e);
        } else {
            this.defaultDispatchEvent(e);
        }
    }

    private static boolean processMouseWheelEvent(@NotNull MouseWheelEvent e) {
        MenuElement[] selectedPath;
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(33);
        }
        if ((selectedPath = MenuSelectionManager.defaultManager().getSelectedPath()).length > 0 && !(selectedPath[0] instanceof ComboPopup)) {
            e.consume();
            Component component2 = selectedPath[0].getComponent();
            if (component2 instanceof JBPopupMenu) {
                ((JBPopupMenu)component2).processMouseWheelEvent(e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIdleActivityListeners(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(34);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myIdleRequestsAlarm.cancelAllRequests();
            for (Runnable idleListener : this.myIdleListeners) {
                MyFireIdleRequest request2 = this.myListenerToRequest.get(idleListener);
                if (request2 == null) {
                    LOG.error("There is no request for " + idleListener);
                    continue;
                }
                this.myIdleRequestsAlarm.addRequest((Runnable)request2, request2.getTimeout(), ModalityState.NON_MODAL);
            }
            if (401 == e.getID() || 400 == e.getID() || 501 == e.getID() || 502 == e.getID() || 500 == e.getID()) {
                this.myLastActiveTime = System.nanoTime();
                for (Runnable activityListener : this.myActivityListeners) {
                    activityListener.run();
                }
            }
        }
    }

    private void dispatchKeyEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(35);
        }
        if ((!SystemInfo.isJetBrainsJvm || JavaVersion.current().compareTo(JavaVersion.compose((int)8, (int)0, (int)202, (int)1504, (boolean)false)) < 0 && JavaVersion.current().compareTo(JavaVersion.compose((int)9, (int)0, (int)0, (int)0, (boolean)false)) < 0 || JavaVersion.current().compareTo(JavaVersion.compose((int)11, (int)0, (int)0, (int)0, (boolean)false)) > 0) && this.myKeyEventDispatcher.dispatchKeyEvent((KeyEvent)e)) {
            ((KeyEvent)e).consume();
        }
        this.defaultDispatchEvent(e);
    }

    private void dispatchMouseEvent(@NotNull AWTEvent e) {
        MouseEvent me;
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(36);
        }
        if ((me = (MouseEvent)e).getID() == 501 && me.getModifiers() > 0 && me.getModifiersEx() == 0) {
            this.resetGlobalMouseEventTarget(me);
        }
        if (IdeMouseEventDispatcher.patchClickCount(me) && me.getID() == 500) {
            this.redispatchLater(me);
        }
        if (!this.myMouseEventDispatcher.dispatchMouseEvent(me)) {
            this.defaultDispatchEvent(e);
        }
    }

    private void resetGlobalMouseEventTarget(MouseEvent me) {
        super.dispatchEvent(new MouseEvent(me.getComponent(), 503, me.getWhen(), 0, me.getX(), me.getY(), 0, false, 0));
    }

    private void redispatchLater(MouseEvent me) {
        MouseEvent toDispatch = new MouseEvent(me.getComponent(), me.getID(), System.currentTimeMillis(), me.getModifiers(), me.getX(), me.getY(), 1, me.isPopupTrigger(), me.getButton());
        SwingUtilities.invokeLater(() -> this.dispatchEvent(toDispatch));
    }

    private boolean dispatchByCustomDispatchers(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(37);
        }
        for (EventDispatcher eachDispatcher : this.myDispatchers) {
            if (!eachDispatcher.dispatch(e)) continue;
            return true;
        }
        return false;
    }

    private static void processAppActivationEvent(@NotNull WindowEvent event) {
        if (event == null) {
            IdeEventQueue.$$$reportNull$$$0(38);
        }
        ApplicationActivationStateManager.updateState(event);
        if (event.getID() != 206 && event.getID() != 208) {
            return;
        }
        Window eventWindow = event.getWindow();
        Component focusOwnerInDeactivatedWindow = eventWindow.getMostRecentFocusOwner();
        if (focusOwnerInDeactivatedWindow == null) {
            return;
        }
        Component frame = ComponentUtil.findUltimateParent((Component)eventWindow);
        WindowManager windowManager = (WindowManager)ApplicationManager.getApplication().getServiceIfCreated(WindowManager.class);
        if (windowManager == null) {
            return;
        }
        for (ProjectFrameHelper frameHelper : ((WindowManagerEx)windowManager).getProjectFrameHelpers()) {
            IdeFocusManager focusManager;
            if (frame != frameHelper.getFrameOrNullIfDisposed() || !((focusManager = IdeFocusManager.getGlobalInstance()) instanceof FocusManagerImpl)) continue;
            ((FocusManagerImpl)focusManager).setLastFocusedAtDeactivation((Window)frame, focusOwnerInDeactivatedWindow);
        }
    }

    private void defaultDispatchEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(39);
        }
        try {
            this.maybeReady();
            IdeEventQueue.fixStickyAlt(e);
            super.dispatchEvent(e);
        }
        catch (Throwable t) {
            this.processException(t);
        }
    }

    private static void fixStickyAlt(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(40);
        }
        if (SystemInfo.isWinXpOrNewer && !SystemInfo.isWinVistaOrNewer && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 18 && !Registry.is((String)"actionSystem.win.suppressAlt.new")) {
            ((KeyEvent)e).consume();
        }
    }

    public void flushQueue() {
        AWTEvent event;
        while ((event = this.peekEvent()) != null) {
            try {
                this.dispatchEvent(this.getNextEvent());
                continue;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            break;
        }
        return;
    }

    public void pumpEventsForHierarchy(@NotNull Component modalComponent, @NotNull Condition<? super AWTEvent> exitCondition) {
        AWTEvent event;
        if (modalComponent == null) {
            IdeEventQueue.$$$reportNull$$$0(41);
        }
        if (exitCondition == null) {
            IdeEventQueue.$$$reportNull$$$0(42);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pumpEventsForHierarchy(" + modalComponent + ", " + exitCondition + ")");
        }
        do {
            try {
                Object s;
                event = this.getNextEvent();
                boolean eventOk = true;
                if (event instanceof InputEvent && (s = event.getSource()) instanceof Component) {
                    Component c;
                    Window modalWindow = SwingUtilities.windowForComponent(modalComponent);
                    for (c = (Component)s; c != null && c != modalWindow; c = c.getParent()) {
                    }
                    if (c == null) {
                        eventOk = false;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("pumpEventsForHierarchy.consumed: " + event);
                        }
                        ((InputEvent)event).consume();
                    }
                }
                if (!eventOk) continue;
                this.dispatchEvent(event);
            }
            catch (Throwable e) {
                LOG.error(e);
                event = null;
            }
        } while (!exitCondition.value((Object)event));
        if (LOG.isDebugEnabled()) {
            LOG.debug("pumpEventsForHierarchy.exit(" + modalComponent + ", " + exitCondition + ")");
        }
    }

    public long getIdleTime() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.myLastActiveTime);
    }

    @NotNull
    public IdePopupManager getPopupManager() {
        IdePopupManager idePopupManager = this.myPopupManager;
        if (idePopupManager == null) {
            IdeEventQueue.$$$reportNull$$$0(43);
        }
        return idePopupManager;
    }

    @NotNull
    public IdeKeyEventDispatcher getKeyEventDispatcher() {
        IdeKeyEventDispatcher ideKeyEventDispatcher = this.myKeyEventDispatcher;
        if (ideKeyEventDispatcher == null) {
            IdeEventQueue.$$$reportNull$$$0(44);
        }
        return ideKeyEventDispatcher;
    }

    public void blockNextEvents(@NotNull MouseEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(45);
        }
        this.blockNextEvents(e, BlockMode.COMPLETE);
    }

    public void blockNextEvents(@NotNull MouseEvent e, @NotNull BlockMode blockMode) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(46);
        }
        if (blockMode == null) {
            IdeEventQueue.$$$reportNull$$$0(47);
        }
        this.myMouseEventDispatcher.blockNextEvents(e, blockMode);
    }

    private boolean isReady() {
        return !this.myKeyboardBusy && this.myKeyEventDispatcher.isReady();
    }

    public void maybeReady() {
        if (this.myReady.isEmpty() || !this.isReady()) {
            return;
        }
        this.invokeReadyHandlers();
    }

    private void invokeReadyHandlers() {
        Runnable[] ready = this.myReady.toArray(new Runnable[0]);
        this.myReady.clear();
        for (Runnable each : ready) {
            each.run();
        }
    }

    public void doWhenReady(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            IdeEventQueue.$$$reportNull$$$0(48);
        }
        if (EventQueue.isDispatchThread()) {
            this.myReady.add(runnable2);
            this.maybeReady();
        } else {
            SwingUtilities.invokeLater(() -> {
                this.myReady.add(runnable2);
                this.maybeReady();
            });
        }
    }

    public boolean isPopupActive() {
        return this.myPopupManager.isPopupActive();
    }

    public boolean isInputMethodEnabled() {
        return !SystemInfo.isMac || this.myInputMethodLock == 0;
    }

    public void disableInputMethods(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            IdeEventQueue.$$$reportNull$$$0(49);
        }
        ++this.myInputMethodLock;
        Disposer.register((Disposable)parentDisposable, () -> --this.myInputMethodLock);
    }

    @Override
    public void postEvent(@NotNull AWTEvent event) {
        if (event == null) {
            IdeEventQueue.$$$reportNull$$$0(50);
        }
        this.doPostEvent(event);
    }

    private static boolean doesFocusGoIntoPopup(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(51);
        }
        AWTEvent unwrappedEvent = IdeEventQueue.unwrapWindowEvent(e);
        if (TYPEAHEAD_LOG.isDebugEnabled() && (e instanceof WindowEvent || e.getClass().getName().contains("SequencedEvent"))) {
            TYPEAHEAD_LOG.debug("Window event: " + e.paramString());
        }
        return IdeEventQueue.doesFocusGoIntoPopupFromWindowEvent(unwrappedEvent);
    }

    @NotNull
    private static AWTEvent unwrapWindowEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(52);
        }
        AWTEvent unwrappedEvent = e;
        if (e.getClass() == SequencedEventNestedFieldHolder.SEQUENCED_EVENT_CLASS) {
            try {
                unwrappedEvent = (AWTEvent)SequencedEventNestedFieldHolder.NESTED_FIELD.get(e);
            }
            catch (IllegalAccessException illegalAccessException) {
                TYPEAHEAD_LOG.error((Throwable)illegalAccessException);
            }
        }
        TYPEAHEAD_LOG.assertTrue(unwrappedEvent != null);
        AWTEvent aWTEvent = unwrappedEvent;
        if (aWTEvent == null) {
            IdeEventQueue.$$$reportNull$$$0(53);
        }
        return aWTEvent;
    }

    private boolean isTypeaheadTimeoutExceeded() {
        if (!this.delayKeyEvents.get()) {
            return false;
        }
        long currentTypeaheadDelay = System.currentTimeMillis() - this.lastTypeaheadTimestamp;
        if ((double)currentTypeaheadDelay > Registry.get((String)"action.aware.typeaheadTimeout").asDouble()) {
            super.postEvent(new InvocationEvent((Object)this, () -> TYPEAHEAD_LOG.error((Throwable)new RuntimeException("Typeahead timeout is exceeded: " + currentTypeaheadDelay))));
            return true;
        }
        return false;
    }

    private static boolean doesFocusGoIntoPopupFromWindowEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(54);
        }
        if ((e.getID() == 207 || SystemInfo.isLinux && e.getID() == 200) && UIUtil.isTypeAheadAware((Window)((WindowEvent)e).getWindow())) {
            TYPEAHEAD_LOG.debug("Focus goes into TypeAhead aware window");
            return true;
        }
        return false;
    }

    private static boolean isFocusEvent(@NotNull AWTEvent e) {
        if (e == null) {
            IdeEventQueue.$$$reportNull$$$0(55);
        }
        return e.getID() == 1004 || e.getID() == 1005 || e.getID() == 205 || e.getID() == 206 || e.getID() == 208 || e.getID() == 207;
    }

    boolean doPostEvent(@NotNull AWTEvent event) {
        long timeDelta;
        if (event == null) {
            IdeEventQueue.$$$reportNull$$$0(56);
        }
        for (PostEventHook listener2 : this.myPostEventListeners.getListeners()) {
            if (!listener2.consumePostedEvent(event)) continue;
            return false;
        }
        if (event instanceof InvocationEvent && !ClientId.isCurrentlyUnderLocalId() && ClientId.Companion.getPropagateAcrossThreads()) {
            ClientId clientId = ClientId.getCurrent();
            super.postEvent(new InvocationEvent(event.getSource(), () -> ClientId.withClientId((ClientId)clientId, () -> this.dispatchEvent(event))));
            return true;
        }
        if (IdeEventQueue.isKeyboardEvent(event)) {
            this.myKeyboardEventsPosted.incrementAndGet();
            if (ourActionAwareTypeaheadEnabled && this.delayKeyEvents.get()) {
                this.myDelayedKeyEvents.offer((KeyEvent)event);
                if (TYPEAHEAD_LOG.isDebugEnabled()) {
                    TYPEAHEAD_LOG.debug("Waiting for typeahead : " + event);
                }
                return true;
            }
        }
        if (IdeEventQueue.isFocusEvent(event)) {
            this.focusEventsList.add(event);
        }
        if (ourActionAwareTypeaheadEnabled) {
            KeyEvent keyEvent;
            if (event.getID() == 401) {
                keyEvent = (KeyEvent)event;
                KeyStroke keyStrokeToFind = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                boolean thisShortcutMayShowPopup = ContainerUtil.exists(this.getShortcutsShowingPopups(), s -> s instanceof KeyboardShortcut && ((KeyboardShortcut)s).getSecondKeyStroke() == null && ((KeyboardShortcut)s).getFirstKeyStroke().equals(keyStrokeToFind));
                if (!IdeEventQueue.isActionPopupShown() && thisShortcutMayShowPopup && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() instanceof IdeFrame) {
                    if (TYPEAHEAD_LOG.isDebugEnabled()) {
                        TYPEAHEAD_LOG.debug("Delay following events; Focused window is " + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow().getClass().getName());
                    }
                    this.delayKeyEvents.set(true);
                    this.lastTypeaheadTimestamp = System.currentTimeMillis();
                }
            } else if (event.getID() == 402 && ourTypeAheadSearchEverywhereEnabled && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() instanceof IdeFrame && (keyEvent = (KeyEvent)event).getKeyCode() == 16) {
                switch (this.mySearchEverywhereTypeaheadState) {
                    case DEACTIVATED: {
                        this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.TRIGGERED;
                        this.ourLastTimePressed.set(keyEvent.getWhen());
                        break;
                    }
                    case TRIGGERED: {
                        long timeDelta2 = keyEvent.getWhen() - this.ourLastTimePressed.get();
                        if (!IdeEventQueue.isActionPopupShown() && timeDelta2 >= 100L && timeDelta2 <= 500L) {
                            this.delayKeyEvents.set(true);
                            this.lastTypeaheadTimestamp = System.currentTimeMillis();
                            this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DETECTED;
                            break;
                        }
                        this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DEACTIVATED;
                        this.flushDelayedKeyEvents();
                        break;
                    }
                }
            }
            if (this.isTypeaheadTimeoutExceeded()) {
                TYPEAHEAD_LOG.debug("Clear delayed events because of IdeFrame deactivation");
                this.delayKeyEvents.set(false);
                this.flushDelayedKeyEvents();
                this.lastTypeaheadTimestamp = 0L;
                if (ourTypeAheadSearchEverywhereEnabled) {
                    this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DEACTIVATED;
                }
            }
        }
        super.postEvent(event);
        if (ourTypeAheadSearchEverywhereEnabled && event instanceof KeyEvent && (this.mySearchEverywhereTypeaheadState == SearchEverywhereTypeaheadState.TRIGGERED || this.mySearchEverywhereTypeaheadState == SearchEverywhereTypeaheadState.DETECTED) && ((timeDelta = ((KeyEvent)event).getWhen() - this.ourLastTimePressed.get()) < 100L || timeDelta > 500L)) {
            this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DEACTIVATED;
            this.flushDelayedKeyEvents();
        }
        if (ourActionAwareTypeaheadEnabled && IdeEventQueue.doesFocusGoIntoPopup(event)) {
            this.delayKeyEvents.set(false);
            this.postDelayedKeyEvents();
            if (ourTypeAheadSearchEverywhereEnabled) {
                this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DEACTIVATED;
            }
        }
        return true;
    }

    private int numberOfDelayedKeyEvents() {
        return this.myDelayedKeyEvents.size();
    }

    private void postDelayedKeyEvents() {
        KeyEvent event;
        if (TYPEAHEAD_LOG.isDebugEnabled()) {
            TYPEAHEAD_LOG.debug("Stop delaying events. Events to post: " + this.numberOfDelayedKeyEvents());
        }
        while ((event = this.myDelayedKeyEvents.poll()) != null) {
            if (TYPEAHEAD_LOG.isDebugEnabled()) {
                TYPEAHEAD_LOG.debug("Posted after delay: " + event.paramString());
            }
            super.postEvent(event);
        }
        if (TYPEAHEAD_LOG.isDebugEnabled()) {
            TYPEAHEAD_LOG.debug("Events after posting: " + this.numberOfDelayedKeyEvents());
        }
    }

    public void flushDelayedKeyEvents() {
        EventWatcher watcher;
        long startedAt = System.currentTimeMillis();
        if (!IdeEventQueue.isActionPopupShown() && this.delayKeyEvents.compareAndSet(true, false)) {
            this.postDelayedKeyEvents();
        }
        if ((watcher = EventWatcher.getInstance()) != null) {
            watcher.logTimeMillis("IdeEventQueue#flushDelayedKeyEvents", startedAt);
        }
    }

    private static boolean isActionPopupShown() {
        if (ApplicationManager.getApplication() == null) {
            return false;
        }
        ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        return actionManager instanceof ActionManagerImpl && !((ActionManagerImpl)actionManager).isActionPopupStackEmpty() && !((ActionManagerImpl)actionManager).isToolWindowContextMenuVisible();
    }

    @NotNull
    private Set<Shortcut> getShortcutsShowingPopups() {
        Keymap keymap2;
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 != null && !(keymap2 = keymapManager2.getActiveKeymap()).equals(this.lastActiveKeymap.get())) {
            String actionsAwareTypeaheadActionsList = Registry.get((String)"action.aware.typeahead.actions.list").asString();
            this.shortcutsShowingPopups.clear();
            this.actionsShowingPopupsList.addAll(StringUtil.split((String)actionsAwareTypeaheadActionsList, (String)","));
            this.actionsShowingPopupsList.forEach(actionId -> {
                List<Shortcut> shortcuts = Arrays.asList(keymap2.getShortcuts(actionId));
                if (TYPEAHEAD_LOG.isDebugEnabled()) {
                    shortcuts.forEach(s -> TYPEAHEAD_LOG.debug("Typeahead for " + actionId + " : Shortcuts: " + s));
                }
                this.shortcutsShowingPopups.addAll(shortcuts);
            });
            this.lastActiveKeymap = new WeakReference<Keymap>(keymap2);
        }
        Set<Shortcut> set = this.shortcutsShowingPopups;
        if (set == null) {
            IdeEventQueue.$$$reportNull$$$0(57);
        }
        return set;
    }

    private static boolean isKeyboardEvent(@NotNull AWTEvent event) {
        if (event == null) {
            IdeEventQueue.$$$reportNull$$$0(58);
        }
        return event instanceof KeyEvent;
    }

    @Override
    public AWTEvent peekEvent() {
        AWTEvent event = super.peekEvent();
        if (event != null) {
            return event;
        }
        if (this.isTestMode() && LaterInvocator.ensureFlushRequested()) {
            return super.peekEvent();
        }
        return null;
    }

    private boolean isTestMode() {
        Boolean testMode = this.myTestMode;
        if (testMode != null) {
            return testMode;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return false;
        }
        this.myTestMode = testMode = Boolean.valueOf(application.isUnitTestMode());
        return testMode;
    }

    public void addPostEventListener(@NotNull PostEventHook listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            IdeEventQueue.$$$reportNull$$$0(59);
        }
        if (parentDisposable == null) {
            IdeEventQueue.$$$reportNull$$$0(60);
        }
        this.myPostEventListeners.addListener((EventListener)listener2, parentDisposable);
    }

    public static void unsafeNonblockingExecute(@NotNull Runnable r) {
        if (r == null) {
            IdeEventQueue.$$$reportNull$$$0(61);
        }
        assert (EventQueue.isDispatchThread());
        if (Holder.unsafeNonBlockingExecuteRef != null) {
            try {
                Holder.unsafeNonBlockingExecuteRef.invoke((Object)Toolkit.getDefaultToolkit(), r);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        r.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 16: 
            case 26: 
            case 30: 
            case 43: 
            case 44: 
            case 53: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 16: 
            case 26: 
            case 30: 
            case 43: 
            case 44: 
            case 53: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: 
            case 16: 
            case 26: 
            case 30: 
            case 43: 
            case 44: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/IdeEventQueue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "no";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowManager";
                break;
            }
            case 8: 
            case 49: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcher";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 38: 
            case 50: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalComponent";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitCondition";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockMode";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/IdeEventQueue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "runnablesWaitingForFocusChangeState";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrueCurrentEvent";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextEvent";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "mapEvent";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupManager";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyEventDispatcher";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapWindowEvent";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutsShowingPopups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeWhenAllFocusEventsLeftTheQueue";
                break;
            }
            case 1: 
            case 16: 
            case 26: 
            case 30: 
            case 43: 
            case 44: 
            case 53: 
            case 57: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ifFocusEventsInTheQueue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setWindowManager";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addIdleListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeIdleListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addActivityListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDispatcher";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeDispatcher";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsDispatcher";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPostprocessor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removePostprocessor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "_addProcessor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "dispatchEvent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fixNestedSequenceEvent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "dispatchTrayIconEvent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "disableAltGrUnsupportedOnMac";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onFocusEvent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "onActionInvoked";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isMetaKeyPressedOnLinux";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "skipTypedKeyEventsIfFocusReturnsToOwner";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInputEvent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "startActivity";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processException";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mapEvent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mapMetaState";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "_dispatchEvent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processMouseWheelEvent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processIdleActivityListeners";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "dispatchKeyEvent";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "dispatchMouseEvent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "dispatchByCustomDispatchers";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processAppActivationEvent";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "defaultDispatchEvent";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "fixStickyAlt";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "pumpEventsForHierarchy";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "blockNextEvents";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doWhenReady";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "disableInputMethods";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "postEvent";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "doesFocusGoIntoPopup";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "unwrapWindowEvent";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "doesFocusGoIntoPopupFromWindowEvent";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isFocusEvent";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "doPostEvent";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isKeyboardEvent";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addPostEventListener";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "unsafeNonblockingExecute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 16: 
            case 26: 
            case 30: 
            case 43: 
            case 44: 
            case 53: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLastShortcut {
        public final long when;
        public final char keyChar;

        private MyLastShortcut(long when, char keyChar) {
            this.when = when;
            this.keyChar = keyChar;
        }
    }

    private static class Holder {
        private static final Method unsafeNonBlockingExecuteRef = ReflectionUtil.getDeclaredMethod(SunToolkit.class, (String)"unsafeNonblockingExecute", (Class[])new Class[]{Runnable.class});

        private Holder() {
        }
    }

    @FunctionalInterface
    public static interface PostEventHook
    extends EventListener {
        public boolean consumePostedEvent(@NotNull AWTEvent var1);
    }

    public static enum BlockMode {
        COMPLETE,
        ACTIONS;

    }

    private static enum SearchEverywhereTypeaheadState {
        DEACTIVATED,
        TRIGGERED,
        DETECTED;

    }

    private static class SequencedEventNestedFieldHolder {
        private static final Field NESTED_FIELD;
        private static final Method DISPOSE_METHOD;
        private static final Class<?> SEQUENCED_EVENT_CLASS;

        private SequencedEventNestedFieldHolder() {
        }

        private static void invokeDispose(AWTEvent event) {
            try {
                DISPOSE_METHOD.invoke((Object)event, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            try {
                SEQUENCED_EVENT_CLASS = Class.forName("java.awt.SequencedEvent");
                NESTED_FIELD = ReflectionUtil.getDeclaredField(SEQUENCED_EVENT_CLASS, (String)"nested");
                DISPOSE_METHOD = ReflectionUtil.getDeclaredMethod(SEQUENCED_EVENT_CLASS, (String)"dispose", (Class[])new Class[0]);
                if (NESTED_FIELD == null) {
                    throw new RuntimeException();
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class EditingCanceller
    implements EventDispatcher {
        private EditingCanceller() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                EditingCanceller.$$$reportNull$$$0(0);
            }
            return e instanceof KeyEvent && e.getID() == 401 && ((KeyEvent)e).getKeyCode() == 27 && !IdeEventQueue.getInstance().getPopupManager().isPopupActive() && EditingCanceller.cancelCellEditing();
        }

        private static boolean cancelCellEditing() {
            Component owner = ComponentUtil.findParentByCondition((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), component2 -> component2 instanceof JTable || component2 instanceof JTree);
            if (owner instanceof JTable && ((JTable)owner).isEditing()) {
                ((JTable)owner).editingCanceled(null);
                return true;
            }
            if (owner instanceof JTree && ((JTree)owner).isEditing()) {
                ((JTree)owner).cancelEditing();
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/IdeEventQueue$EditingCanceller", "dispatch"));
        }
    }

    private class WindowsUpMaximizer
    implements EventDispatcher {
        private WindowsUpMaximizer() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            Window parent;
            if (e == null) {
                WindowsUpMaximizer.$$$reportNull$$$0(0);
            }
            if (IdeEventQueue.this.myWinMetaPressed && e instanceof KeyEvent && e.getID() == 402 && (((KeyEvent)e).getKeyCode() == 38 || ((KeyEvent)e).getKeyCode() == 40) && (parent = ComponentUtil.getWindow((Component)((KeyEvent)e).getComponent())) instanceof JDialog) {
                JDialog dialog2 = (JDialog)parent;
                SwingUtilities.invokeLater(() -> {
                    if (((KeyEvent)e).getKeyCode() == 38) {
                        MaximizeActiveDialogAction.maximize(dialog2);
                    } else {
                        MaximizeActiveDialogAction.normalize(dialog2);
                    }
                });
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/IdeEventQueue$WindowsUpMaximizer", "dispatch"));
        }
    }

    private static class WindowsAltSuppressor
    implements EventDispatcher {
        private boolean myWaitingForAltRelease;
        private Robot myRobot;

        private WindowsAltSuppressor() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                WindowsAltSuppressor.$$$reportNull$$$0(0);
            }
            return e instanceof KeyEvent && this.dispatchKeyEvent((KeyEvent)e);
        }

        private boolean dispatchKeyEvent(@NotNull KeyEvent ke) {
            boolean pureAlt;
            if (ke == null) {
                WindowsAltSuppressor.$$$reportNull$$$0(1);
            }
            boolean dispatch = true;
            Component component2 = ke.getComponent();
            boolean bl = pureAlt = ke.getKeyCode() == 18 && (ke.getModifiers() | 8) == 8;
            if (!pureAlt) {
                this.myWaitingForAltRelease = false;
            } else {
                UISettings uiSettings = UISettings.getInstanceOrNull();
                if (uiSettings == null || !SystemInfo.isWindows || !Registry.is((String)"actionSystem.win.suppressAlt") || !uiSettings.getHideToolStripes() && !uiSettings.getPresentationMode()) {
                    return false;
                }
                if (ke.getID() == 401) {
                    dispatch = !this.myWaitingForAltRelease;
                } else if (ke.getID() == 402) {
                    if (this.myWaitingForAltRelease) {
                        this.myWaitingForAltRelease = false;
                        dispatch = false;
                    } else if (component2 != null) {
                        SwingUtilities.invokeLater(() -> {
                            try {
                                Window window = ComponentUtil.getWindow((Component)component2);
                                if (window == null || !window.isActive()) {
                                    return;
                                }
                                this.myWaitingForAltRelease = true;
                                if (this.myRobot == null) {
                                    this.myRobot = new Robot();
                                }
                                this.myRobot.keyPress(18);
                                this.myRobot.keyRelease(18);
                            }
                            catch (AWTException e1) {
                                LOG.debug((Throwable)e1);
                            }
                        });
                    }
                }
            }
            return !dispatch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ke";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/IdeEventQueue$WindowsAltSuppressor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatch";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatchKeyEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyFireIdleRequest
    implements Runnable {
        private final Runnable myRunnable;
        private final int myTimeout;

        MyFireIdleRequest(Runnable runnable2, int timeout) {
            if (runnable2 == null) {
                MyFireIdleRequest.$$$reportNull$$$0(0);
            }
            this.myTimeout = timeout;
            this.myRunnable = runnable2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myRunnable.run();
            Object object = IdeEventQueue.this.myLock;
            synchronized (object) {
                if (IdeEventQueue.this.myIdleListeners.contains(this.myRunnable)) {
                    IdeEventQueue.this.myIdleRequestsAlarm.addRequest((Runnable)this, this.myTimeout, ModalityState.NON_MODAL);
                }
            }
        }

        public int getTimeout() {
            return this.myTimeout;
        }

        public String toString() {
            return "Fire idle request. delay: " + this.getTimeout() + "; runnable: " + this.myRunnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/IdeEventQueue$MyFireIdleRequest", "<init>"));
        }
    }

    @FunctionalInterface
    public static interface EventDispatcher {
        public boolean dispatch(@NotNull AWTEvent var1);
    }

    private static class IdeEventQueueHolder {
        private static final IdeEventQueue INSTANCE = new IdeEventQueue();

        private IdeEventQueueHolder() {
        }
    }
}

