/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.os;

import com.intellij.internal.DebugAttachDetector;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/os/SystemRuntimeCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "()V", "getGroupId", "", "getJavaVendor", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getVersion", "", "Companion", "intellij.platform.ide.impl"})
public final class SystemRuntimeCollector
extends ApplicationUsagesCollector {
    private static final HashSet<String> knownOptions;
    public static final Companion Companion;

    @NotNull
    public String getGroupId() {
        return "system.runtime";
    }

    public int getVersion() {
        return 3;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        Runtime.getRuntime().totalMemory();
        int cores = Runtime.getRuntime().availableProcessors();
        result2.add(MetricEventFactoryKt.newMetric((String)"cores", (int)cores, null));
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            FeatureUsageData featureUsageData = new FeatureUsageData();
            GarbageCollectorMXBean garbageCollectorMXBean = gc;
            Intrinsics.checkExpressionValueIsNotNull((Object)garbageCollectorMXBean, (String)"gc");
            String string = garbageCollectorMXBean.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gc.name");
            result2.add(MetricEventFactoryKt.newMetric((String)"garbage.collector", (FeatureUsageData)featureUsageData.addData("name", string)));
        }
        FeatureUsageData jvmData = new FeatureUsageData().addVersion(new Version(1, JavaVersion.current().feature, 0)).addData("bit", SystemInfo.is32Bit ? "32" : "64").addData("vendor", this.getJavaVendor());
        result2.add(MetricEventFactoryKt.newMetric((String)"jvm", (FeatureUsageData)jvmData));
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Intrinsics.checkExpressionValueIsNotNull((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
        Iterator<String> iterator2 = runtimeMXBean.getInputArguments().iterator();
        while (iterator2.hasNext()) {
            String argument;
            String string = argument = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"argument");
            FeatureUsageData data2 = Companion.convertOptionToData(string);
            if (data2 == null) continue;
            result2.add(MetricEventFactoryKt.newMetric((String)"jvm.option", (FeatureUsageData)data2));
        }
        result2.add(MetricEventFactoryKt.newBooleanMetric((String)"debug.agent", (boolean)DebugAttachDetector.isDebugEnabled()));
        return result2;
    }

    private final String getJavaVendor() {
        return SystemInfo.isJetBrainsJvm ? "JetBrains" : (SystemInfo.isAppleJvm ? "Apple" : (SystemInfo.isOracleJvm ? "Oracle" : (SystemInfo.isSunJvm ? "Sun" : (SystemInfo.isIbmJvm ? "IBM" : (SystemInfo.isAzulJvm ? "Azul" : "Other")))));
    }

    static {
        Companion = new Companion(null);
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new String[]{"-Xms", "-Xmx", "-XX:SoftRefLRUPolicyMSPerMB", "-XX:ReservedCodeCacheSize"});
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"ContainerUtil.newHashSet\u2026ervedCodeCacheSize\"\n    )");
        knownOptions = hashSet;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\u0011\u001a\u00020\u0012\"\u00020\u000fR!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/os/SystemRuntimeCollector$Companion;", "", "()V", "knownOptions", "Ljava/util/HashSet;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "convertOptionToData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "arg", "getMegabytes", "", "s", "roundDown", "", "value", "steps", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @Nullable
        public final FeatureUsageData convertOptionToData(@NotNull String arg) {
            Intrinsics.checkParameterIsNotNull((Object)arg, (String)"arg");
            long value2 = this.getMegabytes(arg);
            if (value2 < 0L) {
                return null;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-Xmx", (boolean)false, (int)2, null)) {
                return new FeatureUsageData().addData("name", "Xmx").addData("value", this.roundDown(value2, 512L, 750L, 1000L, 1024L, 1500L, 2000L, 2048L, 3000L, 4000L, 4096L, 6000L, 8000L));
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-Xms", (boolean)false, (int)2, null)) {
                return new FeatureUsageData().addData("name", "Xms").addData("value", this.roundDown(value2, 64L, 128L, 256L, 512L));
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-XX:SoftRefLRUPolicyMSPerMB", (boolean)false, (int)2, null)) {
                return new FeatureUsageData().addData("name", "SoftRefLRUPolicyMSPerMB").addData("value", this.roundDown(value2, 50L, 100L));
            }
            if (StringsKt.startsWith$default((String)arg, (String)"-XX:ReservedCodeCacheSize", (boolean)false, (int)2, null)) {
                return new FeatureUsageData().addData("name", "ReservedCodeCacheSize").addData("value", this.roundDown(value2, 240L, 300L, 400L, 500L));
            }
            return null;
        }

        private final int getMegabytes(String s) {
            String num;
            String string;
            Object v1;
            int $i$f$firstOrNull;
            Object $this$firstOrNull$iv2;
            block20: {
                $this$firstOrNull$iv2 = knownOptions;
                $i$f$firstOrNull = 0;
                Iterator iterator2 = $this$firstOrNull$iv2.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    String it = (String)element$iv;
                    boolean bl = false;
                    String string2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
                    if (!StringsKt.startsWith$default((String)s, (String)string2, (boolean)false, (int)2, null)) continue;
                    v1 = element$iv;
                    break block20;
                }
                v1 = null;
            }
            String string3 = v1;
            if (string3 != null) {
                $this$firstOrNull$iv2 = string3;
                $i$f$firstOrNull = 0;
                boolean bl = false;
                Object it = $this$firstOrNull$iv2;
                boolean bl2 = false;
                String string4 = s;
                int n = ((String)it).length();
                boolean bl3 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                string4 = string6;
                n = 0;
                String string7 = string4;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toUpperCase()");
                string4 = string8;
                n = 0;
                String string9 = string4;
                if (string9 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string9)).toString();
            } else {
                string = num = null;
            }
            if (num == null) {
                return -1;
            }
            if (StringsKt.startsWith$default(num, (String)"=", (boolean)false, (int)2, null)) {
                $this$firstOrNull$iv2 = num;
                $i$f$firstOrNull = 1;
                boolean bl = false;
                String string10 = ((String)$this$firstOrNull$iv2).substring($i$f$firstOrNull);
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
                num = string10;
            }
            int $this$firstOrNull$iv2 = StringsKt.last((CharSequence)num);
            $i$f$firstOrNull = 0;
            if (Character.isDigit((char)$this$firstOrNull$iv2)) {
                try {
                    $this$firstOrNull$iv2 = Integer.parseInt(num);
                }
                catch (Exception e) {
                    $this$firstOrNull$iv2 = -1;
                }
                return $this$firstOrNull$iv2;
            }
            try {
                String string11 = num;
                int n = 0;
                int n2 = num.length() - 1;
                boolean bl = false;
                String string12 = string11;
                if (string12 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string13 = string12.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                int size = Integer.parseInt(string13);
                switch (StringsKt.last((CharSequence)num)) {
                    case 'B': {
                        return size / 0x100000;
                    }
                    case 'K': {
                        return size / 1024;
                    }
                    case 'M': {
                        return size;
                    }
                    case 'G': {
                        return size * 1024;
                    }
                }
            }
            catch (Exception e) {
                return -1;
            }
            return -1;
        }

        public final long roundDown(long value2, long ... steps) {
            int ind;
            Intrinsics.checkParameterIsNotNull((Object)steps, (String)"steps");
            int length = steps.length;
            if (length == 0 || steps[0] < 0L) {
                return -1L;
            }
            for (ind = 0; ind < length && value2 >= steps[ind]; ++ind) {
            }
            return ind == 0 ? 0L : steps[ind - 1];
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

