/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EscapeAction
extends EditorAction {
    public EscapeAction() {
        super((EditorActionHandler)new Handler());
        this.setInjectedContext(true);
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            EditorEx editorEx;
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (editor instanceof EditorEx && (editorEx = (EditorEx)editor).isStickySelection()) {
                editorEx.setStickySelection(false);
            }
            boolean scrollNeeded = editor.getCaretModel().getCaretCount() > 1;
            Handler.retainOldestCaret(editor.getCaretModel());
            editor.getSelectionModel().removeSelection();
            if (scrollNeeded) {
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private static void retainOldestCaret(CaretModel caretModel) {
            while (caretModel.getCaretCount() > 1) {
                caretModel.removeCaret(caretModel.getPrimaryCaret());
            }
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if (editor.isOneLineMode() && Boolean.TRUE.equals(PlatformDataKeys.IS_MODAL_CONTEXT.getData(dataContext))) {
                return false;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            CaretModel caretModel = editor.getCaretModel();
            return selectionModel.hasSelection() || caretModel.getCaretCount() > 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/EscapeAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

