/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkProduct;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u0011H\u0014J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001fJ1\u0010!\u001a\u00020\"\"\u0006\b\u0000\u0010#\u0018\u0001*\b\u0012\u0004\u0012\u0002H#0$2\u0014\b\u0004\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\"0&H\u0082\bJ#\u0010'\u001a\u00020\"*\u00020\r2\u0014\b\u0004\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\"0&H\u0082\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloadDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "items", "", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Lcom/intellij/openapi/projectRoots/SdkTypeId;Ljava/util/List;)V", "installDirTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getItems", "()Ljava/util/List;", "panel", "Ljavax/swing/JComponent;", "getParentComponent", "()Ljava/awt/Component;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdkType", "()Lcom/intellij/openapi/projectRoots/SdkTypeId;", "selectedItem", "selectedPath", "", "createCenterPanel", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "selectJdkAndPath", "Lkotlin/Pair;", "Ljava/io/File;", "onSelectionChange", "", "T", "Lcom/intellij/openapi/ui/ComboBox;", "action", "Lkotlin/Function1;", "onTextChange", "intellij.platform.lang.impl"})
public final class JdkDownloadDialog
extends DialogWrapper {
    private final JComponent panel;
    private TextFieldWithBrowseButton installDirTextField;
    private JdkItem selectedItem;
    private String selectedPath;
    @Nullable
    private final Project project;
    @Nullable
    private final Component parentComponent;
    @NotNull
    private final SdkTypeId sdkType;
    @NotNull
    private final List<JdkItem> items;

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo validationInfo;
        String error;
        ValidationInfo validationInfo2 = super.doValidate();
        if (validationInfo2 != null) {
            ValidationInfo validationInfo3 = validationInfo2;
            boolean bl = false;
            boolean bl2 = false;
            ValidationInfo it = validationInfo3;
            boolean bl3 = false;
            return it;
        }
        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
        String string = this.selectedPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPath");
        }
        Object object = jdkInstaller.validateInstallDir(string);
        String string2 = error = (String)object.component2();
        if (string2 != null) {
            object = string2;
            boolean bl = false;
            boolean bl4 = false;
            Object it = object;
            boolean bl5 = false;
            validationInfo = new ValidationInfo(error, (JComponent)this.installDirTextField);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    @Nullable
    public final Pair<JdkItem, File> selectJdkAndPath() {
        Pair<File, String> pair;
        File selectedFile;
        if (!this.showAndGet()) {
            return null;
        }
        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
        String string = this.selectedPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPath");
        }
        if ((selectedFile = (File)(pair = jdkInstaller.validateInstallDir(string)).component1()) == null) {
            return null;
        }
        JdkItem jdkItem = this.selectedItem;
        if (jdkItem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedItem");
        }
        return TuplesKt.to((Object)jdkItem, (Object)selectedFile);
    }

    private final void onTextChange(@NotNull TextFieldWithBrowseButton $this$onTextChange, Function1<? super String, Unit> action2) {
        int $i$f$onTextChange = 0;
        JTextField jTextField = $this$onTextChange.getTextField();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter($this$onTextChange, action2){
            final /* synthetic */ TextFieldWithBrowseButton $this_onTextChange;
            final /* synthetic */ Function1 $action;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                String string = this.$this_onTextChange.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                this.$action.invoke((Object)string);
            }
            {
                this.$this_onTextChange = $receiver;
                this.$action = $captured_local_variable$1;
            }
        });
    }

    private final /* synthetic */ <T> void onSelectionChange(@NotNull ComboBox<T> $this$onSelectionChange, Function1<? super T, Unit> action2) {
        int $i$f$onSelectionChange = 0;
        Intrinsics.needClassReification();
        $this$onSelectionChange.addItemListener(new ItemListener(action2){
            final /* synthetic */ Function1 $action;

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1) {
                    Object object = e.getItem();
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    this.$action.invoke(object);
                }
            }
            {
                this.$action = function1;
            }
        });
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Component getParentComponent() {
        return this.parentComponent;
    }

    @NotNull
    public final SdkTypeId getSdkType() {
        return this.sdkType;
    }

    @NotNull
    public final List<JdkItem> getItems() {
        return this.items;
    }

    /*
     * WARNING - void declaration
     */
    public JdkDownloadDialog(@Nullable Project project, @Nullable Component parentComponent, @NotNull SdkTypeId sdkType, @NotNull List<JdkItem> items) {
        void constraints$iv;
        LayoutBuilder builder$iv;
        LCFlags[] $this$onTextChange$iv;
        ComboBox $this$onSelectionChange$iv;
        Collection<JdkProduct> collection;
        void $this$mapTo$iv$iv;
        Object element$iv$iv2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)sdkType, (String)"sdkType");
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        super(project, parentComponent, false, DialogWrapper.IdeModalityType.PROJECT);
        this.project = project;
        this.parentComponent = parentComponent;
        this.sdkType = sdkType;
        this.items = items;
        this.setTitle(ProjectBundle.message((String)"dialog.title.download.jdk", (Object[])new Object[0]));
        this.setResizable(false);
        Object $this$filter$iv = this.items;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            JdkItem it = (JdkItem)element$iv$iv2;
            boolean bl = false;
            if (!it.isDefaultItem()) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        JdkItem jdkItem = (JdkItem)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (jdkItem == null) {
            jdkItem = (JdkItem)CollectionsKt.firstOrNull(this.items);
        }
        if (jdkItem == null) {
            $this$filter$iv = "There must be at least one JDK to install";
            $i$f$filter = false;
            throw (Throwable)new IllegalStateException($this$filter$iv.toString());
        }
        JdkItem defaultItem = jdkItem;
        Iterable $this$map$iv = this.items;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JdkItem bl = (JdkItem)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            JdkProduct jdkProduct = it.getProduct();
            collection.add(jdkProduct);
        }
        collection = (List)destination$iv$iv2;
        Collection $this$toTypedArray$iv = CollectionsKt.distinct((Iterable)collection);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        JdkProduct[] jdkProductArray = thisCollection$iv.toArray(new JdkProduct[0]);
        if (jdkProductArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Collection<JdkProduct> collection2 = collection = jdkProductArray;
        ComboBox vendorComboBox = new ComboBox(collection2);
        vendorComboBox.setSelectedItem((Object)defaultItem.getProduct());
        vendorComboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdkProduct>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JdkProduct> list2, @Nullable JdkProduct value2, int index, boolean selected2, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                if (value2 == null) {
                    return;
                }
                this.append(value2.getPackagePresentationText());
            }
        });
        vendorComboBox.setSwingPopup(false);
        final DefaultComboBoxModel versionModel = new DefaultComboBoxModel();
        ComboBox versionComboBox = new ComboBox((ComboBoxModel)versionModel);
        versionComboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdkItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JdkItem> list2, @Nullable JdkItem value2, int index, boolean selected2, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                if (value2 == null) {
                    return;
                }
                this.append(value2.getVersionPresentationText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(" ");
                this.append(value2.getDownloadSizePresentationText(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        });
        versionComboBox.setSwingPopup(false);
        Function1<JdkProduct, Unit> $fun$selectVersions$3 = new Function1<JdkProduct, Unit>(){

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull JdkProduct newProduct) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)newProduct, (String)"newProduct");
                Iterable $this$filter$iv = this.getItems();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    JdkItem it = (JdkItem)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getProduct(), (Object)newProduct)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List newVersions = (List)destination$iv$iv;
                versionModel.removeAllElements();
                for (JdkItem version2 : newVersions) {
                    versionModel.addElement(version2);
                }
            }
        };
        String string = ProjectBundle.message((String)"dialog.title.select.path.to.install.jdk", (Object[])new Object[0]);
        FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor2, (String)"FileChooserDescriptorFac\u2026eSingleFolderDescriptor()");
        this.installDirTextField = ComponentsKt.textFieldWithBrowseButton$default(this.project, string, fileChooserDescriptor2, null, 8, null);
        Function1<JdkItem, Unit> $fun$selectInstallPath$4 = new Function1<JdkItem, Unit>(){

            public final void invoke(@NotNull JdkItem newVersion) {
                Intrinsics.checkParameterIsNotNull((Object)newVersion, (String)"newVersion");
                installDirTextField.setText(JdkInstaller.Companion.getInstance().defaultInstallDir(newVersion).getPath());
                selectedItem = newVersion;
            }
        };
        element$iv$iv2 = vendorComboBox;
        JdkDownloadDialog this_$iv = this;
        boolean $i$f$onSelectionChange = false;
        $this$onSelectionChange$iv.addItemListener(new ItemListener($fun$selectVersions$3){
            final /* synthetic */ 3 $selectVersions$3$inlined;
            {
                this.$selectVersions$3$inlined = var1_1;
            }

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1) {
                    JdkProduct p1 = (JdkProduct)e.getItem();
                    boolean bl = false;
                    this.$selectVersions$3$inlined.invoke(p1);
                }
            }
        });
        $this$onSelectionChange$iv = versionComboBox;
        this_$iv = this;
        $i$f$onSelectionChange = false;
        $this$onSelectionChange$iv.addItemListener(new ItemListener($fun$selectInstallPath$4){
            final /* synthetic */ 4 $selectInstallPath$4$inlined;
            {
                this.$selectInstallPath$4$inlined = var1_1;
            }

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1) {
                    JdkItem p1 = (JdkItem)e.getItem();
                    boolean bl = false;
                    this.$selectInstallPath$4$inlined.invoke(p1);
                }
            }
        });
        $this$onSelectionChange$iv = this.installDirTextField;
        this_$iv = this;
        boolean $i$f$onTextChange = false;
        JTextField jTextField = $this$onTextChange$iv.getTextField();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((TextFieldWithBrowseButton)$this$onTextChange$iv, this){
            final /* synthetic */ TextFieldWithBrowseButton $this_onTextChange;
            final /* synthetic */ JdkDownloadDialog this$0;
            {
                this.$this_onTextChange = $receiver;
                this.this$0 = jdkDownloadDialog;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                String string = this.$this_onTextChange.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                String it = string;
                boolean bl = false;
                JdkDownloadDialog.access$setSelectedPath$p(this.this$0, it);
            }
        });
        $this$onTextChange$iv = new LCFlags[]{};
        JdkDownloadDialog jdkDownloadDialog = this;
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, ProjectBundle.message((String)"dialog.row.jdk.vendor", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this, vendorComboBox, versionComboBox){
            final /* synthetic */ JdkDownloadDialog this$0;
            final /* synthetic */ ComboBox $vendorComboBox$inlined;
            final /* synthetic */ ComboBox $versionComboBox$inlined;
            {
                this.this$0 = jdkDownloadDialog;
                this.$vendorComboBox$inlined = comboBox2;
                this.$versionComboBox$inlined = comboBox3;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, (JComponent)this.$vendorComboBox$inlined, new CCFlags[0], null, null, 6, null).sizeGroup("combo").focused();
            }
        }, 2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, ProjectBundle.message((String)"dialog.row.jdk.version", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this, vendorComboBox, versionComboBox){
            final /* synthetic */ JdkDownloadDialog this$0;
            final /* synthetic */ ComboBox $vendorComboBox$inlined;
            final /* synthetic */ ComboBox $versionComboBox$inlined;
            {
                this.this$0 = jdkDownloadDialog;
                this.$vendorComboBox$inlined = comboBox2;
                this.$versionComboBox$inlined = comboBox3;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, (JComponent)this.$versionComboBox$inlined, new CCFlags[0], null, null, 6, null).sizeGroup("combo");
            }
        }, 2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, ProjectBundle.message((String)"dialog.row.jdk.location", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this, vendorComboBox, versionComboBox){
            final /* synthetic */ JdkDownloadDialog this$0;
            final /* synthetic */ ComboBox $vendorComboBox$inlined;
            final /* synthetic */ ComboBox $versionComboBox$inlined;
            {
                this.this$0 = jdkDownloadDialog;
                this.$vendorComboBox$inlined = comboBox2;
                this.$versionComboBox$inlined = comboBox3;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, (JComponent)JdkDownloadDialog.access$getInstallDirTextField$p(this.this$0), new CCFlags[0], null, null, 6, null);
            }
        }, 2, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        DialogPanel dialogPanel = panel$iv;
        jdkDownloadDialog.panel = (JComponent)dialogPanel;
        this.myOKAction.putValue("Name", ProjectBundle.message((String)"dialog.button.download.jdk", (Object[])new Object[0]));
        this.init();
        $fun$selectVersions$3.invoke(defaultItem.getProduct());
    }

    public static final /* synthetic */ void access$setInstallDirTextField$p(JdkDownloadDialog $this, TextFieldWithBrowseButton textFieldWithBrowseButton2) {
        $this.installDirTextField = textFieldWithBrowseButton2;
    }

    public static final /* synthetic */ JdkItem access$getSelectedItem$p(JdkDownloadDialog $this) {
        JdkItem jdkItem = $this.selectedItem;
        if (jdkItem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedItem");
        }
        return jdkItem;
    }

    public static final /* synthetic */ String access$getSelectedPath$p(JdkDownloadDialog $this) {
        String string = $this.selectedPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPath");
        }
        return string;
    }

    public static final /* synthetic */ void access$setSelectedPath$p(JdkDownloadDialog $this, String string) {
        $this.selectedPath = string;
    }
}

