/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.contentQueue;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.contentQueue.CachedFileContent;
import com.intellij.util.indexing.contentQueue.CachedFileContentLoader;
import com.intellij.util.indexing.contentQueue.CurrentProjectHintedCachedFileContentLoader;
import com.intellij.util.indexing.contentQueue.FailedToLoadContentException;
import com.intellij.util.indexing.contentQueue.TooLargeContentException;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.diagnostic.IndexingJobStatistics;
import com.intellij.util.indexing.diagnostic.TooLargeForIndexingFile;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexUpdateRunner {
    private static final long SOFT_MAX_TOTAL_BYTES_LOADED_INTO_MEMORY = 0x1400000L;
    private static final CopyOnWriteArrayList<IndexingJob> ourIndexingJobs = new CopyOnWriteArrayList();
    private final FileBasedIndexImpl myFileBasedIndex;
    private final ExecutorService myIndexingExecutor;
    private final int myNumberOfIndexingThreads;
    private static long ourTotalBytesLoadedIntoMemory = 0L;
    private static final Lock ourLoadedBytesLimitLock = new ReentrantLock();
    private static final Condition ourLoadedBytesAreReleasedCondition = ourLoadedBytesLimitLock.newCondition();

    public IndexUpdateRunner(@NotNull FileBasedIndexImpl fileBasedIndex, @NotNull ExecutorService indexingExecutor, int numberOfIndexingThreads) {
        if (fileBasedIndex == null) {
            IndexUpdateRunner.$$$reportNull$$$0(0);
        }
        if (indexingExecutor == null) {
            IndexUpdateRunner.$$$reportNull$$$0(1);
        }
        this.myFileBasedIndex = fileBasedIndex;
        this.myIndexingExecutor = indexingExecutor;
        this.myNumberOfIndexingThreads = numberOfIndexingThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public IndexingJobStatistics indexFiles(@NotNull Project project, @NotNull Collection<VirtualFile> files2, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            IndexUpdateRunner.$$$reportNull$$$0(2);
        }
        if (files2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            IndexUpdateRunner.$$$reportNull$$$0(4);
        }
        indicator.checkCanceled();
        indicator.setIndeterminate(false);
        CurrentProjectHintedCachedFileContentLoader contentLoader = new CurrentProjectHintedCachedFileContentLoader(project);
        IndexingJob indexingJob = new IndexingJob(project, indicator, contentLoader, files2);
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            while (!indexingJob.areAllFilesProcessed()) {
                this.indexOneFileOfJob(indexingJob);
            }
        } else {
            ourIndexingJobs.add(indexingJob);
            try {
                Throwable error;
                AtomicInteger numberOfRunningWorkers = new AtomicInteger();
                Runnable worker = () -> {
                    try {
                        this.indexJobsFairly();
                    }
                    finally {
                        numberOfRunningWorkers.decrementAndGet();
                    }
                };
                for (int i2 = 0; i2 < this.myNumberOfIndexingThreads; ++i2) {
                    this.myIndexingExecutor.execute(worker);
                    numberOfRunningWorkers.incrementAndGet();
                }
                while (!project.isDisposed() && !indexingJob.areAllFilesProcessed() && indexingJob.myError.get() == null) {
                    if (numberOfRunningWorkers.get() < this.myNumberOfIndexingThreads) {
                        this.myIndexingExecutor.execute(worker);
                        numberOfRunningWorkers.incrementAndGet();
                    }
                    indicator.checkCanceled();
                    try {
                        if (!indexingJob.myAllFilesAreProcessedLatch.await(100L, TimeUnit.MILLISECONDS)) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new ProcessCanceledException((Throwable)e);
                    }
                }
                if ((error = indexingJob.myError.get()) instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)error;
                }
                if (error != null) {
                    throw new RuntimeException("Indexing of " + project.getName() + " has failed", error);
                }
            }
            finally {
                ourIndexingJobs.remove(indexingJob);
            }
        }
        IndexingJobStatistics indexingJobStatistics = indexingJob.myStatistics;
        if (indexingJobStatistics == null) {
            IndexUpdateRunner.$$$reportNull$$$0(5);
        }
        return indexingJobStatistics;
    }

    private void indexJobsFairly() {
        while (!ourIndexingJobs.isEmpty()) {
            for (IndexingJob job2 : ourIndexingJobs) {
                if (job2.myProject.isDisposed() || job2.myNoMoreFilesInQueue.get() || job2.myIndicator.isCanceled() || job2.myError.get() != null) {
                    ourIndexingJobs.remove(job2);
                    continue;
                }
                try {
                    this.indexOneFileOfJob(job2);
                }
                catch (Throwable e) {
                    job2.myError.compareAndSet(null, e);
                    ourIndexingJobs.remove(job2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexOneFileOfJob(@NotNull IndexingJob indexingJob) throws ProcessCanceledException {
        ContentLoadingResult loadingResult;
        if (indexingJob == null) {
            IndexUpdateRunner.$$$reportNull$$$0(6);
        }
        long contentLoadingTime = System.nanoTime();
        try {
            loadingResult = this.loadNextContent(indexingJob, indexingJob.myIndicator);
        }
        catch (TooLargeContentException e) {
            indexingJob.oneMoreFileProcessed();
            indexingJob.myStatistics.getNumberOfTooLargeForIndexingFiles().incrementAndGet();
            indexingJob.myStatistics.getTooLargeForIndexingFiles().addElement(new TooLargeForIndexingFile(e.getFile().getName(), e.getFile().getLength()));
            FileBasedIndexImpl.LOG.info("File: " + e.getFile().getUrl() + " is too large for indexing");
            return;
        }
        catch (FailedToLoadContentException e) {
            indexingJob.oneMoreFileProcessed();
            IndexUpdateRunner.logFailedToLoadContentException(e);
            return;
        }
        finally {
            contentLoadingTime = System.nanoTime() - contentLoadingTime;
        }
        if (loadingResult == null) {
            return;
        }
        CachedFileContent fileContent = loadingResult.cachedFileContent;
        VirtualFile file2 = fileContent.getVirtualFile();
        try {
            indexingJob.setLocationBeingIndexed(file2);
            if (!file2.isDirectory()) {
                FileIndexingStatistics fileIndexingStatistics = (FileIndexingStatistics)ReadAction.nonBlocking(() -> this.myFileBasedIndex.indexFileContent(indexingJob.myProject, fileContent)).expireWith((Disposable)indexingJob.myProject).wrapProgress(indexingJob.myIndicator).executeSynchronously();
                indexingJob.myStatistics.addFileStatistics(fileIndexingStatistics, contentLoadingTime, loadingResult.fileLength);
            }
            indexingJob.oneMoreFileProcessed();
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        catch (Throwable e) {
            indexingJob.oneMoreFileProcessed();
            FileBasedIndexImpl.LOG.error("Error while indexing " + file2.getPresentableUrl() + "\nTo reindex this file IDEA has to be restarted", e);
        }
        finally {
            IndexUpdateRunner.signalThatFileIsUnloaded(loadingResult.fileLength);
        }
    }

    @Nullable
    private ContentLoadingResult loadNextContent(@NotNull IndexingJob indexingJob, @NotNull ProgressIndicator indicator) throws FailedToLoadContentException, TooLargeContentException, ProcessCanceledException {
        long fileLength;
        VirtualFile file2;
        if (indexingJob == null) {
            IndexUpdateRunner.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            IndexUpdateRunner.$$$reportNull$$$0(8);
        }
        if ((file2 = (VirtualFile)indexingJob.myQueueOfFiles.poll()) == null) {
            indexingJob.myNoMoreFilesInQueue.set(true);
            return null;
        }
        if (this.myFileBasedIndex.isTooLarge(file2)) {
            throw new TooLargeContentException(file2);
        }
        try {
            fileLength = file2.getLength();
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        catch (Throwable e) {
            throw new FailedToLoadContentException(file2, e);
        }
        try {
            IndexUpdateRunner.waitForFreeMemoryToLoadFileContent(indicator, fileLength);
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        try {
            CachedFileContent fileContent = indexingJob.myContentLoader.loadContent(file2);
            return new ContentLoadingResult(fileContent, fileLength);
        }
        catch (ProcessCanceledException e) {
            IndexUpdateRunner.signalThatFileIsUnloaded(fileLength);
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        catch (FailedToLoadContentException | TooLargeContentException e) {
            IndexUpdateRunner.signalThatFileIsUnloaded(fileLength);
            throw e;
        }
        catch (Throwable e) {
            IndexUpdateRunner.signalThatFileIsUnloaded(fileLength);
            ExceptionUtil.rethrow((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForFreeMemoryToLoadFileContent(@NotNull ProgressIndicator indicator, long fileLength) throws ProcessCanceledException {
        if (indicator == null) {
            IndexUpdateRunner.$$$reportNull$$$0(9);
        }
        ourLoadedBytesLimitLock.lock();
        try {
            while (ourTotalBytesLoadedIntoMemory >= 0x1400000L) {
                indicator.checkCanceled();
                try {
                    ourLoadedBytesAreReleasedCondition.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException((Throwable)e);
                }
            }
            ourTotalBytesLoadedIntoMemory += fileLength;
        }
        finally {
            ourLoadedBytesLimitLock.unlock();
        }
    }

    private static void signalThatFileIsUnloaded(long fileLength) {
        ourLoadedBytesLimitLock.lock();
        try {
            assert (ourTotalBytesLoadedIntoMemory >= fileLength);
            if ((ourTotalBytesLoadedIntoMemory -= fileLength) < 0x1400000L) {
                ourLoadedBytesAreReleasedCondition.signalAll();
            }
        }
        finally {
            ourLoadedBytesLimitLock.unlock();
        }
    }

    private static void logFailedToLoadContentException(@NotNull FailedToLoadContentException e) {
        if (e == null) {
            IndexUpdateRunner.$$$reportNull$$$0(10);
        }
        Throwable cause = e.getCause();
        VirtualFile file2 = e.getFile();
        String fileUrl = "File: " + file2.getUrl();
        if (cause instanceof FileNotFoundException || cause instanceof NoSuchFileException) {
            FileBasedIndexImpl.LOG.debug(fileUrl, (Throwable)e);
        } else if (cause instanceof IndexOutOfBoundsException || cause instanceof InvalidVirtualFileAccessException) {
            FileBasedIndexImpl.LOG.info(fileUrl, (Throwable)e);
        } else {
            FileBasedIndexImpl.LOG.error(fileUrl, (Throwable)e);
        }
    }

    @NotNull
    public static String getPresentableLocationBeingIndexed(@NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile actualFile;
        if (project == null) {
            IndexUpdateRunner.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(12);
        }
        if ((actualFile = file2).getFileSystem() instanceof ArchiveFileSystem) {
            actualFile = VfsUtil.getLocalFile((VirtualFile)actualFile);
        }
        String string = FileUtil.toSystemDependentName((String)IndexUpdateRunner.getProjectRelativeOrAbsolutePath(project, actualFile));
        if (string == null) {
            IndexUpdateRunner.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getProjectRelativeOrAbsolutePath(@NotNull Project project, @NotNull VirtualFile file2) {
        String filePath;
        String projectBase;
        if (project == null) {
            IndexUpdateRunner.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(15);
        }
        if (StringUtil.isNotEmpty((String)(projectBase = project.getBasePath())) && FileUtil.isAncestor((String)projectBase, (String)(filePath = file2.getPath()), (boolean)true)) {
            String projectDirName = PathUtil.getFileName((String)projectBase);
            String relativePath = FileUtil.getRelativePath((String)projectBase, (String)filePath, (char)'/');
            if (StringUtil.isNotEmpty((String)projectDirName) && StringUtil.isNotEmpty((String)relativePath)) {
                String string = projectDirName + "/" + relativePath;
                if (string == null) {
                    IndexUpdateRunner.$$$reportNull$$$0(16);
                }
                return string;
            }
        }
        String string = file2.getPath();
        if (string == null) {
            IndexUpdateRunner.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingExecutor";
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingJob";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "indexFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableLocationBeingIndexed";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRelativeOrAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indexFiles";
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "indexOneFileOfJob";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadNextContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "waitForFreeMemoryToLoadFileContent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logFailedToLoadContentException";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableLocationBeingIndexed";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRelativeOrAbsolutePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IndexingJob {
        final Project myProject;
        final CachedFileContentLoader myContentLoader;
        final BlockingQueue<VirtualFile> myQueueOfFiles;
        final ProgressIndicator myIndicator;
        final int myTotalFiles;
        final AtomicBoolean myNoMoreFilesInQueue;
        final CountDownLatch myAllFilesAreProcessedLatch;
        final IndexingJobStatistics myStatistics;
        final AtomicReference<Throwable> myError;

        IndexingJob(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull CachedFileContentLoader contentLoader, @NotNull Collection<VirtualFile> files2) {
            if (project == null) {
                IndexingJob.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                IndexingJob.$$$reportNull$$$0(1);
            }
            if (contentLoader == null) {
                IndexingJob.$$$reportNull$$$0(2);
            }
            if (files2 == null) {
                IndexingJob.$$$reportNull$$$0(3);
            }
            this.myNoMoreFilesInQueue = new AtomicBoolean();
            this.myStatistics = new IndexingJobStatistics();
            this.myError = new AtomicReference();
            this.myProject = project;
            this.myIndicator = indicator;
            this.myTotalFiles = files2.size();
            this.myContentLoader = contentLoader;
            this.myQueueOfFiles = new ArrayBlockingQueue<VirtualFile>(files2.size(), false, files2);
            this.myAllFilesAreProcessedLatch = new CountDownLatch(files2.size());
        }

        public void oneMoreFileProcessed() {
            this.myAllFilesAreProcessedLatch.countDown();
            double newFraction = 1.0 - (double)this.myAllFilesAreProcessedLatch.getCount() / (double)this.myTotalFiles;
            try {
                this.myIndicator.setFraction(newFraction);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean areAllFilesProcessed() {
            return this.myAllFilesAreProcessedLatch.getCount() == 0L;
        }

        public void setLocationBeingIndexed(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                IndexingJob.$$$reportNull$$$0(4);
            }
            String presentableLocation = IndexUpdateRunner.getPresentableLocationBeingIndexed(this.myProject, virtualFile);
            if (this.myIndicator instanceof SubTaskProgressIndicator) {
                this.myIndicator.setText(presentableLocation);
            } else {
                this.myIndicator.setText2(presentableLocation);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentLoader";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$IndexingJob";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLocationBeingIndexed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ContentLoadingResult {
        @NotNull
        final CachedFileContent cachedFileContent;
        final long fileLength;

        private ContentLoadingResult(@NotNull CachedFileContent cachedFileContent, long fileLength) {
            if (cachedFileContent == null) {
                ContentLoadingResult.$$$reportNull$$$0(0);
            }
            this.cachedFileContent = cachedFileContent;
            this.fileLength = fileLength;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedFileContent", "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$ContentLoadingResult", "<init>"));
        }
    }
}

