/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.DefaultCustomComponentAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeSearchSession;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeSpeedSearch;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n*\u0001\u000b\b\u0000\u0018\u0000 12\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u000212B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0010H\u0002J\b\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001aH\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010+\u001a\u00020\u001fH\u0016J\b\u0010,\u001a\u00020\u0014H\u0002J\b\u0010-\u001a\u00020\u001fH\u0016J\b\u0010.\u001a\u00020\u001fH\u0016J\b\u0010/\u001a\u00020\u001fH\u0016J\b\u00100\u001a\u00020\u001fH\u0016R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSearchSession;", "Lcom/intellij/find/SearchSession;", "Lcom/intellij/find/FindModel$FindModelObserver;", "Lcom/intellij/find/SearchReplaceComponent$Listener;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "debuggerTreePanel", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel;Lcom/intellij/openapi/project/Project;)V", "closeListener", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSearchSession$closeListener$1", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSearchSession$closeListener$1;", "getDebuggerTreePanel", "()Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel;", "depthChoice", "Ljavax/swing/JComponent;", "findModel", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSearchSession$XDebuggerTreeFindModel;", "hasMatches", "", "previousHeaderComponent", "Ljava/awt/Component;", "getProject", "()Lcom/intellij/openapi/project/Project;", "searchComponent", "Lcom/intellij/find/SearchReplaceComponent;", "speedSearch", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch;", "kotlin.jvm.PlatformType", "close", "", "createDepthChoice", "createFindModel", "createSearchComponent", "findModelChanged", "Lcom/intellij/find/FindModel;", "getComponent", "getData", "", "dataId", "", "getFindModel", "multilineStateChanged", "performSearch", "replaceFieldDocumentChanged", "searchBackward", "searchFieldDocumentChanged", "searchForward", "Companion", "XDebuggerTreeFindModel", "intellij.platform.debugger.impl"})
public final class XDebuggerTreeSearchSession
implements SearchSession,
FindModel.FindModelObserver,
SearchReplaceComponent.Listener,
DataProvider {
    private final Component previousHeaderComponent;
    private final XDebuggerTreeSpeedSearch speedSearch;
    private final JComponent depthChoice;
    private final SearchReplaceComponent searchComponent;
    private final XDebuggerTreeFindModel findModel;
    private boolean hasMatches;
    private closeListener.1 closeListener;
    @NotNull
    private final XDebuggerTreePanel debuggerTreePanel;
    @NotNull
    private final Project project;
    public static final int DEFAULT_SEARCH_DEPTH = 4;
    public static final Companion Companion = new Companion(null);

    private final XDebuggerTreeFindModel createFindModel() {
        XDebuggerTreeFindModel findModel = new XDebuggerTreeFindModel();
        FindManager findManager = FindManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)findManager, (String)"FindManager.getInstance(project)");
        findModel.copyFrom(findManager.getFindInFileModel());
        findModel.addObserver(this);
        return findModel;
    }

    @Override
    @NotNull
    public XDebuggerTreeFindModel getFindModel() {
        return this.findModel;
    }

    public void findModelChanged(@NotNull FindModel findModel) {
        Intrinsics.checkParameterIsNotNull((Object)findModel, (String)"findModel");
        String string = findModel.getStringToFind();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"findModel.stringToFind");
        String stringToFind = string;
        this.hasMatches = this.performSearch();
        if (StringUtil.isNotEmpty((String)stringToFind) && !this.hasMatches) {
            this.searchComponent.setNotFoundBackground();
        } else {
            this.searchComponent.setRegularBackground();
        }
        this.searchComponent.setStatusText("");
        this.searchComponent.update(stringToFind, "", false, findModel.isMultiline());
    }

    @Override
    @NotNull
    public SearchReplaceComponent getComponent() {
        return this.searchComponent;
    }

    @Override
    public boolean hasMatches() {
        return this.hasMatches;
    }

    @Override
    public void searchForward() {
        this.speedSearch.nextOccurence(this.findModel.getStringToFind());
    }

    @Override
    public void searchBackward() {
        this.speedSearch.previousOccurence(this.findModel.getStringToFind());
    }

    private final boolean performSearch() {
        return this.speedSearch.findOccurence(this.findModel.getStringToFind());
    }

    @Override
    public void searchFieldDocumentChanged() {
        JTextComponent jTextComponent = this.searchComponent.getSearchTextComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextComponent, (String)"searchComponent.searchTextComponent");
        String textToFind = jTextComponent.getText();
        this.findModel.setStringToFind(textToFind);
        String string = textToFind;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"textToFind");
        this.findModel.setMultiline(StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null));
    }

    @Override
    public void replaceFieldDocumentChanged() {
    }

    @Override
    public void multilineStateChanged() {
    }

    @Override
    public void close() {
        this.debuggerTreePanel.setHeaderComponent(this.previousHeaderComponent);
        this.debuggerTreePanel.searchSessionStopped();
        XDebuggerTree xDebuggerTree = this.debuggerTreePanel.getTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)xDebuggerTree), (String)"debuggerTreePanel.tree");
        xDebuggerTree.getComponent().removeKeyListener(this.closeListener);
        this.speedSearch.searchSessionStopped();
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.project);
        XDebuggerTree xDebuggerTree2 = this.debuggerTreePanel.getTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)xDebuggerTree2), (String)"debuggerTreePanel.tree");
        ideFocusManager.requestFocus((Component)xDebuggerTree2.getComponent(), false);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
        return SearchSession.KEY.is(dataId) ? this : null;
    }

    private final JComponent createDepthChoice() {
        JBIntSpinner depthSpinner = new JBIntSpinner(4, 1, 30, 1);
        depthSpinner.addChangeListener(new ChangeListener(this, depthSpinner){
            final /* synthetic */ XDebuggerTreeSearchSession this$0;
            final /* synthetic */ JBIntSpinner $depthSpinner;

            public final void stateChanged(ChangeEvent it) {
                XDebuggerTreeSearchSession.access$getFindModel$p(this.this$0).setSearchDepth(this.$depthSpinner.getNumber());
                this.this$0.findModelChanged(XDebuggerTreeSearchSession.access$getFindModel$p(this.this$0));
            }
            {
                this.this$0 = xDebuggerTreeSearchSession;
                this.$depthSpinner = jBIntSpinner;
            }
        });
        JBLabel label2 = new JBLabel(XDebuggerBundle.message((String)"xdebugger.variables.search.depth", (Object[])new Object[0]));
        JPanel panel2 = new JPanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)10)));
        panel2.add((Component)label2);
        panel2.add((Component)depthSpinner);
        return panel2;
    }

    private final SearchReplaceComponent createSearchComponent() {
        XDebuggerTree xDebuggerTree = this.debuggerTreePanel.getTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)xDebuggerTree), (String)"debuggerTreePanel.tree");
        SearchReplaceComponent searchReplaceComponent2 = SearchReplaceComponent.buildFor(this.project, xDebuggerTree.getComponent()).addPrimarySearchActions((AnAction)new PrevOccurrenceAction(), (AnAction)new NextOccurrenceAction()).addExtraSearchActions((AnAction)new ToggleMatchCase(), (AnAction)new DefaultCustomComponentAction((Supplier)new Supplier<JComponent>(this){
            final /* synthetic */ XDebuggerTreeSearchSession this$0;

            @NotNull
            public final JComponent get() {
                return XDebuggerTreeSearchSession.access$getDepthChoice$p(this.this$0);
            }
            {
                this.this$0 = xDebuggerTreeSearchSession;
            }
        }), (AnAction)new StatusTextAction()).withCloseAction(new Runnable(this){
            final /* synthetic */ XDebuggerTreeSearchSession this$0;

            public final void run() {
                this.this$0.close();
            }
            {
                this.this$0 = xDebuggerTreeSearchSession;
            }
        }).withDataProvider(this).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchReplaceComponent2, (String)"SearchReplaceComponent\n \u2026ider(this)\n      .build()");
        SearchReplaceComponent searchReplaceComponent3 = searchReplaceComponent2;
        searchReplaceComponent3.addListener(this);
        return searchReplaceComponent3;
    }

    @NotNull
    public final XDebuggerTreePanel getDebuggerTreePanel() {
        return this.debuggerTreePanel;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public XDebuggerTreeSearchSession(@NotNull XDebuggerTreePanel debuggerTreePanel, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)debuggerTreePanel, (String)"debuggerTreePanel");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.debuggerTreePanel = debuggerTreePanel;
        this.project = project;
        this.previousHeaderComponent = this.debuggerTreePanel.getHeaderComponent();
        this.speedSearch = this.debuggerTreePanel.getTree().mySpeedSearch;
        this.depthChoice = this.createDepthChoice();
        this.searchComponent = this.createSearchComponent();
        this.findModel = this.createFindModel();
        this.closeListener = new KeyListener(this){
            final /* synthetic */ XDebuggerTreeSearchSession this$0;

            public void keyTyped(@NotNull KeyEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.processEvent(e);
            }

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.processEvent(e);
            }

            public void keyReleased(@Nullable KeyEvent e) {
            }

            private final void processEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    this.this$0.close();
                    e.consume();
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.debuggerTreePanel.setHeaderComponent(this.searchComponent);
        XDebuggerTree xDebuggerTree = this.debuggerTreePanel.getTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)xDebuggerTree), (String)"debuggerTreePanel.tree");
        xDebuggerTree.getComponent().addKeyListener(this.closeListener);
        this.speedSearch.searchSessionStarted(this);
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.searchComponent.getSearchTextComponent(), false);
    }

    public static final /* synthetic */ XDebuggerTreeFindModel access$getFindModel$p(XDebuggerTreeSearchSession $this) {
        return $this.findModel;
    }

    public static final /* synthetic */ JComponent access$getDepthChoice$p(XDebuggerTreeSearchSession $this) {
        return $this.depthChoice;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSearchSession$XDebuggerTreeFindModel;", "Lcom/intellij/find/FindModel;", "()V", "searchDepth", "", "getSearchDepth", "()I", "setSearchDepth", "(I)V", "intellij.platform.debugger.impl"})
    public static final class XDebuggerTreeFindModel
    extends FindModel {
        private int searchDepth = 4;

        public final int getSearchDepth() {
            return this.searchDepth;
        }

        public final void setSearchDepth(int n) {
            this.searchDepth = n;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSearchSession$Companion;", "", "()V", "DEFAULT_SEARCH_DEPTH", "", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

