/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.util.TimeZoneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrRequestInfo {
    protected static final int MAX_STACK_SIZE = 10;
    protected static final ThreadLocal<Deque<SolrRequestInfo>> threadLocal = ThreadLocal.withInitial(LinkedList::new);
    protected SolrQueryRequest req;
    protected SolrQueryResponse rsp;
    protected Date now;
    protected HttpServletRequest httpRequest;
    protected TimeZone tz;
    protected ResponseBuilder rb;
    protected List<Closeable> closeHooks;
    protected SolrDispatchFilter.Action action;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static SolrRequestInfo getRequestInfo() {
        Deque<SolrRequestInfo> stack = threadLocal.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public static void setRequestInfo(SolrRequestInfo info) {
        Deque<SolrRequestInfo> stack = threadLocal.get();
        if (info == null) {
            throw new IllegalArgumentException("SolrRequestInfo is null");
        }
        if (stack.size() <= 10) {
            stack.push(info);
        } else {
            assert (false) : "SolrRequestInfo Stack is full";
            log.error("SolrRequestInfo Stack is full");
        }
    }

    public static void clearRequestInfo() {
        Deque<SolrRequestInfo> stack = threadLocal.get();
        if (stack.isEmpty()) {
            assert (false) : "clearRequestInfo called too many times";
            log.error("clearRequestInfo called too many times");
        } else {
            SolrRequestInfo info = stack.pop();
            SolrRequestInfo.closeHooks(info);
        }
    }

    public static void reset() {
        Deque<SolrRequestInfo> stack = threadLocal.get();
        boolean isEmpty = stack.isEmpty();
        while (!stack.isEmpty()) {
            SolrRequestInfo info = stack.pop();
            SolrRequestInfo.closeHooks(info);
        }
        assert (isEmpty) : "SolrRequestInfo Stack should have been cleared.";
    }

    private static void closeHooks(SolrRequestInfo info) {
        if (info.closeHooks != null) {
            for (Closeable hook : info.closeHooks) {
                try {
                    hook.close();
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"Exception during close hook", (Throwable)e);
                }
            }
        }
    }

    public SolrRequestInfo(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.req = req;
        this.rsp = rsp;
    }

    public SolrRequestInfo(SolrQueryRequest req, SolrQueryResponse rsp, SolrDispatchFilter.Action action) {
        this(req, rsp);
        this.setAction(action);
    }

    public SolrRequestInfo(HttpServletRequest httpReq, SolrQueryResponse rsp) {
        this.httpRequest = httpReq;
        this.rsp = rsp;
    }

    public SolrRequestInfo(HttpServletRequest httpReq, SolrQueryResponse rsp, SolrDispatchFilter.Action action) {
        this(httpReq, rsp);
        this.action = action;
    }

    public Principal getUserPrincipal() {
        if (this.req != null) {
            return this.req.getUserPrincipal();
        }
        if (this.httpRequest != null) {
            return this.httpRequest.getUserPrincipal();
        }
        return null;
    }

    public Date getNOW() {
        if (this.now != null) {
            return this.now;
        }
        long ms = 0L;
        String nowStr = this.req.getParams().get("NOW");
        ms = nowStr != null ? Long.parseLong(nowStr) : this.req.getStartTime();
        this.now = new Date(ms);
        return this.now;
    }

    public TimeZone getClientTimeZone() {
        if (this.tz == null) {
            this.tz = TimeZoneUtils.parseTimezone(this.req.getParams().get("TZ"));
        }
        return this.tz;
    }

    public SolrQueryRequest getReq() {
        return this.req;
    }

    public SolrQueryResponse getRsp() {
        return this.rsp;
    }

    public ResponseBuilder getResponseBuilder() {
        return this.rb;
    }

    public void setResponseBuilder(ResponseBuilder rb) {
        this.rb = rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseHook(Closeable hook) {
        SolrRequestInfo solrRequestInfo = this;
        synchronized (solrRequestInfo) {
            if (this.closeHooks == null) {
                this.closeHooks = new LinkedList<Closeable>();
            }
            this.closeHooks.add(hook);
        }
    }

    public SolrDispatchFilter.Action getAction() {
        return this.action;
    }

    public void setAction(SolrDispatchFilter.Action action) {
        this.action = action;
    }

    public static ExecutorUtil.InheritableThreadLocalProvider getInheritableThreadLocalProvider() {
        return new ExecutorUtil.InheritableThreadLocalProvider(){

            public void store(AtomicReference ctx) {
                SolrRequestInfo me = SolrRequestInfo.getRequestInfo();
                if (me != null) {
                    ctx.set(me);
                }
            }

            public void set(AtomicReference ctx) {
                SolrRequestInfo me = (SolrRequestInfo)ctx.get();
                if (me != null) {
                    SolrRequestInfo.setRequestInfo(me);
                }
            }

            public void clean(AtomicReference ctx) {
                if (ctx.get() != null) {
                    SolrRequestInfo.clearRequestInfo();
                }
                SolrRequestInfo.reset();
            }
        };
    }
}

