/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.scraper;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Async {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static <T> CompletableFuture<List<T>> waitForAllSuccessfulResponses(List<CompletableFuture<T>> futures) {
        CompletableFuture<Void> completed = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return ((CompletableFuture)completed.thenApply(values -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()))).exceptionally(error -> {
            futures.stream().filter(CompletableFuture::isCompletedExceptionally).forEach(future -> {
                try {
                    future.get();
                }
                catch (Exception exception) {
                    log.warn("Error occurred during metrics collection", (Throwable)exception);
                }
            });
            return futures.stream().filter(future -> !future.isCompletedExceptionally() && !future.isCancelled()).map(CompletableFuture::join).collect(Collectors.toList());
        });
    }
}

