/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.OnigUtils;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import org.joni.Matcher;
import org.joni.Region;

@BuiltinFunction(value={"_sub_impl/3"})
public class _SubImplFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("_sub_impl/3", in, JsonNodeType.STRING);
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        for (JsonNode regexText : args.get(0).apply(scope, in)) {
            Preconditions.checkArgumentType("_sub_impl/3", 1, regexText, JsonNodeType.STRING);
            for (JsonNode flagsText : args.get(2).apply(scope, in)) {
                Preconditions.checkArgumentType("_sub_impl/3", 3, flagsText, JsonNodeType.STRING);
                OnigUtils.Pattern p = new OnigUtils.Pattern(regexText.asText(), flagsText.asText());
                _SubImplFunction.concat(result, _SubImplFunction.sub(scope, p, in.asText(), args.get(1)));
            }
        }
        return result;
    }

    private static void concat(List<JsonNode> out, int index, Stack<JsonNode> stack, List<List<JsonNode>> values) {
        if (index == values.size()) {
            StringBuilder builder = new StringBuilder();
            for (JsonNode item : stack) {
                if (item.isTextual()) {
                    builder.append(item.asText());
                    continue;
                }
                builder.append(item.toString());
            }
            out.add((JsonNode)TextNode.valueOf((String)builder.toString()));
        } else {
            for (JsonNode value : values.get(index)) {
                stack.push(value);
                _SubImplFunction.concat(out, index + 1, stack, values);
                stack.pop();
            }
        }
    }

    private static void concat(List<JsonNode> out, List<List<JsonNode>> values) {
        _SubImplFunction.concat(out, 0, new Stack<JsonNode>(), values);
    }

    private static List<List<JsonNode>> sub(Scope scope, OnigUtils.Pattern pattern, String inputText, JsonQuery replace) throws JsonQueryException {
        ArrayList<List<JsonNode>> result = new ArrayList<List<JsonNode>>();
        byte[] inputBytes = inputText.getBytes(StandardCharsets.UTF_8);
        Matcher m = pattern.regex.matcher(inputBytes);
        int offset = 0;
        while (m.search(offset, inputBytes.length, 0) >= 0) {
            result.add(Collections.singletonList(TextNode.valueOf((String)new String(inputBytes, offset, m.getBegin() - offset, StandardCharsets.UTF_8))));
            ObjectNode captures = scope.getObjectMapper().createObjectNode();
            Region regions = m.getRegion();
            if (regions != null) {
                for (int i = 1; i < regions.numRegs; ++i) {
                    String name = pattern.names[i];
                    if (name == null) continue;
                    if (regions.beg[i] >= 0) {
                        String value = new String(inputBytes, regions.beg[i], regions.end[i] - regions.beg[i], StandardCharsets.UTF_8);
                        captures.set(name, (JsonNode)TextNode.valueOf((String)value));
                        continue;
                    }
                    captures.set(name, (JsonNode)NullNode.getInstance());
                }
            }
            result.add(replace.apply(scope, (JsonNode)captures));
            offset = m.getEnd();
            if (pattern.global && offset != inputBytes.length) continue;
        }
        result.add(Collections.singletonList(TextNode.valueOf((String)new String(inputBytes, offset, inputBytes.length - offset, StandardCharsets.UTF_8))));
        return result;
    }
}

