/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

final class ViewTabLayoutModel2
implements TabLayoutModel,
ChangeListener {
    private TabDisplayer displayer;
    private PaddingInfo padding;
    private List<Integer> index2Pos;
    private List<Integer> pos2Index;
    private int tabFixedWidth = -1;

    public ViewTabLayoutModel2(TabDisplayer tabDisplayer, PaddingInfo paddingInfo) {
        this.displayer = tabDisplayer;
        this.padding = paddingInfo;
        this.updatePermutations();
        tabDisplayer.getModel().addChangeListener(this);
    }

    public int getH(int n) {
        this.checkIndex(n);
        Insets insets = this.displayer.getInsets();
        return this.displayer.getHeight() - (insets.bottom + insets.top);
    }

    public int getY(int n) {
        this.checkIndex(n);
        return this.displayer.getInsets().top;
    }

    public int getW(int n) {
        this.checkIndex(n);
        int n2 = this.index2Pos.get(n);
        return this.getXCoords()[n2] - this.getX(n);
    }

    public int getX(int n) {
        this.checkIndex(n);
        int n2 = this.index2Pos.get(n);
        return n2 > 0 ? this.getXCoords()[n2 - 1] : this.displayer.getInsets().left;
    }

    public int indexOfPoint(int n, int n2) {
        Insets insets = this.displayer.getInsets();
        int n3 = this.displayer.getWidth() - (insets.left + insets.right);
        int n4 = this.displayer.getHeight() - (insets.bottom + insets.top);
        if (n2 < insets.top || n2 > n4 || n < insets.left || n > n3) {
            return -1;
        }
        int n5 = this.displayer.getModel().size();
        int[] nArray = this.getXCoords();
        for (int i = 0; i < n5; ++i) {
            int n6;
            int n7;
            if (nArray[i] <= 0 || (n7 = n - (n6 = i > 0 ? nArray[i - 1] : insets.left)) < 0 || n7 >= this.getW(i)) continue;
            return this.pos2Index.get(i);
        }
        return -1;
    }

    public int dropIndexOfPoint(int n, int n2) {
        Insets insets = this.displayer.getInsets();
        int n3 = this.displayer.getWidth() - (insets.left + insets.right);
        int n4 = this.displayer.getHeight() - (insets.bottom + insets.top);
        if (n2 < insets.top || n2 > n4 || n < insets.left || n > n3) {
            return -1;
        }
        throw new UnsupportedOperationException("not implemenetd yet....");
    }

    public void setPadding(Dimension dimension) {
    }

    private void checkIndex(int n) {
        int n2 = this.displayer.getModel().size();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Index out of valid scope 0.." + (n2 - 1) + ": " + n);
        }
    }

    private int[] getXCoords() {
        TabDataModel tabDataModel = this.displayer.getModel();
        int n = tabDataModel.size();
        int[] nArray = new int[n];
        if (this.tabFixedWidth < 0) {
            this.tabFixedWidth = this.padding.txtPad.width + this.padding.txtIconsXPad + this.padding.iconsXPad;
        }
        Insets insets = this.displayer.getInsets();
        double d = insets.left;
        int n2 = this.displayer.getWidth() - insets.right;
        for (int i = 0; i < n; ++i) {
            int n3 = this.pos2Index.get(i);
            String string = tabDataModel.getTab(n3).getText();
            d += HtmlRenderer.renderString((String)string, (Graphics)BasicScrollingTabDisplayerUI.getOffscreenGraphics(), (int)0, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)this.displayer.getFont(), (Color)Color.BLACK, (int)1, (boolean)false) + (double)this.tabFixedWidth;
            if (n3 == this.displayer.getSelectionModel().getSelectedIndex()) {
                Icon icon = this.displayer.getUI().getButtonIcon(1, n3);
                if (icon != null) {
                    d += (double)icon.getIconWidth();
                }
                if ((icon = this.displayer.getUI().getButtonIcon(2, n3)) != null) {
                    d += (double)icon.getIconWidth();
                }
            }
            nArray[i] = Math.round(Math.round(d));
            if (d > (double)n2) break;
        }
        return nArray;
    }

    private void updatePermutations() {
        int n = this.displayer.getModel().size();
        this.index2Pos = new ArrayList<Integer>(n);
        this.pos2Index = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            this.index2Pos.add(n - i - 1);
            this.pos2Index.add(0, i);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updatePermutations();
    }

    static final class PaddingInfo {
        Dimension txtPad;
        int txtIconsXPad;
        int iconsXPad;

        PaddingInfo() {
        }
    }
}

