/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.EllipticCurveType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.ModifiableVariableHolder;
import de.rub.nds.tlsattacker.core.protocol.handler.ECDHEServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.ECDHEServerComputations;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ECDHEServerKeyExchangeMessage
extends ServerKeyExchangeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    protected ModifiableByte curveType;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    protected ModifiableByteArray namedGroup;
    protected ECDHEServerComputations computations;

    public ECDHEServerKeyExchangeMessage() {
    }

    public ECDHEServerKeyExchangeMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.SERVER_KEY_EXCHANGE);
    }

    public ModifiableByte getGroupType() {
        return this.curveType;
    }

    public void setCurveType(ModifiableByte curveType) {
        this.curveType = curveType;
    }

    public void setCurveType(byte curveType) {
        this.curveType = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.curveType, (Byte)curveType);
    }

    public ModifiableByteArray getNamedGroup() {
        return this.namedGroup;
    }

    public void setNamedGroup(ModifiableByteArray namedGroup) {
        this.namedGroup = namedGroup;
    }

    public void setNamedGroup(byte[] namedGroup) {
        this.namedGroup = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.namedGroup, (byte[])namedGroup);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ECDHEServerKeyExchangeMessage:");
        sb.append("\n  Curve Type: ");
        if (this.curveType != null && this.curveType.getValue() != null) {
            sb.append((Object)EllipticCurveType.getCurveType((Byte)this.curveType.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Named Curve: ");
        if (this.namedGroup != null && this.namedGroup.getValue() != null) {
            sb.append((Object)NamedGroup.getNamedGroup((byte[])this.namedGroup.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Public Key: ");
        if (this.getPublicKey() != null && this.getPublicKey().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getPublicKey().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature and Hash Algorithm: ");
        if (this.getSignatureAndHashAlgorithm() != null && this.getSignatureAndHashAlgorithm().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getSignatureAndHashAlgorithm().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature: ");
        if (this.getSignature() != null && this.getSignature().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getSignature().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public ECDHEServerComputations getComputations() {
        return this.computations;
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new ECDHEServerKeyExchangeHandler(context);
    }

    @Override
    public String toCompactString() {
        return "ECDHE_SERVER_KEY_EXCHANGE";
    }

    @Override
    public void prepareComputations() {
        if (this.computations == null) {
            this.computations = new ECDHEServerComputations();
        }
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.computations != null) {
            holders.add(this.computations);
        }
        return holders;
    }
}

