/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl;

import de.rub.nds.tlsattacker.attacks.config.PaddingOracleCommandConfig;
import de.rub.nds.tlsattacker.attacks.exception.AttackFailedException;
import de.rub.nds.tlsattacker.attacks.exception.OracleUnstableException;
import de.rub.nds.tlsattacker.attacks.impl.Attacker;
import de.rub.nds.tlsattacker.attacks.padding.PaddingTraceGenerator;
import de.rub.nds.tlsattacker.attacks.padding.PaddingTraceGeneratorFactory;
import de.rub.nds.tlsattacker.attacks.padding.PaddingVectorGenerator;
import de.rub.nds.tlsattacker.attacks.padding.VectorResponse;
import de.rub.nds.tlsattacker.attacks.padding.vector.FingerprintTaskVectorPair;
import de.rub.nds.tlsattacker.attacks.padding.vector.PaddingVector;
import de.rub.nds.tlsattacker.attacks.task.FingerPrintTask;
import de.rub.nds.tlsattacker.attacks.util.response.EqualityError;
import de.rub.nds.tlsattacker.attacks.util.response.EqualityErrorTranslator;
import de.rub.nds.tlsattacker.attacks.util.response.FingerPrintChecker;
import de.rub.nds.tlsattacker.attacks.util.response.ResponseFingerprint;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.ParallelExecutor;
import de.rub.nds.tlsattacker.core.workflow.task.TlsTask;
import de.rub.nds.tlsattacker.util.ConsoleLogger;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaddingOracleAttacker
extends Attacker<PaddingOracleCommandConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Config tlsConfig = this.getTlsConfig();
    private boolean increasingTimeout = true;
    private long additionalTimeout = 1000L;
    private long additionalTcpTimeout = 5000L;
    private List<VectorResponse> fullResponseMap;
    private EqualityError resultError;
    private CipherSuite testedSuite;
    private ProtocolVersion testedVersion;
    private final ParallelExecutor executor;
    private boolean shakyScans = false;
    private boolean errornousScans = false;

    public PaddingOracleAttacker(PaddingOracleCommandConfig paddingOracleConfig, Config baseConfig) {
        super(paddingOracleConfig, baseConfig);
        this.executor = new ParallelExecutor(1, 3);
    }

    public PaddingOracleAttacker(PaddingOracleCommandConfig paddingOracleConfig, Config baseConfig, ParallelExecutor executor) {
        super(paddingOracleConfig, baseConfig);
        this.executor = executor;
    }

    @Override
    public void executeAttack() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Boolean isVulnerable() {
        ConsoleLogger.CONSOLE.info("A server is considered vulnerable to this attack if it responds differently to the test vectors.");
        ConsoleLogger.CONSOLE.info("A server is considered secure if it always responds the same way.");
        EqualityError referenceError = null;
        this.fullResponseMap = new LinkedList<VectorResponse>();
        try {
            for (int i = 0; i < ((PaddingOracleCommandConfig)this.config).getNumberOfIterations(); ++i) {
                List<VectorResponse> responseMap = this.createVectorResponseList();
                this.fullResponseMap.addAll(responseMap);
            }
        }
        catch (AttackFailedException E) {
            ConsoleLogger.CONSOLE.info(E.getMessage());
            return null;
        }
        referenceError = this.getEqualityError(this.fullResponseMap);
        if (referenceError != EqualityError.NONE) {
            ConsoleLogger.CONSOLE.info("Found a behavior difference within the responses. The server could be vulnerable.");
        } else {
            ConsoleLogger.CONSOLE.info("Found no behavior difference within the responses. The server is very liekly not vulnerable.");
        }
        ConsoleLogger.CONSOLE.info(EqualityErrorTranslator.translation(referenceError, null, null));
        if (referenceError != EqualityError.NONE || LOGGER.getLevel().isMoreSpecificThan(Level.INFO)) {
            LOGGER.debug("-------------(Not Grouped)-----------------");
            for (VectorResponse vectorResponse : this.fullResponseMap) {
                LOGGER.debug(vectorResponse.toString());
            }
        }
        this.resultError = referenceError;
        return referenceError != EqualityError.NONE;
    }

    public boolean lookEqual(List<VectorResponse> responseVectorListOne, List<VectorResponse> responseVectorListTwo) {
        boolean result = true;
        if (responseVectorListOne.size() != responseVectorListTwo.size()) {
            throw new OracleUnstableException("The padding oracle seems to be unstable - there is something going terrible wrong. We recommend manual analysis");
        }
        for (VectorResponse vectorResponseOne : responseVectorListOne) {
            VectorResponse equivalentVector = null;
            for (VectorResponse vectorResponseTwo : responseVectorListTwo) {
                if (!vectorResponseOne.getVector().equals(vectorResponseTwo.getVector())) continue;
                equivalentVector = vectorResponseTwo;
                break;
            }
            if (vectorResponseOne.getFingerprint() == null) {
                LOGGER.error("First vector has no fingerprint:" + (Object)((Object)this.testedSuite) + " - " + (Object)((Object)this.testedVersion));
                result = false;
                continue;
            }
            if (equivalentVector == null) {
                LOGGER.error("Equivalent vector is null:" + (Object)((Object)this.testedSuite) + " - " + (Object)((Object)this.testedVersion));
                result = false;
                continue;
            }
            if (equivalentVector.getFingerprint() == null) {
                LOGGER.warn("Equivalent vector has no fingerprint:" + (Object)((Object)this.testedSuite) + " - " + (Object)((Object)this.testedVersion));
                result = false;
                continue;
            }
            EqualityError error = FingerPrintChecker.checkEquality(vectorResponseOne.getFingerprint(), equivalentVector.getFingerprint());
            if (error == EqualityError.NONE) continue;
            LOGGER.warn("There is an error beween rescan:" + (Object)((Object)error) + " - " + (Object)((Object)this.testedSuite) + " - " + (Object)((Object)this.testedVersion));
            result = false;
        }
        return result;
    }

    public List<VectorResponse> createVectorResponseList() {
        PaddingTraceGenerator generator = PaddingTraceGeneratorFactory.getPaddingTraceGenerator((PaddingOracleCommandConfig)this.config);
        PaddingVectorGenerator vectorGenerator = generator.getVectorGenerator();
        LinkedList<TlsTask> taskList = new LinkedList<TlsTask>();
        LinkedList<FingerprintTaskVectorPair> stateVectorPairList = new LinkedList<FingerprintTaskVectorPair>();
        for (PaddingVector vector : vectorGenerator.getVectors(this.tlsConfig.getDefaultSelectedCipherSuite(), this.tlsConfig.getDefaultHighestClientProtocolVersion())) {
            State state = new State(this.tlsConfig, generator.getPaddingOracleWorkflowTrace(this.tlsConfig, vector));
            FingerPrintTask fingerPrintTask = new FingerPrintTask(state, this.additionalTimeout, this.increasingTimeout, this.executor.getReexecutions(), this.additionalTcpTimeout);
            taskList.add(fingerPrintTask);
            stateVectorPairList.add(new FingerprintTaskVectorPair(fingerPrintTask, vector));
        }
        LinkedList<VectorResponse> tempResponseVectorList = new LinkedList<VectorResponse>();
        this.executor.bulkExecuteTasks(taskList);
        for (FingerprintTaskVectorPair pair : stateVectorPairList) {
            ResponseFingerprint fingerprint = null;
            if (pair.getFingerPrintTask().isHasError()) {
                this.errornousScans = true;
                LOGGER.warn("Could not extract fingerprint for " + pair.toString());
                continue;
            }
            this.testedSuite = pair.getFingerPrintTask().getState().getTlsContext().getSelectedCipherSuite();
            this.testedVersion = pair.getFingerPrintTask().getState().getTlsContext().getSelectedProtocolVersion();
            if (this.testedSuite == null || this.testedVersion == null) {
                LOGGER.fatal("Could not find ServerHello after successful extraction");
                throw new OracleUnstableException("Fatal Extraction error");
            }
            fingerprint = pair.getFingerPrintTask().getFingerprint();
            tempResponseVectorList.add(new VectorResponse(pair.getVector(), fingerprint));
        }
        return tempResponseVectorList;
    }

    public EqualityError getEqualityError(List<VectorResponse> responseVectorList) {
        for (VectorResponse responseOne : responseVectorList) {
            for (VectorResponse responseTwo : responseVectorList) {
                EqualityError error;
                if (responseOne == responseTwo || (error = FingerPrintChecker.checkEquality(responseOne.getFingerprint(), responseTwo.getFingerprint())) == EqualityError.NONE) continue;
                ConsoleLogger.CONSOLE.info("Found an EqualityError: " + (Object)((Object)error));
                LOGGER.debug("Fingerprint1: " + responseOne.getFingerprint().toString());
                LOGGER.debug("Fingerprint2: " + responseTwo.getFingerprint().toString());
                return error;
            }
        }
        return EqualityError.NONE;
    }

    public EqualityError getResultError() {
        return this.resultError;
    }

    public List<VectorResponse> getResponseMapList() {
        return this.fullResponseMap;
    }

    public CipherSuite getTestedSuite() {
        return this.testedSuite;
    }

    public ProtocolVersion getTestedVersion() {
        return this.testedVersion;
    }

    public boolean isShakyScans() {
        return this.shakyScans;
    }

    public boolean isErrornousScans() {
        return this.errornousScans;
    }

    public boolean isIncreasingTimeout() {
        return this.increasingTimeout;
    }

    public void setIncreasingTimeout(boolean increasingTimeout) {
        this.increasingTimeout = increasingTimeout;
    }

    public long getAdditionalTimeout() {
        return this.additionalTimeout;
    }

    public void setAdditionalTimeout(long additionalTimeout) {
        this.additionalTimeout = additionalTimeout;
    }

    public long getAdditionalTcpTimeout() {
        return this.additionalTcpTimeout;
    }

    public void setAdditionalTcpTimeout(long additionalTcpTimeout) {
        this.additionalTcpTimeout = additionalTcpTimeout;
    }
}

