/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.channel;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingChannelInboundHandlerAdapter
extends ChannelInboundHandlerAdapter {
    private final Logger logger;

    public LoggingChannelInboundHandlerAdapter(Class clazz) {
        this.logger = LoggerFactory.getLogger((Class)clazz);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace("channelRegistered");
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace("channelUnregistered");
        ctx.fireChannelUnregistered();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace("channelActive");
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace("channelInactive");
        ctx.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.logger.trace("channelRead {}", msg);
        ctx.fireChannelRead(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace("channelReadComplete");
        ctx.fireChannelReadComplete();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.logger.trace("userEventTriggered {}", evt);
        ctx.fireUserEventTriggered(evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace("channelWritabilityChanged");
        ctx.fireChannelWritabilityChanged();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.trace("exceptionCaught", cause);
        ctx.fireExceptionCaught(cause);
    }
}

