/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocol;
import org.traccar.Context;
import org.traccar.database.ActiveDevice;
import org.traccar.database.DataManager;
import org.traccar.database.ExtendedObjectManager;
import org.traccar.model.Command;
import org.traccar.model.Position;
import org.traccar.model.Typed;

public class CommandsManager
extends ExtendedObjectManager<Command> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandsManager.class);
    private final Map<Long, Queue<Command>> deviceQueues = new ConcurrentHashMap<Long, Queue<Command>>();
    private boolean queueing;

    public CommandsManager(DataManager dataManager, boolean queueing) {
        super(dataManager, Command.class);
        this.queueing = queueing;
    }

    public boolean checkDeviceCommand(long deviceId, long commandId) {
        return !this.getAllDeviceItems(deviceId).contains(commandId);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean sendCommand(Command command) throws Exception {
        long deviceId = command.getDeviceId();
        if (command.getId() != 0L) {
            command = ((Command)this.getById(command.getId())).clone();
            command.setDeviceId(deviceId);
        }
        if (command.getTextChannel()) {
            Position lastPosition = Context.getIdentityManager().getLastPosition(deviceId);
            String phone = Context.getIdentityManager().getById(deviceId).getPhone();
            if (lastPosition != null) {
                BaseProtocol protocol = Context.getServerManager().getProtocol(lastPosition.getProtocol());
                protocol.sendTextCommand(phone, command);
                return true;
            }
            if (!command.getType().equals("custom")) throw new RuntimeException("Command " + command.getType() + " is not supported");
            if (Context.getSmsManager() == null) throw new RuntimeException("SMS is not enabled");
            Context.getSmsManager().sendMessageSync(phone, command.getString("data"), true);
            return true;
        }
        ActiveDevice activeDevice = Context.getConnectionManager().getActiveDevice(deviceId);
        if (activeDevice != null) {
            if (activeDevice.supportsLiveCommands()) {
                activeDevice.sendCommand(command);
                return true;
            }
            this.getDeviceQueue(deviceId).add(command);
            return false;
        }
        if (!this.queueing) {
            throw new RuntimeException("Device is not online");
        }
        this.getDeviceQueue(deviceId).add(command);
        return false;
    }

    public Collection<Long> getSupportedCommands(long deviceId) {
        ArrayList<Long> result = new ArrayList<Long>();
        Position lastPosition = Context.getIdentityManager().getLastPosition(deviceId);
        for (long commandId : this.getAllDeviceItems(deviceId)) {
            Command command = (Command)this.getById(commandId);
            if (lastPosition != null) {
                BaseProtocol protocol = Context.getServerManager().getProtocol(lastPosition.getProtocol());
                if ((!command.getTextChannel() || !protocol.getSupportedTextCommands().contains(command.getType())) && (command.getTextChannel() || !protocol.getSupportedDataCommands().contains(command.getType()))) continue;
                result.add(commandId);
                continue;
            }
            if (!command.getType().equals("custom")) continue;
            result.add(commandId);
        }
        return result;
    }

    public Collection<Typed> getCommandTypes(long deviceId, boolean textChannel) {
        Position lastPosition = Context.getIdentityManager().getLastPosition(deviceId);
        if (lastPosition != null) {
            return this.getCommandTypes(lastPosition.getProtocol(), textChannel);
        }
        return Collections.singletonList(new Typed("custom"));
    }

    public Collection<Typed> getCommandTypes(String protocolName, boolean textChannel) {
        ArrayList<Typed> result = new ArrayList<Typed>();
        BaseProtocol protocol = Context.getServerManager().getProtocol(protocolName);
        Collection<String> commands = textChannel ? protocol.getSupportedTextCommands() : protocol.getSupportedDataCommands();
        for (String commandKey : commands) {
            result.add(new Typed(commandKey));
        }
        return result;
    }

    public Collection<Typed> getAllCommandTypes() {
        Field[] fields;
        ArrayList<Typed> result = new ArrayList<Typed>();
        for (Field field : fields = Command.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("TYPE_")) continue;
            try {
                result.add(new Typed(field.get(null).toString()));
            }
            catch (IllegalAccessException | IllegalArgumentException error) {
                LOGGER.warn("Get command types error", (Throwable)error);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Queue<Command> getDeviceQueue(long deviceId) {
        Queue<Command> deviceQueue;
        try {
            this.readLock();
            deviceQueue = this.deviceQueues.get(deviceId);
        }
        finally {
            this.readUnlock();
        }
        if (deviceQueue != null) {
            return deviceQueue;
        }
        try {
            this.writeLock();
            Queue queue = this.deviceQueues.computeIfAbsent(deviceId, key -> new ConcurrentLinkedQueue());
            return queue;
        }
        finally {
            this.writeUnlock();
        }
    }

    public Collection<Command> readQueuedCommands(long deviceId) {
        return this.readQueuedCommands(deviceId, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Command> readQueuedCommands(long deviceId, int count) {
        Queue<Command> deviceQueue;
        try {
            this.readLock();
            deviceQueue = this.deviceQueues.get(deviceId);
        }
        finally {
            this.readUnlock();
        }
        ArrayList<Command> result = new ArrayList<Command>();
        if (deviceQueue != null) {
            Command command = deviceQueue.poll();
            while (command != null && result.size() < count) {
                result.add(command);
                command = deviceQueue.poll();
            }
        }
        return result;
    }
}

