/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import io.netty.channel.Channel;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.net.SocketAddress;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.GlobalTimer;
import org.traccar.Main;
import org.traccar.Protocol;
import org.traccar.database.ActiveDevice;
import org.traccar.handler.events.MotionEventHandler;
import org.traccar.handler.events.OverspeedEventHandler;
import org.traccar.model.Device;
import org.traccar.model.DeviceState;
import org.traccar.model.Event;
import org.traccar.model.Position;

public class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private static final long DEFAULT_TIMEOUT = 600L;
    private final long deviceTimeout;
    private final boolean enableStatusEvents;
    private final boolean updateDeviceState;
    private final Map<Long, ActiveDevice> activeDevices = new ConcurrentHashMap<Long, ActiveDevice>();
    private final Map<Long, Set<UpdateListener>> listeners = new ConcurrentHashMap<Long, Set<UpdateListener>>();
    private final Map<Long, Timeout> timeouts = new ConcurrentHashMap<Long, Timeout>();

    public ConnectionManager() {
        this.deviceTimeout = Context.getConfig().getLong("status.timeout", 600L) * 1000L;
        this.enableStatusEvents = Context.getConfig().getBoolean("event.enable");
        this.updateDeviceState = Context.getConfig().getBoolean("status.updateDeviceState");
    }

    public void addActiveDevice(long deviceId, Protocol protocol, Channel channel, SocketAddress remoteAddress) {
        this.activeDevices.put(deviceId, new ActiveDevice(deviceId, protocol, channel, remoteAddress));
    }

    public void removeActiveDevice(Channel channel) {
        for (ActiveDevice activeDevice : this.activeDevices.values()) {
            if (activeDevice.getChannel() != channel) continue;
            this.updateDevice(activeDevice.getDeviceId(), "offline", null);
            this.activeDevices.remove(activeDevice.getDeviceId());
            break;
        }
    }

    public ActiveDevice getActiveDevice(long deviceId) {
        return this.activeDevices.get(deviceId);
    }

    public void updateDevice(final long deviceId, String status, Date time) {
        Timeout timeout;
        Device device = Context.getIdentityManager().getById(deviceId);
        if (device == null) {
            return;
        }
        String oldStatus = device.getStatus();
        device.setStatus(status);
        if (this.enableStatusEvents && !status.equals(oldStatus)) {
            String eventType;
            HashMap<Event, Position> events = new HashMap<Event, Position>();
            switch (status) {
                case "online": {
                    eventType = "deviceOnline";
                    break;
                }
                case "unknown": {
                    eventType = "deviceUnknown";
                    if (!this.updateDeviceState) break;
                    events.putAll(this.updateDeviceState(deviceId));
                    break;
                }
                default: {
                    eventType = "deviceOffline";
                    if (!this.updateDeviceState) break;
                    events.putAll(this.updateDeviceState(deviceId));
                }
            }
            events.put(new Event(eventType, deviceId), null);
            Context.getNotificationManager().updateEvents(events);
        }
        if ((timeout = this.timeouts.remove(deviceId)) != null) {
            timeout.cancel();
        }
        if (time != null) {
            device.setLastUpdate(time);
        }
        if (status.equals("online")) {
            this.timeouts.put(deviceId, GlobalTimer.getTimer().newTimeout(new TimerTask(){

                public void run(Timeout timeout) {
                    if (!timeout.isCancelled()) {
                        ConnectionManager.this.updateDevice(deviceId, "unknown", null);
                    }
                }
            }, this.deviceTimeout, TimeUnit.MILLISECONDS));
        }
        try {
            Context.getDeviceManager().updateDeviceStatus(device);
        }
        catch (SQLException error) {
            LOGGER.warn("Update device status error", (Throwable)error);
        }
        this.updateDevice(device);
    }

    public Map<Event, Position> updateDeviceState(long deviceId) {
        DeviceState deviceState = Context.getDeviceManager().getDeviceState(deviceId);
        HashMap<Event, Position> result = new HashMap<Event, Position>();
        Map<Event, Position> event = ((MotionEventHandler)((Object)Main.getInjector().getInstance(MotionEventHandler.class))).updateMotionState(deviceState);
        if (event != null) {
            result.putAll(event);
        }
        if ((event = ((OverspeedEventHandler)((Object)Main.getInjector().getInstance(OverspeedEventHandler.class))).updateOverspeedState(deviceState, Context.getDeviceManager().lookupAttributeDouble(deviceId, "speedLimit", 0.0, true, false))) != null) {
            result.putAll(event);
        }
        return result;
    }

    public synchronized void updateDevice(Device device) {
        for (long userId : Context.getPermissionsManager().getDeviceUsers(device.getId())) {
            if (!this.listeners.containsKey(userId)) continue;
            for (UpdateListener listener : this.listeners.get(userId)) {
                listener.onUpdateDevice(device);
            }
        }
    }

    public synchronized void updatePosition(Position position) {
        long deviceId = position.getDeviceId();
        for (long userId : Context.getPermissionsManager().getDeviceUsers(deviceId)) {
            if (!this.listeners.containsKey(userId)) continue;
            for (UpdateListener listener : this.listeners.get(userId)) {
                listener.onUpdatePosition(position);
            }
        }
    }

    public synchronized void updateEvent(long userId, Event event) {
        if (this.listeners.containsKey(userId)) {
            for (UpdateListener listener : this.listeners.get(userId)) {
                listener.onUpdateEvent(event);
            }
        }
    }

    public synchronized void addListener(long userId, UpdateListener listener) {
        if (!this.listeners.containsKey(userId)) {
            this.listeners.put(userId, new HashSet());
        }
        this.listeners.get(userId).add(listener);
    }

    public synchronized void removeListener(long userId, UpdateListener listener) {
        if (!this.listeners.containsKey(userId)) {
            this.listeners.put(userId, new HashSet());
        }
        this.listeners.get(userId).remove(listener);
    }

    public static interface UpdateListener {
        public void onUpdateDevice(Device var1);

        public void onUpdatePosition(Position var1);

        public void onUpdateEvent(Event var1);
    }
}

