/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseDataHandler;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.AttributesManager;
import org.traccar.database.IdentityManager;
import org.traccar.model.Attribute;
import org.traccar.model.Device;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class ComputedAttributesHandler
extends BaseDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputedAttributesHandler.class);
    private final IdentityManager identityManager;
    private final AttributesManager attributesManager;
    private final JexlEngine engine;
    private final boolean includeDeviceAttributes;

    public ComputedAttributesHandler(Config config, IdentityManager identityManager, AttributesManager attributesManager) {
        this.identityManager = identityManager;
        this.attributesManager = attributesManager;
        this.engine = new JexlEngine();
        this.engine.setStrict(true);
        this.engine.setFunctions(Collections.singletonMap("math", Math.class));
        this.includeDeviceAttributes = config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_DEVICE_ATTRIBUTES);
    }

    private MapContext prepareContext(Position position) {
        Device device;
        MapContext result = new MapContext();
        if (this.includeDeviceAttributes && (device = this.identityManager.getById(position.getDeviceId())) != null) {
            for (String key : device.getAttributes().keySet()) {
                result.set(key, device.getAttributes().get(key));
            }
        }
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(position.getClass().getMethods()));
        methods.removeAll(Arrays.asList(Object.class.getMethods()));
        for (Method method : methods) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
            String name = Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4);
            try {
                if (!method.getReturnType().equals(Map.class)) {
                    result.set(name, method.invoke((Object)position, new Object[0]));
                    continue;
                }
                for (Object key : ((Map)method.invoke((Object)position, new Object[0])).keySet()) {
                    result.set((String)key, ((Map)method.invoke((Object)position, new Object[0])).get(key));
                }
            }
            catch (IllegalAccessException | InvocationTargetException error) {
                LOGGER.warn("Attribute reflection error", (Throwable)error);
            }
        }
        return result;
    }

    @Deprecated
    public Object computeAttribute(Attribute attribute, Position position) throws JexlException {
        return this.engine.createExpression(attribute.getExpression()).evaluate((JexlContext)this.prepareContext(position));
    }

    @Override
    protected Position handlePosition(Position position) {
        Collection attributes = this.attributesManager.getItems(this.attributesManager.getAllDeviceItems(position.getDeviceId()));
        for (Attribute attribute : attributes) {
            if (attribute.getAttribute() == null) continue;
            Object result = null;
            try {
                result = this.computeAttribute(attribute, position);
            }
            catch (JexlException error) {
                LOGGER.warn("Attribute computation error", (Throwable)error);
            }
            if (result == null) continue;
            try {
                switch (attribute.getType()) {
                    case "number": {
                        Number numberValue = (Number)result;
                        position.getAttributes().put(attribute.getAttribute(), numberValue);
                        break;
                    }
                    case "boolean": {
                        Boolean booleanValue = (Boolean)result;
                        position.getAttributes().put(attribute.getAttribute(), booleanValue);
                        break;
                    }
                    default: {
                        position.getAttributes().put(attribute.getAttribute(), result.toString());
                        break;
                    }
                }
            }
            catch (ClassCastException error) {
                LOGGER.warn("Attribute cast error", (Throwable)error);
            }
        }
        return position;
    }
}

