/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class AnytrekProtocolDecoder
extends BaseProtocolDecoder {
    public AnytrekProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int type) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(30840);
            response.writeShortLE(7);
            response.writeByte(type);
            response.writeByte(0);
            response.writeShortLE(0);
            response.writeByte(0);
            response.writeShortLE(0);
            response.writeByte(13);
            response.writeByte(10);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.readUnsignedShortLE();
        short type = buf.readUnsignedByte();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(2);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("versionFw", buf.readUnsignedShortLE());
        position.set("battery", (double)buf.readUnsignedShortLE() * 0.01);
        position.set("rssi", buf.readUnsignedByte());
        DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
        position.setTime(dateBuilder.getDate());
        position.set("sat", BitUtil.to(buf.readUnsignedByte(), 4));
        double latitude = (double)buf.readUnsignedIntLE() / 1800000.0;
        double longitude = (double)buf.readUnsignedIntLE() / 1800000.0;
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        int flags = buf.readUnsignedShortLE();
        position.setCourse(BitUtil.to(flags, 10));
        position.setValid(BitUtil.check(flags, 12));
        if (!BitUtil.check(flags, 10)) {
            latitude = -latitude;
        }
        if (BitUtil.check(flags, 11)) {
            longitude = -longitude;
        }
        position.setLatitude(latitude);
        position.setLongitude(longitude);
        buf.readUnsignedIntLE();
        buf.readUnsignedIntLE();
        flags = buf.readUnsignedByte();
        position.set("charge", BitUtil.check(flags, 0));
        position.set("ignition", BitUtil.check(flags, 1));
        position.set("alarm", BitUtil.check(flags, 4) ? "general" : null);
        buf.readUnsignedShortLE();
        position.set("odometer", buf.readUnsignedIntLE());
        this.sendResponse(channel, remoteAddress, type);
        return position;
    }
}

