/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class RoboTrackFrameDecoder
extends BaseFrameDecoder {
    private int messageLength(ByteBuf buf) {
        switch (buf.getUnsignedByte(buf.readerIndex())) {
            case 0: {
                return 69;
            }
            case 128: {
                return 3;
            }
            case 3: 
            case 4: 
            case 6: {
                return 24;
            }
            case 7: {
                return 8 + buf.getUnsignedShortLE(buf.readerIndex() + 1);
            }
            case 8: {
                return 6;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        int length = this.messageLength(buf);
        if (buf.readableBytes() >= length) {
            return buf.readRetainedSlice(length);
        }
        return null;
    }
}

