/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.EnvironmentException;
import com.cloudhopper.commons.util.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class EnvironmentUtil {
    public static final String HOST_NAME = "HOST_NAME";
    public static final String HOST_DOMAIN = "HOST_DOMAIN";
    public static final String HOST_FQDN = "HOST_FQDN";

    public static Properties createCommonSystemProperties() throws EnvironmentException {
        Properties systemProperties = new Properties();
        String hostFQDN = EnvironmentUtil.getHostFQDN();
        if (!StringUtil.isEmpty(hostFQDN)) {
            systemProperties.put(HOST_FQDN, hostFQDN);
            String[] hostInfo = EnvironmentUtil.splitHostFQDN(hostFQDN);
            systemProperties.put(HOST_NAME, hostInfo[0] != null ? hostInfo[0] : "");
            systemProperties.put(HOST_DOMAIN, hostInfo[1] != null ? hostInfo[1] : "");
        } else {
            systemProperties.put(HOST_FQDN, "");
            systemProperties.put(HOST_NAME, "");
            systemProperties.put(HOST_DOMAIN, "");
        }
        return systemProperties;
    }

    public static String getHostFQDN() throws EnvironmentException {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] ipAddr = addr.getAddress();
            return addr.getHostName();
        }
        catch (UnknownHostException e) {
            throw new EnvironmentException("Unable to determine hostname", e);
        }
    }

    public static String[] splitHostFQDN(String fqdn) {
        String[] result = new String[2];
        if (StringUtil.isEmpty(fqdn)) {
            return result;
        }
        int pos = fqdn.indexOf(46);
        if (pos >= 0) {
            result[0] = fqdn.substring(0, pos);
            if (pos + 1 < fqdn.length()) {
                result[1] = fqdn.substring(pos + 1);
            }
        } else {
            result[0] = fqdn;
        }
        return result;
    }
}

