/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.httpclient;

import ch.csnc.extension.httpclient.AliasCertificate;
import ch.csnc.extension.httpclient.AliasKeyManager;
import ch.csnc.extension.httpclient.PKCS11Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class SSLContextManager {
    public static final String SUN_PKCS11_CANONICAL_CLASS_NAME = "sun.security.pkcs11.SunPKCS11";
    public static final String IBM_PKCS11_CONONICAL_CLASS_NAME = "com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl";
    private static final String SUN_PKCS11_PROVIDER_NAME = "SunPKCS11";
    public static final String PKCS11_PROVIDER_TYPE = "PKCS11";
    private static final String SUN_PKCS11_KEYSTORE_TYPE = "PKCS11";
    private static final String IBM_PKCS11_KEYSTORE_TYPE = "PKCS11IMPLKS";
    private static Boolean java9SunPKCS11;
    private Map<String, SSLContext> _contextMaps = new TreeMap<String, SSLContext>();
    private SSLContext _noClientCertContext;
    private String _defaultKey = null;
    private Map<String, Map<?, ?>> _aliasPasswords = new HashMap();
    private List<KeyStore> _keyStores = new ArrayList<KeyStore>();
    private Map<KeyStore, String> _keyStoreDescriptions = new HashMap<KeyStore, String>();
    private Map<KeyStore, String> _keyStorePasswords = new HashMap<KeyStore, String>();
    private static Logger log;
    private static TrustManager[] _trustAllCerts;
    private int _defaultKeystoreIndex = -1;
    private int _defaultAliasIndex = -1;

    public SSLContextManager() {
        try {
            this._noClientCertContext = SSLContext.getInstance("SSL");
            this._noClientCertContext.init(null, _trustAllCerts, new SecureRandom());
        }
        catch (NoSuchAlgorithmException nsao) {
            log.error((Object)("Could not get an instance of the SSL algorithm: " + nsao.getMessage()), (Throwable)nsao);
        }
        catch (KeyManagementException kme) {
            log.error((Object)("Error initialising the SSL Context:  " + kme.getMessage()), (Throwable)kme);
        }
        try {
            this.initMSCAPI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isProviderAvailable(String type) {
        try {
            if (type.equals("PKCS11")) {
                try {
                    Class.forName(SUN_PKCS11_CANONICAL_CLASS_NAME);
                    return true;
                }
                catch (Throwable ignore) {
                    Class.forName(IBM_PKCS11_CONONICAL_CLASS_NAME);
                    return true;
                }
            }
            if (type.equals("msks")) {
                Class.forName("se.assembla.jce.provider.ms.MSProvider");
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private int addKeyStore(KeyStore ks, String description, String password) {
        int index = this._keyStores.indexOf(ks);
        if (index == -1) {
            this._keyStores.add(ks);
            index = this._keyStores.size() - 1;
        }
        this._keyStoreDescriptions.put(ks, description);
        this._keyStorePasswords.put(ks, password);
        return index;
    }

    public boolean removeKeyStore(int keystoreIndex) {
        boolean isDefaultKeyStore = keystoreIndex == this._defaultKeystoreIndex;
        KeyStore ks = this._keyStores.get(keystoreIndex);
        this._keyStores.remove(ks);
        this._keyStoreDescriptions.remove(ks);
        this._keyStorePasswords.remove(ks);
        if (isDefaultKeyStore) {
            this._defaultKeystoreIndex = -1;
            this._defaultAliasIndex = -1;
        }
        return isDefaultKeyStore;
    }

    public int getKeyStoreCount() {
        return this._keyStores.size();
    }

    public String getKeyStoreDescription(int keystoreIndex) {
        return this._keyStoreDescriptions.get(this._keyStores.get(keystoreIndex));
    }

    public String getKeyStorePassword(int keystoreIndex) {
        return this._keyStorePasswords.get(this._keyStores.get(keystoreIndex));
    }

    public int getAliasCount(int keystoreIndex) {
        return this.getAliases(this._keyStores.get(keystoreIndex)).size();
    }

    public String getAliasAt(int keystoreIndex, int aliasIndex) {
        return this.getAliases(this._keyStores.get(keystoreIndex)).get(aliasIndex).getAlias();
    }

    private List<AliasCertificate> getAliases(KeyStore ks) {
        ArrayList<AliasCertificate> aliases = new ArrayList<AliasCertificate>();
        try {
            Enumeration<String> en = ks.aliases();
            boolean isIbm = SSLContextManager.isIbmPKCS11Provider();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                if (!ks.isKeyEntry(alias) && (!isIbm || !ks.isCertificateEntry(alias))) continue;
                Certificate cert = ks.getCertificate(alias);
                AliasCertificate aliasCert = new AliasCertificate(cert, alias);
                aliases.add(aliasCert);
            }
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
        }
        return aliases;
    }

    public List<AliasCertificate> getAliases(int ks) {
        return this.getAliases(this._keyStores.get(ks));
    }

    public Certificate getCertificate(int keystoreIndex, int aliasIndex) {
        try {
            KeyStore ks = this._keyStores.get(keystoreIndex);
            String alias = this.getAliasAt(keystoreIndex, aliasIndex);
            return ks.getCertificate(alias);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFingerPrint(Certificate cert) throws KeyStoreException {
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        X509Certificate x509 = (X509Certificate)cert;
        try {
            String fingerprint = DigestUtils.md5Hex((byte[])cert.getEncoded());
            for (int i = 0; i < fingerprint.length(); i += 2) {
                buff.append(fingerprint.substring(i, i + 1)).append(":");
            }
            buff.deleteCharAt(buff.length() - 1);
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException(e.getMessage());
        }
        String dn = x509.getSubjectDN().getName();
        log.info((Object)("Fingerprint is " + buff.toString().toUpperCase()));
        return buff.toString().toUpperCase() + " " + dn;
    }

    public boolean isKeyUnlocked(int keystoreIndex, int aliasIndex) {
        KeyStore ks = this._keyStores.get(keystoreIndex);
        String alias = this.getAliasAt(keystoreIndex, aliasIndex);
        Map<?, ?> pwmap = this._aliasPasswords.get(ks);
        if (pwmap == null) {
            return false;
        }
        return pwmap.containsKey(alias);
    }

    public void setDefaultKey(int keystoreIndex, int aliasIndex) throws KeyStoreException {
        this._defaultKeystoreIndex = keystoreIndex;
        this._defaultAliasIndex = aliasIndex;
        this._defaultKey = this._defaultKeystoreIndex == -1 || this._defaultAliasIndex == -1 ? "" : this.getFingerPrint(this.getCertificate(keystoreIndex, aliasIndex));
    }

    public String getDefaultKey() {
        return this._defaultKey;
    }

    public Certificate getDefaultCertificate() {
        return this.getCertificate(this._defaultKeystoreIndex, this._defaultAliasIndex);
    }

    public int initMSCAPI() throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
        try {
            if (!this.isProviderAvailable("msks")) {
                return -1;
            }
            Provider mscapi = (Provider)Class.forName("se.assembla.jce.provider.ms.MSProvider").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Security.addProvider(mscapi);
            KeyStore ks = KeyStore.getInstance("msks", "assembla");
            ks.load(null, null);
            return this.addKeyStore(ks, "Microsoft CAPI Store", null);
        }
        catch (Exception e) {
            log.error((Object)("Error instantiating the MSCAPI provider: " + e.getMessage()), (Throwable)e);
            return -1;
        }
    }

    public int initPKCS11(PKCS11Configuration configuration, String kspassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (!this.isProviderAvailable("PKCS11")) {
            return -1;
        }
        Provider pkcs11 = SSLContextManager.createPKCS11Provider(configuration);
        Security.addProvider(pkcs11);
        KeyStore ks = SSLContextManager.getPKCS11KeyStore(pkcs11.getName());
        ks.load(null, kspassword == null ? null : kspassword.toCharArray());
        return this.addKeyStore(ks, "PKCS#11: " + configuration.getName(), "");
    }

    private static Provider createPKCS11Provider(PKCS11Configuration configuration) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        Provider pkcs11 = null;
        if (SSLContextManager.isSunPKCS11Provider()) {
            if (SSLContextManager.isJava9SunPKCS11()) {
                Provider provider = Security.getProvider(SUN_PKCS11_PROVIDER_NAME);
                Method configure = provider.getClass().getMethod("configure", String.class);
                File configFile = File.createTempFile("pkcs11", ".cfg");
                configFile.deleteOnExit();
                FileUtils.write((File)configFile, (CharSequence)configuration.toString(), (Charset)StandardCharsets.UTF_8);
                pkcs11 = (Provider)configure.invoke((Object)provider, configFile.getAbsolutePath());
            } else {
                pkcs11 = SSLContextManager.createInstance(SUN_PKCS11_CANONICAL_CLASS_NAME, InputStream.class, configuration.toInpuStream());
            }
        } else if (SSLContextManager.isIbmPKCS11Provider()) {
            pkcs11 = SSLContextManager.createInstance(IBM_PKCS11_CONONICAL_CLASS_NAME, BufferedReader.class, new BufferedReader(new InputStreamReader(configuration.toInpuStream())));
        }
        return pkcs11;
    }

    private static Provider createInstance(String name, Class<?> paramClass, Object param) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> instanceClass = Class.forName(name);
        Constructor<?> c = instanceClass.getConstructor(paramClass);
        return (Provider)c.newInstance(param);
    }

    private static boolean isSunPKCS11Provider() {
        try {
            Class.forName(SUN_PKCS11_CANONICAL_CLASS_NAME);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isJava9SunPKCS11() {
        if (java9SunPKCS11 != null) {
            return java9SunPKCS11;
        }
        java9SunPKCS11 = Boolean.FALSE;
        try {
            Provider provider = Security.getProvider(SUN_PKCS11_PROVIDER_NAME);
            if (provider != null) {
                provider.getClass().getMethod("configure", String.class);
                java9SunPKCS11 = Boolean.TRUE;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return java9SunPKCS11;
    }

    private static boolean isIbmPKCS11Provider() {
        try {
            Class.forName(IBM_PKCS11_CONONICAL_CLASS_NAME);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static KeyStore getPKCS11KeyStore(String providerName) throws KeyStoreException {
        String keyStoreType = "PKCS11";
        if (SSLContextManager.isIbmPKCS11Provider()) {
            keyStoreType = IBM_PKCS11_KEYSTORE_TYPE;
        }
        return KeyStore.getInstance(keyStoreType, Security.getProvider(providerName));
    }

    public int loadPKCS12Certificate(String filename, String ksPassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException(filename + " could not be found");
        }
        String name = file.getName();
        try (FileInputStream is = new FileInputStream(file);){
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(is, ksPassword == null ? null : ksPassword.toCharArray());
            int n = this.addKeyStore(ks, "PKCS#12: " + name, ksPassword);
            return n;
        }
    }

    public boolean unlockKeyWithDefaultPassword(int keystoreIndex, int aliasIndex) throws KeyManagementException, KeyStoreException {
        return this.unlockKey(keystoreIndex, aliasIndex, this.getKeyStorePassword(keystoreIndex));
    }

    public boolean unlockKey(int keystoreIndex, int aliasIndex, String keyPassword) throws KeyStoreException, KeyManagementException {
        SSLContext sc;
        KeyStore ks = this._keyStores.get(keystoreIndex);
        String alias = this.getAliasAt(keystoreIndex, aliasIndex);
        AliasKeyManager akm = new AliasKeyManager(ks, alias, keyPassword);
        try {
            akm.getPrivateKey(alias).toString();
        }
        catch (NullPointerException ex) {
            log.error((Object)("Could not get private key: " + ex.getMessage()), (Throwable)ex);
            return false;
        }
        String fingerprint = this.getFingerPrint(this.getCertificate(keystoreIndex, aliasIndex));
        if (fingerprint == null) {
            log.info((Object)"No fingerprint found");
            return false;
        }
        try {
            sc = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException nsao) {
            log.error((Object)("Could not get an instance of the SSL algorithm: " + nsao.getMessage()), (Throwable)nsao);
            return false;
        }
        sc.init(new KeyManager[]{akm}, _trustAllCerts, new SecureRandom());
        String key = fingerprint;
        if (key.indexOf(" ") > 0) {
            key = key.substring(0, key.indexOf(" "));
        }
        this._contextMaps.put(key, sc);
        log.info((Object)"Key has been unlocked.");
        return true;
    }

    public void invalidateSessions() {
        this.invalidateSession(this._noClientCertContext);
        Iterator<String> it = this._contextMaps.keySet().iterator();
        while (it.hasNext()) {
            this.invalidateSession(this._contextMaps.get(it.next()));
        }
    }

    private void invalidateSession(SSLContext sc) {
        int timeout;
        SSLSessionContext sslsc = sc.getClientSessionContext();
        if (sslsc != null) {
            timeout = sslsc.getSessionTimeout();
            sslsc.setSessionTimeout(1);
            sslsc.setSessionTimeout(timeout);
        }
        if ((sslsc = sc.getServerSessionContext()) != null) {
            timeout = sslsc.getSessionTimeout();
            sslsc.setSessionTimeout(1);
            sslsc.setSessionTimeout(timeout);
        }
    }

    public SSLContext getSSLContext(String fingerprint) {
        log.info((Object)("Requested SSLContext for " + fingerprint));
        if (fingerprint == null || fingerprint.equals("none")) {
            return this._noClientCertContext;
        }
        if (fingerprint.indexOf(" ") > 0) {
            fingerprint = fingerprint.substring(0, fingerprint.indexOf(" "));
        }
        return this._contextMaps.get(fingerprint);
    }

    static {
        log = Logger.getLogger(SSLContextManager.class);
        _trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }
}

